/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.ChainOperation;
import com.intellij.compiler.chainsSearch.MethodCall;
import com.intellij.compiler.chainsSearch.RefChainOperation;
import com.intellij.compiler.chainsSearch.TypeCast;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OperationChain {
    private static final Logger f = Logger.getInstance(OperationChain.class);
    @NotNull
    private final ChainOperation[] c;
    private final RefChainOperation d;
    private final MethodCall e;
    private final int a;
    private final PsiClass b;

    @Nullable
    public static OperationChain create(@NotNull RefChainOperation refChainOperation, int n2, @NotNull ChainCompletionContext chainCompletionContext) {
        if (refChainOperation == null) {
            OperationChain.a(0);
        }
        if (chainCompletionContext == null) {
            OperationChain.a(1);
        }
        if (refChainOperation instanceof MethodCall) {
            PsiClass psiClass;
            MethodCall methodCall = (MethodCall)refChainOperation;
            PsiClass psiClass2 = chainCompletionContext.resolvePsiClass(methodCall.getQualifierDef());
            if (psiClass2 == null || !methodCall.isStatic() && InheritanceUtil.isInheritorOrSelf((PsiClass)chainCompletionContext.getTarget().getTargetClass(), (PsiClass)psiClass2, (boolean)true)) {
                return null;
            }
            PsiMethod[] psiMethodArray = chainCompletionContext.resolve(methodCall);
            if (psiMethodArray.length == 0) {
                return null;
            }
            Set set = Arrays.stream(psiMethodArray).flatMap(psiMethod -> Arrays.stream(psiMethod.getParameterList().getParameters())).map(psiParameter -> PsiUtil.resolveClassInType((PsiType)psiParameter.getType())).collect(Collectors.toSet());
            if (set.contains(psiClass = chainCompletionContext.getTarget().getTargetClass())) {
                return null;
            }
            set.add(psiClass);
            return new OperationChain(psiClass2, new ChainOperation[]{new ChainOperation.MethodCall(psiMethodArray)}, methodCall, methodCall, n2);
        }
        TypeCast typeCast = (TypeCast)refChainOperation;
        PsiClass psiClass = chainCompletionContext.resolvePsiClass(typeCast.getLightRef());
        PsiClass psiClass3 = chainCompletionContext.resolvePsiClass(typeCast.getCastTypeRef());
        if (psiClass == null || psiClass3 == null) {
            return null;
        }
        return new OperationChain(psiClass, new ChainOperation[]{new ChainOperation.TypeCast(psiClass, psiClass3)}, typeCast, null, n2);
    }

    private OperationChain(@NotNull PsiClass psiClass, @NotNull ChainOperation[] chainOperationArray, RefChainOperation refChainOperation, MethodCall methodCall, int n2) {
        if (psiClass == null) {
            OperationChain.a(2);
        }
        if (chainOperationArray == null) {
            OperationChain.a(3);
        }
        this.b = psiClass;
        this.c = chainOperationArray;
        this.d = refChainOperation;
        this.e = methodCall;
        this.a = n2;
    }

    public boolean hasCast() {
        return Arrays.stream(this.c).anyMatch(chainOperation -> chainOperation instanceof ChainOperation.TypeCast);
    }

    @Nullable
    public MethodCall getHeadMethodCall() {
        return this.e;
    }

    @NotNull
    public RefChainOperation getHead() {
        RefChainOperation refChainOperation = this.d;
        if (refChainOperation == null) {
            OperationChain.a(4);
        }
        return refChainOperation;
    }

    public int length() {
        return this.c.length;
    }

    public PsiClass getQualifierClass() {
        return this.b;
    }

    @NotNull
    public PsiMethod[] getFirst() {
        PsiMethod[] psiMethodArray = ((ChainOperation.MethodCall)this.c[0]).getCandidates();
        if (psiMethodArray == null) {
            OperationChain.a(5);
        }
        return psiMethodArray;
    }

    public ChainOperation[] getPath() {
        return (ChainOperation[])ArrayUtil.reverseArray((Object[])this.c);
    }

    public int getChainWeight() {
        return this.a;
    }

    @Nullable
    OperationChain continuationWithMethod(@NotNull MethodCall methodCall, int n2, @NotNull ChainCompletionContext chainCompletionContext) {
        OperationChain operationChain;
        if (methodCall == null) {
            OperationChain.a(6);
        }
        if (chainCompletionContext == null) {
            OperationChain.a(7);
        }
        if ((operationChain = OperationChain.create(methodCall, n2, chainCompletionContext)) == null) {
            return null;
        }
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() + 1];
        System.arraycopy(this.c, 0, chainOperationArray, 0, this.c.length);
        chainOperationArray[this.length()] = operationChain.getPath()[0];
        return new OperationChain(operationChain.getQualifierClass(), chainOperationArray, operationChain.getHead(), methodCall, Math.min(n2, this.getChainWeight()));
    }

    @Nullable
    OperationChain continuationWithCast(@NotNull TypeCast typeCast, @NotNull ChainCompletionContext chainCompletionContext) {
        OperationChain operationChain;
        if (typeCast == null) {
            OperationChain.a(8);
        }
        if (chainCompletionContext == null) {
            OperationChain.a(9);
        }
        if ((operationChain = OperationChain.create(typeCast, 0, chainCompletionContext)) == null) {
            return null;
        }
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() + 1];
        System.arraycopy(this.c, 0, chainOperationArray, 0, this.c.length);
        chainOperationArray[this.length()] = operationChain.getPath()[0];
        return new OperationChain(operationChain.getQualifierClass(), chainOperationArray, operationChain.getHead(), this.e, this.getChainWeight());
    }

    @NotNull
    OperationChain removeHeadCast(@NotNull ChainCompletionContext chainCompletionContext) {
        if (chainCompletionContext == null) {
            OperationChain.a(10);
        }
        f.assertTrue(this.getHead() instanceof TypeCast);
        ChainOperation[] chainOperationArray = new ChainOperation[this.length() - 1];
        System.arraycopy(this.c, 0, chainOperationArray, 0, this.length() - 1);
        OperationChain operationChain = new OperationChain(Objects.requireNonNull(chainCompletionContext.resolvePsiClass(this.e.getQualifierDef())), chainOperationArray, this.e, this.e, this.getChainWeight());
        if (operationChain == null) {
            OperationChain.a(11);
        }
        return operationChain;
    }

    public String toString() {
        Object[] objectArray = this.getPath();
        return Arrays.toString(objectArray) + " on " + this.b.getName();
    }

    public static CompareResult compare(@NotNull OperationChain operationChain, @NotNull OperationChain operationChain2) {
        int n2;
        if (operationChain == null) {
            OperationChain.a(12);
        }
        if (operationChain2 == null) {
            OperationChain.a(13);
        }
        if (operationChain.length() == 0 || operationChain2.length() == 0) {
            throw new IllegalStateException("chains can't be empty");
        }
        int n3 = 0;
        for (n2 = 0; n3 < operationChain.length() && n2 < operationChain2.length(); ++n3, ++n2) {
            ChainOperation chainOperation = operationChain.c[n3];
            ChainOperation chainOperation2 = operationChain2.c[n3];
            if (OperationChain.lookSimilar(chainOperation, chainOperation2)) continue;
            return CompareResult.NOT_EQUAL;
        }
        if (n3 < operationChain.length() && n2 == operationChain2.length()) {
            return CompareResult.LEFT_CONTAINS_RIGHT;
        }
        if (n3 == operationChain.length() && n2 < operationChain2.length()) {
            return CompareResult.RIGHT_CONTAINS_LEFT;
        }
        return CompareResult.EQUAL;
    }

    static boolean lookSimilar(ChainOperation chainOperation, ChainOperation chainOperation2) {
        HashSet hashSet;
        if (chainOperation instanceof ChainOperation.TypeCast || chainOperation2 instanceof ChainOperation.TypeCast) {
            return false;
        }
        Object[] objectArray = ((ChainOperation.MethodCall)chainOperation).getCandidates();
        Object[] objectArray2 = ((ChainOperation.MethodCall)chainOperation2).getCandidates();
        PsiMethod psiMethod2 = objectArray[0];
        PsiMethod psiMethod3 = objectArray2[0];
        if (psiMethod2.hasModifierProperty("static") || psiMethod3.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod2.getName().equals(psiMethod3.getName()) || psiMethod2.getParameterList().getParametersCount() != psiMethod3.getParameterList().getParametersCount()) {
            return false;
        }
        HashSet hashSet2 = ContainerUtil.newHashSet((Object[])objectArray);
        if (ContainerUtil.intersects((Collection)hashSet2, (Collection)(hashSet = ContainerUtil.newHashSet((Object[])objectArray2)))) {
            return true;
        }
        Set set = hashSet2.stream().flatMap(psiMethod -> Arrays.stream(psiMethod.findDeepestSuperMethods())).collect(Collectors.toSet());
        return hashSet.stream().flatMap(psiMethod -> Arrays.stream(psiMethod.findDeepestSuperMethods())).anyMatch(set::contains);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseOperations";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cast";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/chainsSearch/OperationChain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHead";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirst";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHeadCast";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "continuationWithCast";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeHeadCast";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CompareResult {
        LEFT_CONTAINS_RIGHT,
        RIGHT_CONTAINS_LEFT,
        EQUAL,
        NOT_EQUAL;

    }
}

