/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.CommonBundle;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.BuildTargetScopeProvider;
import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompilerCacheManager;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.ExitStatus;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerFilter;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.ex.CompilerPathsEx;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.DefaultModuleConfigurationEditorFactory;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompilerUtil;
import com.intellij.packaging.impl.compiler.ArtifactsCompiler;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Chunk;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class CompileDriver {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileDriver");
    private static final Key<Boolean> f = Key.create((String)"compilation_started_automatically");
    private static final Key<ExitStatus> d = Key.create((String)"COMPILE_SERVER_BUILD_STATUS");
    private static final long a = 60000L;
    private final Project c;
    private final Map<Module, String> h = new HashMap<Module, String>();
    private final Map<Module, String> b = new HashMap<Module, String>();
    private CompilerFilter e = CompilerFilter.ALL;

    public CompileDriver(Project project2) {
        this.c = project2;
    }

    public void setCompilerFilter(CompilerFilter compilerFilter) {
        this.e = compilerFilter == null ? CompilerFilter.ALL : compilerFilter;
    }

    public void rebuild(CompileStatusNotification compileStatusNotification) {
        this.a(compileStatusNotification, new ProjectCompileScope(this.c));
    }

    public void make(CompileScope compileScope, CompileStatusNotification compileStatusNotification) {
        this.make(compileScope, false, compileStatusNotification);
    }

    public void make(CompileScope compileScope, boolean bl2, CompileStatusNotification compileStatusNotification) {
        if (this.a(compileScope)) {
            this.a(compileScope, false, false, bl2, compileStatusNotification, null);
        } else {
            compileStatusNotification.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public boolean isUpToDate(CompileScope compileScope) {
        if (g.isDebugEnabled()) {
            g.debug("isUpToDate operation started");
        }
        CompilerTask compilerTask = new CompilerTask(this.c, "Classes up-to-date check", true, false, false, CompileDriver.b(compileScope));
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.c, compilerTask, compileScope, true, false);
        Ref ref = new Ref();
        compilerTask.start(() -> {
            ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
            if (progressIndicator.isCanceled() || this.c.isDisposed()) {
                return;
            }
            try {
                TaskFuture taskFuture = this.a(compileContextImpl, true);
                if (taskFuture != null) {
                    while (!taskFuture.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!progressIndicator.isCanceled()) continue;
                        taskFuture.cancel(false);
                    }
                }
            }
            catch (Throwable throwable) {
                g.error(throwable);
            }
            finally {
                ref.set(d.get((UserDataHolder)compileContextImpl));
                if (!this.c.isDisposed()) {
                    CompilerCacheManager.getInstance(this.c).flushCaches();
                }
            }
        }, null);
        if (g.isDebugEnabled()) {
            g.debug("isUpToDate operation finished");
        }
        return ExitStatus.UP_TO_DATE.equals(ref.get());
    }

    public void compile(CompileScope compileScope, CompileStatusNotification compileStatusNotification) {
        if (this.a(compileScope)) {
            this.a(compileScope, false, true, compileStatusNotification, null);
        } else {
            compileStatusNotification.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    private void a(CompileStatusNotification compileStatusNotification, CompileScope compileScope) {
        if (this.a(compileScope)) {
            this.a(compileScope, true, false, compileStatusNotification, null);
        } else {
            compileStatusNotification.finished(true, 0, 0, (CompileContext)DummyCompileContext.getInstance());
        }
    }

    public static void setCompilationStartedAutomatically(CompileScope compileScope) {
        compileScope.putUserData(f, (Object)Boolean.TRUE);
    }

    private static boolean b(CompileScope compileScope) {
        return Boolean.TRUE.equals(compileScope.getUserData(f));
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> a(@NotNull CompileContextImpl compileContextImpl, CompileScope compileScope, Collection<String> collection) {
        if (compileContextImpl == null) {
            CompileDriver.a(0);
        }
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2 = new ArrayList<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope>();
        boolean bl2 = !compileContextImpl.isMake();
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list3 = CompileScopeUtil.getBaseScopeForExternalBuild(compileScope);
        if (list3 != null) {
            list2.addAll(list3);
        } else if (!compileContextImpl.isRebuild() && !CompileScopeUtil.allProjectModulesAffected(compileContextImpl)) {
            CompileScopeUtil.addScopesForModules(Arrays.asList(compileScope.getAffectedModules()), compileScope.getAffectedUnloadedModules(), list2, bl2);
        } else {
            list2.addAll(CmdlineProtoUtil.createAllModulesScopes((boolean)bl2));
        }
        if (collection.isEmpty()) {
            list2 = this.a(compileScope, list2, bl2);
        }
        return list2;
    }

    private List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> a(CompileScope compileScope, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2, boolean bl2) {
        for (BuildTargetScopeProvider buildTargetScopeProvider : (BuildTargetScopeProvider[])BuildTargetScopeProvider.EP_NAME.getExtensions()) {
            List list3 = (List)ReadAction.compute(() -> this.c.isDisposed() ? Collections.emptyList() : buildTargetScopeProvider.getBuildTargetScopes(compileScope, this.c, bl2));
            list2 = CompileScopeUtil.mergeScopes(list2, list3);
        }
        return list2;
    }

    @Nullable
    private TaskFuture a(final @NotNull CompileContextImpl compileContextImpl, boolean bl2) throws Exception {
        Map map;
        HashMap<String, String> hashMap;
        if (compileContextImpl == null) {
            CompileDriver.a(1);
        }
        CompileScope compileScope = compileContextImpl.getCompileScope();
        List<String> list2 = CompileScopeUtil.fetchFiles(compileContextImpl);
        List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list3 = this.a(compileContextImpl, compileScope, list2);
        if (bl2) {
            hashMap = new HashMap<String, String>();
        } else {
            map = compileScope.exportUserData();
            if (!map.isEmpty()) {
                hashMap = new HashMap();
                for (Map.Entry object2 : map.entrySet()) {
                    String string = ((Key)object2.getKey()).toString();
                    String string2 = object2.getValue().toString();
                    hashMap.put(string, string2);
                }
            } else {
                hashMap = new HashMap();
            }
        }
        if (!compileScope.getAffectedUnloadedModules().isEmpty()) {
            hashMap.put("load_unloaded_modules", Boolean.TRUE.toString());
        }
        map = this.c.getMessageBus();
        Iterator iterator = ArtifactCompilerUtil.containsArtifacts(list3) ? ArtifactCompilerUtil.createOutputToArtifactMap(this.c) : null;
        BuildManager buildManager = BuildManager.getInstance();
        buildManager.cancelAutoMakeTasks(this.c);
        return buildManager.scheduleBuild(this.c, compileContextImpl.isRebuild(), compileContextImpl.isMake(), bl2, list3, list2, hashMap, new DefaultMessageHandler(this.c, (MessageBus)map, (MultiMap)iterator){
            final /* synthetic */ MessageBus val$messageBus;
            final /* synthetic */ MultiMap val$outputToArtifact;
            {
                this.val$messageBus = messageBus;
                this.val$outputToArtifact = multiMap;
                super(project2);
            }

            @Override
            public void sessionTerminated(UUID uUID) {
                if (compileContextImpl.shouldUpdateProblemsView()) {
                    ProblemsView problemsView = ProblemsView.SERVICE.getInstance(CompileDriver.this.c);
                    problemsView.clearProgress();
                    problemsView.clearOldMessages(compileContextImpl.getCompileScope(), compileContextImpl.getSessionId());
                }
            }

            @Override
            public void handleFailure(UUID uUID, CmdlineRemoteProto.Message.Failure failure) {
                String string;
                compileContextImpl.addMessage(CompilerMessageCategory.ERROR, failure.hasDescription() ? failure.getDescription() : "", null, -1, -1);
                String string2 = string = failure.hasStacktrace() ? failure.getStacktrace() : null;
                if (string != null) {
                    g.info(string);
                }
                compileContextImpl.putUserData(d, ExitStatus.ERRORS);
            }

            @Override
            protected void handleCompileMessage(UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.CompileMessage compileMessage) {
                CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind kind = compileMessage.getKind();
                String string = compileMessage.getText();
                if (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS) {
                    ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
                    progressIndicator.setText(string);
                    if (compileMessage.hasDone()) {
                        progressIndicator.setFraction((double)compileMessage.getDone());
                    }
                } else {
                    String string2;
                    CompilerMessageCategory compilerMessageCategory = kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR ? CompilerMessageCategory.ERROR : (kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.WARNING ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
                    String string3 = string2 = compileMessage.hasSourceFilePath() ? compileMessage.getSourceFilePath() : null;
                    if (string2 != null) {
                        string2 = FileUtil.toSystemIndependentName((String)string2);
                    }
                    long l2 = compileMessage.hasLine() ? compileMessage.getLine() : -1L;
                    long l3 = compileMessage.hasColumn() ? compileMessage.getColumn() : -1L;
                    String string4 = string2 != null ? VirtualFileManager.constructUrl((String)"file", (String)string2) : null;
                    compileContextImpl.addMessage(compilerMessageCategory, string, string4, (int)l2, (int)l3);
                    if (compileContextImpl.shouldUpdateProblemsView() && kind == CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO) {
                        Project project2 = compileContextImpl.getProject();
                        ProblemsView.SERVICE.getInstance(project2).addMessage(new CompilerMessageImpl(project2, compilerMessageCategory, string), compileContextImpl.getSessionId());
                    }
                }
            }

            @Override
            protected void handleBuildEvent(UUID uUID, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent buildEvent) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type type = buildEvent.getEventType();
                switch (type) {
                    case FILES_GENERATED: {
                        List list2 = buildEvent.getGeneratedFilesList();
                        CompilationStatusListener compilationStatusListener = !CompileDriver.this.c.isDisposed() ? (CompilationStatusListener)this.val$messageBus.syncPublisher(CompilerTopics.COMPILATION_STATUS) : null;
                        THashSet tHashSet = this.val$outputToArtifact != null ? new THashSet(FileUtil.PATH_HASHING_STRATEGY) : null;
                        for (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile : list2) {
                            Collection collection;
                            String string = FileUtil.toSystemIndependentName((String)generatedFile.getOutputRoot());
                            String string2 = FileUtil.toSystemIndependentName((String)generatedFile.getRelativePath());
                            if (compilationStatusListener != null) {
                                compilationStatusListener.fileGenerated(string, string2);
                            }
                            if (this.val$outputToArtifact == null || (collection = this.val$outputToArtifact.get((Object)string)).isEmpty()) continue;
                            for (Artifact artifact : collection) {
                                ArtifactsCompiler.addChangedArtifact(compileContextImpl, artifact);
                            }
                            tHashSet.add(FileUtil.toSystemDependentName((String)DeploymentUtil.appendToPath((String)string, (String)string2)));
                        }
                        if (tHashSet == null || tHashSet.isEmpty()) break;
                        ArtifactsCompiler.addWrittenPaths(compileContextImpl, (Set<String>)tHashSet);
                        break;
                    }
                    case BUILD_COMPLETED: {
                        ExitStatus exitStatus = ExitStatus.SUCCESS;
                        if (buildEvent.hasCompletionStatus()) {
                            CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status = buildEvent.getCompletionStatus();
                            switch (status) {
                                case CANCELED: {
                                    exitStatus = ExitStatus.CANCELLED;
                                    break;
                                }
                                case ERRORS: {
                                    exitStatus = ExitStatus.ERRORS;
                                    break;
                                }
                                case SUCCESS: {
                                    exitStatus = ExitStatus.SUCCESS;
                                    break;
                                }
                                case UP_TO_DATE: {
                                    exitStatus = ExitStatus.UP_TO_DATE;
                                }
                            }
                        }
                        compileContextImpl.putUserDataIfAbsent(d, exitStatus);
                        break;
                    }
                    case CUSTOM_BUILDER_MESSAGE: {
                        String string;
                        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage customBuilderMessage;
                        if (!buildEvent.hasCustomBuilderMessage() || !"JPS".equals((customBuilderMessage = buildEvent.getCustomBuilderMessage()).getBuilderId()) || !"!unprocessed_fs_changes_detected!".equals(customBuilderMessage.getMessageType()) || StringUtil.isEmpty((String)(string = customBuilderMessage.getMessageText()))) break;
                        compileContextImpl.addMessage(CompilerMessageCategory.INFORMATION, string, null, -1, -1);
                    }
                }
            }
        });
    }

    private void a(CompileScope compileScope, boolean bl2, boolean bl3, CompileStatusNotification compileStatusNotification, CompilerMessage compilerMessage) {
        this.a(compileScope, bl2, bl3, false, compileStatusNotification, compilerMessage);
    }

    private void a(CompileScope compileScope, boolean bl2, boolean bl3, boolean bl4, CompileStatusNotification compileStatusNotification, CompilerMessage compilerMessage) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = CompilerBundle.message((String)(bl3 ? "compiler.content.name.compile" : "compiler.content.name.make"), (Object[])new Object[0]);
        boolean bl5 = ApplicationManager.getApplication().isUnitTestMode();
        CompilerTask compilerTask = new CompilerTask(this.c, string, bl5, !bl4, true, CompileDriver.b(compileScope), bl4);
        StatusBar.Info.set((String)"", (Project)this.c, (String)"Compiler");
        this.c.save();
        if (!bl5) {
            ApplicationManager.getApplication().saveSettings();
        }
        PsiDocumentManager.getInstance((Project)this.c).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.c, compilerTask, compileScope, !bl2 && !bl3, bl2);
        Runnable runnable = () -> {
            ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
            if (progressIndicator.isCanceled() || this.c.isDisposed()) {
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(true, 0, 0, (CompileContext)compileContextImpl);
                }
                return;
            }
            CompilerCacheManager compilerCacheManager = CompilerCacheManager.getInstance(this.c);
            try {
                g.info("COMPILATION STARTED (BUILD PROCESS)");
                if (compilerMessage != null) {
                    compileContextImpl.addMessage(compilerMessage);
                }
                if (bl2) {
                    CompilerUtil.runInContext(compileContextImpl, "Clearing build system data...", () -> compilerCacheManager.clearCaches(compileContextImpl));
                }
                boolean bl3 = this.a((CompileContext)compileContextImpl, true);
                int n2 = compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR);
                if (!bl3 || n2 > 0) {
                    d.set((UserDataHolder)compileContextImpl, (Object)(n2 > 0 ? ExitStatus.ERRORS : ExitStatus.CANCELLED));
                    return;
                }
                TaskFuture taskFuture = this.a(compileContextImpl, false);
                if (taskFuture != null) {
                    while (!taskFuture.waitFor(200L, TimeUnit.MILLISECONDS)) {
                        if (!progressIndicator.isCanceled()) continue;
                        taskFuture.cancel(false);
                    }
                    if (!this.a((CompileContext)compileContextImpl, false)) {
                        d.set((UserDataHolder)compileContextImpl, (Object)ExitStatus.CANCELLED);
                    }
                    if (compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR) > 0) {
                        d.set((UserDataHolder)compileContextImpl, (Object)ExitStatus.ERRORS);
                    }
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                compileContextImpl.putUserDataIfAbsent(d, ExitStatus.CANCELLED);
            }
            catch (Throwable throwable) {
                g.error(throwable);
            }
            finally {
                compilerCacheManager.flushCaches();
                long l2 = this.a(compileContextImpl, compileStatusNotification, (ExitStatus)d.get((UserDataHolder)compileContextImpl));
                CompilerUtil.logDuration("\tCOMPILATION FINISHED (BUILD PROCESS); Errors: " + compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR) + "; warnings: " + compileContextImpl.getMessageCount(CompilerMessageCategory.WARNING), l2);
            }
        };
        compilerTask.start(runnable, () -> {
            int n2;
            if (bl2 && (n2 = Messages.showOkCancelDialog((Project)this.c, (String)"You are about to rebuild the whole project.\nRun 'Build Project' instead?", (String)"Confirm Project Rebuild", (String)"Build", (String)"Rebuild", (Icon)Messages.getQuestionIcon())) == 0) {
                this.a(compileScope, false, false, compileStatusNotification, null);
                return;
            }
            this.a(compileScope, bl2, bl3, compileStatusNotification, compilerMessage);
        });
    }

    @Nullable
    public static ExitStatus getExternalBuildExitStatus(CompileContext compileContext) {
        return (ExitStatus)compileContext.getUserData(d);
    }

    private long a(CompileContextImpl compileContextImpl, CompileStatusNotification compileStatusNotification, ExitStatus exitStatus) {
        long l2 = System.currentTimeMillis() - compileContextImpl.getStartCompilationStamp();
        if (!this.c.isDisposed()) {
            HashSet hashSet;
            Module[] moduleArray = compileContextImpl.getCompileScope().getAffectedModules();
            if (exitStatus != ExitStatus.UP_TO_DATE && exitStatus != ExitStatus.CANCELLED && !(hashSet = ContainerUtil.newHashSet((Object[])CompilerPathsEx.getOutputPaths((Module[])moduleArray))).isEmpty()) {
                ProgressIndicator progressIndicator = compileContextImpl.getProgressIndicator();
                progressIndicator.setText("Synchronizing output directories...");
                CompilerUtil.refreshOutputRoots(hashSet);
                progressIndicator.setText("");
            }
        }
        SwingUtilities.invokeLater(() -> {
            int n2 = 0;
            int n3 = 0;
            try {
                n2 = compileContextImpl.getMessageCount(CompilerMessageCategory.ERROR);
                n3 = compileContextImpl.getMessageCount(CompilerMessageCategory.WARNING);
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(exitStatus == ExitStatus.CANCELLED, n2, n3, (CompileContext)compileContextImpl);
                }
            }
            catch (Throwable throwable) {
                if (compileStatusNotification != null) {
                    compileStatusNotification.finished(exitStatus == ExitStatus.CANCELLED, n2, n3, (CompileContext)compileContextImpl);
                }
                throw throwable;
            }
            if (!this.c.isDisposed()) {
                MessageType messageType;
                String string = CompileDriver.a(exitStatus, n3, n2, l2);
                MessageType messageType2 = n2 > 0 ? MessageType.ERROR : (messageType = n3 > 0 ? MessageType.WARNING : MessageType.INFO);
                if (l2 > 60000L && CompilerWorkspaceConfiguration.getInstance((Project)this.c).DISPLAY_NOTIFICATION_POPUP) {
                    ToolWindowManager.getInstance((Project)this.c).notifyByBalloon(ToolWindowId.MESSAGES_WINDOW, messageType, string);
                }
                String string2 = exitStatus != ExitStatus.UP_TO_DATE ? "<a href='#'>" + string + "</a>" : string;
                Notification notification = CompilerManager.NOTIFICATION_GROUP.createNotification("", string2, messageType.toNotificationType(), (NotificationListener)new MessagesActivationListener(compileContextImpl)).setImportant(false);
                compileContextImpl.getBuildSession().registerCloseAction(() -> ((Notification)notification).expire());
                notification.notify(this.c);
                if (exitStatus != ExitStatus.UP_TO_DATE && compileContextImpl.getMessageCount(null) > 0) {
                    String string3 = DateFormatUtil.formatDateTime((Date)new Date()) + " - " + string;
                    compileContextImpl.addMessage(CompilerMessageCategory.INFORMATION, string3, null, -1, -1);
                }
            }
        });
        return l2;
    }

    private static String a(ExitStatus exitStatus, int n2, int n3, long l2) {
        String string;
        if (exitStatus == ExitStatus.CANCELLED) {
            string = CompilerBundle.message((String)"status.compilation.aborted", (Object[])new Object[0]);
        } else if (exitStatus == ExitStatus.UP_TO_DATE) {
            string = CompilerBundle.message((String)"status.all.up.to.date", (Object[])new Object[0]);
        } else {
            string = exitStatus == ExitStatus.SUCCESS ? (n2 > 0 ? CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings", (Object[])new Object[]{n2}) : CompilerBundle.message((String)"status.compilation.completed.successfully", (Object[])new Object[0])) : CompilerBundle.message((String)"status.compilation.completed.successfully.with.warnings.and.errors", (Object[])new Object[]{n3, n2});
            string = string + " in " + StringUtil.formatDuration((long)l2);
        }
        return string;
    }

    private String a(Module module2, boolean bl2) {
        Map<Module, String> map = bl2 ? this.b : this.h;
        return map.computeIfAbsent(module2, module3 -> CompilerPaths.getModuleOutputPath((Module)module2, (boolean)bl2));
    }

    public void executeCompileTask(CompileTask compileTask, CompileScope compileScope, String string, Runnable runnable) {
        CompilerTask compilerTask = new CompilerTask(this.c, string, false, false, true, CompileDriver.b(compileScope));
        CompileContextImpl compileContextImpl = new CompileContextImpl(this.c, compilerTask, compileScope, false, false);
        FileDocumentManager.getInstance().saveAllDocuments();
        compilerTask.start(() -> {
            try {
                compileTask.execute((CompileContext)compileContextImpl);
            }
            catch (ProcessCanceledException processCanceledException) {
            }
            finally {
                if (runnable != null) {
                    runnable.run();
                }
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(CompileContext compileContext, boolean bl2) {
        if (this.c.isDisposed()) {
            return false;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.c);
        ProgressIndicator progressIndicator = compileContext.getProgressIndicator();
        progressIndicator.pushState();
        try {
            StatusBar statusBar;
            Object object = statusBar = bl2 ? compilerManager.getBeforeTasks() : compilerManager.getAfterTasks();
            if (((CompileTask[])statusBar).length > 0) {
                progressIndicator.setText(CompilerBundle.message((String)(bl2 ? "progress.executing.precompile.tasks" : "progress.executing.postcompile.tasks"), (Object[])new Object[0]));
                for (StatusBar statusBar2 : statusBar) {
                    if (statusBar2.execute(compileContext)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
            }
        }
        finally {
            progressIndicator.popState();
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.c);
            if (statusBar != null) {
                statusBar.setInfo("");
            }
            if (progressIndicator instanceof CompilerTask) {
                ApplicationManager.getApplication().invokeLater(((CompilerTask)progressIndicator)::showCompilerContent);
            }
        }
        return true;
    }

    private boolean a(CompileScope compileScope) {
        try {
            CompilerModuleExtension compilerModuleExtension;
            String string;
            Module[] moduleArray = compileScope.getAffectedModules();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            CompilerManager compilerManager = CompilerManager.getInstance((Project)this.c);
            boolean bl2 = false;
            boolean bl3 = false;
            for (Module object2 : moduleArray) {
                if (!compilerManager.isValidationEnabled(object2)) continue;
                boolean bl4 = CompileDriver.a(object2, JavaSourceRootType.SOURCE);
                boolean bl5 = CompileDriver.a(object2, JavaSourceRootType.TEST_SOURCE);
                if (!bl4 && !bl5) continue;
                Sdk sdk = ModuleRootManager.getInstance((Module)object2).getSdk();
                if (sdk == null) {
                    bl2 |= ModuleRootManager.getInstance((Module)object2).isSdkInherited();
                    arrayList2.add(object2.getName());
                }
                String string2 = this.a(object2, false);
                string = this.a(object2, true);
                if (string2 == null && string == null) {
                    compilerModuleExtension = CompilerModuleExtension.getInstance((Module)object2);
                    bl3 |= compilerModuleExtension != null && compilerModuleExtension.isCompilerOutputPathInherited();
                    arrayList.add(object2.getName());
                    continue;
                }
                if (string2 == null && bl4) {
                    arrayList.add(object2.getName());
                }
                if (string != null || !bl5) continue;
                arrayList.add(object2.getName());
            }
            if (!arrayList2.isEmpty()) {
                this.a("error.jdk.not.specified", bl2, arrayList2, ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]));
                return false;
            }
            if (!arrayList.isEmpty()) {
                this.a("error.output.not.specified", bl3, arrayList, DefaultModuleConfigurationEditorFactory.getInstance().getOutputEditorDisplayName());
                return false;
            }
            List list2 = ModuleCompilerUtil.getCyclicDependencies((Project)this.c, Arrays.asList(moduleArray));
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                Set set = chunk.getNodes();
                if (set.size() <= 1) continue;
                CompilerModuleExtension compilerModuleExtension2 = null;
                LanguageLevel languageLevel = null;
                for (String string2 : set) {
                    string = string2.getModule();
                    compilerModuleExtension = ModuleRootManager.getInstance((Module)string).getSdk();
                    if (compilerModuleExtension2 == null) {
                        compilerModuleExtension2 = compilerModuleExtension;
                    } else if (!compilerModuleExtension2.equals(compilerModuleExtension)) {
                        this.b(ModuleSourceSet.getModules((Collection)set));
                        return false;
                    }
                    LanguageLevel languageLevel2 = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)string);
                    if (languageLevel == null) {
                        languageLevel = languageLevel2;
                        continue;
                    }
                    if (languageLevel.equals((Object)languageLevel2)) continue;
                    this.a(ModuleSourceSet.getModules((Collection)set));
                    return false;
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            g.info(throwable);
            return false;
        }
    }

    private void a(Set<Module> set) {
        Module module2 = (Module)ContainerUtil.getFirstItem(set);
        g.assertTrue(module2 != null);
        String string = module2.getName();
        String string2 = CompileDriver.a(set);
        Messages.showMessageDialog((Project)this.c, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.language.level", (Object[])new Object[]{string2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string, null);
    }

    private void b(Set<Module> set) {
        Module module2 = (Module)ContainerUtil.getFirstItem(set);
        g.assertTrue(module2 != null);
        String string = module2.getName();
        String string2 = CompileDriver.a(set);
        Messages.showMessageDialog((Project)this.c, (String)CompilerBundle.message((String)"error.chunk.modules.must.have.same.jdk", (Object[])new Object[]{string2}), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string, null);
    }

    private static String a(Collection<Module> collection) {
        return StringUtil.join(collection, module2 -> "\"" + module2.getName() + "\"", (String)"\n");
    }

    private static boolean a(Module module2, JavaSourceRootType javaSourceRootType) {
        return !ModuleRootManager.getInstance((Module)module2).getSourceRoots((JpsModuleSourceRootType)javaSourceRootType).isEmpty();
    }

    private void a(@NonNls String string, boolean bl2, List<String> list2, String string2) {
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 10;
        for (String string4 : list2.size() > 10 ? list2.subList(0, 10) : list2) {
            if (string3 == null && !bl2) {
                string3 = string4;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",\n");
            }
            stringBuilder.append("\"");
            stringBuilder.append(string4);
            stringBuilder.append("\"");
        }
        if (list2.size() > 10) {
            stringBuilder.append(",\n...");
        }
        String string5 = CompilerBundle.message((String)string, (Object[])new Object[]{list2.size(), stringBuilder.toString()});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            g.error(string5);
        }
        Messages.showMessageDialog((Project)this.c, (String)string5, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        this.a(string3, string2);
    }

    private void a(@Nullable String string, @Nullable String string2) {
        ProjectSettingsService projectSettingsService = ProjectSettingsService.getInstance((Project)this.c);
        if (string != null) {
            projectSettingsService.showModuleConfigurationDialog(string, string2);
        } else {
            projectSettingsService.openProjectSettings();
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "compileContext";
        objectArray2[1] = "com/intellij/compiler/impl/CompileDriver";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuildScopes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compileInExternalProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MessagesActivationListener
    extends NotificationListener.Adapter {
        private final WeakReference<Project> a;
        private final Object b;

        MessagesActivationListener(CompileContextImpl compileContextImpl) {
            this.a = new WeakReference<Project>(compileContextImpl.getProject());
            this.b = compileContextImpl.getBuildSession().getContentId();
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
            Project project2;
            if (notification == null) {
                MessagesActivationListener.a(0);
            }
            if (hyperlinkEvent == null) {
                MessagesActivationListener.a(1);
            }
            if ((project2 = (Project)this.a.get()) != null && !project2.isDisposed() && CompilerTask.showCompilerContent(project2, this.b)) {
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (toolWindow != null) {
                    toolWindow.activate(null, false);
                }
            } else {
                notification.expire();
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "e";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/impl/CompileDriver$MessagesActivationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

