/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CompilerUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.compiler.impl.CompilerUtil");

    public static String quotePath(String string) {
        if (string != null && string.indexOf(32) != -1) {
            string = string.replaceAll("\\\\", "\\\\\\\\");
            string = '\"' + string + '\"';
        }
        return string;
    }

    public static void refreshIOFiles(@NotNull Collection<File> collection) {
        if (collection == null) {
            CompilerUtil.a(0);
        }
        if (!collection.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(collection);
        }
    }

    public static void refreshIODirectories(@NotNull Collection<File> collection) {
        if (collection == null) {
            CompilerUtil.a(1);
        }
        if (!collection.isEmpty()) {
            LocalFileSystem.getInstance().refreshIoFiles(collection, false, true, null);
        }
    }

    public static void refreshOutputRoots(@NotNull Collection<String> collection) {
        if (collection == null) {
            CompilerUtil.a(2);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        HashSet hashSet = ContainerUtil.newHashSet();
        for (String string : collection) {
            FileAttributes fileAttributes = FileSystemUtil.getAttributes((String)FileUtil.toSystemDependentName((String)string));
            VirtualFile virtualFile = localFileSystem.findFileByPath(string);
            if (fileAttributes != null && virtualFile == null) {
                VirtualFile virtualFile2 = localFileSystem.refreshAndFindFileByPath(PathUtil.getParentPath((String)string));
                if (virtualFile2 == null || !hashSet.add(virtualFile2)) continue;
                virtualFile2.getChildren();
                continue;
            }
            if ((fileAttributes != null || virtualFile == null) && (fileAttributes == null || fileAttributes.isDirectory() == virtualFile.isDirectory())) continue;
            hashSet.add(virtualFile);
        }
        if (!hashSet.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, (Collection)hashSet);
        }
    }

    public static void refreshIOFile(File file) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (virtualFile != null) {
            virtualFile.refresh(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Throwable> void runInContext(CompileContext compileContext, String string, ThrowableRunnable<T> throwableRunnable) throws T {
        ProgressIndicator progressIndicator = compileContext.getProgressIndicator();
        if (string != null) {
            progressIndicator.pushState();
            progressIndicator.setText(string);
        }
        try {
            throwableRunnable.run();
        }
        finally {
            if (string != null) {
                progressIndicator.popState();
            }
        }
    }

    public static void logDuration(String string, long l2) {
        a.info(string + " took " + l2 + " ms: " + l2 / 60000L + " min " + l2 % 60000L / 1000L + "sec");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputRoots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/impl/CompilerUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshIOFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshIODirectories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshOutputRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

