/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class CompilerModuleOptionsComponent
extends JPanel {
    private final JBTable a;
    private final Project b;

    public CompilerModuleOptionsComponent(Project project2) {
        super(new GridBagLayout());
        this.b = project2;
        this.a = new JBTable((TableModel)new MyTableModel());
        this.a.setRowHeight(22);
        this.a.getEmptyText().setText("Additional compilation options will be the same for all modules");
        TableColumn tableColumn = this.a.getColumnModel().getColumn(0);
        tableColumn.setHeaderValue("Module");
        tableColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn tableColumn2 = this.a.getColumnModel().getColumn(1);
        String string = "Compilation options";
        tableColumn2.setHeaderValue("Compilation options");
        int n2 = this.a.getFontMetrics(this.a.getFont()).stringWidth("Compilation options") + 10;
        tableColumn2.setPreferredWidth(n2);
        tableColumn2.setMinWidth(n2);
        new TableSpeedSearch((JTable)this.a);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.a).disableUpAction().disableDownAction().setAddAction((AnActionButtonRunnable)new ChooseModuleAction()).setRemoveAction((AnActionButtonRunnable)new RemoveSelectedRowsAction()).createPanel();
        jPanel.setPreferredSize(new Dimension(this.a.getWidth(), 150));
        JLabel jLabel = new JLabel("Override compiler parameters per-module:");
        this.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
    }

    @NotNull
    public Map<String, String> getModuleOptionsMap() {
        MyTableModel myTableModel = (MyTableModel)this.a.getModel();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (MyTableModel.Item item : myTableModel.getItems()) {
            hashMap.put(item.module.getName(), item.options);
        }
        HashMap<String, String> hashMap2 = hashMap;
        if (hashMap2 == null) {
            CompilerModuleOptionsComponent.a(0);
        }
        return hashMap2;
    }

    public void setModuleOptionsMap(@NotNull Map<String, String> map) {
        Map<Module, String> map2;
        if (map == null) {
            CompilerModuleOptionsComponent.a(1);
        }
        if (!map.isEmpty()) {
            map2 = new HashMap();
            for (Module module2 : ModuleManager.getInstance((Project)this.b).getModules()) {
                String string = map.get(module2.getName());
                if (string == null) continue;
                map2.put(module2, string);
            }
        } else {
            map2 = Collections.emptyMap();
        }
        ((MyTableModel)this.a.getModel()).setItems(map2);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOptions";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOptionsMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/impl/javaCompiler/CompilerModuleOptionsComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setModuleOptionsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemoveSelectedRowsAction
    implements AnActionButtonRunnable {
        private RemoveSelectedRowsAction() {
        }

        public void run(AnActionButton anActionButton) {
            int[] nArray = CompilerModuleOptionsComponent.this.a.getSelectedRows();
            if (nArray.length > 0) {
                TableUtil.removeSelectedItems((JTable)CompilerModuleOptionsComponent.this.a);
            }
        }
    }

    private class ChooseModuleAction
    implements AnActionButtonRunnable {
        private ChooseModuleAction() {
        }

        public void run(AnActionButton anActionButton) {
            MyTableModel myTableModel = (MyTableModel)CompilerModuleOptionsComponent.this.a.getModel();
            HashSet<Module> hashSet = new HashSet<Module>();
            for (MyTableModel.Item chooseModulesDialog2 : myTableModel.getItems()) {
                hashSet.add(chooseModulesDialog2.module);
            }
            ArrayList arrayList = new ArrayList();
            for (Module module2 : ModuleManager.getInstance((Project)CompilerModuleOptionsComponent.this.b).getModules()) {
                if (hashSet.contains(module2)) continue;
                arrayList.add(module2);
            }
            Collections.sort(arrayList, Comparator.comparing(Module::getName));
            ChooseModulesDialog chooseModulesDialog = new ChooseModulesDialog((Component)CompilerModuleOptionsComponent.this, (List)arrayList, "Choose module");
            chooseModulesDialog.show();
            List list2 = chooseModulesDialog.getChosenElements();
            if (!list2.isEmpty()) {
                myTableModel.addItems(list2);
                int n2 = myTableModel.getModuleRow((Module)list2.get(0));
                if (n2 >= 0) {
                    TableUtil.selectRows((JTable)CompilerModuleOptionsComponent.this.a, (int[])new int[]{n2});
                    TableUtil.scrollSelectionToVisible((JTable)CompilerModuleOptionsComponent.this.a);
                }
            }
        }
    }

    private static final class MyTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<Item> a = new ArrayList<Item>();

        private MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return n3 != 0;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            Item item = this.a.get(n2);
            return n3 == 0 ? item.module : item.options;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            Item item = this.a.get(n2);
            item.options = ((String)object).trim();
            this.fireTableCellUpdated(n2, n3);
        }

        public void addItems(Collection<Module> collection) {
            for (Module module2 : collection) {
                this.a.add(new Item(module2));
            }
            this.a();
            this.fireTableDataChanged();
        }

        private void a() {
            Collections.sort(this.a, Comparator.comparing(item -> item.module.getName()));
        }

        public List<Item> getItems() {
            return this.a;
        }

        public void removeRow(int n2) {
            this.a.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }

        public void setItems(Map<Module, String> map) {
            this.a.clear();
            for (Map.Entry<Module, String> entry : map.entrySet()) {
                this.a.add(new Item(entry.getKey(), entry.getValue()));
            }
            this.a();
            this.fireTableDataChanged();
        }

        public int getModuleRow(Module module2) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                if (!this.a.get((int)i2).module.equals(module2)) continue;
                return i2;
            }
            return -1;
        }

        private static final class Item {
            final Module module;
            String options = "";

            Item(Module module2) {
                this.module = module2;
            }

            Item(Module module2, String string) {
                this.module = module2;
                this.options = string;
            }
        }
    }
}

