/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.remote.RemoteConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.util.concurrency.Semaphore;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileStepBeforeRun
extends BeforeRunTaskProvider<MakeBeforeRunTask> {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.compiler.options.CompileStepBeforeRun");
    public static final Key<MakeBeforeRunTask> ID = Key.create((String)"Make");
    public static final Key<RunConfiguration> RUN_CONFIGURATION = CompilerManager.RUN_CONFIGURATION_KEY;
    public static final Key<String> RUN_CONFIGURATION_TYPE_ID = CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY;
    @NonNls
    protected static final String MAKE_PROJECT_ON_RUN_KEY = "makeProjectOnRun";
    private final Project b;

    public CompileStepBeforeRun(@NotNull Project project2) {
        if (project2 == null) {
            CompileStepBeforeRun.a(0);
        }
        this.b = project2;
    }

    public Key<MakeBeforeRunTask> getId() {
        return ID;
    }

    public String getName() {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public String getDescription(MakeBeforeRunTask makeBeforeRunTask) {
        return ExecutionBundle.message((String)"before.launch.compile.step", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return AllIcons.Actions.Compile;
    }

    public Icon getTaskIcon(MakeBeforeRunTask makeBeforeRunTask) {
        return AllIcons.Actions.Compile;
    }

    @Nullable
    public MakeBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CompileStepBeforeRun.a(1);
        }
        MakeBeforeRunTask makeBeforeRunTask = null;
        if (CompileStepBeforeRun.shouldCreateTask(runConfiguration)) {
            makeBeforeRunTask = new MakeBeforeRunTask();
            makeBeforeRunTask.setEnabled(CompileStepBeforeRun.a(runConfiguration));
        }
        return makeBeforeRunTask;
    }

    private static boolean a(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CompileStepBeforeRun.a(2);
        }
        return runConfiguration instanceof RunProfileWithCompileBeforeLaunchOption && ((RunProfileWithCompileBeforeLaunchOption)runConfiguration).isBuildBeforeLaunchAddedByDefault() && runConfiguration instanceof RunConfigurationBase && ((RunConfigurationBase)runConfiguration).isCompileBeforeLaunchAddedByDefault();
    }

    static boolean shouldCreateTask(RunConfiguration runConfiguration) {
        return !(runConfiguration instanceof RemoteConfiguration) && runConfiguration instanceof RunProfileWithCompileBeforeLaunchOption;
    }

    public boolean executeTask(DataContext dataContext, @NotNull RunConfiguration runConfiguration, @NotNull ExecutionEnvironment executionEnvironment, @NotNull MakeBeforeRunTask makeBeforeRunTask) {
        if (runConfiguration == null) {
            CompileStepBeforeRun.a(3);
        }
        if (executionEnvironment == null) {
            CompileStepBeforeRun.a(4);
        }
        if (makeBeforeRunTask == null) {
            CompileStepBeforeRun.a(5);
        }
        return CompileStepBeforeRun.doMake(this.b, runConfiguration, executionEnvironment, false);
    }

    static boolean doMake(Project project2, RunConfiguration runConfiguration, ExecutionEnvironment executionEnvironment, boolean bl2) {
        return CompileStepBeforeRun.doMake(project2, runConfiguration, executionEnvironment, bl2, Boolean.getBoolean(MAKE_PROJECT_ON_RUN_KEY));
    }

    static boolean doMake(Project project2, RunConfiguration runConfiguration, ExecutionEnvironment executionEnvironment, final boolean bl2, boolean bl3) {
        if (!(runConfiguration instanceof RunProfileWithCompileBeforeLaunchOption)) {
            return true;
        }
        if (runConfiguration instanceof RunConfigurationBase && ((RunConfigurationBase)runConfiguration).excludeCompileBeforeLaunchOption()) {
            return true;
        }
        RunProfileWithCompileBeforeLaunchOption runProfileWithCompileBeforeLaunchOption = (RunProfileWithCompileBeforeLaunchOption)runConfiguration;
        final Ref ref = new Ref((Object)Boolean.FALSE);
        try {
            final Semaphore semaphore = new Semaphore();
            semaphore.down();
            ProjectTaskNotification projectTaskNotification = new ProjectTaskNotification(){

                public void finished(@NotNull ProjectTaskResult projectTaskResult) {
                    if (projectTaskResult == null) {
                        1.a(0);
                    }
                    if ((projectTaskResult.getErrors() == 0 || bl2) && !projectTaskResult.isAborted()) {
                        ref.set((Object)Boolean.TRUE);
                    }
                    semaphore.up();
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionResult", "com/intellij/compiler/options/CompileStepBeforeRun$1", "finished"));
                }
            };
            TransactionGuard.submitTransaction((Disposable)project2, () -> {
                ProjectTask projectTask;
                Object object = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)executionEnvironment);
                ProjectTaskManager projectTaskManager = ProjectTaskManager.getInstance((Project)project2);
                if (bl3) {
                    projectTask = projectTaskManager.createAllModulesBuildTask(true, project2);
                } else {
                    Module[] moduleArray = runProfileWithCompileBeforeLaunchOption.getModules();
                    if (moduleArray.length > 0) {
                        for (Module module2 : moduleArray) {
                            if (module2 != null) continue;
                            a.error("RunConfiguration should not return null modules. Configuration=" + runProfileWithCompileBeforeLaunchOption.getName() + "; class=" + runProfileWithCompileBeforeLaunchOption.getClass().getName());
                        }
                        projectTask = projectTaskManager.createModulesBuildTask(moduleArray, true, true, true);
                    } else {
                        projectTask = projectTaskManager.createAllModulesBuildTask(true, project2);
                    }
                }
                if (!project2.isDisposed()) {
                    projectTaskManager.run(new ProjectTaskContext(object, runConfiguration), projectTask, projectTaskNotification);
                } else {
                    semaphore.up();
                }
            });
            semaphore.waitFor();
        }
        catch (Exception exception) {
            return false;
        }
        return (Boolean)ref.get();
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileContext compileContext) {
        return CompileStepBeforeRun.getRunConfiguration(compileContext.getCompileScope());
    }

    @Nullable
    public static RunConfiguration getRunConfiguration(CompileScope compileScope) {
        return (RunConfiguration)compileScope.getUserData(CompilerManager.RUN_CONFIGURATION_KEY);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        objectArray2[1] = "com/intellij/compiler/options/CompileStepBeforeRun";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledByDefault";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "executeTask";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MakeBeforeRunTask
    extends BeforeRunTask<MakeBeforeRunTask> {
        public MakeBeforeRunTask() {
            super(ID);
            this.setEnabled(true);
        }
    }
}

