/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.compiler.options.ModuleTableCellRenderer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ChooseModulesDialog;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public class TargetOptionsComponent
extends JPanel {
    private static final String[] a;
    private static final String c = "Same as language level";
    private final ComboBox e;
    private final JBTable d;
    private final Project b;

    public TargetOptionsComponent(Project project2) {
        super(new GridBagLayout());
        this.b = project2;
        this.e = TargetOptionsComponent.b();
        this.d = new JBTable((TableModel)new TargetLevelTableModel());
        this.d.setRowHeight(22);
        this.d.getEmptyText().setText("All modules will be compiled with project bytecode version");
        TableColumn tableColumn = this.d.getColumnModel().getColumn(0);
        tableColumn.setHeaderValue("Module");
        tableColumn.setCellRenderer(new ModuleTableCellRenderer());
        TableColumn tableColumn2 = this.d.getColumnModel().getColumn(1);
        String string = "Target bytecode version";
        tableColumn2.setHeaderValue("Target bytecode version");
        tableColumn2.setCellEditor(new TargetLevelCellEditor());
        tableColumn2.setCellRenderer(new TargetLevelCellRenderer());
        int n2 = this.d.getFontMetrics(this.d.getFont()).stringWidth("Target bytecode version") + 10;
        tableColumn2.setPreferredWidth(n2);
        tableColumn2.setMinWidth(n2);
        tableColumn2.setMaxWidth(n2);
        new TableSpeedSearch((JTable)this.d);
        this.add((Component)new JLabel("Project bytecode version: "), TargetOptionsComponent.a(0, 0, 1, 1, 0.0, 0.0, 0));
        this.add((Component)this.e, TargetOptionsComponent.a(1, 0, 1, 1, 1.0, 0.0, 0));
        this.add((Component)new JLabel("Per-module bytecode version:"), TargetOptionsComponent.a(0, 1, 2, 1, 1.0, 0.0, 0));
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.d).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TargetOptionsComponent.this.c();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TargetOptionsComponent.this.a();
            }
        }).createPanel();
        jPanel.setPreferredSize(new Dimension(this.d.getWidth(), 150));
        this.add((Component)jPanel, TargetOptionsComponent.a(0, 2, 2, 1, 1.0, 1.0, 1));
    }

    private void a() {
        int[] nArray = this.d.getSelectedRows();
        if (nArray.length > 0) {
            TableUtil.removeSelectedItems((JTable)this.d);
        }
    }

    private void c() {
        TargetLevelTableModel targetLevelTableModel = (TargetLevelTableModel)this.d.getModel();
        ArrayList<Module> arrayList = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.b).getModules()));
        HashSet<Module> hashSet = new HashSet<Module>();
        for (TargetLevelTableModel.Item object2 : targetLevelTableModel.getItems()) {
            hashSet.add(object2.module);
        }
        Iterator<TargetLevelTableModel.Item> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Module module4 = (Module)iterator.next();
            if (!hashSet.contains(module4)) continue;
            iterator.remove();
        }
        Collections.sort(arrayList, (module2, module3) -> module2.getName().compareTo(module3.getName()));
        iterator = new ChooseModulesDialog((Component)this, arrayList, "Choose module");
        iterator.show();
        List list2 = iterator.getChosenElements();
        if (!list2.isEmpty()) {
            targetLevelTableModel.addItems(list2);
            int n2 = targetLevelTableModel.getModuleRow((Module)list2.get(0));
            if (n2 != -1) {
                TableUtil.selectRows((JTable)this.d, (int[])new int[]{n2});
                TableUtil.scrollSelectionToVisible((JTable)this.d);
            }
        }
    }

    public void setProjectBytecodeTargetLevel(String string) {
        this.e.setSelectedItem((Object)(string == null ? "" : string));
    }

    @Nullable
    public String getProjectBytecodeTarget() {
        String string = ((String)this.e.getSelectedItem()).trim();
        return "".equals(string) ? null : string;
    }

    public Map<String, String> getModulesBytecodeTargetMap() {
        TargetLevelTableModel targetLevelTableModel = (TargetLevelTableModel)this.d.getModel();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (TargetLevelTableModel.Item item : targetLevelTableModel.getItems()) {
            hashMap.put(item.module.getName(), item.targetLevel);
        }
        return hashMap;
    }

    public void setModuleTargetLevels(Map<String, String> map) {
        Map<Module, String> map2;
        if (!map.isEmpty()) {
            map2 = new HashMap();
            for (Module module2 : ModuleManager.getInstance((Project)this.b).getModules()) {
                String string = map.get(module2.getName());
                if (string == null) continue;
                map2.put(module2, string);
            }
        } else {
            map2 = Collections.emptyMap();
        }
        ((TargetLevelTableModel)this.d.getModel()).setItems(map2);
    }

    private static GridBagConstraints a(int n2, int n3, int n4, int n5, double d2, double d3, int n6) {
        return new GridBagConstraints(n2, n3, n4, n5, d2, d3, 17, n6, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0);
    }

    private static ComboBox b() {
        ComboBox comboBox = new ComboBox((ComboBoxModel)new TargetLevelComboboxModel());
        comboBox.setEditable(true);
        comboBox.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                HintTextField hintTextField = new HintTextField(TargetOptionsComponent.c, 12);
                hintTextField.setBorder(null);
                return hintTextField;
            }
        });
        return comboBox;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("1.1");
        arrayList.add("1.2");
        for (LanguageLevel languageLevel : LanguageLevel.values()) {
            arrayList.add(JpsJavaSdkType.complianceOption((JavaVersion)languageLevel.toJavaVersion()));
        }
        a = ArrayUtil.toStringArray(arrayList);
    }

    static class HintTextField
    extends JTextField {
        private final char[] a;

        public HintTextField(String string) {
            this(string, 0);
        }

        public HintTextField(String string, int n2) {
            super(string, n2);
            this.a = string.toCharArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            boolean bl2 = this.isFocusOwner();
            if (!bl2 && this.getText().isEmpty()) {
                Color color = graphics.getColor();
                Font font = graphics.getFont();
                try {
                    graphics.setColor((Color)JBColor.GRAY);
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n2 = Math.abs(this.getWidth() - fontMetrics.charsWidth(this.a, 0, this.a.length)) / 2;
                    int n3 = Math.abs(this.getHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
                    graphics.drawChars(this.a, 0, this.a.length, n2, n3);
                }
                finally {
                    graphics.setColor(color);
                    graphics.setFont(font);
                }
            }
        }
    }

    private static class TargetLevelCellRenderer
    extends DefaultTableCellRenderer {
        private TargetLevelCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(0);
                if ("".equals(object)) {
                    jLabel.setForeground((Color)JBColor.GRAY);
                    jLabel.setText(TargetOptionsComponent.c);
                } else {
                    jLabel.setForeground(jTable.getForeground());
                }
            }
            return component;
        }
    }

    private static class TargetLevelCellEditor
    extends DefaultCellEditor {
        private TargetLevelCellEditor() {
            super((JComboBox<?>)TargetOptionsComponent.b());
            this.setClickCountToStart(0);
        }
    }

    private static final class TargetLevelComboboxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private final List<String> a = new ArrayList<String>();
        private String b = "";

        TargetLevelComboboxModel() {
            for (int i2 = a.length - 1; i2 >= 0; --i2) {
                this.a.add(a[i2]);
            }
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @Override
        public void setSelectedItem(Object object) {
            this.b = this.a((String)object);
            this.fireContentsChanged(this, 0, this.a.size());
        }

        @Override
        public Object getSelectedItem() {
            return this.b;
        }

        @Override
        public Object getElementAt(int n2) {
            return this.a.get(n2);
        }

        private String a(String string) {
            string = string.trim();
            for (String string2 : this.a) {
                if (!string2.equals(string)) continue;
                return string2;
            }
            return string;
        }
    }

    private static final class TargetLevelTableModel
    extends AbstractTableModel
    implements ItemRemovable {
        private final List<Item> a = new ArrayList<Item>();

        private TargetLevelTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return n3 != 0;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            Item item = this.a.get(n2);
            return n3 == 0 ? item.module : item.targetLevel;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            Item item = this.a.get(n2);
            item.targetLevel = ((String)object).trim();
            this.fireTableCellUpdated(n2, n3);
        }

        public void addItems(Collection<Module> collection) {
            for (Module module2 : collection) {
                this.a.add(new Item(module2));
            }
            this.a();
            this.fireTableDataChanged();
        }

        private void a() {
            Collections.sort(this.a, (item, item2) -> item.module.getName().compareTo(item2.module.getName()));
        }

        public List<Item> getItems() {
            return this.a;
        }

        public void removeRow(int n2) {
            this.a.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }

        public void setItems(Map<Module, String> map) {
            this.a.clear();
            for (Map.Entry<Module, String> entry : map.entrySet()) {
                this.a.add(new Item(entry.getKey(), entry.getValue()));
            }
            this.a();
            this.fireTableDataChanged();
        }

        public int getModuleRow(Module module2) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                if (!this.a.get((int)i2).module.equals(module2)) continue;
                return i2;
            }
            return -1;
        }

        private static final class Item {
            final Module module;
            String targetLevel = "";

            Item(Module module2) {
                this.module = module2;
            }

            Item(Module module2, String string) {
                this.module = module2;
                this.targetLevel = string;
            }
        }
    }
}

