/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.impl.CompilerErrorTreeView;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.AppIcon;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerTask
extends Task.Backgroundable {
    private static final Logger q = Logger.getInstance((String)"#com.intellij.compiler.progress.CompilerProgressIndicator");
    private static final Key<Object> g = Key.create((String)"CONTENT_ID");
    private static final Key<Object> h = Key.create((String)"SESSION_ID");
    private static final String o = "compiler";
    @NotNull
    private final Object d;
    private final boolean j;
    @NotNull
    private Object i;
    private NewErrorTreeViewPanel s;
    private final Object v;
    private final String k;
    private final boolean a;
    private final boolean f;
    private final boolean n;
    private int p;
    private int c;
    private boolean b;
    private volatile ProgressIndicator r;
    private Runnable t;
    private final AtomicBoolean l;
    private Runnable e;
    private final boolean u;
    private CloseListener m;

    @Deprecated
    public CompilerTask(@NotNull Project project2, String string, boolean bl2, boolean bl3, boolean bl4) {
        if (project2 == null) {
            CompilerTask.a(0);
        }
        this(project2, string, bl2, bl3, bl4, false);
    }

    public CompilerTask(@NotNull Project project2, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (project2 == null) {
            CompilerTask.a(1);
        }
        this(project2, string, bl2, bl3, bl4, bl5, false);
    }

    public CompilerTask(@NotNull Project project2, String string, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (project2 == null) {
            CompilerTask.a(2);
        }
        super(project2, string);
        this.i = this.d = new IDObject("content_id");
        this.v = new Object();
        this.p = 0;
        this.c = 0;
        this.b = false;
        this.r = new EmptyProgressIndicator();
        this.l = new AtomicBoolean(false);
        this.k = string;
        this.a = bl2;
        this.f = bl3;
        this.n = bl4;
        this.u = bl5;
        this.j = bl6;
    }

    @NotNull
    public Object getSessionId() {
        Object object = this.i;
        if (object == null) {
            CompilerTask.a(3);
        }
        return object;
    }

    public void setSessionId(@NotNull Object object) {
        if (object == null) {
            CompilerTask.a(4);
        }
        this.i = object;
    }

    @NotNull
    public Object getContentId() {
        Object object = this.d;
        if (object == null) {
            CompilerTask.a(5);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCloseAction(final Runnable runnable) {
        Object object = this.v;
        synchronized (object) {
            if (this.s != null) {
                Disposer.register((Disposable)this.s, (Disposable)new Disposable(){

                    public void dispose() {
                        runnable.run();
                    }
                });
                return;
            }
        }
        runnable.run();
    }

    public boolean shouldStartInBackground() {
        return !this.j;
    }

    public boolean isConditionalModal() {
        return this.j;
    }

    public ProgressIndicator getIndicator() {
        return this.r;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.p > 0 ? "Compiler (errors)" : "Compiler (success)", "Compilation Finished", this.p + " Errors, " + this.c + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(@NotNull ProgressIndicator progressIndicator) {
        if (progressIndicator == null) {
            CompilerTask.a(6);
        }
        this.r = progressIndicator;
        this.r.setIndeterminate(false);
        ProjectManager projectManager = ProjectManager.getInstance();
        this.m = new CloseListener();
        projectManager.addProjectManagerListener(this.myProject, (ProjectManagerListener)this.m);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)this.myProject)).getCompilationSemaphore();
        boolean bl2 = false;
        while (true) {
            try {
                if (bl2) break;
                bl2 = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                if (bl2 || this.n) continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
            catch (ProcessCanceledException processCanceledException) {
                try {
                    progressIndicator.stop();
                    projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.m);
                    return;
                }
                finally {
                    if (bl2) {
                        semaphore.release();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        progressIndicator.stop();
                        projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.m);
                        throw throwable;
                    }
                    finally {
                        if (bl2) {
                            semaphore.release();
                        }
                    }
                }
            }
            try {
                progressIndicator.stop();
                projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.m);
                return;
            }
            finally {
                if (bl2) {
                    semaphore.release();
                }
            }
            {
                if (!progressIndicator.isCanceled()) continue;
            }
            break;
        }
        if (!this.isHeadless()) {
            this.d();
        }
        this.t.run();
        try {
            progressIndicator.stop();
            projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.m);
            return;
        }
        finally {
            if (bl2) {
                semaphore.release();
            }
        }
    }

    private void a() {
        if (!this.r.isRunning()) {
            return;
        }
        if (this.l.getAndSet(true)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project2 = this.myProject;
            if (project2 == null || project2.isDisposed()) {
                return;
            }
            Object object = this.v;
            synchronized (object) {
                if (this.s == null) {
                    this.a(project2, null);
                }
            }
        });
    }

    private void d() {
        ProgressIndicator progressIndicator = this.r;
        if (!(progressIndicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)progressIndicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

            public void cancel() {
                super.cancel();
                this.a();
                this.b();
            }

            public void stop() {
                super.stop();
                if (!this.isCanceled()) {
                    this.a();
                }
                this.b();
            }

            private void a() {
                if (!CompilerTask.this.g()) {
                    SwingUtilities.invokeLater(() -> {
                        if (CompilerTask.this.myProject != null && CompilerTask.this.myProject.isDisposed()) {
                            return;
                        }
                        Object object = CompilerTask.this.v;
                        synchronized (object) {
                            if (CompilerTask.this.s != null) {
                                CompilerTask.this.s.selectFirstMessage();
                            }
                        }
                    });
                }
            }

            private void b() {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (CompilerTask.this.myProject != null && CompilerTask.this.myProject.isDisposed()) {
                        return;
                    }
                    AppIcon appIcon = AppIcon.getInstance();
                    if (appIcon.hideProgress(CompilerTask.this.myProject, (Object)CompilerTask.o)) {
                        if (CompilerTask.this.p > 0) {
                            appIcon.setErrorBadge(CompilerTask.this.myProject, String.valueOf(CompilerTask.this.p));
                            appIcon.requestAttention(CompilerTask.this.myProject, true);
                        } else if (!CompilerTask.this.u) {
                            appIcon.setOkBadge(CompilerTask.this.myProject, true);
                            appIcon.requestAttention(CompilerTask.this.myProject, false);
                        }
                    }
                });
            }

            public void setText(String string) {
                super.setText(string);
                CompilerTask.this.f();
            }

            public void setText2(String string) {
                super.setText2(string);
                CompilerTask.this.f();
            }

            public void setFraction(double d2) {
                super.setFraction(d2);
                CompilerTask.this.f();
                GuiUtils.invokeLaterIfNeeded(() -> AppIcon.getInstance().setProgress(CompilerTask.this.myProject, (Object)CompilerTask.o, AppIconScheme.Progress.BUILD, d2, true), (ModalityState)ModalityState.any());
            }

            protected void onProgressChange() {
                CompilerTask.this.a();
            }
        });
    }

    public void cancel() {
        if (!this.r.isCanceled()) {
            this.r.cancel();
        }
    }

    public void addMessage(CompilerMessage compilerMessage) {
        this.a();
        CompilerMessageCategory compilerMessageCategory = compilerMessage.getCategory();
        if (CompilerMessageCategory.WARNING.equals((Object)compilerMessageCategory)) {
            ++this.c;
        } else if (CompilerMessageCategory.ERROR.equals((Object)compilerMessageCategory)) {
            ++this.p;
            this.d(compilerMessage);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.e();
            this.b(compilerMessage);
        } else {
            Window window = this.getWindow();
            ModalityState modalityState = window != null ? ModalityState.stateForComponent((Component)window) : ModalityState.NON_MODAL;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (this.myProject != null && !this.myProject.isDisposed()) {
                    this.e();
                    this.b(compilerMessage);
                }
            }, modalityState);
        }
    }

    private void d(CompilerMessage compilerMessage) {
        WolfTheProblemSolver wolfTheProblemSolver = WolfTheProblemSolver.getInstance((Project)this.myProject);
        VirtualFile virtualFile = CompilerTask.c(compilerMessage);
        wolfTheProblemSolver.queue(virtualFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(CompilerMessage compilerMessage) {
        Object object = this.v;
        synchronized (object) {
            if (this.s != null) {
                boolean bl2;
                Navigatable navigatable = compilerMessage.getNavigatable();
                VirtualFile virtualFile = compilerMessage.getVirtualFile();
                CompilerMessageCategory compilerMessageCategory = compilerMessage.getCategory();
                int n2 = CompilerTask.translateCategory(compilerMessageCategory);
                String[] stringArray = CompilerTask.a(compilerMessage);
                if (navigatable != null) {
                    String string = virtualFile != null ? virtualFile.getPresentableUrl() : compilerMessageCategory.getPresentableText();
                    this.s.addMessage(n2, stringArray, string, navigatable, compilerMessage.getExportTextPrefix(), compilerMessage.getRenderTextPrefix(), (Object)compilerMessage.getVirtualFile());
                } else {
                    this.s.addMessage(n2, stringArray, virtualFile, -1, -1, (Object)compilerMessage.getVirtualFile());
                }
                boolean bl3 = bl2 = !this.b && (CompilerMessageCategory.ERROR.equals((Object)compilerMessageCategory) || CompilerMessageCategory.WARNING.equals((Object)compilerMessageCategory) && !ErrorTreeViewConfiguration.getInstance((Project)this.myProject).isHideWarnings());
                if (bl2) {
                    this.b = true;
                    this.b();
                }
            }
        }
    }

    private static String[] a(CompilerMessage compilerMessage) {
        String string = compilerMessage.getMessage();
        if (!string.contains("\n")) {
            return new String[]{string};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return ArrayUtil.toStringArray(arrayList);
    }

    public static int translateCategory(CompilerMessageCategory compilerMessageCategory) {
        if (CompilerMessageCategory.ERROR.equals((Object)compilerMessageCategory)) {
            return 4;
        }
        if (CompilerMessageCategory.WARNING.equals((Object)compilerMessageCategory)) {
            return 5;
        }
        if (CompilerMessageCategory.STATISTICS.equals((Object)compilerMessageCategory)) {
            return 2;
        }
        if (CompilerMessageCategory.INFORMATION.equals((Object)compilerMessageCategory)) {
            return 3;
        }
        q.error("Unknown message category: " + compilerMessageCategory);
        return 0;
    }

    public void start(Runnable runnable, Runnable runnable2) {
        this.t = runnable;
        this.e = runnable2;
        this.queue();
    }

    private void f() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() {
        JComponent jComponent;
        if (this.g()) {
            return;
        }
        if (this.r.isCanceled()) {
            return;
        }
        Object object = this.v;
        synchronized (object) {
            if (this.s != null) {
                return;
            }
            this.s = new CompilerErrorTreeView(this.myProject, this.e);
            this.s.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                public void stopProcess() {
                    CompilerTask.this.cancel();
                }

                public boolean isProcessStopped() {
                    return !CompilerTask.this.r.isRunning();
                }
            });
            jComponent = this.s.getComponent();
        }
        object = MessageView.SERVICE.getInstance((Project)this.myProject);
        Content content = ContentFactory.SERVICE.getInstance().createContent(jComponent, this.k, true);
        content.setHelpId("reference.toolWindows.messages");
        g.set((UserDataHolder)content, this.d);
        h.set((UserDataHolder)content, this.i);
        object.getContentManager().addContent(content);
        this.m.setContent(content, object.getContentManager());
        this.a(this.myProject, content);
        object.getContentManager().setSelectedContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCompilerContent() {
        Object object = this.v;
        synchronized (object) {
            if (this.s != null) {
                CompilerTask.showCompilerContent(this.myProject, this.d);
            }
        }
    }

    public static boolean showCompilerContent(Project project2, Object object) {
        MessageView messageView = MessageView.SERVICE.getInstance((Project)project2);
        for (Content content : messageView.getContentManager().getContents()) {
            if (g.get((UserDataHolder)content) != object) continue;
            messageView.getContentManager().setSelectedContent(content);
            return true;
        }
        return false;
    }

    private void a(Project project2, Content content) {
        Content[] contentArray;
        if (project2.isDisposed()) {
            return;
        }
        MessageView messageView = MessageView.SERVICE.getInstance((Project)project2);
        for (Content content2 : contentArray = messageView.getContentManager().getContents()) {
            boolean bl2;
            if (content2.isPinned() || content2 == content) continue;
            boolean bl3 = bl2 = g.get((UserDataHolder)content2) == this.d;
            if (!bl2) {
                Object object = h.get((UserDataHolder)content2);
                boolean bl4 = bl2 = object != null && object != this.i;
            }
            if (!bl2) continue;
            messageView.getContentManager().removeContent(content2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        Object object = this.v;
        synchronized (object) {
            ToolWindow toolWindow;
            if (this.s != null && this.myProject != null && (toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                toolWindow.activate(null, false);
            }
        }
    }

    public Window getWindow() {
        return null;
    }

    public boolean isHeadless() {
        return this.a && !this.f;
    }

    private boolean g() {
        return this.a;
    }

    private static VirtualFile c(CompilerMessage compilerMessage) {
        Navigatable navigatable;
        VirtualFile virtualFile = compilerMessage.getVirtualFile();
        if (virtualFile == null && (navigatable = compilerMessage.getNavigatable()) instanceof OpenFileDescriptor) {
            virtualFile = ((OpenFileDescriptor)navigatable).getFile();
        }
        return virtualFile;
    }

    public static TextRange getTextRange(CompilerMessage compilerMessage) {
        Navigatable navigatable = compilerMessage.getNavigatable();
        if (navigatable instanceof OpenFileDescriptor) {
            int n2 = ((OpenFileDescriptor)navigatable).getOffset();
            return new TextRange(n2, n2);
        }
        return TextRange.EMPTY_RANGE;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/progress/CompilerTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/progress/CompilerTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSessionId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSessionId";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class IDObject {
        private final String a;

        public IDObject(@NotNull String string) {
            if (string == null) {
                IDObject.a(0);
            }
            this.a = string;
        }

        public String toString() {
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/compiler/progress/CompilerTask$IDObject", "<init>"));
        }
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content a;
        private ContentManager d;
        private boolean b = false;
        private boolean c = false;

        private CloseListener() {
        }

        public void projectClosingBeforeSave(@NotNull Project project2) {
            if (project2 == null) {
                CloseListener.a(0);
            }
            if (CompilerTask.this.myProject == project2) {
                CompilerTask.this.cancel();
            }
        }

        public void setContent(Content content, ContentManager contentManager) {
            this.a = content;
            this.d = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent contentManagerEvent) {
            if (contentManagerEvent.getContent() == this.a) {
                Object object = CompilerTask.this.v;
                synchronized (object) {
                    if (CompilerTask.this.s != null) {
                        Disposer.dispose((Disposable)CompilerTask.this.s);
                        CompilerTask.this.s = null;
                        if (CompilerTask.this.r.isRunning()) {
                            CompilerTask.this.cancel();
                        }
                        if (AppIcon.getInstance().hideProgress(CompilerTask.this.myProject, (Object)CompilerTask.o)) {
                            AppIcon.getInstance().setErrorBadge(CompilerTask.this.myProject, null);
                        }
                    }
                }
                this.d.removeContentManagerListener((ContentManagerListener)this);
                this.a.release();
                this.a = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent contentManagerEvent) {
            if (contentManagerEvent.getContent() == this.a && !CompilerTask.this.r.isCanceled() && this.a()) {
                int n2 = Messages.showOkCancelDialog((Project)CompilerTask.this.myProject, (String)CompilerBundle.message((String)"warning.compiler.running.on.toolwindow.close", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.running.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (n2 != 0) {
                    contentManagerEvent.consume();
                }
                this.c = true;
            }
        }

        private boolean a() {
            return !this.c && !this.b && CompilerTask.this.r.isRunning();
        }

        public void projectClosed(Project project2) {
            if (project2.equals(CompilerTask.this.myProject) && this.a != null) {
                this.d.removeContent(this.a, true);
            }
        }

        public void projectClosing(Project project2) {
            if (project2.equals(CompilerTask.this.myProject)) {
                this.b = true;
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/progress/CompilerTask$CloseListener", "projectClosingBeforeSave"));
        }
    }
}

