/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.compiler.server.PreloadedProcessMessageHandler;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.ThreadLocalRandom;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.api.TaskFutureAdapter;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;

public class BuildManager
implements Disposable {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    private static final Key<Integer> m = Key.create((String)"_compiler_process_debug_port_");
    private static final Key<String> C = Key.create((String)"_force_model_loading");
    private static final Key<CharSequence> k = Key.create((String)"_process_launch_errors_");
    private static final SimpleDateFormat e = new SimpleDateFormat("dd.MM.yyyy");
    private static final Logger v = Logger.getInstance((String)"#com.intellij.compiler.server.BuildManager");
    private static final String s = "compiler.process.jdk";
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private final boolean y;
    private static final String p = ".iws";
    private static final String z = ".ipr";
    private static final String x = "/.idea/";
    private static final Function<String, Boolean> t = SystemInfo.isFileSystemCaseSensitive ? string -> !string.contains(x) && !string.endsWith(p) && !string.endsWith(z) : string -> !StringUtil.endsWithIgnoreCase((String)string, (String)p) && !StringUtil.endsWithIgnoreCase((String)string, (String)z) && !StringUtil.containsIgnoreCase((String)string, (String)x);
    private final List<String> a = new SmartList();
    private final ProjectManager q;
    private final Map<TaskFuture, Project> w = Collections.synchronizedMap(new HashMap());
    private final Map<String, RequestFuture> h = Collections.synchronizedMap(new HashMap());
    private final Map<String, Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>> r = Collections.synchronizedMap(new HashMap());
    private final BuildProcessClasspathManager b = new BuildProcessClasspathManager();
    private final ExecutorService A = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager requestProcessor pool");
    private final List<VFileEvent> f = new ArrayList<VFileEvent>();
    private final ExecutorService B = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager auto-make trigger");
    private final Map<String, ProjectData> D = Collections.synchronizedMap(new HashMap());
    private volatile int j;
    private final BuildManagerPeriodicTask u = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.automake.trigger.delay");
        }

        @Override
        protected void runTask() {
            BuildManager.this.e();
        }
    };
    private final BuildManagerPeriodicTask o = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.document.save.trigger.delay");
        }

        @Override
        public void runTask() {
            if (this.a()) {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false));
            }
        }

        private boolean a() {
            Project project2 = BuildManager.this.h();
            return project2 != null && BuildManager.c(project2);
        }
    };
    private final Runnable l = () -> {
        int n2 = Registry.intValue((String)"compiler.build.data.unused.threshold", (int)-1);
        if (n2 <= 0) {
            return;
        }
        File file2 = this.getBuildSystemDirectory().toFile();
        File[] fileArray = file2.listFiles(file -> file.isDirectory() && !TEMP_DIR_NAME.equals(file.getName()));
        if (fileArray != null) {
            Date date = new Date();
            for (File file3 : fileArray) {
                File file4 = BuildManager.b(file3);
                if (file4.exists()) {
                    File file5;
                    Pair<Date, File> pair2 = BuildManager.a(file4);
                    if (pair2 == null || ((file5 = (File)pair2.second) == null || file5.exists()) && DateFormatUtil.getDifferenceInDays((Date)((Date)pair2.first), (Date)date) <= (long)n2) continue;
                    v.info("Clearing project build data because the project does not exist or was not opened for more than " + n2 + " days: " + file3);
                    FileUtil.delete((File)file3);
                    continue;
                }
                BuildManager.a(null, file3);
            }
        }
    };
    private final ChannelRegistrar c = new ChannelRegistrar();
    private final BuildMessageDispatcher d = new BuildMessageDispatcher();
    private volatile int g = -1;
    @NotNull
    private final Charset i = CharsetToolkit.getDefaultSystemCharset();
    private volatile boolean n;

    public BuildManager(ProjectManager projectManager) {
        final Application application = ApplicationManager.getApplication();
        this.y = application.isUnitTestMode();
        this.q = projectManager;
        String string = BuildManager.d();
        if (string != null) {
            this.a.add("-Djps.fallback.jdk.home=" + string);
            this.a.add("-Djps.fallback.jdk.version=" + SystemInfo.JAVA_VERSION);
        }
        MessageBusConnection messageBusConnection = application.getMessageBus().connect();
        messageBusConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectWatcher());
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> list2) {
                if (list2 == null) {
                    3.a(0);
                }
                if (!BuildManager.this.y) {
                    List list3 = BuildManager.this.f;
                    synchronized (list3) {
                        BuildManager.this.f.addAll(list2);
                    }
                    BuildManager.this.B.submit(() -> {
                        if (!application.isDisposed()) {
                            ReadAction.run(() -> {
                                ArrayList arrayList;
                                List list2 = BuildManager.this.f;
                                synchronized (list2) {
                                    if (BuildManager.this.f.isEmpty()) {
                                        return;
                                    }
                                    arrayList = new ArrayList(BuildManager.this.f);
                                    BuildManager.this.f.clear();
                                }
                                if (this.a(arrayList)) {
                                    BuildManager.this.scheduleAutoMake();
                                }
                            });
                        } else {
                            List list2 = BuildManager.this.f;
                            synchronized (list2) {
                                BuildManager.this.f.clear();
                            }
                        }
                    });
                }
            }

            private boolean a(List<? extends VFileEvent> list2) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project2 = null;
                ProjectFileIndex projectFileIndex = null;
                for (VFileEvent vFileEvent : list2) {
                    VirtualFile virtualFile = vFileEvent.getFile();
                    if (virtualFile == null) continue;
                    if (!virtualFile.isValid()) {
                        return true;
                    }
                    if (project2 == null) {
                        project2 = BuildManager.this.h();
                        if (project2 == null) {
                            return false;
                        }
                        projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    }
                    if (!projectFileIndex.isInContent(virtualFile) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile, (Project)project2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$3", "after"));
            }
        });
        messageBusConnection.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(@NotNull Project project2, @Nullable String string) {
                if (project2 == null) {
                    4.a(0);
                }
                BuildManager.this.j++;
                BuildManager.this.cancelAutoMakeTasks(project2);
            }

            public void batchChangeCompleted(@NotNull Project project2) {
                if (project2 == null) {
                    4.a(1);
                }
                BuildManager.this.j--;
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/compiler/server/BuildManager$4";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent documentEvent) {
                VirtualFile virtualFile;
                Document document = documentEvent.getDocument();
                if (FileDocumentManager.getInstance().isDocumentUnsaved(document) && (virtualFile = FileDocumentManager.getInstance().getFile(document)) != null && virtualFile.isInLocalFileSystem()) {
                    BuildManager.this.b();
                }
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(this::k);
        ScheduledFuture<?> scheduledFuture = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.runCommand(this.l), 3L, 180L, TimeUnit.MINUTES);
        Disposer.register((Disposable)this, () -> scheduledFuture.cancel(false));
    }

    @Nullable
    private static String d() {
        String string;
        String string2 = SystemProperties.getJavaHome();
        if (string2 == null) {
            return null;
        }
        if (!JdkUtil.checkForJdk((String)string2) && (string = new File(string2).getParent()) != null && JdkUtil.checkForJdk((String)string)) {
            string2 = string;
        }
        return FileUtil.toSystemIndependentName((String)string2);
    }

    private List<Project> f() {
        Project[] projectArray = this.q.getOpenProjects();
        if (projectArray.length == 0) {
            return Collections.emptyList();
        }
        SmartList smartList = new SmartList();
        for (Project project2 : projectArray) {
            if (!BuildManager.f(project2)) continue;
            smartList.add(project2);
        }
        return smartList;
    }

    private static boolean f(@Nullable Project project2) {
        return project2 != null && !project2.isDisposed() && !project2.isDefault() && project2.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getComponent(BuildManager.class);
    }

    public void notifyFilesChanged(Collection<File> collection) {
        this.a(collection, false);
    }

    public void notifyFilesDeleted(Collection<File> collection) {
        this.a(collection, true);
    }

    public void runCommand(@NotNull Runnable runnable) {
        if (runnable == null) {
            BuildManager.a(0);
        }
        this.A.submit(runnable);
    }

    private void a(Collection<File> collection, boolean bl2) {
        this.runCommand(() -> {
            ArrayList<String> arrayList = new ArrayList<String>(collection.size());
            for (Object object : collection) {
                String object2 = FileUtil.toSystemIndependentName((String)((File)object).getPath());
                if (!((Boolean)t.fun((Object)object2)).booleanValue()) continue;
                arrayList.add(object2);
            }
            if (arrayList.isEmpty()) {
                return;
            }
            Map<String, ProjectData> map = this.D;
            synchronized (map) {
                for (Map.Entry entry : this.D.entrySet()) {
                    UUID uUID;
                    Channel channel;
                    RequestFuture requestFuture;
                    ProjectData projectData = (ProjectData)entry.getValue();
                    if (bl2) {
                        projectData.addDeleted(arrayList);
                    } else {
                        projectData.addChanged(arrayList);
                    }
                    if ((requestFuture = this.h.get(entry.getKey())) == null || requestFuture.isCancelled() || requestFuture.isDone() || (channel = this.d.getConnectedChannel(uUID = requestFuture.getRequestID())) == null) continue;
                    CmdlineRemoteProto.Message.ControllerMessage controllerMessage = (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(projectData.createNextEvent()).build();
                    channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)uUID, (CmdlineRemoteProto.Message.ControllerMessage)controllerMessage));
                }
            }
        });
    }

    public static void forceModelLoading(CompileContext compileContext) {
        compileContext.getCompileScope().putUserData(C, (Object)Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(Project project2) {
        String string = BuildManager.b(project2);
        this.e(string);
        Map<String, ProjectData> map = this.D;
        synchronized (map) {
            ProjectData projectData = this.D.get(string);
            if (projectData != null) {
                projectData.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        boolean bl2;
        Map<String, ProjectData> map = this.D;
        synchronized (map) {
            bl2 = !this.D.isEmpty();
            for (Map.Entry<String, ProjectData> entry : this.D.entrySet()) {
                this.e(entry.getKey());
                entry.getValue().dropChanges();
            }
        }
        if (bl2) {
            this.scheduleAutoMake();
        }
    }

    public boolean isProjectWatched(Project project2) {
        return this.D.containsKey(BuildManager.b(project2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(Project project2) {
        String string = BuildManager.b(project2);
        Map<String, ProjectData> map = this.D;
        synchronized (map) {
            ProjectData projectData = this.D.get(string);
            if (projectData != null && !projectData.a) {
                return BuildManager.a(projectData.b);
            }
            return null;
        }
    }

    private static List<String> a(Collection<InternedPath> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (InternedPath internedPath : collection) {
            arrayList.add(internedPath.getValue());
        }
        return arrayList;
    }

    @Nullable
    private static String b(Project project2) {
        String string = project2.getPresentableUrl();
        if (string == null) {
            return null;
        }
        return VirtualFileManager.extractPath((String)string);
    }

    public void scheduleAutoMake() {
        if (!this.y && !PowerSaveMode.isEnabled()) {
            if (v.isDebugEnabled()) {
                v.debug("Automake scheduled:\n" + BuildManager.a(Thread.currentThread(), 10));
            }
            this.u.schedule();
        }
    }

    @NotNull
    private static String a(Thread thread, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        for (int i2 = 0; i2 < n2 && i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder.append("\tat ").append(stackTraceElement).append("\n");
        }
        String string = stringBuilder.toString();
        if (string == null) {
            BuildManager.a(1);
        }
        return string;
    }

    private void b() {
        if (!this.y && !PowerSaveMode.isEnabled()) {
            if (v.isDebugEnabled()) {
                v.debug("Automake canceled; reason: project save scheduled");
            }
            this.u.cancelPendingExecution();
            this.o.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e() {
        Project project2 = this.h();
        if (project2 == null || !BuildManager.c(project2)) {
            return;
        }
        List list2 = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
        AutoMakeMessageHandler autoMakeMessageHandler = new AutoMakeMessageHandler(project2);
        TaskFuture taskFuture = this.scheduleBuild(project2, false, true, false, list2, Collections.emptyList(), Collections.emptyMap(), autoMakeMessageHandler);
        if (taskFuture != null) {
            this.w.put(taskFuture, project2);
            try {
                taskFuture.waitFor();
            }
            finally {
                this.w.remove(taskFuture);
                if (autoMakeMessageHandler.unprocessedFSChangesDetected()) {
                    this.scheduleAutoMake();
                }
            }
        }
    }

    private static boolean c(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.a(2);
        }
        if (project2.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration compilerWorkspaceConfiguration = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        if (!compilerWorkspaceConfiguration.MAKE_PROJECT_ON_SAVE) {
            return false;
        }
        return compilerWorkspaceConfiguration.allowAutoMakeWhileRunningApplication() || !BuildManager.d(project2);
    }

    @Nullable
    private Project h() {
        return this.a((Window)null);
    }

    @Nullable
    private Project a(@Nullable Window window) {
        Container container;
        List<Project> list2 = this.f();
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() == 1) {
            return list2.get(0);
        }
        if (window == null && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null) {
            return null;
        }
        Container container2 = window;
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        container = null;
        if (container2 instanceof IdeFrame) {
            container = ((IdeFrame)container2).getProject();
        }
        if (container == null) {
            container = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)container2));
        }
        return BuildManager.f((Project)container) ? container : null;
    }

    private static boolean d(Project project2) {
        for (ProcessHandler processHandler : ExecutionManager.getInstance((Project)project2).getRunningProcesses()) {
            if (processHandler.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)processHandler, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskFuture> cancelAutoMakeTasks(Project project2) {
        SmartList smartList = new SmartList();
        Map<TaskFuture, Project> map = this.w;
        synchronized (map) {
            for (Map.Entry<TaskFuture, Project> entry : this.w.entrySet()) {
                if (!entry.getValue().equals(project2)) continue;
                TaskFuture taskFuture = entry.getKey();
                taskFuture.cancel(false);
                smartList.add(taskFuture);
            }
        }
        if (v.isDebugEnabled() && !smartList.isEmpty()) {
            v.debug("Automake cancel (all tasks):\n" + BuildManager.a(Thread.currentThread(), 10));
        }
        return smartList;
    }

    private void j() {
        String[] stringArray;
        for (String string : stringArray = ArrayUtil.toStringArray(this.r.keySet())) {
            this.e(string);
        }
    }

    private void e(String string) {
        this.runCommand(() -> {
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair2 = this.a(string);
            if (pair2 != null) {
                RequestFuture requestFuture = (RequestFuture)pair2.first;
                OSProcessHandler oSProcessHandler = (OSProcessHandler)pair2.second;
                this.d.cancelSession(requestFuture.getRequestID());
                this.b((String)string).taskQueue.submit(() -> {
                    Throwable throwable = null;
                    try {
                        while (!oSProcessHandler.waitFor()) {
                            v.info("processHandler.waitFor() returned false for session " + requestFuture.getRequestID() + ", continue waiting");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    finally {
                        this.b(requestFuture.getRequestID(), throwable);
                    }
                });
            }
        });
    }

    @Nullable
    private Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> a(String string) {
        Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair2;
        Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> future = this.r.remove(string);
        try {
            pair2 = future != null ? future.get() : null;
        }
        catch (Throwable throwable) {
            v.info(throwable);
            pair2 = null;
        }
        return pair2 != null && !((RequestFuture)pair2.first).isDone() ? pair2 : null;
    }

    @Nullable
    public TaskFuture scheduleBuild(Project project2, boolean bl2, boolean bl3, boolean bl4, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> list2, Collection<String> collection, Map<String, String> map, DefaultMessageHandler defaultMessageHandler) {
        String string = BuildManager.b(project2);
        boolean bl5 = defaultMessageHandler instanceof AutoMakeMessageHandler;
        NotifyingMessageHandler notifyingMessageHandler = new NotifyingMessageHandler(project2, defaultMessageHandler, bl5);
        try {
            this.c();
        }
        catch (Exception exception) {
            UUID uUID = UUID.randomUUID();
            notifyingMessageHandler.handleFailure(uUID, CmdlineProtoUtil.createFailure((String)exception.getMessage(), null));
            notifyingMessageHandler.sessionTerminated(uUID);
            return null;
        }
        DelegateFuture delegateFuture = new DelegateFuture();
        this.runCommand(() -> {
            UUID uUID;
            boolean bl6;
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair2 = this.a(string);
            RequestFuture requestFuture = pair2 != null ? (RequestFuture)pair2.first : null;
            boolean bl7 = bl6 = requestFuture != null;
            if (bl6) {
                v.info("Using preloaded build process to compile " + string);
                uUID = requestFuture.getRequestID();
                ((PreloadedProcessMessageHandler)requestFuture.getMessageHandler()).setDelegateHandler(notifyingMessageHandler);
            } else {
                uUID = UUID.randomUUID();
            }
            RequestFuture requestFuture2 = bl6 ? requestFuture : new RequestFuture((Object)notifyingMessageHandler, uUID, new CancelBuildSessionAction());
            TaskFuture[] taskFutureArray = new TaskFuture[]{requestFuture2};
            if (!bl6 && (requestFuture2.isCancelled() || project2.isDisposed())) {
                notifyingMessageHandler.sessionTerminated(uUID);
                requestFuture2.setDone();
            } else {
                ExecutorService executorService;
                CmdlineRemoteProto.Message.ControllerMessage.FSEvent fSEvent;
                boolean bl8;
                Object object;
                CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globalSettings = (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(PathManager.getOptionsPath()).build();
                CmdlineRemoteProto.Message.ControllerMessage controllerMessage = this.D;
                synchronized (controllerMessage) {
                    object = this.b(string);
                    if (bl2) {
                        ((ProjectData)object).dropChanges();
                    }
                    if (this.y) {
                        v.info("Scheduling build for " + string + "; CHANGED: " + new HashSet<String>(BuildManager.a(((ProjectData)object).b)) + "; DELETED: " + new HashSet<String>(BuildManager.a(((ProjectData)object).c)));
                    }
                    fSEvent = (bl8 = ((ProjectData)object).getAndResetRescanFlag()) ? null : ((ProjectData)object).createNextEvent();
                    executorService = ((ProjectData)object).taskQueue;
                }
                controllerMessage = bl2 ? CmdlineProtoUtil.createBuildRequest((String)string, (List)list2, Collections.emptyList(), (Map)map, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globalSettings, null) : (bl4 ? CmdlineProtoUtil.createUpToDateCheckRequest((String)string, (List)list2, (Collection)collection, (Map)map, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globalSettings, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)fSEvent) : CmdlineProtoUtil.createBuildRequest((String)string, (List)list2, bl3 ? Collections.emptyList() : collection, (Map)map, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globalSettings, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)fSEvent));
                if (!bl6) {
                    this.d.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)requestFuture2, controllerMessage);
                }
                try {
                    object = executorService.submit(() -> {
                        Throwable throwable = null;
                        try {
                            CharSequence charSequence;
                            OSProcessHandler oSProcessHandler;
                            if (project2.isDisposed()) {
                                if (bl6) {
                                    requestFuture2.cancel(false);
                                } else {
                                    return;
                                }
                            }
                            this.h.put(string, requestFuture2);
                            if (bl6) {
                                boolean bl5 = this.d.sendBuildParameters(requestFuture2.getRequestID(), controllerMessage);
                                if (!bl5) {
                                    this.d.cancelSession(requestFuture2.getRequestID());
                                }
                                oSProcessHandler = (OSProcessHandler)pair2.second;
                                charSequence = (CharSequence)k.get((UserDataHolder)oSProcessHandler);
                            } else {
                                if (bl5 && bl8) {
                                    try {
                                        TransactionGuard.getInstance().submitTransactionAndWait(() -> ((Project)project2).save());
                                    }
                                    catch (Throwable throwable2) {
                                        v.info(throwable2);
                                    }
                                }
                                oSProcessHandler = this.a(project2, this.g, uUID, false);
                                charSequence = new StringBuffer();
                                oSProcessHandler.addProcessListener((ProcessListener)new StdOutputCollector((Appendable)((Object)charSequence)));
                                oSProcessHandler.startNotify();
                            }
                            Integer n2 = (Integer)oSProcessHandler.getUserData(m);
                            if (n2 != null) {
                                String string2 = "Build: waiting for debugger connection on port " + n2;
                                defaultMessageHandler.handleCompileMessage(uUID, CmdlineProtoUtil.createCompileProgressMessageResponse((String)string2).getCompileMessage());
                            }
                            while (!oSProcessHandler.waitFor()) {
                                v.info("processHandler.waitFor() returned false for session " + uUID + ", continue waiting");
                            }
                            int n3 = oSProcessHandler.getProcess().exitValue();
                            if (n3 != 0) {
                                StringBuilder stringBuilder = new StringBuilder();
                                stringBuilder.append("Abnormal build process termination: ");
                                if (charSequence != null && charSequence.length() > 0) {
                                    stringBuilder.append("\n").append(charSequence);
                                    if (StringUtil.contains((CharSequence)charSequence, (CharSequence)"java.lang.NoSuchMethodError")) {
                                        stringBuilder.append("\nThe error may be caused by JARs in Java Extensions directory which conflicts with libraries used by the external build process.").append("\nTry adding -Djava.ext.dirs=\"\" argument to 'Build process VM options' in File | Settings | Build, Execution, Deployment | Compiler to fix the problem.");
                                    }
                                } else {
                                    stringBuilder.append("unknown error");
                                }
                                notifyingMessageHandler.handleFailure(uUID, CmdlineProtoUtil.createFailure((String)stringBuilder.toString(), null));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                        }
                        finally {
                            this.h.remove(string);
                            this.b(uUID, throwable);
                            if (this.a(project2)) {
                                this.runCommand(() -> {
                                    if (!this.r.containsKey(string)) {
                                        try {
                                            Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> future = this.a(project2, executorService);
                                            this.r.put(string, future);
                                        }
                                        catch (Throwable throwable) {
                                            v.info("Error pre-loading build process for project " + string, throwable);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    taskFutureArray = new TaskFuture[]{requestFuture2, new TaskFutureAdapter((Future)object)};
                }
                catch (Throwable throwable) {
                    this.a(uUID, throwable);
                }
            }
            boolean bl9 = delegateFuture.a(taskFutureArray);
            assert (bl9);
        });
        return delegateFuture;
    }

    private boolean a(Project project2) {
        if (this.y || !Registry.is((String)"compiler.process.preload") || this.n) {
            return false;
        }
        if (project2.isDisposed()) {
            return true;
        }
        for (BuildProcessParametersProvider buildProcessParametersProvider : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            if (buildProcessParametersProvider.isProcessPreloadingEnabled()) continue;
            return false;
        }
        return true;
    }

    private void b(UUID uUID, @Nullable Throwable throwable) {
        BuilderMessageHandler builderMessageHandler;
        if (this.d.getAssociatedChannel(uUID) == null && (builderMessageHandler = this.d.unregisterBuildMessageHandler(uUID)) != null) {
            if (throwable != null) {
                builderMessageHandler.handleFailure(uUID, CmdlineProtoUtil.createFailure((String)throwable.getMessage(), (Throwable)throwable));
            }
            builderMessageHandler.sessionTerminated(uUID);
        }
    }

    private void a(UUID uUID, Throwable throwable) {
        BuilderMessageHandler builderMessageHandler = this.d.unregisterBuildMessageHandler(uUID);
        if (builderMessageHandler != null) {
            builderMessageHandler.handleFailure(uUID, CmdlineProtoUtil.createFailure((String)throwable.getMessage(), (Throwable)throwable));
            builderMessageHandler.sessionTerminated(uUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ProjectData b(String string2) {
        Map<String, ProjectData> map = this.D;
        // MONITORENTER : map
        ProjectData projectData = this.D.computeIfAbsent(string2, string -> new ProjectData(SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager pool")));
        // MONITOREXIT : map
        if (projectData != null) return projectData;
        BuildManager.a(3);
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() throws Exception {
        if (this.g < 0) {
            BuildManager buildManager = this;
            synchronized (buildManager) {
                if (this.g < 0) {
                    this.g = this.g();
                }
            }
        }
    }

    public void dispose() {
        this.k();
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getBuildProcessRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.a(4);
        }
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.a(project2, 8);
        if (pair2 == null) {
            BuildManager.a(5);
        }
        return pair2;
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getJavacRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.a(6);
        }
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.a(project2, 6);
        if (pair2 == null) {
            BuildManager.a(7);
        }
        return pair2;
    }

    private static Pair<Sdk, JavaSdkVersion> a(Project project2, int n2) {
        LinkedHashSet<Sdk> linkedHashSet = new LinkedHashSet<Sdk>();
        Sdk sdk2 = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (sdk2 != null && sdk2.getSdkType() instanceof JavaSdkType) {
            linkedHashSet.add(sdk2);
        }
        for (JavaSdk javaSdk : ModuleManager.getInstance((Project)project2).getModules()) {
            Sdk sdk3 = ModuleRootManager.getInstance((Module)javaSdk).getSdk();
            if (sdk3 == null || !(sdk3.getSdkType() instanceof JavaSdkType)) continue;
            linkedHashSet.add(sdk3);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        return linkedHashSet.stream().map(sdk -> Pair.pair((Object)sdk, (Object)JavaVersion.tryParse((String)sdk.getVersionString()))).filter(pair2 -> pair2.second != null && ((JavaVersion)pair2.second).isAtLeast(n2)).max(Comparator.comparing(pair2 -> (JavaVersion)pair2.second)).map(pair2 -> Pair.pair((Object)pair2.first, (Object)JavaSdkVersion.fromJavaVersion((JavaVersion)((JavaVersion)pair2.second)))).orElseGet(() -> {
            Sdk sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            return Pair.pair((Object)sdk, (Object)javaSdk.getVersion(sdk));
        });
    }

    private Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> a(Project project2, ExecutorService executorService) throws Exception {
        this.c();
        return executorService.submit(() -> {
            if (project2.isDisposed()) {
                return null;
            }
            RequestFuture requestFuture = new RequestFuture((Object)new PreloadedProcessMessageHandler(), UUID.randomUUID(), new CancelBuildSessionAction());
            try {
                this.d.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)requestFuture, null);
                OSProcessHandler oSProcessHandler = this.a(project2, this.g, requestFuture.getRequestID(), true);
                StringBuffer stringBuffer = new StringBuffer();
                oSProcessHandler.addProcessListener((ProcessListener)new StdOutputCollector(stringBuffer));
                k.set((UserDataHolder)oSProcessHandler, (Object)stringBuffer);
                oSProcessHandler.startNotify();
                return Pair.create((Object)requestFuture, (Object)oSProcessHandler);
            }
            catch (Throwable throwable) {
                this.a(requestFuture.getRequestID(), throwable);
                throw throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private OSProcessHandler a(@NotNull Project project2, int n2, UUID uUID, boolean bl2) throws com.intellij.execution.ExecutionException {
        void var26_40;
        Object object;
        String[] stringArray22;
        Object object3;
        String string;
        String string2;
        String string3;
        Object object4;
        Sdk sdk;
        Sdk sdk2;
        CompilerConfiguration compilerConfiguration;
        if (project2 == null) {
            BuildManager.a(8);
        }
        JavaSdkVersion javaSdkVersion = null;
        String string4 = Registry.stringValue((String)s);
        if (StringUtil.isEmptyOrSpaces((String)string4)) {
            compilerConfiguration = BuildManager.getBuildProcessRuntimeSdk(project2);
            sdk2 = (Sdk)compilerConfiguration.first;
            javaSdkVersion = (JavaSdkVersion)compilerConfiguration.second;
            sdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            JavaSdkType javaSdkType = (JavaSdkType)sdk2.getSdkType();
            if (FileUtil.pathsEqual((String)sdk2.getHomePath(), (String)sdk.getHomePath())) {
                object4 = ToolProvider.getSystemJavaCompiler();
                if (object4 == null) {
                    try {
                        string3 = ClasspathBootstrap.getResourcePath(Class.forName("com.sun.tools.javac.api.JavacTool", false, BuildManager.class.getClassLoader()));
                    }
                    catch (Throwable throwable) {
                        v.info(throwable);
                        string3 = null;
                    }
                    if (string3 == null) {
                        throw new com.intellij.execution.ExecutionException("No system java compiler is provided by the JRE. Make sure tools.jar is present in IntelliJ IDEA classpath.");
                    }
                } else {
                    string3 = ClasspathBootstrap.getResourcePath(object4.getClass());
                }
            } else {
                string3 = javaSdkType.getToolsPath(sdk2);
                if (string3 == null && !JavaSdkUtil.isJdkAtLeast((Sdk)sdk2, (JavaSdkVersion)JavaSdkVersion.JDK_1_9)) {
                    throw new com.intellij.execution.ExecutionException("Cannot determine path to 'tools.jar' library for " + sdk2.getName() + " (" + sdk2.getHomePath() + ")");
                }
            }
            string2 = javaSdkType.getVMExecutablePath(sdk2);
        } else {
            string3 = new File(string4, "lib/tools.jar").getAbsolutePath();
            string2 = new File(string4, "bin/java").getAbsolutePath();
        }
        compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
        sdk2 = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        sdk = new GeneralCommandLine();
        sdk.setExePath(string2);
        boolean bl3 = false;
        object4 = null;
        SmartList smartList = new SmartList();
        String string5 = sdk2.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        boolean bl4 = !StringUtil.isEmptyOrSpaces((String)string5);
        String string6 = string = bl4 ? string5 : compilerConfiguration.getBuildProcessVMOptions();
        if (!StringUtil.isEmptyOrSpaces((String)string)) {
            object3 = new StringTokenizer(string, " ", false);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                String string7 = ((StringTokenizer)object3).nextToken();
                if (StringUtil.startsWithIgnoreCase((String)string7, (String)"-Xmx")) {
                    if (!bl4) continue;
                    object4 = string7;
                    continue;
                }
                if ("-Dprofiling.mode=true".equals(string7)) {
                    bl3 = true;
                }
                smartList.add(string7);
            }
        }
        if (object4 != null) {
            sdk.addParameter((String)object4);
        } else {
            int n3 = compilerConfiguration.getBuildProcessHeapSize(JavacConfiguration.getOptions((Project)project2, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
            sdk.addParameter("-Xmx" + n3 + "m");
        }
        if (SystemInfo.isMac && javaSdkVersion != null && JavaSdkVersion.JDK_1_6.equals((Object)javaSdkVersion) && Registry.is((String)"compiler.process.32bit.vm.on.mac")) {
            sdk.addParameter("-d32");
        }
        sdk.addParameter("-Djava.awt.headless=true");
        if (javaSdkVersion != null && javaSdkVersion.ordinal() < JavaSdkVersion.JDK_1_9.ordinal()) {
            sdk.addParameter("-Djava.endorsed.dirs=\"\"");
        }
        if (this.y) {
            sdk.addParameter("-Dtest.mode=true");
        }
        sdk.addParameter("-Djdt.compiler.useSingleThread=true");
        if (bl2) {
            sdk.addParameter("-Dpreload.project.path=" + FileUtil.toCanonicalPath((String)BuildManager.b(project2)));
            sdk.addParameter("-Dpreload.config.path=" + FileUtil.toCanonicalPath((String)PathManager.getOptionsPath()));
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            sdk.addParameter("-Dexternal.project.config=" + ProjectUtil.getExternalConfigurationDir((Project)project2));
        }
        if ((object3 = System.getProperty("generate.classpath.index")) != null) {
            sdk.addParameter("-Dgenerate.classpath.index=" + (String)object3);
        }
        sdk.addParameter("-Dcompile.parallel=" + Boolean.toString(sdk2.PARALLEL_COMPILATION));
        sdk.addParameter("-Drebuild.on.dependency.change=" + Boolean.toString(sdk2.REBUILD_ON_DEPENDENCY_CHANGE));
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
            sdk.addParameter("-Djava.net.preferIPv4Stack=true");
        }
        sdk.addParameter("-Dio.netty.initialSeedUniquifier=" + ThreadLocalRandom.getInitialSeedUniquifier());
        for (String[] stringArray22 : smartList) {
            sdk.addParameter((String)stringArray22);
        }
        if (bl3) {
            sdk.addParameter("-agentlib:yjpagent=disablealloc,delay=10000,sessionname=ExternalBuild");
        }
        int n4 = -1;
        if (this.n) {
            n4 = Registry.intValue((String)"compiler.process.debug.port");
            if (n4 <= 0) {
                try {
                    n4 = NetUtils.findAvailableSocketPort();
                }
                catch (IOException iOException) {
                    throw new com.intellij.execution.ExecutionException("Cannot find free port to debug build process", (Throwable)iOException);
                }
            }
            if (n4 > 0) {
                sdk.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
                sdk.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + n4);
            }
        }
        if (!Registry.is((String)"compiler.process.use.memory.temp.cache")) {
            sdk.addParameter("-Duse.memory.temp.cache=false");
        }
        sdk.setCharset(this.i);
        sdk.addParameter("-Dfile.encoding=" + this.i.name());
        stringArray22 = new String[]{"user.language", "user.country", "user.region", "idea.paths.selector", "idea.case.sensitive.fs"};
        for (String string8 : stringArray22) {
            String string9 = System.getProperty(string8);
            if (string9 == null) continue;
            sdk.addParameter("-D" + string8 + "=" + string9);
        }
        sdk.addParameter("-Didea.home.path=" + PathManager.getHomePath());
        sdk.addParameter("-Didea.config.path=" + PathManager.getConfigPath());
        sdk.addParameter("-Didea.plugins.path=" + PathManager.getPluginsPath());
        sdk.addParameter("-Djps.log.dir=" + FileUtil.toSystemIndependentName((String)this.getBuildLogDirectory().getAbsolutePath()));
        sdk.addParameters(this.a);
        sdk.addParameter("-Dio.netty.noUnsafe=true");
        Path path = this.getBuildSystemDirectory();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            v.warn((Throwable)iOException);
        }
        File file = this.getProjectSystemDirectory(project2);
        if (file != null) {
            sdk.addParameter("-Djava.io.tmpdir=" + FileUtil.toSystemIndependentName((String)file.getPath()) + "/" + TEMP_DIR_NAME);
        }
        for (BuildProcessParametersProvider object22 : (BuildProcessParametersProvider[])project2.getExtensions(BuildProcessParametersProvider.EP_NAME)) {
            object = object22.getVMArguments();
            sdk.addParameters(object);
        }
        Class<Launcher> clazz = Launcher.class;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ClasspathBootstrap.getResourcePath((Class)clazz));
        arrayList.addAll(BuildProcessClasspathManager.getLauncherClasspath(project2));
        if (string3 != null) {
            arrayList.add(string3);
        }
        int n5 = BuildManager.a(compilerConfiguration) ? 1 : 0;
        Object var26_38 = null;
        if (n5 && !StringUtil.isEmptyOrSpaces((String)(object = EclipseCompilerConfiguration.getOptions((Project)project2, EclipseCompilerConfiguration.class).ECJ_TOOL_PATH))) {
            File file2 = new File((String)object);
            if (file2.exists()) {
                n5 = 0;
            } else {
                throw new com.intellij.execution.ExecutionException("Path to eclipse ecj compiler does not exist: " + file2.getAbsolutePath());
            }
        }
        ClasspathBootstrap.appendJavaCompilerClasspath(arrayList, n5 != 0);
        if (var26_40 != null) {
            arrayList.add(var26_40.getAbsolutePath());
        }
        sdk.addParameter("-classpath");
        sdk.addParameter(BuildManager.a(arrayList));
        sdk.addParameter(clazz.getName());
        object = ClasspathBootstrap.getBuildProcessApplicationClasspath();
        object.addAll(this.b.getBuildProcessPluginsClasspath(project2));
        if (bl3) {
            object.add(path.resolve("yjp-controller-api-redist.jar").toString());
        }
        sdk.addParameter(BuildManager.a((List<String>)object));
        sdk.addParameter(BuildMain.class.getName());
        sdk.addParameter(Boolean.valueOf(System.getProperty("java.net.preferIPv6Addresses", "false")) != false ? "::1" : "127.0.0.1");
        sdk.addParameter(Integer.toString(n2));
        sdk.addParameter(uUID.toString());
        sdk.addParameter(PathKt.getSystemIndependentPath((Path)path));
        sdk.setWorkDirectory(path.toFile());
        try {
            ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).beforeBuildProcessStarted(project2, uUID);
        }
        catch (Throwable throwable) {
            v.error(throwable);
        }
        OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)sdk){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    6.a(0);
                }
                return options;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$6", "readerOptions"));
            }
        };
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key key) {
                String string;
                if (processEvent == null) {
                    7.a(0);
                }
                if (key == null) {
                    7.a(1);
                }
                if (!StringUtil.isEmptyOrSpaces((String)(string = processEvent.getText()))) {
                    if (ProcessOutputTypes.SYSTEM.equals((Object)key)) {
                        if (v.isDebugEnabled()) {
                            v.debug("BUILDER_PROCESS [" + key + "]: " + string.trim());
                        }
                    } else {
                        v.info("BUILDER_PROCESS [" + key + "]: " + string.trim());
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/server/BuildManager$7";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (n4 > 0) {
            oSProcessHandler.putUserData(m, (Object)n4);
        }
        return oSProcessHandler;
    }

    private static boolean a(CompilerConfiguration compilerConfiguration) {
        if (compilerConfiguration instanceof CompilerConfigurationImpl) {
            BackendCompiler backendCompiler = ((CompilerConfigurationImpl)compilerConfiguration).getDefaultCompiler();
            String string = backendCompiler != null ? backendCompiler.getId() : null;
            return "Eclipse".equals(string) || "EclipseEmbedded".equals(string);
        }
        return true;
    }

    @NotNull
    public Path getBuildSystemDirectory() {
        Path path = PathManagerEx.getAppSystemDir().resolve(SYSTEM_ROOT);
        if (path == null) {
            BuildManager.a(9);
        }
        return path;
    }

    public File getBuildLogDirectory() {
        return new File(PathManager.getLogPath(), "build-log");
    }

    @Nullable
    public File getProjectSystemDirectory(Project project2) {
        String string = BuildManager.b(project2);
        return string != null ? Utils.getDataStorageRoot((File)this.getBuildSystemDirectory().toFile(), (String)string) : null;
    }

    private static File b(@NotNull File file) {
        if (file == null) {
            BuildManager.a(10);
        }
        return new File(file, "ustamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(@Nullable Project project2, @NotNull File file) {
        if (file == null) {
            BuildManager.a(11);
        }
        File file2 = BuildManager.b(file);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object = e;
            synchronized (object) {
                stringBuilder.append(e.format(System.currentTimeMillis()));
            }
            if (project2 != null && !project2.isDisposed() && !StringUtil.isEmptyOrSpaces((String)(object = project2.getProjectFilePath()))) {
                stringBuilder.append("\n").append(FileUtil.toCanonicalPath((String)object));
            }
            FileUtil.writeToFile((File)file2, (String)stringBuilder.toString());
        }
        catch (Throwable throwable) {
            v.info(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<Date, File> a(File file) {
        block5: {
            try {
                Date date;
                List list2 = FileUtil.loadLines((File)file, (String)CharsetToolkit.UTF8_CHARSET.name());
                if (list2.isEmpty()) break block5;
                String string = (String)list2.get(0);
                Serializable serializable = e;
                synchronized (serializable) {
                    date = e.parse(string);
                }
                serializable = list2.size() > 1 ? new File((String)list2.get(1)) : null;
                return Pair.create((Object)date, (Object)serializable);
            }
            catch (Throwable throwable) {
                v.info(throwable);
            }
        }
        return null;
    }

    private void k() {
        this.g = -1;
        this.c.close();
    }

    private int g() throws Exception {
        BuiltInServer builtInServer = StartupUtil.getServer();
        boolean bl2 = !Registry.is((String)"compiler.shared.event.group", (boolean)true) || builtInServer == null || builtInServer.getEventLoopGroup() instanceof OioEventLoopGroup;
        EventLoopGroup eventLoopGroup = bl2 ? NettyKt.MultiThreadEventLoopGroup((int)1, (ThreadFactory)ConcurrencyUtil.newNamedThreadFactory((String)"External compiler")) : builtInServer.getEventLoopGroup();
        ServerBootstrap serverBootstrap = NettyKt.serverBootstrap((EventLoopGroup)eventLoopGroup);
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) throws Exception {
                if (channel == null) {
                    8.a(0);
                }
                channel.pipeline().addLast(new ChannelHandler[]{BuildManager.this.c, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.d});
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/compiler/server/BuildManager$8", "initChannel"));
            }
        });
        Channel channel = serverBootstrap.bind(InetAddress.getLoopbackAddress(), 0).syncUninterruptibly().channel();
        this.c.setServerChannel(channel, bl2);
        return ((InetSocketAddress)channel.localAddress()).getPort();
    }

    private static String a(List<String> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(FileUtil.toCanonicalPath((String)string));
        }
        return stringBuilder.toString();
    }

    public boolean isBuildProcessDebuggingEnabled() {
        return this.n;
    }

    public void setBuildProcessDebuggingEnabled(boolean bl2) {
        this.n = bl2;
        if (this.n) {
            this.j();
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemDir";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadTrace";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProcessRuntimeSdk";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavacRuntimeSdk";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystemDirectory";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canStartAutoMake";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBuildProcessRuntimeSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getJavacRuntimeSdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "launchBuildProcess";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUsageFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateUsageFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CancelBuildSessionAction<T extends BuilderMessageHandler>
    implements RequestFuture.CancelAction<T> {
        private CancelBuildSessionAction() {
        }

        public void cancel(RequestFuture<T> requestFuture) throws Exception {
            BuildManager.this.d.cancelSession(requestFuture.getRequestID());
        }
    }

    private static final class DelegateFuture
    implements TaskFuture {
        @Nullable
        private TaskFuture[] a;
        private Boolean b;

        private DelegateFuture() {
        }

        @NotNull
        private synchronized TaskFuture[] a() {
            TaskFuture[] taskFutureArray = this.a;
            while (taskFutureArray == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                taskFutureArray = this.a;
            }
            if (taskFutureArray == null) {
                DelegateFuture.a(0);
            }
            return taskFutureArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean a(TaskFuture ... taskFutureArray) {
            if (taskFutureArray == null) {
                DelegateFuture.a(1);
            }
            if (this.a == null) {
                try {
                    this.a = taskFutureArray;
                    if (this.b != null) {
                        for (TaskFuture taskFuture : taskFutureArray) {
                            taskFuture.cancel(this.b.booleanValue());
                        }
                    }
                }
                finally {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        public synchronized boolean cancel(boolean bl2) {
            TaskFuture[] taskFutureArray = this.a;
            if (taskFutureArray == null) {
                this.b = bl2;
                return true;
            }
            Stream.of(taskFutureArray).forEach(future -> future.cancel(bl2));
            return this.isDone();
        }

        public void waitFor() {
            Stream.of(this.a()).forEach(TaskFuture::waitFor);
        }

        public boolean waitFor(long l2, TimeUnit timeUnit) {
            Stream.of(this.a()).forEach(taskFuture -> taskFuture.waitFor(l2, timeUnit));
            return this.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            TaskFuture[] taskFutureArray;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                taskFutureArray = this.a;
                if (taskFutureArray == null) {
                    return this.b != null;
                }
            }
            return Stream.of(taskFutureArray).anyMatch(Future::isCancelled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            TaskFuture[] taskFutureArray;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                taskFutureArray = this.a;
                if (taskFutureArray == null) {
                    return false;
                }
            }
            return Stream.of(taskFutureArray).allMatch(Future::isDone);
        }

        public Object get() throws InterruptedException, ExecutionException {
            for (TaskFuture taskFuture : this.a()) {
                taskFuture.get();
            }
            return null;
        }

        public Object get(long l2, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (timeUnit == null) {
                DelegateFuture.a(2);
            }
            for (TaskFuture taskFuture : this.a()) {
                taskFuture.get(l2, timeUnit);
            }
            return null;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegates";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegates";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class XInternedPath
    extends InternedPath {
        private XInternedPath(String string) {
            super(string);
        }

        @Override
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int n2 : this.myPath) {
                    stringBuilder.append("/").append(FileNameCache.getVFileName((int)n2));
                }
                return stringBuilder.toString();
            }
            return "/";
        }
    }

    private static class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String string) {
            super(string);
        }

        @Override
        public String getValue() {
            if (this.myPath.length == 1) {
                String string = FileNameCache.getVFileName((int)this.myPath[0]).toString();
                return string.length() == 2 && string.endsWith(":") ? string + "/" : string;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int n2 : this.myPath) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(FileNameCache.getVFileName((int)n2));
            }
            return stringBuilder.toString();
        }
    }

    private static abstract class InternedPath {
        protected final int[] myPath;

        InternedPath(String string) {
            IntArrayList intArrayList = new IntArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                intArrayList.add(FileNameCache.storeName((String)string2));
            }
            this.myPath = intArrayList.toArray();
        }

        public abstract String getValue();

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InternedPath internedPath = (InternedPath)object;
            return Arrays.equals(this.myPath, internedPath.myPath);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myPath);
        }

        public static InternedPath create(String string) {
            return string.startsWith("/") ? new XInternedPath(string) : new WinInternedPath(string);
        }
    }

    private static class ProjectData {
        @NotNull
        final ExecutorService taskQueue;
        private final Set<InternedPath> b;
        private final Set<InternedPath> c;
        private long d;
        private boolean a;

        private ProjectData(@NotNull ExecutorService executorService) {
            if (executorService == null) {
                ProjectData.a(0);
            }
            this.b = new THashSet();
            this.c = new THashSet();
            this.a = true;
            this.taskQueue = executorService;
        }

        void addChanged(Collection<String> collection) {
            if (!this.a) {
                for (String string : collection) {
                    InternedPath internedPath = InternedPath.create(string);
                    this.c.remove(internedPath);
                    this.b.add(internedPath);
                }
            }
        }

        void addDeleted(Collection<String> collection) {
            if (!this.a) {
                for (String string : collection) {
                    InternedPath internedPath = InternedPath.create(string);
                    this.b.remove(internedPath);
                    this.c.add(internedPath);
                }
            }
        }

        CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent() {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.d);
            for (InternedPath internedPath : this.b) {
                builder.addChangedPaths(internedPath.getValue());
            }
            this.b.clear();
            for (InternedPath internedPath : this.c) {
                builder.addDeletedPaths(internedPath.getValue());
            }
            this.c.clear();
            return (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)builder.build();
        }

        boolean getAndResetRescanFlag() {
            boolean bl2 = this.a;
            this.a = false;
            return bl2;
        }

        void dropChanges() {
            if (v.isDebugEnabled()) {
                v.debug("Project build state cleared: " + BuildManager.a(Thread.currentThread(), 20));
            }
            this.a = true;
            this.d = 0L;
            this.b.clear();
            this.c.clear();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskQueue", "com/intellij/compiler/server/BuildManager$ProjectData", "<init>"));
        }
    }

    private class ProjectWatcher
    implements ProjectManagerListener {
        private final Map<Project, MessageBusConnection> a = new HashMap<Project, MessageBusConnection>();

        private ProjectWatcher() {
        }

        public void projectOpened(final Project project2) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MessageBusConnection messageBusConnection = project2.getMessageBus().connect();
            this.a.put(project2, messageBusConnection);
            messageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(ModuleRootEvent moduleRootEvent) {
                    Object object = moduleRootEvent.getSource();
                    if (object instanceof Project) {
                        BuildManager.this.clearState((Project)object);
                    }
                }
            });
            messageBusConnection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                public void processStarting(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment) {
                    if (string == null) {
                        2.a(0);
                    }
                    if (executionEnvironment == null) {
                        2.a(1);
                    }
                    BuildManager.this.cancelAutoMakeTasks(executionEnvironment.getProject());
                }

                public void processStarted(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment, @NotNull ProcessHandler processHandler) {
                    if (string == null) {
                        2.a(2);
                    }
                    if (executionEnvironment == null) {
                        2.a(3);
                    }
                    if (processHandler == null) {
                        2.a(4);
                    }
                    BuildManager.this.cancelAutoMakeTasks(executionEnvironment.getProject());
                }

                public void processNotStarted(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment) {
                    if (string == null) {
                        2.a(5);
                    }
                    if (executionEnvironment == null) {
                        2.a(6);
                    }
                    BuildManager.this.scheduleAutoMake();
                }

                public void processTerminated(@NotNull String string, @NotNull ExecutionEnvironment executionEnvironment, @NotNull ProcessHandler processHandler, int n2) {
                    if (string == null) {
                        2.a(7);
                    }
                    if (executionEnvironment == null) {
                        2.a(8);
                    }
                    if (processHandler == null) {
                        2.a(9);
                    }
                    BuildManager.this.scheduleAutoMake();
                }

                private static /* synthetic */ void a(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executorId";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 6: 
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "env";
                            break;
                        }
                        case 4: 
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectWatcher$2";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarting";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarted";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNotStarted";
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            messageBusConnection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> a = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

                public void automakeCompilationFinished(int n2, int n3, CompileContext compileContext) {
                    if (!compileContext.getProgressIndicator().isCanceled()) {
                        this.a(compileContext);
                    }
                }

                public void compilationFinished(boolean bl2, int n2, int n3, CompileContext compileContext) {
                    this.a(compileContext);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void a(CompileContext compileContext) {
                    if (project2.isDisposed()) {
                        return;
                    }
                    THashSet tHashSet = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                    CompilerConfiguration compilerConfiguration = this.a;
                    synchronized (compilerConfiguration) {
                        tHashSet.addAll(this.a);
                        this.a.clear();
                    }
                    if (compileContext.isAnnotationProcessorsEnabled()) {
                        compilerConfiguration = CompilerConfiguration.getInstance((Project)project2);
                        for (Module module2 : compileContext.getCompileScope().getAffectedModules()) {
                            String string;
                            if (!compilerConfiguration.getAnnotationProcessingConfiguration(module2).isEnabled()) continue;
                            String string2 = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)false);
                            if (string2 != null) {
                                tHashSet.add(string2);
                            }
                            if ((string = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)true)) == null) continue;
                            tHashSet.add(string);
                        }
                    }
                    if (!tHashSet.isEmpty()) {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> 3.a(project2, (Set)tHashSet));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(String string, String string2) {
                    Set<String> set = this.a;
                    synchronized (set) {
                        this.a.add(string);
                    }
                }

                private static /* synthetic */ void a(Project project22, Set set) {
                    if (project22.isDisposed()) {
                        return;
                    }
                    CompilerUtil.refreshOutputRoots(set);
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    Set set2 = (Set)ReadAction.compute(() -> {
                        if (project22.isDisposed()) {
                            return Collections.emptySet();
                        }
                        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project22).getFileIndex();
                        return set.stream().map(arg_0 -> ((LocalFileSystem)localFileSystem).findFileByPath(arg_0)).filter(virtualFile -> virtualFile != null && projectFileIndex.isInSourceContent(virtualFile)).collect(Collectors.toSet());
                    });
                    if (!set2.isEmpty()) {
                        localFileSystem.refreshFiles((Iterable)set2, true, true, null);
                    }
                }
            });
            String string = BuildManager.b(project2);
            Disposer.register((Disposable)project2, () -> {
                BuildManager.this.e(string);
                BuildManager.this.D.remove(string);
            });
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> {
                BuildManager.this.runCommand(() -> {
                    File file = BuildManager.this.getProjectSystemDirectory(project2);
                    if (file != null) {
                        BuildManager.a(project2, file);
                    }
                });
                BuildManager.this.scheduleAutoMake();
            });
        }

        public void projectClosingBeforeSave(@NotNull Project project2) {
            if (project2 == null) {
                ProjectWatcher.a(0);
            }
            BuildManager.this.cancelAutoMakeTasks(project2);
        }

        public void projectClosing(Project project2) {
            BuildManager.this.e(BuildManager.b(project2));
            for (TaskFuture taskFuture : BuildManager.this.cancelAutoMakeTasks(project2)) {
                taskFuture.waitFor(500L, TimeUnit.MILLISECONDS);
            }
        }

        public void projectClosed(Project project2) {
            BuildManager.this.D.remove(BuildManager.b(project2));
            MessageBusConnection messageBusConnection = this.a.remove(project2);
            if (messageBusConnection != null) {
                messageBusConnection.disconnect();
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/server/BuildManager$ProjectWatcher", "projectClosingBeforeSave"));
        }
    }

    private static final class StdOutputCollector
    extends ProcessAdapter {
        private final Appendable a;
        private int b;

        StdOutputCollector(@NotNull Appendable appendable) {
            if (appendable == null) {
                StdOutputCollector.a(0);
            }
            this.a = appendable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key key) {
            String string;
            if (processEvent == null) {
                StdOutputCollector.a(1);
            }
            if (key == null) {
                StdOutputCollector.a(2);
            }
            StdOutputCollector stdOutputCollector = this;
            synchronized (stdOutputCollector) {
                if (this.b > 16384) {
                    return;
                }
                string = processEvent.getText();
                if (StringUtil.isEmptyOrSpaces((String)string)) {
                    return;
                }
                this.b += string.length();
            }
            try {
                this.a.append(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputSink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$StdOutputCollector";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NotifyingMessageHandler
    extends DelegatingMessageHandler {
        private final Project a;
        private final BuilderMessageHandler b;
        private final boolean c;

        NotifyingMessageHandler(@NotNull Project project2, @NotNull BuilderMessageHandler builderMessageHandler, boolean bl2) {
            if (project2 == null) {
                NotifyingMessageHandler.a(0);
            }
            if (builderMessageHandler == null) {
                NotifyingMessageHandler.a(1);
            }
            this.a = project2;
            this.b = builderMessageHandler;
            this.c = bl2;
        }

        @Override
        protected BuilderMessageHandler getDelegateHandler() {
            return this.b;
        }

        @Override
        public void buildStarted(UUID uUID) {
            super.buildStarted(uUID);
            try {
                ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(this.a, uUID, this.c);
            }
            catch (Throwable throwable) {
                v.error(throwable);
            }
        }

        @Override
        public void sessionTerminated(UUID uUID) {
            try {
                super.sessionTerminated(uUID);
            }
            finally {
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(this.a, uUID, this.c);
                }
                catch (Throwable throwable) {
                    v.error(throwable);
                }
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegateHandler";
                    break;
                }
            }
            objectArray[1] = "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm a;
        private final AtomicBoolean b = new AtomicBoolean(false);
        private final Runnable c = () -> {
            try {
                this.runTask();
            }
            finally {
                this.b.set(false);
            }
        };

        BuildManagerPeriodicTask() {
            this.a = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)BuildManager.this);
        }

        final void schedule() {
            this.cancelPendingExecution();
            int n2 = Math.max(100, this.getDelay());
            this.a.addRequest((Runnable)this, n2);
        }

        void cancelPendingExecution() {
            this.a.cancelAllRequests();
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            if (!HeavyProcessLatch.INSTANCE.isRunning() && BuildManager.this.j <= 0 && !this.b.getAndSet(true)) {
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(this.c);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.b.set(false);
                }
                catch (Throwable throwable) {
                    this.b.set(false);
                    throw new RuntimeException(throwable);
                }
            } else {
                this.schedule();
            }
        }
    }
}

