/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ArrayAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebuggerContextImpl debuggerContextImpl = DebuggerAction.getDebuggerContext(anActionEvent.getDataContext());
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        XValueNodeImpl xValueNodeImpl = XDebuggerTreeActionBase.getSelectedNode((DataContext)anActionEvent.getDataContext());
        if (xValueNodeImpl == null) {
            return;
        }
        ArrayRenderer arrayRenderer2 = ArrayAction.getArrayRenderer((XValue)xValueNodeImpl.getValueContainer());
        if (arrayRenderer2 == null) {
            return;
        }
        this.createNewRenderer(xValueNodeImpl, arrayRenderer2, debuggerContextImpl, xValueNodeImpl.getName()).done(arrayRenderer -> ArrayAction.setArrayRenderer(arrayRenderer, xValueNodeImpl, debuggerContextImpl));
    }

    @NotNull
    protected abstract Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl var1, ArrayRenderer var2, @NotNull DebuggerContextImpl var3, String var4);

    public void update(AnActionEvent anActionEvent) {
        boolean bl2 = false;
        List<JavaValue> list2 = ViewAsGroup.getSelectedValues(anActionEvent);
        if (list2.size() == 1) {
            bl2 = ArrayAction.getArrayRenderer((XValue)list2.get(0)) != null;
        }
        anActionEvent.getPresentation().setEnabledAndVisible(bl2);
    }

    @Nullable
    public static ArrayRenderer getArrayRenderer(XValue xValue) {
        if (xValue instanceof JavaValue) {
            ChildrenRenderer childrenRenderer;
            ValueDescriptorImpl valueDescriptorImpl = ((JavaValue)xValue).getDescriptor();
            Renderer renderer = valueDescriptorImpl.getLastRenderer();
            if (renderer instanceof CompoundNodeRenderer && (childrenRenderer = ((CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer && (renderer = ExpressionChildrenRenderer.getLastChildrenRenderer(valueDescriptorImpl)) == null) {
                renderer = ((ExpressionChildrenRenderer)childrenRenderer).getPredictedRenderer();
            }
            if (renderer instanceof ArrayRenderer) {
                return (ArrayRenderer)renderer;
            }
        }
        return null;
    }

    public static void setArrayRenderer(final ArrayRenderer arrayRenderer, final @NotNull XValueNodeImpl xValueNodeImpl, @NotNull DebuggerContextImpl debuggerContextImpl) {
        XValue xValue;
        ArrayRenderer arrayRenderer2;
        if (xValueNodeImpl == null) {
            ArrayAction.b(0);
        }
        if (debuggerContextImpl == null) {
            ArrayAction.b(1);
        }
        if ((arrayRenderer2 = ArrayAction.getArrayRenderer(xValue = (XValue)xValueNodeImpl.getValueContainer())) == null) {
            return;
        }
        final ValueDescriptorImpl valueDescriptorImpl = ((JavaValue)xValue).getDescriptor();
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl != null) {
            debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContextImpl.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    CompoundNodeRenderer compoundNodeRenderer;
                    ChildrenRenderer childrenRenderer;
                    Renderer renderer;
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                    if ((renderer = valueDescriptorImpl.getLastRenderer()) instanceof ArrayRenderer) {
                        ((JavaValue)xValue).setRenderer(arrayRenderer, xValueNodeImpl);
                        xValueNodeImpl.invokeNodeUpdate(() -> {
                            if (xValueNodeImpl == null) {
                                1.b(1);
                            }
                            xValueNodeImpl.getTree().expandPath(xValueNodeImpl.getPath());
                        });
                    } else if (renderer instanceof CompoundNodeRenderer && (childrenRenderer = (compoundNodeRenderer = (CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer) {
                        ExpressionChildrenRenderer.setPreferableChildrenRenderer(valueDescriptorImpl, arrayRenderer);
                        ((JavaValue)xValue).reBuild(xValueNodeImpl);
                    }
                }

                private static /* synthetic */ void b(int n2) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "suspendContext";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$1";
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "contextAction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$contextAction$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static String a(String string, DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        if (debuggerTreeNodeImpl != null) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = debuggerTreeNodeImpl.getParent();
            NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl2.getDescriptor();
            if (nodeDescriptorImpl instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)nodeDescriptorImpl).isArray()) {
                int n2 = debuggerTreeNodeImpl2.getIndex(debuggerTreeNodeImpl);
                return ArrayAction.a(string, debuggerTreeNodeImpl2) + "[" + n2 + "]";
            }
            String string2 = debuggerTreeNodeImpl.getDescriptor() != null ? debuggerTreeNodeImpl.getDescriptor().getName() : null;
            return string2 != null ? string + " " + string2 : string;
        }
        return string;
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "debuggerContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/debugger/actions/ArrayAction";
        objectArray[2] = "setArrayRenderer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FilterArrayAction
    extends ArrayAction {
        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl xValueNodeImpl, ArrayRenderer arrayRenderer, @NotNull DebuggerContextImpl debuggerContextImpl, String string) {
            if (debuggerContextImpl == null) {
                FilterArrayAction.c(0);
            }
            ArrayFilterInplaceEditor.editParent(xValueNodeImpl);
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                FilterArrayAction.c(1);
            }
            return promise;
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$FilterArrayAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AdjustArrayRangeAction
    extends ArrayAction {
        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl xValueNodeImpl, ArrayRenderer arrayRenderer, @NotNull DebuggerContextImpl debuggerContextImpl, String string) {
            if (debuggerContextImpl == null) {
                AdjustArrayRangeAction.c(0);
            }
            ArrayRenderer arrayRenderer2 = arrayRenderer.clone();
            arrayRenderer2.setForced(true);
            if (ShowSettingsUtil.getInstance().editConfigurable(debuggerContextImpl.getProject(), (Configurable)new NamedArrayConfigurable(string, arrayRenderer2))) {
                Promise promise = Promises.resolvedPromise((Object)arrayRenderer2);
                if (promise == null) {
                    AdjustArrayRangeAction.c(1);
                }
                return promise;
            }
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AdjustArrayRangeAction.c(2);
            }
            return promise;
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debuggerContext";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewRenderer";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String h;

        public NamedArrayConfigurable(String string, ArrayRenderer arrayRenderer) {
            super(arrayRenderer);
            this.h = string;
        }

        public String getDisplayName() {
            return this.h;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

