/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class EditSourceAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebuggerContextImpl debuggerContextImpl;
        DebugProcessImpl debugProcessImpl;
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        final DebuggerTreeNodeImpl debuggerTreeNodeImpl = EditSourceAction.getSelectedNode(anActionEvent.getDataContext());
        if (debuggerTreeNodeImpl != null && (debugProcessImpl = (debuggerContextImpl = EditSourceAction.getDebuggerContext(anActionEvent.getDataContext())).getDebugProcess()) != null) {
            debugProcessImpl.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                    SourcePosition sourcePosition;
                    if (suspendContextImpl == null) {
                        1.c(0);
                    }
                    if ((sourcePosition = EditSourceAction.a(debuggerTreeNodeImpl, debuggerContextImpl)) != null) {
                        sourcePosition.navigate(true);
                    }
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/EditSourceAction$1", "threadAction"));
                }
            });
        }
    }

    private static SourcePosition a(DebuggerTreeNodeImpl debuggerTreeNodeImpl, DebuggerContextImpl debuggerContextImpl) {
        NodeDescriptorImpl nodeDescriptorImpl;
        DebuggerContextImpl debuggerContextImpl2 = debuggerContextImpl;
        if (debuggerTreeNodeImpl == null || debuggerContextImpl2 == null) {
            return null;
        }
        Project project2 = debuggerTreeNodeImpl.getProject();
        DebuggerSession debuggerSession = debuggerContextImpl2.getDebuggerSession();
        if (debuggerSession == null) {
            return null;
        }
        NodeDescriptorImpl nodeDescriptorImpl2 = debuggerTreeNodeImpl.getDescriptor();
        if (nodeDescriptorImpl2 instanceof WatchItemDescriptor) {
            nodeDescriptorImpl = ((WatchItemDescriptor)nodeDescriptorImpl2).getModifier();
            if (nodeDescriptorImpl == null) {
                return null;
            }
            nodeDescriptorImpl2 = (NodeDescriptorImpl)nodeDescriptorImpl.getInspectItem(project2);
        }
        nodeDescriptorImpl = nodeDescriptorImpl2;
        return (SourcePosition)ReadAction.compute(() -> SourcePositionProvider.getSourcePosition(nodeDescriptorImpl, project2, debuggerContextImpl2));
    }

    public void update(AnActionEvent anActionEvent) {
        final Project project2 = anActionEvent.getProject();
        final DebuggerContextImpl debuggerContextImpl = EditSourceAction.getDebuggerContext(anActionEvent.getDataContext());
        final DebuggerTreeNodeImpl debuggerTreeNodeImpl = EditSourceAction.getSelectedNode(anActionEvent.getDataContext());
        final Presentation presentation = anActionEvent.getPresentation();
        if (debuggerContextImpl.getDebugProcess() != null) {
            presentation.setEnabled(true);
            debuggerContextImpl.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                    SourcePosition sourcePosition;
                    if (suspendContextImpl == null) {
                        2.c(0);
                    }
                    if ((sourcePosition = EditSourceAction.a(debuggerTreeNodeImpl, debuggerContextImpl)) == null) {
                        DebuggerInvocationUtil.swingInvokeLater(project2, () -> presentation.setEnabled(false));
                    }
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/EditSourceAction$2", "threadAction"));
                }
            });
        } else {
            presentation.setEnabled(false);
        }
        anActionEvent.getPresentation().setText(ActionManager.getInstance().getAction("EditSource").getTemplatePresentation().getText());
    }
}

