/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.actions.ExportToTextFileAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import java.util.List;

public class ExportThreadsAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DebugProcessImpl debugProcessImpl;
        final Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null && debuggerSession.isAttached() && (debugProcessImpl = debuggerContextImpl.getDebugProcess()) != null) {
            debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    List<ThreadState> list2 = ThreadDumpAction.buildThreadStates(debugProcessImpl.getVirtualMachineProxy());
                    ApplicationManager.getApplication().invokeLater(() -> ExportToTextFileAction.export((Project)project2, (ExporterToTextFile)ThreadDumpPanel.createToFileExporter((Project)project2, (List)list2)), ModalityState.NON_MODAL);
                }
            });
        }
    }

    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isPaused());
    }
}

