/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.codeInsight.daemon.impl.JavaHighlightInfoTypes;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ObjectMarkupPropertiesDialog;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.xdebugger.impl.actions.MarkObjectActionHandler;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaMarkObjectActionHandler
extends MarkObjectActionHandler {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.actions.JavaMarkObjectActionHandler");
    public static final long AUTO_MARKUP_REFERRING_OBJECTS_LIMIT = 100L;

    public void perform(@NotNull Project project2, AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (project2 == null) {
            JavaMarkObjectActionHandler.a(0);
        }
        if ((debuggerTreeNodeImpl = DebuggerAction.getSelectedNode(anActionEvent.getDataContext())) == null) {
            return;
        }
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (!(nodeDescriptorImpl instanceof ValueDescriptorImpl)) {
            return;
        }
        final DebuggerTree debuggerTree = debuggerTreeNodeImpl.getTree();
        debuggerTree.saveState(debuggerTreeNodeImpl);
        final Component component = (Component)anActionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        final ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptorImpl;
        final DebuggerContextImpl debuggerContextImpl = debuggerTree.getDebuggerContext();
        final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        final ValueMarkup valueMarkup = valueDescriptorImpl.getMarkup(debugProcessImpl);
        debugProcessImpl.getManagerThread().invoke(new DebuggerContextCommandImpl(debuggerContextImpl){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                boolean bl2;
                if (suspendContextImpl == null) {
                    1.c(0);
                }
                boolean bl3 = true;
                try {
                    if (valueMarkup != null) {
                        valueDescriptorImpl.setMarkup(debugProcessImpl, null);
                    } else {
                        String string = valueDescriptorImpl.getName();
                        Ref ref = new Ref(null);
                        try {
                            boolean bl4 = JavaMarkObjectActionHandler.a(debugProcessImpl, valueDescriptorImpl.getValue());
                            SwingUtilities.invokeAndWait(() -> {
                                Map<ObjectReference, ValueMarkup> map = NodeDescriptorImpl.getMarkupMap(debugProcessImpl);
                                Collection<Object> collection = map != null ? map.values() : Collections.emptySet();
                                ObjectMarkupPropertiesDialog objectMarkupPropertiesDialog = new ObjectMarkupPropertiesDialog(component, string, bl4, collection);
                                if (objectMarkupPropertiesDialog.showAndGet()) {
                                    ref.set((Object)Pair.create((Object)objectMarkupPropertiesDialog.getConfiguredMarkup(), (Object)objectMarkupPropertiesDialog.isMarkAdditionalFields()));
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            a.error((Throwable)invocationTargetException);
                        }
                        Pair pair2 = (Pair)ref.get();
                        if (pair2 != null) {
                            Map<ObjectReference, ValueMarkup> map;
                            Value value;
                            Map map2;
                            valueDescriptorImpl.setMarkup(debugProcessImpl, (ValueMarkup)pair2.first);
                            if (((Boolean)pair2.second).booleanValue() && !(map2 = JavaMarkObjectActionHandler.b((ObjectReference)(value = valueDescriptorImpl.getValue()))).isEmpty() && (map = NodeDescriptorImpl.getMarkupMap(debugProcessImpl)) != null) {
                                for (Map.Entry entry : map2.entrySet()) {
                                    ObjectReference objectReference = (ObjectReference)entry.getKey();
                                    if (map.containsKey(objectReference)) continue;
                                    map.put(objectReference, (ValueMarkup)entry.getValue());
                                }
                            }
                        } else {
                            bl3 = false;
                        }
                    }
                    bl2 = bl3;
                }
                catch (Throwable throwable) {
                    boolean bl5 = bl3;
                    SwingUtilities.invokeLater(new Runnable(bl5){
                        final /* synthetic */ boolean val$_sessionRefreshNeeded;
                        {
                            this.val$_sessionRefreshNeeded = bl2;
                        }

                        @Override
                        public void run() {
                            DebuggerSession debuggerSession;
                            debuggerTree.restoreState(debuggerTreeNodeImpl);
                            TreeBuilder treeBuilder = debuggerTree.getMutableModel();
                            this.a(treeBuilder.getRoot(), treeBuilder, valueDescriptorImpl.getValue());
                            if (this.val$_sessionRefreshNeeded && (debuggerSession = debuggerContextImpl.getDebuggerSession()) != null) {
                                debuggerSession.refresh(true);
                            }
                        }

                        private void a(Object object, TreeBuilder treeBuilder, Value value) {
                            DebuggerTreeNodeImpl debuggerTreeNodeImpl;
                            NodeDescriptorImpl nodeDescriptorImpl;
                            if (object instanceof DebuggerTreeNodeImpl && (nodeDescriptorImpl = (debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)object).getDescriptor()) instanceof ValueDescriptor && Comparing.equal((Object)value, (Object)((ValueDescriptor)((Object)nodeDescriptorImpl)).getValue())) {
                                debuggerTreeNodeImpl.labelChanged();
                            }
                            int n2 = treeBuilder.getChildCount(object);
                            for (int i2 = 0; i2 < n2; ++i2) {
                                this.a(treeBuilder.getChild(object, i2), treeBuilder, value);
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JavaMarkObjectActionHandler$1", "threadAction"));
            }
        });
    }

    private static boolean a(DebugProcessImpl debugProcessImpl, Value value) {
        if (!debugProcessImpl.getVirtualMachineProxy().canGetInstanceInfo()) {
            return false;
        }
        if (!(value instanceof ObjectReference)) {
            return false;
        }
        ObjectReference objectReference = (ObjectReference)value;
        return !(objectReference instanceof ArrayReference) && !(objectReference instanceof ClassObjectReference) && !(objectReference instanceof ThreadReference) && !(objectReference instanceof ThreadGroupReference) && !(objectReference instanceof ClassLoaderReference);
    }

    private static Map<ObjectReference, ValueMarkup> b(ObjectReference objectReference) {
        HashMap<ObjectReference, ValueMarkup> hashMap = new HashMap<ObjectReference, ValueMarkup>();
        for (ObjectReference objectReference2 : JavaMarkObjectActionHandler.a(objectReference)) {
            ReferenceType referenceType;
            if (!(objectReference2 instanceof ClassObjectReference) || !(referenceType = ((ClassObjectReference)objectReference2).reflectedType()).isAbstract()) continue;
            for (Field field : referenceType.visibleFields()) {
                Value value;
                if (!field.isStatic() || !field.isFinal() || DebuggerUtils.isPrimitiveType((String)field.typeName()) || !((value = referenceType.getValue(field)) instanceof ObjectReference)) continue;
                ValueMarkup valueMarkup = (ValueMarkup)hashMap.get((ObjectReference)value);
                String string = field.name();
                Color color = JavaMarkObjectActionHandler.getAutoMarkupColor();
                if (valueMarkup == null) {
                    hashMap.put((ObjectReference)value, new ValueMarkup(string, color, JavaMarkObjectActionHandler.a(null, referenceType, string)));
                    continue;
                }
                String string2 = valueMarkup.getText();
                if (string2.contains(string)) continue;
                String string3 = valueMarkup.getToolTipText();
                String string4 = JavaMarkObjectActionHandler.a(string3, referenceType, string);
                hashMap.put((ObjectReference)value, new ValueMarkup(string2 + ", " + string, color, string4));
            }
        }
        return hashMap;
    }

    private static List<ObjectReference> a(ObjectReference objectReference) {
        try {
            return objectReference.referringObjects(100L);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            a.info((Throwable)unsupportedOperationException);
            return Collections.emptyList();
        }
    }

    private static String a(@Nullable String string, ReferenceType referenceType, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            stringBuilder.append("Value referenced from:");
        } else {
            stringBuilder.append(string);
        }
        return stringBuilder.append("<br><b>").append(referenceType.name()).append(".").append(string2).append("</b>").toString();
    }

    public boolean isEnabled(@NotNull Project project2, AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (project2 == null) {
            JavaMarkObjectActionHandler.a(1);
        }
        return (debuggerTreeNodeImpl = DebuggerAction.getSelectedNode(anActionEvent.getDataContext())) != null && debuggerTreeNodeImpl.getDescriptor() instanceof ValueDescriptor;
    }

    public boolean isHidden(@NotNull Project project2, AnActionEvent anActionEvent) {
        if (project2 == null) {
            JavaMarkObjectActionHandler.a(2);
        }
        return DebuggerAction.getSelectedNode(anActionEvent.getDataContext()) == null;
    }

    public boolean isMarked(@NotNull Project project2, @NotNull AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (project2 == null) {
            JavaMarkObjectActionHandler.a(3);
        }
        if (anActionEvent == null) {
            JavaMarkObjectActionHandler.a(4);
        }
        if ((debuggerTreeNodeImpl = DebuggerAction.getSelectedNode(anActionEvent.getDataContext())) == null) {
            return false;
        }
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (!(nodeDescriptorImpl instanceof ValueDescriptor)) {
            return false;
        }
        DebugProcessImpl debugProcessImpl = debuggerTreeNodeImpl.getTree().getDebuggerContext().getDebugProcess();
        return ((ValueDescriptor)((Object)nodeDescriptorImpl)).getMarkup(debugProcessImpl) != null;
    }

    public static Color getAutoMarkupColor() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        TextAttributes textAttributes = editorColorsManager.getGlobalScheme().getAttributes(JavaHighlightInfoTypes.STATIC_FIELD.getAttributesKey());
        return textAttributes.getForegroundColor();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/actions/JavaMarkObjectActionHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isHidden";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

