/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.MonitorInfo;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ThreadDumpAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(AnActionEvent anActionEvent) {
        final Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            return;
        }
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        if (debuggerSession != null && debuggerSession.isAttached()) {
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                    virtualMachineProxyImpl.suspend();
                    try {
                        List<ThreadState> list2 = ThreadDumpAction.buildThreadStates(virtualMachineProxyImpl);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            XDebugSession xDebugSession = debuggerSession.getXDebugSession();
                            if (xDebugSession != null) {
                                DebuggerUtilsEx.addThreadDump(project2, list2, xDebugSession.getUI(), debuggerSession);
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    finally {
                        virtualMachineProxyImpl.resume();
                    }
                }
            });
        }
    }

    public static List<ThreadState> buildThreadStates(VirtualMachineProxyImpl virtualMachineProxyImpl) {
        Object object;
        List<ThreadReference> list2 = virtualMachineProxyImpl.getVirtualMachine().allThreads();
        ArrayList<ThreadState> arrayList = new ArrayList<ThreadState>();
        HashMap<String, ThreadState> hashMap = new HashMap<String, ThreadState>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (ThreadReference object2 : list2) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            object = new StringBuilder();
            boolean bl2 = true;
            int n2 = object2.status();
            if (n2 == 0) continue;
            String string = ThreadDumpAction.a(object2);
            ThreadState threadState = new ThreadState(string, ThreadDumpAction.b(n2));
            hashMap.put(string, threadState);
            arrayList.add(threadState);
            threadState.setJavaThreadState(ThreadDumpAction.a(n2));
            ((StringBuilder)object).append("\"").append(string).append("\"");
            ReferenceType referenceType = object2.referenceType();
            if (referenceType != null) {
                object6 = referenceType.fieldByName("daemon");
                if (object6 != null && (object5 = object2.getValue((Field)object6)) instanceof BooleanValue && ((BooleanValue)object5).booleanValue()) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                    threadState.setDaemon(true);
                }
                if ((object5 = referenceType.fieldByName("priority")) != null && (object4 = object2.getValue((Field)object5)) instanceof IntegerValue) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)object4).intValue()}));
                }
                if ((object4 = referenceType.fieldByName("tid")) != null && (object3 = object2.getValue((Field)object4)) instanceof LongValue) {
                    ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.tid", (Object[])new Object[]{Long.toHexString(((LongValue)object3).longValue())}));
                    ((StringBuilder)object).append(" nid=NA");
                }
            }
            if ((object6 = threadState.getState()) != null) {
                ((StringBuilder)object).append(" ").append((String)object6);
            }
            ((StringBuilder)object).append("\n  java.lang.Thread.State: ").append(threadState.getJavaThreadState());
            try {
                Object object7;
                if (virtualMachineProxyImpl.canGetOwnedMonitorInfo() && virtualMachineProxyImpl.canGetMonitorInfo()) {
                    object5 = object2.ownedMonitors();
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (ObjectReference)object4.next();
                        if (!virtualMachineProxyImpl.canGetMonitorFrameInfo()) {
                            ((StringBuilder)object).append("\n\t ").append(ThreadDumpAction.a((ObjectReference)object3));
                        }
                        List<ThreadReference> list3 = object3.waitingThreads();
                        Iterator<ThreadReference> iterator = list3.iterator();
                        while (iterator.hasNext()) {
                            ThreadReference threadReference = iterator.next();
                            object7 = ThreadDumpAction.a(threadReference);
                            hashMap2.put((String)object7, string);
                            ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{object7}));
                        }
                    }
                }
                Object object8 = object5 = virtualMachineProxyImpl.canGetCurrentContendedMonitor() ? object2.currentContendedMonitor() : null;
                if (object5 != null && virtualMachineProxyImpl.canGetMonitorInfo() && (object4 = object5.owningThread()) != null) {
                    object3 = ThreadDumpAction.a((ThreadReference)object4);
                    hashMap2.put(string, object3);
                    ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{object3, ThreadDumpAction.renderObject((ObjectReference)object5)}));
                }
                bl2 = (object4 = object2.frames()).size() == 0;
                object3 = new TIntObjectHashMap();
                if (virtualMachineProxyImpl.canGetMonitorFrameInfo()) {
                    for (MonitorInfo monitorInfo : object2.ownedMonitorsAndFrames()) {
                        int n3 = monitorInfo.stackDepth();
                        object7 = (List)object3.get(n3);
                        if (object7 == null) {
                            object7 = new SmartList();
                            object3.put(n3, object7);
                        }
                        object7.add(monitorInfo.monitor());
                    }
                }
                int n4 = object4.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    StackFrame stackFrame = (StackFrame)object4.get(i2);
                    try {
                        object7 = stackFrame.location();
                        ((StringBuilder)object).append("\n\t  ").append(ThreadDumpAction.renderLocation((Location)object7));
                        List list4 = (List)object3.get(i2);
                        if (list4 == null) continue;
                        for (ObjectReference objectReference : list4) {
                            ((StringBuilder)object).append("\n\t  - ").append(ThreadDumpAction.a(objectReference));
                        }
                        continue;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        ((StringBuilder)object).append("\n\t  Invalid stack frame: ").append(invalidStackFrameException.getMessage());
                    }
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            threadState.setStackTrace(((StringBuilder)object).toString(), bl2);
            ThreadDumpParser.inferThreadStateDetail((ThreadState)threadState);
        }
        for (String string : hashMap2.keySet()) {
            object = (ThreadState)hashMap.get(string);
            ThreadState threadState = (ThreadState)hashMap.get(hashMap2.get(string));
            if (object == null || threadState == null) continue;
            threadState.addWaitingThread((ThreadState)object);
        }
        for (ThreadState threadState : arrayList) {
            for (ThreadState threadState2 : threadState.getAwaitingThreads()) {
                if (!threadState2.isAwaitedBy(threadState)) continue;
                threadState.addDeadlockedThread(threadState2);
                threadState2.addDeadlockedThread(threadState);
            }
        }
        ThreadDumpParser.sortThreads(arrayList);
        return arrayList;
    }

    private static String a(ObjectReference objectReference) {
        return DebuggerBundle.message((String)"threads.export.attribute.label.locked", (Object[])new Object[]{ThreadDumpAction.renderObject(objectReference)});
    }

    public static String renderObject(ObjectReference objectReference) {
        String string;
        try {
            string = objectReference.referenceType().name();
        }
        catch (Throwable throwable) {
            string = "Error getting object type: '" + throwable.getMessage() + "'";
        }
        return DebuggerBundle.message((String)"threads.export.attribute.label.object-id", (Object[])new Object[]{Long.toHexString(objectReference.uniqueID()), string});
    }

    private static String a(int n2) {
        switch (n2) {
            case 3: {
                return Thread.State.BLOCKED.name();
            }
            case 5: {
                return Thread.State.NEW.name();
            }
            case 1: {
                return Thread.State.RUNNABLE.name();
            }
            case 2: {
                return Thread.State.TIMED_WAITING.name();
            }
            case 4: {
                return Thread.State.WAITING.name();
            }
            case 0: {
                return Thread.State.TERMINATED.name();
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    private static String b(int n2) {
        switch (n2) {
            case 3: {
                return "waiting for monitor entry";
            }
            case 5: {
                return "not started";
            }
            case 1: {
                return "runnable";
            }
            case 2: {
                return "sleeping";
            }
            case 4: {
                return "waiting";
            }
            case 0: {
                return "zombie";
            }
            case -1: {
                return "unknown";
            }
        }
        return "undefined";
    }

    public static String renderLocation(Location location) {
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), DebuggerUtilsEx.getSourceName(location, throwable -> "Unknown Source"), DebuggerUtilsEx.getLineNumber(location, false)});
    }

    private static String a(ThreadReference threadReference) {
        return threadReference.name() + "@" + threadReference.uniqueID();
    }

    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            presentation.setEnabled(false);
            return;
        }
        DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
        presentation.setEnabled(debuggerSession != null && debuggerSession.isAttached());
    }
}

