/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.DebuggerManagerThread;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.InvokeAndWaitThread;
import com.intellij.debugger.impl.InvokeThread;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorListenerAdapter;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.ProgressWindowWithNotification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class DebuggerManagerThreadImpl
extends InvokeAndWaitThread<DebuggerCommandImpl>
implements DebuggerManagerThread,
Disposable {
    private static final Logger d = Logger.getInstance(DebuggerManagerThreadImpl.class);
    static final int COMMAND_TIMEOUT = 3000;
    private volatile boolean e;

    DebuggerManagerThreadImpl(@NotNull Disposable disposable, Project project2) {
        if (disposable == null) {
            DebuggerManagerThreadImpl.b(0);
        }
        super(project2);
        Disposer.register((Disposable)disposable, (Disposable)this);
    }

    public void dispose() {
        this.e = true;
    }

    public static DebuggerManagerThreadImpl createTestInstance(@NotNull Disposable disposable, Project project2) {
        if (disposable == null) {
            DebuggerManagerThreadImpl.b(1);
        }
        return new DebuggerManagerThreadImpl(disposable, project2);
    }

    public static boolean isManagerThread() {
        return DebuggerManagerThreadImpl.currentThread() instanceof DebuggerManagerThreadImpl;
    }

    public static void assertIsManagerThread() {
        d.assertTrue(DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked in manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
    }

    @Override
    public void invokeAndWait(DebuggerCommandImpl debuggerCommandImpl) {
        d.assertTrue(!DebuggerManagerThreadImpl.isManagerThread(), (Object)"Should be invoked outside manager thread, use DebuggerManagerThreadImpl.getInstance(..).invoke...");
        super.invokeAndWait(debuggerCommandImpl);
    }

    public void invoke(DebuggerCommandImpl debuggerCommandImpl) {
        if (DebuggerManagerThreadImpl.currentThread() == this) {
            this.processEvent(debuggerCommandImpl);
        } else {
            this.schedule(debuggerCommandImpl);
        }
    }

    @Override
    public boolean pushBack(DebuggerCommandImpl debuggerCommandImpl) {
        boolean bl2 = super.pushBack(debuggerCommandImpl);
        if (!bl2) {
            debuggerCommandImpl.notifyCancelled();
        }
        return bl2;
    }

    @Override
    public boolean schedule(DebuggerCommandImpl debuggerCommandImpl) {
        boolean bl2 = super.schedule(debuggerCommandImpl);
        if (!bl2) {
            debuggerCommandImpl.notifyCancelled();
        }
        return bl2;
    }

    public void terminateAndInvoke(DebuggerCommandImpl debuggerCommandImpl, int n2) {
        DebuggerCommandImpl debuggerCommandImpl2 = (DebuggerCommandImpl)this.myEvents.getCurrentEvent();
        this.invoke(debuggerCommandImpl);
        if (debuggerCommandImpl2 != null) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> {
                if (debuggerCommandImpl2 == this.myEvents.getCurrentEvent()) {
                    this.getCurrentRequest().requestStop();
                    try {
                        this.getCurrentRequest().join();
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    finally {
                        if (!this.e) {
                            this.startNewWorkerThread();
                        }
                    }
                }
            }, (long)n2, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void processEvent(@NotNull DebuggerCommandImpl debuggerCommandImpl) {
        if (debuggerCommandImpl == null) {
            DebuggerManagerThreadImpl.b(2);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (this.myEvents.isClosed()) {
                debuggerCommandImpl.notifyCancelled();
            } else {
                debuggerCommandImpl.run();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            d.debug((Throwable)vMDisconnectedException);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        catch (Exception exception) {
            d.error((Throwable)exception);
        }
    }

    @Deprecated
    public void startProgress(DebuggerCommandImpl debuggerCommandImpl, ProgressWindowWithNotification progressWindowWithNotification) {
        this.startProgress(debuggerCommandImpl, (ProgressWindow)progressWindowWithNotification);
    }

    public void startProgress(final DebuggerCommandImpl debuggerCommandImpl, ProgressWindow progressWindow) {
        new ProgressIndicatorListenerAdapter(){

            public void cancelled() {
                debuggerCommandImpl.release();
            }
        }.installToProgress((ProgressIndicatorEx)progressWindow);
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> this.invokeAndWait(debuggerCommandImpl), (ProgressIndicator)progressWindow));
    }

    void startLongProcessAndFork(Runnable runnable) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.startNewWorkerThread();
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            InvokeThread.WorkerThreadRequest workerThreadRequest = DebuggerManagerThreadImpl.getCurrentThreadRequest();
            if (d.isDebugEnabled()) {
                d.debug("Switching back to " + workerThreadRequest);
            }
            super.invokeAndWait(new DebuggerCommandImpl(workerThreadRequest){
                final /* synthetic */ InvokeThread.WorkerThreadRequest val$request;
                {
                    this.val$request = workerThreadRequest;
                }

                @Override
                protected void action() throws Exception {
                    DebuggerManagerThreadImpl.this.switchToRequest(this.val$request);
                }

                @Override
                protected void commandCancelled() {
                    d.debug("Event queue was closed, killing request");
                    this.val$request.requestStop();
                }
            });
            throw throwable;
        }
        InvokeThread.WorkerThreadRequest workerThreadRequest = DebuggerManagerThreadImpl.getCurrentThreadRequest();
        if (d.isDebugEnabled()) {
            d.debug("Switching back to " + workerThreadRequest);
        }
        super.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
    }

    public void invokeCommand(final DebuggerCommand debuggerCommand) {
        if (debuggerCommand instanceof SuspendContextCommand) {
            SuspendContextCommand suspendContextCommand = (SuspendContextCommand)debuggerCommand;
            this.schedule(new SuspendContextCommandImpl((SuspendContextImpl)suspendContextCommand.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    if (suspendContextImpl == null) {
                        3.b(0);
                    }
                    debuggerCommand.action();
                }

                @Override
                protected void commandCancelled() {
                    debuggerCommand.commandCancelled();
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebuggerManagerThreadImpl$3", "contextAction"));
                }
            });
        } else {
            this.schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    debuggerCommand.action();
                }

                @Override
                protected void commandCancelled() {
                    debuggerCommand.commandCancelled();
                }
            });
        }
    }

    void restartIfNeeded() {
        if (this.myEvents.isClosed()) {
            this.myEvents.reopen();
            this.startNewWorkerThread();
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerCommand";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/DebuggerManagerThreadImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

