/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointHandler
extends XBreakpointHandler {
    protected final DebugProcessImpl myProcess;

    public JavaBreakpointHandler(@NotNull Class<? extends XBreakpointType<?, ?>> clazz, DebugProcessImpl debugProcessImpl) {
        if (clazz == null) {
            JavaBreakpointHandler.a(0);
        }
        super(clazz);
        this.myProcess = debugProcessImpl;
    }

    @Nullable
    protected Breakpoint createJavaBreakpoint(@NotNull XBreakpoint xBreakpoint) {
        if (xBreakpoint == null) {
            JavaBreakpointHandler.a(1);
        }
        return null;
    }

    public void registerBreakpoint(@NotNull XBreakpoint xBreakpoint) {
        Breakpoint breakpoint;
        if (xBreakpoint == null) {
            JavaBreakpointHandler.a(2);
        }
        if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) == null) {
            breakpoint = this.createJavaBreakpoint(xBreakpoint);
            xBreakpoint.putUserData(Breakpoint.DATA_KEY, (Object)breakpoint);
        }
        if (breakpoint != null) {
            final Breakpoint breakpoint2 = breakpoint;
            BreakpointManager.addBreakpoint(breakpoint2);
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    breakpoint2.createRequest(JavaBreakpointHandler.this.myProcess);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    public void unregisterBreakpoint(@NotNull XBreakpoint xBreakpoint, boolean bl2) {
        Breakpoint breakpoint;
        if (xBreakpoint == null) {
            JavaBreakpointHandler.a(3);
        }
        if ((breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint)) != null) {
            this.myProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    JavaBreakpointHandler.this.myProcess.getRequestsManager().deleteRequest(breakpoint);
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }
            });
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointTypeClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xBreakpoint";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaBreakpointHandler";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createJavaBreakpoint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterBreakpoint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JavaFieldBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaFieldBreakpointHandler(DebugProcessImpl debugProcessImpl) {
            super(JavaFieldBreakpointType.class, debugProcessImpl);
        }
    }

    public static class JavaWildcardBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaWildcardBreakpointHandler(DebugProcessImpl debugProcessImpl) {
            super(JavaWildcardMethodBreakpointType.class, debugProcessImpl);
        }
    }

    public static class JavaMethodBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaMethodBreakpointHandler(DebugProcessImpl debugProcessImpl) {
            super(JavaMethodBreakpointType.class, debugProcessImpl);
        }
    }

    public static class JavaExceptionBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaExceptionBreakpointHandler(DebugProcessImpl debugProcessImpl) {
            super(JavaExceptionBreakpointType.class, debugProcessImpl);
        }
    }

    public static class JavaLineBreakpointHandler
    extends JavaBreakpointHandler {
        public JavaLineBreakpointHandler(DebugProcessImpl debugProcessImpl) {
            super(JavaLineBreakpointType.class, debugProcessImpl);
        }
    }
}

