/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerPsiEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaDebuggerEvaluator
extends XDebuggerEvaluator
implements XDebuggerPsiEvaluator {
    private final DebugProcessImpl b;
    private final JavaStackFrame a;

    public JavaDebuggerEvaluator(DebugProcessImpl debugProcessImpl, JavaStackFrame javaStackFrame) {
        this.b = debugProcessImpl;
        this.a = javaStackFrame;
    }

    public void evaluate(@NotNull String string, @NotNull XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback, @Nullable XSourcePosition xSourcePosition) {
        if (string == null) {
            JavaDebuggerEvaluator.a(0);
        }
        if (xEvaluationCallback == null) {
            JavaDebuggerEvaluator.a(1);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)string), xEvaluationCallback, xSourcePosition);
    }

    public void evaluate(final @NotNull XExpression xExpression, final @NotNull XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback, @Nullable XSourcePosition xSourcePosition) {
        if (xExpression == null) {
            JavaDebuggerEvaluator.a(2);
        }
        if (xEvaluationCallback == null) {
            JavaDebuggerEvaluator.a(3);
        }
        this.b.getManagerThread().schedule(new DebuggerContextCommandImpl(this.b.getDebuggerContext(), this.a.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.c(0);
                }
                if (DebuggerUIUtil.isObsolete((Object)xEvaluationCallback)) {
                    return;
                }
                JavaDebugProcess javaDebugProcess = JavaDebuggerEvaluator.this.b.getXdebugProcess();
                if (javaDebugProcess == null) {
                    xEvaluationCallback.errorOccurred("No debug process");
                    return;
                }
                TextWithImports textWithImports = TextWithImportsImpl.fromXExpression(xExpression);
                NodeManagerImpl nodeManagerImpl = javaDebugProcess.getNodeManager();
                WatchItemDescriptor watchItemDescriptor = nodeManagerImpl.getWatchItemDescriptor(null, textWithImports, null);
                EvaluationContextImpl evaluationContextImpl = JavaDebuggerEvaluator.this.a.getFrameDebuggerContext(this.getDebuggerContext()).createEvaluationContext();
                if (evaluationContextImpl == null) {
                    xEvaluationCallback.errorOccurred("Context is not available");
                    return;
                }
                watchItemDescriptor.setContext(evaluationContextImpl);
                EvaluateException evaluateException = watchItemDescriptor.getEvaluateException();
                if (evaluateException != null && watchItemDescriptor.getValue() == null) {
                    xEvaluationCallback.errorOccurred(evaluateException.getMessage());
                    return;
                }
                xEvaluationCallback.evaluated((XValue)JavaValue.create(null, watchItemDescriptor, evaluationContextImpl, nodeManagerImpl, true));
            }

            private static /* synthetic */ void c(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaDebuggerEvaluator$1", "threadAction"));
            }
        });
    }

    public void evaluate(final @NotNull PsiElement psiElement, final @NotNull XDebuggerEvaluator.XEvaluationCallback xEvaluationCallback) {
        if (psiElement == null) {
            JavaDebuggerEvaluator.a(4);
        }
        if (xEvaluationCallback == null) {
            JavaDebuggerEvaluator.a(5);
        }
        this.b.getManagerThread().schedule(new DebuggerContextCommandImpl(this.b.getDebuggerContext(), this.a.getStackFrameProxy().threadProxy()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    2.c(0);
                }
                if (DebuggerUIUtil.isObsolete((Object)xEvaluationCallback)) {
                    return;
                }
                JavaDebugProcess javaDebugProcess = JavaDebuggerEvaluator.this.b.getXdebugProcess();
                if (javaDebugProcess == null) {
                    xEvaluationCallback.errorOccurred("No debug process");
                    return;
                }
                DebuggerContextImpl debuggerContextImpl = JavaDebuggerEvaluator.this.a.getFrameDebuggerContext(this.getDebuggerContext());
                EvaluationContextImpl evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
                if (evaluationContextImpl == null) {
                    xEvaluationCallback.errorOccurred("Context is not available");
                    return;
                }
                try {
                    Project project2 = JavaDebuggerEvaluator.this.b.getProject();
                    ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)ReadAction.compute(() -> {
                        if (psiElement == null) {
                            2.c(1);
                        }
                        CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.getCodeFragmentFactory(psiElement, null);
                        try {
                            return codeFragmentFactory.getEvaluatorBuilder().build(psiElement, debuggerContextImpl.getSourcePosition());
                        }
                        catch (UnsupportedExpressionException unsupportedExpressionException) {
                            PsiElement psiElement2 = PositionUtil.getContextElement((StackFrameContext)debuggerContextImpl);
                            ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(project2, psiElement2, psiElement3 -> {
                                if (psiElement == null) {
                                    2.c(2);
                                }
                                return codeFragmentFactory.createCodeFragment((TextWithImports)new TextWithImportsImpl(psiElement), psiElement2, project2);
                            });
                            if (expressionEvaluator != null) {
                                return expressionEvaluator;
                            }
                            throw unsupportedExpressionException;
                        }
                    });
                    Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
                    TextWithImportsImpl textWithImportsImpl = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
                    WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(project2, textWithImportsImpl, value, evaluationContextImpl);
                    xEvaluationCallback.evaluated((XValue)JavaValue.create(null, watchItemDescriptor, evaluationContextImpl, javaDebugProcess.getNodeManager(), true));
                }
                catch (EvaluateException evaluateException) {
                    xEvaluationCallback.errorOccurred(evaluateException.getMessage());
                }
            }

            private static /* synthetic */ void c(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suspendContext";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator$2";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "threadAction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$threadAction$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project2, @NotNull Document document, int n2, boolean bl2) {
        if (project2 == null) {
            JavaDebuggerEvaluator.a(6);
        }
        if (document == null) {
            JavaDebuggerEvaluator.a(7);
        }
        return (ExpressionInfo)PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> {
            if (project2 == null) {
                JavaDebuggerEvaluator.a(9);
            }
            if (document == null) {
                JavaDebuggerEvaluator.a(10);
            }
            try {
                PsiElement psiElement = DebuggerUtilsEx.findElementAt(PsiDocumentManager.getInstance((Project)project2).getPsiFile(document), n2);
                if (psiElement == null || !psiElement.isValid()) {
                    return null;
                }
                Pair<PsiElement, TextRange> pair2 = JavaDebuggerEvaluator.a(psiElement, bl2);
                if (pair2 != null) {
                    PsiElement psiElement2 = (PsiElement)pair2.getFirst();
                    return new ExpressionInfo((TextRange)pair2.getSecond(), null, null, (PsiElement)(psiElement2 instanceof PsiExpression ? psiElement2 : null));
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            return null;
        });
    }

    @Nullable
    private static Pair<PsiElement, TextRange> a(PsiElement psiElement, boolean bl2) {
        EditorTextProvider editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage());
        if (editorTextProvider != null) {
            return editorTextProvider.findExpression(psiElement, bl2);
        }
        return null;
    }

    public EvaluationMode getEvaluationMode(@NotNull String string, int n2, int n3, @Nullable PsiFile psiFile) {
        if (string == null) {
            JavaDebuggerEvaluator.a(8);
        }
        if (psiFile != null) {
            PsiElement[] psiElementArray = CodeInsightUtil.findStatementsInRange((PsiFile)psiFile, (int)n2, (int)n3);
            return psiElementArray.length > 1 ? EvaluationMode.CODE_FRAGMENT : EvaluationMode.EXPRESSION;
        }
        return super.getEvaluationMode(string, n2, n3, null);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/JavaDebuggerEvaluator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getExpressionInfoAtOffset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getEvaluationMode";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getExpressionInfoAtOffset$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

