/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.Location;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionStack
extends XExecutionStack {
    private static final Logger a = Logger.getInstance(JavaExecutionStack.class);
    private final ThreadReferenceProxyImpl c;
    private final DebugProcessImpl d;
    private volatile XStackFrame b;
    private volatile boolean f;
    private final MethodsTracker e;

    public JavaExecutionStack(@NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl, @NotNull DebugProcessImpl debugProcessImpl, boolean bl2) {
        if (threadReferenceProxyImpl == null) {
            JavaExecutionStack.a(0);
        }
        if (debugProcessImpl == null) {
            JavaExecutionStack.a(1);
        }
        super(JavaExecutionStack.a(threadReferenceProxyImpl), JavaExecutionStack.a(threadReferenceProxyImpl, bl2));
        this.f = false;
        this.e = new MethodsTracker();
        this.c = threadReferenceProxyImpl;
        this.d = debugProcessImpl;
    }

    private static Icon a(ThreadReferenceProxyImpl threadReferenceProxyImpl, boolean bl2) {
        if (bl2) {
            return threadReferenceProxyImpl.isSuspended() ? AllIcons.Debugger.ThreadCurrent : AllIcons.Debugger.ThreadRunning;
        }
        if (threadReferenceProxyImpl.isAtBreakpoint()) {
            return AllIcons.Debugger.ThreadAtBreakpoint;
        }
        if (threadReferenceProxyImpl.isSuspended()) {
            return AllIcons.Debugger.ThreadSuspended;
        }
        return AllIcons.Debugger.ThreadRunning;
    }

    @NotNull
    ThreadReferenceProxyImpl getThreadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.c;
        if (threadReferenceProxyImpl == null) {
            JavaExecutionStack.a(2);
        }
        return threadReferenceProxyImpl;
    }

    public final void initTopFrame() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            StackFrameProxyImpl stackFrameProxyImpl = this.c.frame(0);
            if (stackFrameProxyImpl != null) {
                this.b = this.createStackFrame(stackFrameProxyImpl);
            }
        }
        catch (EvaluateException evaluateException) {
            a.info((Throwable)evaluateException);
        }
        finally {
            this.f = true;
        }
    }

    @NotNull
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl stackFrameProxyImpl) {
        XStackFrame xStackFrame;
        if (stackFrameProxyImpl == null) {
            JavaExecutionStack.a(3);
        }
        StackFrameDescriptorImpl stackFrameDescriptorImpl = new StackFrameDescriptorImpl(stackFrameProxyImpl, this.e);
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)stackFrameDescriptorImpl.getDebugProcess();
        Location location = stackFrameDescriptorImpl.getLocation();
        if (location != null && (xStackFrame = debugProcessImpl.getPositionManager().createStackFrame(stackFrameProxyImpl, debugProcessImpl, location)) != null) {
            XStackFrame xStackFrame2 = xStackFrame;
            if (xStackFrame2 == null) {
                JavaExecutionStack.a(4);
            }
            return xStackFrame2;
        }
        JavaStackFrame javaStackFrame = new JavaStackFrame(stackFrameDescriptorImpl, true);
        if (javaStackFrame == null) {
            JavaExecutionStack.a(5);
        }
        return javaStackFrame;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        assert (this.f) : "Top frame must be already calculated here";
        return this.b;
    }

    public void computeStackFrames(final int n2, final XExecutionStack.XStackFrameContainer xStackFrameContainer) {
        if (xStackFrameContainer.isObsolete()) {
            return;
        }
        this.d.getManagerThread().schedule(new SuspendContextCommandImpl(this.d.getDebuggerContext().getSuspendContext()){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                if (xStackFrameContainer.isObsolete()) {
                    return;
                }
                if (!JavaExecutionStack.this.c.isCollected() && JavaExecutionStack.this.d.getSuspendManager().isSuspended(JavaExecutionStack.this.c)) {
                    int n22 = JavaExecutionStack.this.c.status();
                    if (n22 != -1 && n22 != 5 && n22 != 0) {
                        try {
                            int n3 = 0;
                            Iterator<StackFrameProxyImpl> iterator = JavaExecutionStack.this.c.frames().iterator();
                            if (iterator.hasNext() && n2 > 0) {
                                iterator.next();
                                ++n3;
                            }
                            JavaExecutionStack.this.d.getManagerThread().schedule(new AppendFrameCommand(suspendContextImpl, iterator, xStackFrameContainer, n3, n2));
                        }
                        catch (EvaluateException evaluateException) {
                            xStackFrameContainer.errorOccurred(evaluateException.getMessage());
                        }
                    }
                } else {
                    xStackFrameContainer.errorOccurred(DebuggerBundle.message((String)"frame.panel.frames.not.available", (Object[])new Object[0]));
                }
            }

            private static /* synthetic */ void b(int n22) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaExecutionStack$1", "contextAction"));
            }
        });
    }

    private static boolean a(@NotNull XStackFrame xStackFrame) {
        if (xStackFrame == null) {
            JavaExecutionStack.a(6);
        }
        if (!XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames() && xStackFrame instanceof JVMStackFrameInfoProvider) {
            JVMStackFrameInfoProvider jVMStackFrameInfoProvider = (JVMStackFrameInfoProvider)xStackFrame;
            return !jVMStackFrameInfoProvider.isSynthetic() && !jVMStackFrameInfoProvider.isInLibraryContent();
        }
        return true;
    }

    private static String a(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        String string = threadReferenceProxyImpl.name();
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = threadReferenceProxyImpl.threadGroupProxy();
        String string2 = threadGroupReferenceProxyImpl != null ? threadGroupReferenceProxyImpl.name() : null;
        String string3 = DebuggerUtilsEx.getThreadStatusText(threadReferenceProxyImpl.status());
        if (string2 != null && !"SYSTEM".equalsIgnoreCase(string2)) {
            return DebuggerBundle.message((String)"label.thread.node.in.group", (Object[])new Object[]{string, threadReferenceProxyImpl.uniqueID(), string3, string2});
        }
        return DebuggerBundle.message((String)"label.thread.node", (Object[])new Object[]{string, threadReferenceProxyImpl.uniqueID(), string3});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        JavaExecutionStack javaExecutionStack = (JavaExecutionStack)((Object)object);
        return this.c.equals(javaExecutionStack.c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameProxy";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaExecutionStack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadProxy";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStackFrame";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createStackFrame";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showFrame";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class AppendFrameCommand
    extends SuspendContextCommandImpl {
        private final Iterator<StackFrameProxyImpl> f;
        private final XExecutionStack.XStackFrameContainer d;
        private int g;
        private final int e;

        public AppendFrameCommand(SuspendContextImpl suspendContextImpl, Iterator<StackFrameProxyImpl> iterator, XExecutionStack.XStackFrameContainer xStackFrameContainer, int n2, int n3) {
            super(suspendContextImpl);
            this.f = iterator;
            this.d = xStackFrameContainer;
            this.g = n2;
            this.e = n3;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return this.g <= 10 ? PrioritizedTask.Priority.NORMAL : PrioritizedTask.Priority.LOW;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
            if (suspendContextImpl == null) {
                AppendFrameCommand.b(0);
            }
            if (this.d.isObsolete()) {
                return;
            }
            if (this.f.hasNext()) {
                StackFrameProxyImpl stackFrameProxyImpl;
                XStackFrame xStackFrame;
                boolean bl2;
                boolean bl3 = bl2 = this.g == 0;
                if (bl2 && JavaExecutionStack.this.f) {
                    xStackFrame = JavaExecutionStack.this.b;
                    stackFrameProxyImpl = this.f.next();
                } else {
                    stackFrameProxyImpl = this.f.next();
                    xStackFrame = JavaExecutionStack.this.createStackFrame(stackFrameProxyImpl);
                    if (bl2 && !JavaExecutionStack.this.f) {
                        JavaExecutionStack.this.b = xStackFrame;
                        JavaExecutionStack.this.f = true;
                    }
                }
                if ((bl2 || JavaExecutionStack.a(xStackFrame)) && ++this.g > this.e) {
                    this.d.addStackFrames(Collections.singletonList(xStackFrame), false);
                }
                if (xStackFrame instanceof JavaStackFrame && AsyncStacksToggleAction.isAsyncStacksEnabled((XDebugSessionImpl)JavaExecutionStack.this.d.getXdebugProcess().getSession())) {
                    List<StackFrameItem> list2 = StackCapturingLineBreakpoint.getRelatedStack(stackFrameProxyImpl, suspendContextImpl, true);
                    if (!ContainerUtil.isEmpty(list2)) {
                        int n2 = 0;
                        boolean bl4 = true;
                        for (StackFrameItem stackFrameItem : list2) {
                            if (n2 > 500) {
                                this.d.addStackFrames(Collections.singletonList(new XStackFrame(){

                                    public void customizePresentation(@NotNull ColoredTextContainer coloredTextContainer) {
                                        if (coloredTextContainer == null) {
                                            1.a(0);
                                        }
                                        coloredTextContainer.append("Too many frames, the rest is truncated...", SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                                    }

                                    private static /* synthetic */ void a(int n2) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand$1", "customizePresentation"));
                                    }
                                }), true);
                                return;
                            }
                            ++n2;
                            if (stackFrameItem == null) {
                                bl4 = true;
                                continue;
                            }
                            StackFrameItem.CapturedStackFrame capturedStackFrame = stackFrameItem.createFrame(JavaExecutionStack.this.d);
                            if (!JavaExecutionStack.a(capturedStackFrame)) continue;
                            capturedStackFrame.setWithSeparator(bl4);
                            this.d.addStackFrames(Collections.singletonList(capturedStackFrame), false);
                            bl4 = false;
                        }
                        this.d.addStackFrames(Collections.emptyList(), true);
                        return;
                    }
                    ((JavaStackFrame)xStackFrame).setInsertCapturePoint(StackCapturingLineBreakpoint.getMatchingDisabledInsertionPoint(stackFrameProxyImpl));
                }
                JavaExecutionStack.this.d.getManagerThread().schedule(new AppendFrameCommand(suspendContextImpl, this.f, this.d, this.g, this.e));
            } else {
                this.d.addStackFrames(Collections.emptyList(), true);
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaExecutionStack$AppendFrameCommand", "contextAction"));
        }
    }
}

