/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaStaticGroup
extends XValueGroup
implements NodeDescriptorProvider {
    private final StaticDescriptorImpl a;
    private final EvaluationContextImpl c;
    private final NodeManagerImpl b;

    public JavaStaticGroup(StaticDescriptorImpl staticDescriptorImpl, EvaluationContextImpl evaluationContextImpl, NodeManagerImpl nodeManagerImpl) {
        super(staticDescriptorImpl.getName());
        this.a = staticDescriptorImpl;
        this.c = evaluationContextImpl;
        this.b = nodeManagerImpl;
    }

    @Nullable
    public String getComment() {
        String string = NodeRendererSettings.getInstance().getClassRenderer().renderTypeName(this.a.getType().name());
        if (!StringUtil.isEmpty((String)string)) {
            return " members of " + string;
        }
        return string;
    }

    @NotNull
    public String getSeparator() {
        if ("" == null) {
            JavaStaticGroup.a(0);
        }
        return "";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Nodes.Static;
    }

    @Override
    public NodeDescriptorImpl getDescriptor() {
        return this.a;
    }

    public void computeChildren(final @NotNull XCompositeNode xCompositeNode) {
        if (xCompositeNode == null) {
            JavaStaticGroup.a(1);
        }
        JavaValue.scheduleCommand(this.c, xCompositeNode, new SuspendContextCommandImpl(this.c.getSuspendContext()){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                XValueChildrenList xValueChildrenList = new XValueChildrenList();
                ReferenceType referenceType = JavaStaticGroup.this.a.getType();
                List<Field> list2 = referenceType.allFields();
                ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                for (Field field : list2) {
                    if (!field.isStatic()) continue;
                    boolean bl2 = DebuggerUtils.isSynthetic((TypeComponent)field);
                    if (!classRenderer.SHOW_SYNTHETICS && bl2) continue;
                    FieldDescriptorImpl fieldDescriptorImpl = JavaStaticGroup.this.b.getFieldDescriptor(JavaStaticGroup.this.a, null, field);
                    xValueChildrenList.add((XNamedValue)JavaValue.create(fieldDescriptorImpl, JavaStaticGroup.this.c, JavaStaticGroup.this.b));
                }
                xCompositeNode.addChildren(xValueChildrenList, true);
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/JavaStaticGroup$1", "contextAction"));
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/JavaStaticGroup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeparator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/JavaStaticGroup";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

