/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.MultiRequestPositionManager;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.RemappedSourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.EmptyIterable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PositionManagerImpl
implements PositionManager,
MultiRequestPositionManager {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.PositionManagerImpl");
    private final DebugProcessImpl a;

    public PositionManagerImpl(DebugProcessImpl debugProcessImpl) {
        this.a = debugProcessImpl;
    }

    public DebugProcess getDebugProcess() {
        return this.a;
    }

    @NotNull
    public List<Location> locationsOfLine(@NotNull ReferenceType referenceType, @NotNull SourcePosition sourcePosition) throws NoDataException {
        List<Location> list2;
        if (referenceType == null) {
            PositionManagerImpl.a(0);
        }
        if (sourcePosition == null) {
            PositionManagerImpl.a(1);
        }
        try {
            int n2 = sourcePosition.getLine() + 1;
            list2 = referenceType.locationsOfLine("Java", null, n2);
        }
        catch (AbsentInformationException absentInformationException) {
            List<Location> list3 = Collections.emptyList();
            if (list3 == null) {
                PositionManagerImpl.a(3);
            }
            return list3;
        }
        if (list2 == null) {
            PositionManagerImpl.a(2);
        }
        return list2;
    }

    public ClassPrepareRequest createPrepareRequest(@NotNull ClassPrepareRequestor classPrepareRequestor, @NotNull SourcePosition sourcePosition) throws NoDataException {
        if (classPrepareRequestor == null) {
            PositionManagerImpl.a(4);
        }
        if (sourcePosition == null) {
            PositionManagerImpl.a(5);
        }
        throw new IllegalStateException("This class implements MultiRequestPositionManager, corresponding createPrepareRequests version should be used");
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(final @NotNull ClassPrepareRequestor classPrepareRequestor, final @NotNull SourcePosition sourcePosition) throws NoDataException {
        if (classPrepareRequestor == null) {
            PositionManagerImpl.a(6);
        }
        if (sourcePosition == null) {
            PositionManagerImpl.a(7);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (sourcePosition == null) {
                PositionManagerImpl.a(15);
            }
            if (classPrepareRequestor == null) {
                PositionManagerImpl.a(16);
            }
            ArrayList<PsiClass> arrayList = new ArrayList<PsiClass>();
            for (PsiClass psiClass : PositionManagerImpl.b(sourcePosition.getFile(), sourcePosition.getLine())) {
                Object object;
                ClassPrepareRequestor classPrepareRequestor2 = classPrepareRequestor;
                String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
                if (string == null) {
                    String string2;
                    object = JVMNameUtil.getTopLevelParentClass(psiClass);
                    if (object == null || (string2 = JVMNameUtil.getNonAnonymousClassName(object)) == null) continue;
                    string = string2 + "*";
                    classPrepareRequestor2 = new ClassPrepareRequestor(){

                        public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
                            if (((DebugProcessImpl)debugProcess).getPositionManager().getAllClasses(sourcePosition).contains(referenceType)) {
                                classPrepareRequestor.processClassPrepare(debugProcess, referenceType);
                            }
                        }
                    };
                }
                if ((object = this.a.getRequestsManager().createClassPrepareRequest(classPrepareRequestor2, string)) == null) continue;
                arrayList.add((PsiClass)object);
            }
            return arrayList;
        });
        if (list2 == null) {
            PositionManagerImpl.a(8);
        }
        return list2;
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location2) throws NoDataException {
        Set set;
        Method method;
        Object object;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (location2 == null) {
            return null;
        }
        Project project2 = this.getDebugProcess().getProject();
        Object object2 = this.getPsiFileByLocation(project2, location2);
        if (object2 == null) {
            return null;
        }
        b.assertTrue(this.a != null);
        int n2 = DebuggerUtilsEx.getLineNumber(location2, true);
        String string = location2.declaringType().name();
        String string2 = DebuggerUtilsEx.getAlternativeSourceUrl(string, project2);
        if (string2 != null && (object = VirtualFileManager.getInstance().findFileByUrl(string2)) != null && (method = object2.getManager().findFile(object)) != null) {
            object2 = method;
        }
        object = null;
        if (n2 > -1) {
            object = PositionManagerImpl.c(object2, n2);
        }
        method = DebuggerUtilsEx.getMethod(location2);
        if (object == null && (object2 instanceof PsiCompiledElement || n2 < 0)) {
            if (method != null && method.name() != null && method.signature() != null) {
                PsiClass psiClass = this.a(string, null);
                set = this.findMethod((PsiElement)(psiClass != null ? psiClass : object2), string, method.name(), method.signature());
                if (set != null) {
                    object = SourcePosition.createFromElement((PsiElement)set);
                    if (n2 >= 0) {
                        object = new ClsSourcePosition((SourcePosition)object, n2);
                    }
                }
            } else {
                return SourcePosition.createFromLine((PsiFile)object2, (int)-1);
            }
        }
        if (object == null) {
            object = SourcePosition.createFromLine((PsiFile)object2, (int)n2);
        }
        int n3 = -1;
        if (DebuggerUtilsEx.isLambda(method) && (set = ContainerUtil.map2SetNotNull(this.locationsOfLine(location2.declaringType(), (SourcePosition)object), location -> {
            Method method = location.method();
            if (DebuggerUtilsEx.isLambda(method)) {
                return method;
            }
            return null;
        })).size() > 1) {
            ArrayList<Method> arrayList = new ArrayList<Method>(set);
            arrayList.sort(DebuggerUtilsEx.LAMBDA_ORDINAL_COMPARATOR);
            n3 = arrayList.indexOf(method);
        }
        return new JavaSourcePosition((SourcePosition)object, location2.declaringType(), method, n3);
    }

    private static Iterable<PsiElement> a(final PsiFile psiFile, int n2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document == null || n2 < 0 || n2 >= document.getLineCount()) {
            return EmptyIterable.getInstance();
        }
        final TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
        return new Iterable<PsiElement>(){

            @Override
            public Iterator<PsiElement> iterator() {
                return new Iterator<PsiElement>(){
                    PsiElement myElement;
                    {
                        this.myElement = DebuggerUtilsEx.findElementAt(psiFile, textRange.getStartOffset());
                    }

                    @Override
                    public boolean hasNext() {
                        return this.myElement != null;
                    }

                    @Override
                    public PsiElement next() {
                        PsiElement psiElement = this.myElement;
                        do {
                            this.myElement = PsiTreeUtil.nextLeaf((PsiElement)this.myElement);
                            if (this.myElement != null && this.myElement.getTextOffset() <= textRange.getEndOffset()) continue;
                            this.myElement = null;
                            break;
                        } while (this.myElement.getTextLength() == 0);
                        return psiElement;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    private static Set<PsiClass> b(PsiFile psiFile, int n2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet<PsiClass> hashSet = new HashSet<PsiClass>();
        for (PsiElement psiElement : PositionManagerImpl.a(psiFile, n2)) {
            PsiClass psiClass = PositionManagerImpl.a(psiElement);
            if (psiClass == null) continue;
            hashSet.add(psiClass);
        }
        return hashSet;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project2, Location location) {
        if (location == null) {
            return null;
        }
        ReferenceType referenceType = location.declaringType();
        if (referenceType == null) {
            return null;
        }
        String string = referenceType.name();
        Ref ref = new Ref();
        PsiClass psiClass = this.a(string, (ClsClassImpl clsClassImpl) -> ref.set((Object)this.a((ClsClassImpl)clsClassImpl)));
        if (!ref.isNull()) {
            return (PsiFile)ref.get();
        }
        if (psiClass != null) {
            PsiElement psiElement;
            PsiElement psiElement2 = psiClass.getNavigationElement();
            if (psiElement2 instanceof PsiCompiledElement && !((psiElement = psiClass.getContainingFile().getNavigationElement()) instanceof PsiCompiledElement)) {
                psiElement2 = psiElement;
            }
            return psiElement2.getContainingFile();
        }
        try {
            PsiFile[] psiFileArray;
            for (PsiFile psiFile : psiFileArray = FilenameIndex.getFilesByName((Project)project2, (String)referenceType.sourceName(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project2))) {
                if (!(psiFile instanceof PsiJavaFile)) continue;
                for (PsiClass psiClass2 : ((PsiJavaFile)psiFile).getClasses()) {
                    if (!StringUtil.equals((CharSequence)string, (CharSequence)psiClass2.getQualifiedName())) continue;
                    return psiFile;
                }
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private PsiClass a(String string, @Nullable Consumer<ClsClassImpl> consumer) {
        PsiClass psiClass = null;
        Sdk sdk = this.a.getSession().getAlternativeJre();
        if (sdk != null && (psiClass = PositionManagerImpl.findClass(this.a.getProject(), string, AlternativeJreClassFinder.getSearchScope(sdk))) instanceof ClsClassImpl && consumer != null) {
            consumer.accept((ClsClassImpl)psiClass);
        }
        if (psiClass == null) {
            psiClass = PositionManagerImpl.findClass(this.a.getProject(), string, this.a.getSearchScope());
        }
        return psiClass;
    }

    @Nullable
    public static PsiClass findClass(Project project2, String string, GlobalSearchScope globalSearchScope) {
        int n2;
        PsiClass psiClass = DebuggerUtils.findClass((String)string, (Project)project2, (GlobalSearchScope)globalSearchScope);
        if (psiClass == null && (n2 = string.indexOf(36)) > 0) {
            psiClass = DebuggerUtils.findClass((String)string.substring(0, n2), (Project)project2, (GlobalSearchScope)globalSearchScope);
        }
        return psiClass;
    }

    @Nullable
    private PsiFile a(ClsClassImpl clsClassImpl) {
        String string = clsClassImpl.getSourceFileName();
        String string2 = ((PsiClassOwner)clsClassImpl.getContainingFile()).getPackageName();
        String string3 = string2.isEmpty() ? string : string2.replace('.', '/') + '/' + string;
        Sdk sdk = this.a.getSession().getAlternativeJre();
        if (sdk != null) {
            for (VirtualFile virtualFile : AlternativeJreClassFinder.getSourceRoots(sdk)) {
                PsiFile psiFile;
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string3);
                if (virtualFile2 == null || !virtualFile2.isValid() || !((psiFile = clsClassImpl.getManager().findFile(virtualFile2)) instanceof PsiClassOwner)) continue;
                return psiFile;
            }
        }
        return null;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition sourcePosition) throws NoDataException {
        if (sourcePosition == null) {
            PositionManagerImpl.a(9);
        }
        List list2 = (List)ReadAction.compute(() -> {
            if (sourcePosition == null) {
                PositionManagerImpl.a(13);
            }
            return StreamEx.of(PositionManagerImpl.b(sourcePosition.getFile(), sourcePosition.getLine())).flatMap(psiClass -> {
                if (sourcePosition == null) {
                    PositionManagerImpl.a(14);
                }
                return this.a((PsiClass)psiClass, sourcePosition);
            }).toList();
        });
        if (list2 == null) {
            PositionManagerImpl.a(10);
        }
        return list2;
    }

    private StreamEx<ReferenceType> a(@NotNull PsiClass psiClass, SourcePosition sourcePosition) {
        if (psiClass == null) {
            PositionManagerImpl.a(11);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl2 = false;
        int n2 = 0;
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        if (string == null) {
            bl2 = true;
            Pair<PsiClass, Integer> pair2 = PositionManagerImpl.a(psiClass);
            PsiClass psiClass2 = (PsiClass)pair2.first;
            if (psiClass2 != null) {
                String string2 = JVMNameUtil.getNonAnonymousClassName(psiClass2);
                if (string2 != null) {
                    n2 = (Integer)pair2.second;
                    string = string2;
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                PsiTreeUtil.treeWalkUp((PsiElement)psiClass, null, (psiElement, psiElement2) -> {
                    stringBuilder.append('\n').append(psiElement);
                    return true;
                });
                b.info("Local or anonymous class " + psiClass + " has no non-local parent, parents:" + stringBuilder);
            }
        }
        if (string == null) {
            return StreamEx.empty();
        }
        if (!bl2) {
            return StreamEx.of(this.a.getVirtualMachineProxy().classesByName(string));
        }
        int n3 = n2;
        return StreamEx.of(this.a.getVirtualMachineProxy().classesByName(string)).map(referenceType -> {
            if (psiClass == null) {
                PositionManagerImpl.a(12);
            }
            return this.a((ReferenceType)referenceType, 0, psiClass, n3, sourcePosition);
        }).nonNull();
    }

    private static Pair<PsiClass, Integer> a(PsiClass psiClass) {
        int n2 = 0;
        PsiClass psiClass2 = PositionManagerImpl.a((PsiElement)psiClass);
        while (psiClass2 != null) {
            PsiClass psiClass3;
            ++n2;
            if (psiClass2.hasModifierProperty("static") || (psiClass3 = PositionManagerImpl.a((PsiElement)psiClass2)) == null) break;
            psiClass2 = psiClass3;
        }
        return Pair.create((Object)psiClass2, (Object)n2);
    }

    @Nullable
    private static PsiClass a(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        PsiElement psiElement2 = null;
        for (psiElement = psiElement.getParent(); psiElement != null; psiElement = psiElement.getParent()) {
            if (PsiClass.class.isInstance(psiElement) && !(psiElement2 instanceof PsiExpressionList)) {
                return (PsiClass)psiElement;
            }
            if (psiElement instanceof PsiFile) {
                return null;
            }
            psiElement2 = psiElement;
        }
        return null;
    }

    @Nullable
    private ReferenceType a(ReferenceType referenceType, int n2, PsiClass psiClass, int n3, SourcePosition sourcePosition) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.a.getVirtualMachineProxy();
        if (referenceType.isPrepared()) {
            int n4;
            if (n2 < n3) {
                List<ReferenceType> list2 = virtualMachineProxyImpl.nestedTypes(referenceType);
                for (ReferenceType referenceType2 : list2) {
                    ReferenceType referenceType3 = this.a(referenceType2, n2 + 1, psiClass, n3, sourcePosition);
                    if (referenceType3 == null) continue;
                    return referenceType3;
                }
                return null;
            }
            int n5 = Integer.MAX_VALUE;
            int n6 = Integer.MIN_VALUE;
            List<Location> list3 = DebuggerUtilsEx.allLineLocations(referenceType);
            if (list3 != null) {
                for (Location set : list3) {
                    Method method;
                    int n7 = DebuggerUtilsEx.getLineNumber(set, false);
                    if (n7 <= 1 || (method = DebuggerUtilsEx.getMethod(set)) == null || DebuggerUtils.isSynthetic((TypeComponent)method) || method.isBridge()) continue;
                    int n8 = n7 - 1;
                    PsiFile psiFile = sourcePosition.getFile().getOriginalFile();
                    if (psiFile instanceof PsiCompiledFile && (n8 = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n8)) < 0) continue;
                    n5 = Math.min(n5, n8);
                    n6 = Math.max(n6, n8);
                }
            }
            if ((n4 = sourcePosition.getLine()) >= n5 && n4 <= n6) {
                if (!psiClass.isValid()) {
                    return null;
                }
                Set<PsiClass> set = PositionManagerImpl.b(sourcePosition.getFile(), n6);
                if (set.size() > 1) {
                    for (PsiClass psiClass2 : set) {
                        if (!psiClass.equals(psiClass2)) continue;
                        return referenceType;
                    }
                } else if (!set.isEmpty()) {
                    return psiClass.equals(set.iterator().next()) ? referenceType : null;
                }
                return null;
            }
        }
        return null;
    }

    @Nullable
    public PsiMethod findMethod(PsiElement psiElement, String string, String string2, String string3) {
        MethodFinder methodFinder = new MethodFinder(string, string2, string3);
        psiElement.accept((PsiElementVisitor)methodFinder);
        return methodFinder.getCompiledMethod();
    }

    @Nullable
    private static SourcePosition c(PsiFile psiFile, int n2) {
        int n3 = DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n2);
        if (n3 > -1) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)n3);
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/PositionManagerImpl";
                break;
            }
            case 4: 
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/PositionManagerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "locationsOfLine";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "locationsOfLine";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequest";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getClassReferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassReferences$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllClasses$4";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$3";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createPrepareRequests$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClsSourcePosition
    extends RemappedSourcePosition {
        private final int c;

        public ClsSourcePosition(SourcePosition sourcePosition, int n2) {
            super(sourcePosition);
            this.c = n2;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition sourcePosition) {
            PsiFile psiFile = this.getFile();
            if (this.c < 0 || !psiFile.isValid()) {
                return sourcePosition;
            }
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            SourcePosition sourcePosition2 = PositionManagerImpl.c(psiFile, this.c);
            return sourcePosition2 != null ? sourcePosition2 : sourcePosition;
        }
    }

    private class MethodFinder
    extends JavaRecursiveElementVisitor {
        private final String d;
        private PsiClass e;
        private final String b;
        private final String a;
        private PsiMethod c;

        public MethodFinder(String string, String string2, String string3) {
            this.d = string;
            this.b = string2;
            this.a = string3;
        }

        public void visitClass(PsiClass psiClass) {
            if (this.c == null) {
                if (PositionManagerImpl.this.a(psiClass, SourcePosition.createFromElement((PsiElement)psiClass)).anyMatch(referenceType -> referenceType.name().equals(this.d))) {
                    this.e = psiClass;
                }
                psiClass.acceptChildren((PsiElementVisitor)this);
            }
        }

        public void visitMethod(PsiMethod psiMethod) {
            if (this.c == null) {
                try {
                    String string = JVMNameUtil.getJVMMethodName(psiMethod);
                    PsiClass psiClass = psiMethod.getContainingClass();
                    if (psiClass != null && psiClass.equals(this.e) && string.equals(this.b) && JVMNameUtil.getJVMSignature(psiMethod).getName(PositionManagerImpl.this.a).equals(this.a)) {
                        this.c = psiMethod;
                    }
                }
                catch (EvaluateException evaluateException) {
                    b.debug((Throwable)evaluateException);
                }
            }
        }

        public void visitElement(PsiElement psiElement) {
            if (this.c == null) {
                super.visitElement(psiElement);
            }
        }

        @Nullable
        public PsiMethod getCompiledMethod() {
            return this.c;
        }
    }

    public static class JavaSourcePosition
    extends RemappedSourcePosition {
        private final String e;
        private final String d;
        private final int c;

        public JavaSourcePosition(@NotNull SourcePosition sourcePosition, ReferenceType referenceType, Method method, int n2) {
            if (sourcePosition == null) {
                JavaSourcePosition.b(0);
            }
            super(sourcePosition);
            this.e = referenceType != null ? referenceType.name() : null;
            this.d = method != null ? method.name() : null;
            this.c = n2;
        }

        public JavaSourcePosition(@NotNull SourcePosition sourcePosition, int n2) {
            if (sourcePosition == null) {
                JavaSourcePosition.b(1);
            }
            super(sourcePosition);
            assert (n2 > -1);
            this.e = null;
            this.d = "lambda$";
            this.c = n2;
        }

        private PsiElement a(PsiElement psiElement) {
            String string = JVMNameUtil.getClassVMName(PositionManagerImpl.a(psiElement));
            if (string != null && !string.equals(this.e)) {
                return null;
            }
            PsiElement psiElement2 = DebuggerUtilsEx.getContainingMethod(psiElement);
            if (!StringUtil.isEmpty((String)this.d)) {
                if (psiElement2 == null) {
                    return null;
                }
                if ((psiElement2 instanceof PsiMethod && this.d.equals(((PsiMethod)psiElement2).getName()) || psiElement2 instanceof PsiLambdaExpression && DebuggerUtilsEx.isLambdaName(this.d)) && JavaSourcePosition.a(psiElement, DebuggerUtilsEx.getBody(psiElement2))) {
                    return psiElement;
                }
            }
            return null;
        }

        private static boolean a(@NotNull PsiElement psiElement, @Nullable PsiElement psiElement2) {
            if (psiElement == null) {
                JavaSourcePosition.b(2);
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement2, (PsiElement)psiElement, (boolean)false)) {
                return false;
            }
            if (psiElement2 instanceof PsiCodeBlock) {
                return !psiElement.equals(((PsiCodeBlock)psiElement2).getRBrace()) && !psiElement.equals(((PsiCodeBlock)psiElement2).getLBrace());
            }
            return true;
        }

        @Override
        public SourcePosition mapDelegate(SourcePosition sourcePosition) {
            return (SourcePosition)ReadAction.compute(() -> {
                PsiFile psiFile = sourcePosition.getFile();
                int n2 = sourcePosition.getLine();
                if (DebuggerUtilsEx.isLambdaName(this.d) && this.c > -1) {
                    PsiElement psiElement;
                    List<PsiLambdaExpression> list2 = DebuggerUtilsEx.collectLambdas(sourcePosition, true);
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
                    if (document == null || n2 >= document.getLineCount()) {
                        return sourcePosition;
                    }
                    if (this.c < list2.size() && (psiElement = DebuggerUtilsEx.getFirstElementOnTheLine(list2.get(this.c), document, n2)) != null) {
                        return SourcePosition.createFromElement((PsiElement)psiElement);
                    }
                } else {
                    for (PsiElement psiElement : PositionManagerImpl.a(psiFile, n2)) {
                        PsiElement psiElement2 = this.a(psiElement);
                        if (psiElement2 == null) continue;
                        if (psiElement2.getTextOffset() <= sourcePosition.getOffset()) break;
                        return SourcePosition.createFromElement((PsiElement)psiElement2);
                    }
                }
                return sourcePosition;
            });
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/engine/PositionManagerImpl$JavaSourcePosition";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insideBody";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

