/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.ExtraSteppingFilter;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VMDisconnectedException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestHint {
    public static final int STOP = 0;
    public static final int RESUME = -100;
    private static final Logger e = Logger.getInstance((String)"#com.intellij.debugger.engine.RequestHint");
    private final int b;
    private final int a;
    private final SourcePosition k;
    private final int h;
    private boolean c;
    @Nullable
    private final MethodFilter f;
    private boolean j;
    private boolean g;
    private boolean d;
    private boolean i;

    public RequestHint(ThreadReferenceProxyImpl threadReferenceProxyImpl, SuspendContextImpl suspendContextImpl, @NotNull MethodFilter methodFilter) {
        if (methodFilter == null) {
            RequestHint.a(0);
        }
        this(threadReferenceProxyImpl, suspendContextImpl, -2, 1, methodFilter);
    }

    public RequestHint(ThreadReferenceProxyImpl threadReferenceProxyImpl, SuspendContextImpl suspendContextImpl, int n2) {
        this(threadReferenceProxyImpl, suspendContextImpl, -2, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestHint(final ThreadReferenceProxyImpl threadReferenceProxyImpl, final SuspendContextImpl suspendContextImpl, int n2, int n3, @Nullable MethodFilter methodFilter) {
        this.c = false;
        this.j = false;
        this.g = false;
        this.d = false;
        this.i = false;
        this.b = n2;
        this.a = n3;
        this.f = methodFilter;
        int n4 = 0;
        SourcePosition sourcePosition = null;
        try {
            n4 = threadReferenceProxyImpl.frameCount();
            sourcePosition = ContextUtil.getSourcePosition(new StackFrameContext(){

                public StackFrameProxy getFrameProxy() {
                    try {
                        return threadReferenceProxyImpl.frame(0);
                    }
                    catch (EvaluateException evaluateException) {
                        e.debug((Throwable)evaluateException);
                        return null;
                    }
                }

                @NotNull
                public DebugProcess getDebugProcess() {
                    DebugProcessImpl debugProcessImpl = suspendContextImpl.getDebugProcess();
                    if (debugProcessImpl == null) {
                        1.a(0);
                    }
                    return debugProcessImpl;
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/RequestHint$1", "getDebugProcess"));
                }
            });
        }
        catch (Exception exception) {
            e.info((Throwable)exception);
        }
        finally {
            this.h = n4;
            this.k = sourcePosition;
        }
    }

    public void setIgnoreFilters(boolean bl2) {
        this.g = bl2;
    }

    public void setResetIgnoreFilters(boolean bl2) {
        this.d = bl2;
    }

    public boolean isResetIgnoreFilters() {
        return this.d;
    }

    public void setRestoreBreakpoints(boolean bl2) {
        this.i = bl2;
    }

    public boolean isRestoreBreakpoints() {
        return this.i;
    }

    public boolean isIgnoreFilters() {
        return this.g;
    }

    public int getSize() {
        return this.b;
    }

    public int getDepth() {
        return this.a;
    }

    @Nullable
    public MethodFilter getMethodFilter() {
        return this.f;
    }

    public boolean wasStepTargetMethodMatched() {
        return this.f instanceof BreakpointStepMethodFilter || this.j;
    }

    protected boolean isTheSameFrame(SuspendContextImpl suspendContextImpl) {
        if (this.c) {
            return false;
        }
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        if (threadReferenceProxyImpl != null) {
            try {
                int n2 = threadReferenceProxyImpl.frameCount();
                if (n2 < this.h) {
                    this.c = true;
                }
                return n2 == this.h;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean a(SourcePosition sourcePosition) {
        if (this.f == null) {
            return this.k.getLine() == sourcePosition.getLine();
        }
        Range<Integer> range = this.f.getCallingExpressionLines();
        return range != null && range.isWithin((Comparable)Integer.valueOf(sourcePosition.getLine()));
    }

    protected boolean isSteppedOut() {
        return this.c;
    }

    public int getNextStepDepth(SuspendContextImpl suspendContextImpl) {
        try {
            Comparable<Location> comparable;
            DebuggerSettings debuggerSettings;
            StackFrameProxyImpl stackFrameProxyImpl = suspendContextImpl.getFrameProxy();
            if (this.f != null && stackFrameProxyImpl != null && !(this.f instanceof BreakpointStepMethodFilter)) {
                if (this.f.locationMatches(suspendContextImpl.getDebugProcess(), stackFrameProxyImpl.location(), stackFrameProxyImpl::thisObject) && !this.isTheSameFrame(suspendContextImpl)) {
                    this.j = true;
                    return this.f.onReached(suspendContextImpl, this);
                }
            }
            if ((this.a == 2 || this.a == 1) && this.k != null && (debuggerSettings = ContextUtil.getSourcePosition((StackFrameContext)suspendContextImpl)) != null && (comparable = (Integer)ReadAction.compute(() -> this.a((SourcePosition)debuggerSettings, suspendContextImpl))) != null) {
                return (Integer)comparable;
            }
            debuggerSettings = DebuggerSettings.getInstance();
            if ((this.f != null || debuggerSettings.SKIP_SYNTHETIC_METHODS && !this.g) && stackFrameProxyImpl != null && (comparable = stackFrameProxyImpl.location()) != null && DebuggerUtils.isSynthetic((TypeComponent)comparable.method())) {
                return this.a;
            }
            if (!this.g) {
                boolean bl2;
                if (debuggerSettings.SKIP_GETTERS && (bl2 = ((Boolean)ReadAction.compute(() -> {
                    PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)suspendContextImpl);
                    return psiElement != null && DebuggerUtils.isInsideSimpleGetter((PsiElement)psiElement);
                })).booleanValue())) {
                    return 3;
                }
                if (stackFrameProxyImpl != null) {
                    Location location;
                    Method method;
                    Location location2;
                    if (debuggerSettings.SKIP_CONSTRUCTORS && (location2 = stackFrameProxyImpl.location()) != null && (method = location2.method()) != null && method.isConstructor()) {
                        return 3;
                    }
                    if (debuggerSettings.SKIP_CLASSLOADERS && (location = stackFrameProxyImpl.location()) != null && DebuggerUtilsEx.isAssignableFrom("java.lang.ClassLoader", location.declaringType())) {
                        return 3;
                    }
                }
                for (ExtraSteppingFilter extraSteppingFilter : (ExtraSteppingFilter[])ExtraSteppingFilter.EP_NAME.getExtensions()) {
                    try {
                        if (extraSteppingFilter.isApplicable(suspendContextImpl)) {
                            return extraSteppingFilter.getStepRequestDepth(suspendContextImpl);
                        }
                    }
                    catch (AssertionError | Exception object) {
                        e.error((Throwable)object);
                    }
                }
            }
            if (this.f != null && !this.c) {
                return 3;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (EvaluateException evaluateException) {
            e.error((Throwable)evaluateException);
        }
        return 0;
    }

    private /* synthetic */ Integer a(SourcePosition sourcePosition, SuspendContextImpl suspendContextImpl) throws RuntimeException {
        if (this.k.getFile().equals(sourcePosition.getFile()) && this.isTheSameFrame(suspendContextImpl) && !this.c) {
            return this.a(sourcePosition) ? this.a : 0;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodFilter", "com/intellij/debugger/engine/RequestHint", "<init>"));
    }
}

