/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuspendContextImpl
extends XSuspendContext
implements SuspendContext {
    private static final Logger k = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendContextImpl");
    private final DebugProcessImpl e;
    private final int j;
    private ThreadReferenceProxyImpl c;
    boolean myIsVotedForResume;
    protected int myVotesToVote;
    protected Set<ThreadReferenceProxyImpl> myResumedThreads;
    private final EventSet f;
    private volatile boolean l;
    private final ConcurrentLinkedQueue<SuspendContextCommandImpl> b;
    public volatile boolean myInProgress;
    private final HashSet<ObjectReference> h;
    private EvaluationContextImpl d;
    private JavaExecutionStack g;
    private static final Comparator<JavaExecutionStack> a = Comparator.comparing(XExecutionStack::getDisplayName, String.CASE_INSENSITIVE_ORDER);
    private static final Comparator<ThreadReferenceProxyImpl> m = Comparator.comparing(ThreadReferenceProxyImpl::isSuspended).reversed();
    private static final Comparator<JavaExecutionStack> i = Comparator.comparing(JavaExecutionStack::getThreadProxy, m).thenComparing(a);

    SuspendContextImpl(@NotNull DebugProcessImpl debugProcessImpl, int n2, int n3, EventSet eventSet) {
        if (debugProcessImpl == null) {
            SuspendContextImpl.a(0);
        }
        this.myIsVotedForResume = true;
        this.b = new ConcurrentLinkedQueue();
        this.h = new HashSet();
        this.d = null;
        this.e = debugProcessImpl;
        this.j = n2;
        this.myVotesToVote = n3;
        this.f = eventSet;
    }

    public void setThread(ThreadReference threadReference) {
        this.a();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.e.getVirtualMachineProxy().getThreadReferenceProxy(threadReference);
        k.assertTrue(this.c == null || this.c == threadReferenceProxyImpl);
        this.c = threadReferenceProxyImpl;
    }

    protected abstract void resumeImpl();

    protected void resume() {
        this.a();
        if (this.isEvaluating()) {
            k.error("Resuming context while evaluating", new String[]{ThreadDumper.dumpThreadsToString()});
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                this.h.forEach(DebuggerUtilsEx::enableCollection);
                this.h.clear();
            }
            SuspendContextCommandImpl suspendContextCommandImpl = this.pollPostponedCommand();
            while (suspendContextCommandImpl != null) {
                suspendContextCommandImpl.notifyCancelled();
                suspendContextCommandImpl = this.pollPostponedCommand();
            }
            this.resumeImpl();
        }
        finally {
            this.l = true;
        }
    }

    private void a() {
        if (this.l && this.e.isAttached()) {
            k.error("Cannot access SuspendContext. SuspendContext is resumed.");
        }
    }

    @Nullable
    public EventSet getEventSet() {
        return this.f;
    }

    @NotNull
    public DebugProcessImpl getDebugProcess() {
        DebugProcessImpl debugProcessImpl = this.e;
        if (debugProcessImpl == null) {
            SuspendContextImpl.a(1);
        }
        return debugProcessImpl;
    }

    public StackFrameProxyImpl getFrameProxy() {
        this.a();
        try {
            return this.c != null && this.c.frameCount() > 0 ? this.c.frame(0) : null;
        }
        catch (EvaluateException evaluateException) {
            return null;
        }
    }

    @Nullable
    public ThreadReferenceProxyImpl getThread() {
        return this.c;
    }

    public int getSuspendPolicy() {
        return this.j;
    }

    public void doNotResumeHack() {
        this.a();
        this.myVotesToVote = 1000000000;
    }

    public boolean isExplicitlyResumed(@Nullable ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return this.myResumedThreads != null && this.myResumedThreads.contains(threadReferenceProxyImpl);
    }

    public boolean suspends(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        this.a();
        if (this.isEvaluating()) {
            return false;
        }
        switch (this.getSuspendPolicy()) {
            case 2: {
                return !this.isExplicitlyResumed(threadReferenceProxyImpl);
            }
            case 1: {
                return threadReferenceProxyImpl == this.getThread();
            }
        }
        return false;
    }

    public boolean isEvaluating() {
        this.a();
        return this.d != null;
    }

    public EvaluationContextImpl getEvaluationContext() {
        return this.d;
    }

    public boolean isResumed() {
        return this.l;
    }

    public void setIsEvaluating(EvaluationContextImpl evaluationContextImpl) {
        this.a();
        this.d = evaluationContextImpl;
    }

    public String toString() {
        if (this.f != null) {
            return this.f.toString();
        }
        return this.c != null ? this.c.toString() : DebuggerBundle.message((String)"string.null.context", (Object[])new Object[0]);
    }

    public void keep(ObjectReference objectReference) {
        boolean bl2;
        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG && (bl2 = this.h.add(objectReference))) {
            DebuggerUtilsEx.disableCollection(objectReference);
        }
    }

    public final void postponeCommand(SuspendContextCommandImpl suspendContextCommandImpl) {
        if (!this.isResumed()) {
            suspendContextCommandImpl.hold();
            this.b.add(suspendContextCommandImpl);
        } else {
            suspendContextCommandImpl.notifyCancelled();
        }
    }

    public final SuspendContextCommandImpl pollPostponedCommand() {
        return this.b.poll();
    }

    @Nullable
    public JavaExecutionStack getActiveExecutionStack() {
        return this.g;
    }

    public void initExecutionStacks(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.c == null) {
            this.c = threadReferenceProxyImpl;
        }
        if (threadReferenceProxyImpl != null) {
            this.g = new JavaExecutionStack(threadReferenceProxyImpl, this.e, this.c == threadReferenceProxyImpl);
            this.g.initTopFrame();
        }
    }

    public void computeExecutionStacks(final XSuspendContext.XExecutionStackContainer xExecutionStackContainer) {
        this.e.getManagerThread().schedule(new SuspendContextCommandImpl(this){
            final Set<ThreadReferenceProxyImpl> myAddedThreads;
            {
                super(suspendContextImpl2);
                this.myAddedThreads = new HashSet<ThreadReferenceProxyImpl>();
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                if (!this.addThreads(Collections.singletonList(SuspendContextImpl.this.c), null, false)) {
                    return;
                }
                List list2 = StreamEx.of(((SuspendManagerImpl)SuspendContextImpl.this.e.getSuspendManager()).getPausedContexts()).map(SuspendContextImpl::getThread).nonNull().toList();
                if (!this.addThreads(list2, a, false)) {
                    return;
                }
                this.addThreads(SuspendContextImpl.this.getDebugProcess().getVirtualMachineProxy().allThreads(), i, true);
            }

            boolean addThreads(Collection<ThreadReferenceProxyImpl> collection, @Nullable Comparator<JavaExecutionStack> comparator, boolean bl2) {
                ArrayList<JavaExecutionStack> arrayList = new ArrayList<JavaExecutionStack>();
                for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                    if (xExecutionStackContainer.isObsolete()) {
                        return false;
                    }
                    if (threadReferenceProxyImpl == null || !this.myAddedThreads.add(threadReferenceProxyImpl)) continue;
                    arrayList.add(new JavaExecutionStack(threadReferenceProxyImpl, SuspendContextImpl.this.e, threadReferenceProxyImpl == SuspendContextImpl.this.c));
                }
                if (arrayList.size() > 1 && comparator != null) {
                    arrayList.sort(comparator);
                }
                xExecutionStackContainer.addExecutionStack(arrayList, bl2);
                return true;
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/SuspendContextImpl$1", "contextAction"));
            }
        });
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/engine/SuspendContextImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

