/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.jetbrains.annotations.NotNull;

public class SuspendManagerImpl
implements SuspendManager {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.SuspendManager");
    private final Deque<SuspendContextImpl> c;
    private final Deque<SuspendContextImpl> b;
    private final Set<ThreadReferenceProxyImpl> d;
    private final DebugProcessImpl e;
    public int suspends;

    public SuspendManagerImpl(@NotNull DebugProcessImpl debugProcessImpl) {
        if (debugProcessImpl == null) {
            SuspendManagerImpl.a(0);
        }
        this.c = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.b = new ConcurrentLinkedDeque<SuspendContextImpl>();
        this.d = Collections.synchronizedSet(new HashSet());
        this.suspends = 0;
        this.e = debugProcessImpl;
        this.e.addDebugProcessListener(new DebugProcessAdapterImpl(){

            @Override
            public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
                SuspendManagerImpl.this.c.clear();
                SuspendManagerImpl.this.b.clear();
                SuspendManagerImpl.this.d.clear();
            }
        });
    }

    @Override
    public SuspendContextImpl pushSuspendContext(int n2, int n3) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.e, n2, n3, null){

            @Override
            protected void resumeImpl() {
                a.debug("Start resuming...");
                SuspendManagerImpl.this.e.logThreads();
                switch (this.getSuspendPolicy()) {
                    case 2: {
                        int n2 = 5;
                        while (--n2 > 0) {
                            try {
                                SuspendManagerImpl.this.e.getVirtualMachineProxy().resume();
                            }
                            catch (InternalException internalException) {
                                if (internalException.errorCode() == 13) continue;
                                a.error((Throwable)internalException);
                            }
                            break;
                        }
                        a.debug("VM resumed ");
                        break;
                    }
                    case 1: {
                        SuspendManagerImpl.this.d.remove(this.getThread());
                        this.getThread().resume();
                        if (!a.isDebugEnabled()) break;
                        a.debug("Thread resumed : " + this.getThread().toString());
                        break;
                    }
                    case 0: {
                        a.debug("None resumed");
                    }
                }
                if (a.isDebugEnabled()) {
                    a.debug("Suspends = " + SuspendManagerImpl.this.suspends);
                }
                SuspendManagerImpl.this.e.logThreads();
            }
        };
        this.a(suspendContextImpl);
        return suspendContextImpl;
    }

    @Override
    public SuspendContextImpl pushSuspendContext(final EventSet eventSet) {
        SuspendContextImpl suspendContextImpl = new SuspendContextImpl(this.e, eventSet.suspendPolicy(), eventSet.size(), eventSet){

            @Override
            protected void resumeImpl() {
                if (a.isDebugEnabled()) {
                    a.debug("Start resuming eventSet " + eventSet.toString() + " suspendPolicy = " + eventSet.suspendPolicy() + ",size = " + eventSet.size());
                }
                SuspendManagerImpl.this.e.logThreads();
                int n2 = 5;
                while (--n2 > 0) {
                    try {
                        eventSet.resume();
                        break;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        a.info((Throwable)objectCollectedException);
                    }
                    catch (InternalException internalException) {
                        if (internalException.errorCode() == 13 && eventSet.suspendPolicy() == 2) continue;
                        a.error((Throwable)internalException);
                        break;
                    }
                }
                a.debug("Set resumed ");
                SuspendManagerImpl.this.e.logThreads();
            }
        };
        this.a(suspendContextImpl);
        return suspendContextImpl;
    }

    private void a(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.c.addFirst(suspendContextImpl);
        ++this.suspends;
        if (a.isDebugEnabled()) {
            a.debug("Push context : Suspends = " + this.suspends);
        }
    }

    @Override
    public void resume(SuspendContextImpl suspendContextImpl) {
        SuspendManagerUtil.prepareForResume(suspendContextImpl);
        this.e.logThreads();
        this.popContext(suspendContextImpl);
        suspendContextImpl.resume();
        this.e.clearCashes(suspendContextImpl.getSuspendPolicy());
    }

    @Override
    public void popFrame(SuspendContextImpl suspendContextImpl) {
        this.popContext(suspendContextImpl);
        SuspendContextImpl suspendContextImpl2 = this.pushSuspendContext(suspendContextImpl.getSuspendPolicy(), 0);
        suspendContextImpl2.setThread(suspendContextImpl.getThread().getThreadReference());
        this.notifyPaused(suspendContextImpl2);
    }

    @Override
    public SuspendContextImpl getPausedContext() {
        return this.b.peekFirst();
    }

    public void popContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        --this.suspends;
        if (a.isDebugEnabled()) {
            a.debug("popContext, suspends = " + this.suspends);
        }
        this.c.remove((Object)suspendContextImpl);
        this.b.remove((Object)suspendContextImpl);
    }

    void pushPausedContext(SuspendContextImpl suspendContextImpl) {
        if (a.isDebugEnabled()) {
            a.assertTrue(this.c.contains((Object)suspendContextImpl));
        }
        this.b.addFirst(suspendContextImpl);
    }

    public boolean hasEventContext(SuspendContextImpl suspendContextImpl) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.c.contains((Object)suspendContextImpl);
    }

    @Override
    public List<SuspendContextImpl> getEventContexts() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new ArrayList<SuspendContextImpl>(this.c);
    }

    @Override
    public boolean isFrozen(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return this.d.contains(threadReferenceProxyImpl);
    }

    @Override
    public boolean isSuspended(ThreadReferenceProxyImpl threadReferenceProxyImpl) throws ObjectCollectedException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        boolean bl2 = this.isFrozen(threadReferenceProxyImpl) ? true : this.c.stream().anyMatch(suspendContextImpl -> suspendContextImpl.suspends(threadReferenceProxyImpl));
        return bl2 && (threadReferenceProxyImpl == null || threadReferenceProxyImpl.isSuspended());
    }

    @Override
    public void suspendThread(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        a.assertTrue(threadReferenceProxyImpl != suspendContextImpl.getThread(), (Object)"Thread is already suspended at the breakpoint");
        if (suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl)) {
            suspendContextImpl.myResumedThreads.remove(threadReferenceProxyImpl);
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void resumeThread(SuspendContextImpl suspendContextImpl, @NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (threadReferenceProxyImpl == null) {
            SuspendManagerImpl.a(1);
        }
        a.assertTrue(!suspendContextImpl.isExplicitlyResumed(threadReferenceProxyImpl));
        if (suspendContextImpl.myResumedThreads == null) {
            suspendContextImpl.myResumedThreads = new HashSet<ThreadReferenceProxyImpl>();
        }
        suspendContextImpl.myResumedThreads.add(threadReferenceProxyImpl);
        threadReferenceProxyImpl.resume();
    }

    @Override
    public void freezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.d.add(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.suspend();
        }
    }

    @Override
    public void unfreezeThread(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        if (this.d.remove(threadReferenceProxyImpl)) {
            threadReferenceProxyImpl.resume();
        }
    }

    private void b(final SuspendContextImpl suspendContextImpl) {
        a.assertTrue(suspendContextImpl.myVotesToVote > 0);
        --suspendContextImpl.myVotesToVote;
        if (a.isDebugEnabled()) {
            a.debug("myVotesToVote = " + suspendContextImpl.myVotesToVote);
        }
        if (suspendContextImpl.myVotesToVote == 0) {
            if (suspendContextImpl.myIsVotedForResume) {
                this.e.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        SuspendManagerImpl.this.resume(suspendContextImpl);
                    }

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }
                });
            } else {
                a.debug("vote paused");
                this.e.logThreads();
                this.e.cancelRunToCursorBreakpoint();
                if (!Registry.is((String)"debugger.keep.step.requests")) {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                    this.e.deleteStepRequests(threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null);
                }
                this.notifyPaused(suspendContextImpl);
            }
        }
    }

    public void notifyPaused(SuspendContextImpl suspendContextImpl) {
        this.pushPausedContext(suspendContextImpl);
        ((DebugProcessListener)this.e.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
    }

    @Override
    public void voteResume(SuspendContextImpl suspendContextImpl) {
        a.debug("Resume voted");
        this.b(suspendContextImpl);
    }

    @Override
    public void voteSuspend(SuspendContextImpl suspendContextImpl) {
        suspendContextImpl.myIsVotedForResume = false;
        this.b(suspendContextImpl);
    }

    public List<SuspendContextImpl> getPausedContexts() {
        return new ArrayList<SuspendContextImpl>(this.b);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/engine/SuspendManagerImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resumeThread";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

