/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.util.Collections;

public class BoxingEvaluator
implements Evaluator {
    private final Evaluator a;

    public BoxingEvaluator(Evaluator evaluator) {
        this.a = DisableGC.create(evaluator);
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        PrimitiveValue primitiveValue;
        PsiPrimitiveType psiPrimitiveType;
        Object object = this.a.evaluate(evaluationContextImpl);
        if (object == null || object instanceof ObjectReference) {
            return object;
        }
        if (object instanceof PrimitiveValue && (psiPrimitiveType = PsiJavaParserFacadeImpl.getPrimitiveType((String)(primitiveValue = (PrimitiveValue)object).type().name())) != null) {
            return BoxingEvaluator.a(evaluationContextImpl, primitiveValue, psiPrimitiveType.getBoxedTypeName());
        }
        throw new EvaluateException("Cannot perform boxing conversion for a value of type " + ((Value)object).type().name());
    }

    private static Value a(EvaluationContextImpl evaluationContextImpl, PrimitiveValue primitiveValue, String string) throws EvaluateException {
        String string2;
        DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
        ClassType classType = (ClassType)debugProcessImpl.findClass(evaluationContextImpl, string, null);
        Method method = classType.concreteMethodByName("valueOf", string2 = "(" + JVMNameUtil.getPrimitiveSignature(primitiveValue.type().name()) + ")L" + string.replace('.', '/') + ";");
        if (method == null) {
            method = classType.concreteMethodByName("<init>", string2);
        }
        if (method == null) {
            throw new EvaluateException("Cannot construct wrapper object for value of type " + primitiveValue.type() + ": Unable to find either valueOf() or constructor method");
        }
        return debugProcessImpl.invokeMethod((EvaluationContext)evaluationContextImpl, classType, method, Collections.singletonList(primitiveValue));
    }
}

