/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThrowEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TryEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl a = new EvaluatorBuilderImpl();

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return a;
    }

    public static ExpressionEvaluator build(TextWithImports textWithImports, @Nullable PsiElement psiElement, @Nullable SourcePosition sourcePosition, @NotNull Project project2) throws EvaluateException {
        CodeFragmentFactory codeFragmentFactory;
        JavaCodeFragment javaCodeFragment;
        if (project2 == null) {
            EvaluatorBuilderImpl.a(0);
        }
        if ((javaCodeFragment = (codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement)).createCodeFragment(textWithImports, psiElement, project2)) == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{textWithImports.getText()}));
        }
        DebuggerUtils.checkSyntax((PsiCodeFragment)javaCodeFragment);
        return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, sourcePosition);
    }

    public ExpressionEvaluator build(PsiElement psiElement, SourcePosition sourcePosition) throws EvaluateException {
        return new Builder(sourcePosition).buildElement(psiElement);
    }

    private static void a(PsiParameter[] psiParameterArray, PsiExpression[] psiExpressionArray, PsiSubstitutor psiSubstitutor, Evaluator[] evaluatorArray) {
        if (psiParameterArray.length > 0) {
            int n2 = Math.max(psiParameterArray.length, psiExpressionArray.length);
            PsiType psiType = null;
            for (int i2 = 0; i2 < n2 && i2 < psiExpressionArray.length; ++i2) {
                PsiType psiType2;
                PsiType psiType3;
                if (i2 < psiParameterArray.length) {
                    psiType3 = psiSubstitutor.substitute(psiParameterArray[i2].getType());
                    if (psiType3 instanceof PsiEllipsisType) {
                        psiType3 = psiType = ((PsiEllipsisType)psiType3).getComponentType();
                    }
                } else {
                    if (psiType == null) break;
                    psiType3 = psiType;
                }
                if (!TypeConversionUtil.boxingConversionApplicable((PsiType)psiType3, (PsiType)(psiType2 = psiExpressionArray[i2].getType()))) continue;
                Evaluator evaluator = evaluatorArray[i2];
                evaluatorArray[i2] = psiType3 instanceof PsiPrimitiveType ? new UnBoxingEvaluator(evaluator) : new BoxingEvaluator(evaluator);
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl", "build"));
    }

    private static class Builder
    extends JavaElementVisitor {
        private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl");
        private Evaluator e = null;
        private PsiClass f;
        private CodeFragmentEvaluator d;
        private final Set<JavaCodeFragment> g = new HashSet<JavaCodeFragment>();
        @Nullable
        private final SourcePosition c;
        @Nullable
        private final PsiClass a;

        private Builder(@Nullable SourcePosition sourcePosition) {
            this.c = sourcePosition;
            this.a = JVMNameUtil.getClassAt(this.c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitCodeFragment(JavaCodeFragment javaCodeFragment) {
            this.g.add(javaCodeFragment);
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                for (PsiElement psiElement = javaCodeFragment.getFirstChild(); psiElement != null; psiElement = psiElement.getNextSibling()) {
                    psiElement.accept((PsiElementVisitor)this);
                    if (this.e != null) {
                        arrayList.add(this.e);
                    }
                    this.e = null;
                }
                this.d.setStatements(arrayList.toArray(new Evaluator[0]));
                this.e = this.d;
            }
            finally {
                this.d = codeFragmentEvaluator;
            }
        }

        public void visitErrorElement(PsiErrorElement psiErrorElement) {
            Builder.c((PsiElement)psiErrorElement);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression psiAssignmentExpression) {
            PsiExpression psiExpression = psiAssignmentExpression.getRExpression();
            if (psiExpression == null) {
                Builder.c((PsiElement)psiAssignmentExpression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiExpression psiExpression2 = psiAssignmentExpression.getLExpression();
            PsiType psiType = psiExpression2.getType();
            if (psiType == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression2.getText()}));
            }
            IElementType iElementType = psiAssignmentExpression.getOperationTokenType();
            PsiType psiType2 = psiExpression.getType();
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType, (PsiExpression)psiExpression) && psiType2 != null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{psiAssignmentExpression.getOperationSign().getText()}));
            }
            psiExpression2.accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.e;
            evaluator = Builder.a(psiType, psiType2, evaluator);
            if (iElementType != JavaTokenType.EQ) {
                IElementType iElementType2 = TypeConversionUtil.convertEQtoOperation((IElementType)iElementType);
                PsiType psiType3 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType, (PsiType)psiType2, (IElementType)iElementType2, (boolean)true);
                if (psiType3 == null || psiType2 == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiAssignmentExpression.getText()}));
                }
                evaluator = Builder.a(evaluator2, psiType, evaluator, psiType2, iElementType2, psiType3);
            }
            this.e = new AssignmentEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, PsiType psiType2, Evaluator evaluator) {
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            if (psiPrimitiveType != null) {
                if (psiType2 instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)psiType2)) {
                    if (!psiType2.equals(psiPrimitiveType)) {
                        evaluator = new TypeCastEvaluator(evaluator, psiPrimitiveType.getCanonicalText(), true);
                    }
                    evaluator = new BoxingEvaluator(evaluator);
                }
            } else if (psiType instanceof PsiPrimitiveType) {
                PsiPrimitiveType psiPrimitiveType2;
                PsiPrimitiveType psiPrimitiveType3;
                if (psiType2 instanceof PsiClassType) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
                Object object = psiPrimitiveType3 = (psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2)) != null ? psiPrimitiveType2 : psiType2;
                if (psiPrimitiveType3 instanceof PsiPrimitiveType && !PsiType.NULL.equals((Object)psiPrimitiveType3) && !psiType.equals(psiPrimitiveType3)) {
                    evaluator = new TypeCastEvaluator(evaluator, psiType.getCanonicalText(), true);
                }
            }
            return evaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitTryStatement(PsiTryStatement psiTryStatement) {
            if (psiTryStatement.getResourceList() != null) {
                throw new EvaluateRuntimeException(new UnsupportedExpressionException("Try with resources is not yet supported"));
            }
            Evaluator evaluator = this.b((PsiElement)psiTryStatement.getTryBlock());
            if (evaluator != null) {
                PsiCatchSection[] psiCatchSectionArray = psiTryStatement.getCatchSections();
                ArrayList<CatchEvaluator> arrayList = new ArrayList<CatchEvaluator>();
                for (PsiCatchSection psiCatchSection : psiCatchSectionArray) {
                    PsiParameter psiParameter = psiCatchSection.getParameter();
                    PsiCodeBlock psiCodeBlock = psiCatchSection.getCatchBlock();
                    if (psiParameter == null || psiCodeBlock == null) continue;
                    CodeFragmentEvaluator codeFragmentEvaluator = this.b();
                    try {
                        this.d.setInitialValue(psiParameter.getName(), null);
                        this.d.setStatements(this.a(psiCodeBlock.getStatements()));
                        PsiType psiType = psiParameter.getType();
                        List list2 = psiType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)psiType).getDisjunctions() : Collections.singletonList(psiType);
                        for (PsiType psiType2 : list2) {
                            arrayList.add(new CatchEvaluator(psiType2.getCanonicalText(), psiParameter.getName(), this.d));
                        }
                    }
                    finally {
                        this.d = codeFragmentEvaluator;
                    }
                }
                this.e = new TryEvaluator(evaluator, arrayList, this.b((PsiElement)psiTryStatement.getFinallyBlock()));
            }
        }

        public void visitThrowStatement(PsiThrowStatement psiThrowStatement) {
            Evaluator evaluator = this.b((PsiElement)psiThrowStatement.getException());
            if (evaluator != null) {
                this.e = new ThrowEvaluator(evaluator);
            }
        }

        public void visitReturnStatement(PsiReturnStatement psiReturnStatement) {
            this.e = new ReturnEvaluator(this.b((PsiElement)psiReturnStatement.getReturnValue()));
        }

        public void visitStatement(PsiStatement psiStatement) {
            Builder.a(DebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{psiStatement.getText()}));
        }

        private CodeFragmentEvaluator b() {
            CodeFragmentEvaluator codeFragmentEvaluator = this.d;
            this.d = new CodeFragmentEvaluator(this.d);
            return codeFragmentEvaluator;
        }

        private Evaluator[] a(PsiStatement[] psiStatementArray) {
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            for (PsiStatement psiStatement : psiStatementArray) {
                psiStatement.accept((PsiElementVisitor)this);
                if (this.e != null) {
                    arrayList.add(DisableGC.create(this.e));
                }
                this.e = null;
            }
            return arrayList.toArray(new Evaluator[0]);
        }

        public void visitCodeBlock(PsiCodeBlock psiCodeBlock) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                this.e = new BlockStatementEvaluator(this.a(psiCodeBlock.getStatements()));
            }
            finally {
                this.d = codeFragmentEvaluator;
            }
        }

        public void visitBlockStatement(PsiBlockStatement psiBlockStatement) {
            this.visitCodeBlock(psiBlockStatement.getCodeBlock());
        }

        public void visitLabeledStatement(PsiLabeledStatement psiLabeledStatement) {
            PsiStatement psiStatement = psiLabeledStatement.getStatement();
            if (psiStatement != null) {
                psiStatement.accept((PsiElementVisitor)this);
            }
        }

        private static String a(PsiElement psiElement) {
            String string = null;
            if (psiElement.getParent() instanceof PsiLabeledStatement) {
                string = ((PsiLabeledStatement)psiElement.getParent()).getName();
            }
            return string;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement psiDoWhileStatement) {
            Evaluator evaluator = this.b((PsiElement)psiDoWhileStatement.getBody());
            Evaluator evaluator2 = this.b((PsiElement)psiDoWhileStatement.getCondition());
            if (evaluator2 != null) {
                this.e = new DoWhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.a((PsiElement)psiDoWhileStatement));
            }
        }

        public void visitWhileStatement(PsiWhileStatement psiWhileStatement) {
            Evaluator evaluator = this.b((PsiElement)psiWhileStatement.getBody());
            Evaluator evaluator2 = this.b((PsiElement)psiWhileStatement.getCondition());
            if (evaluator2 != null) {
                this.e = new WhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.a((PsiElement)psiWhileStatement));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForStatement(PsiForStatement psiForStatement) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                Evaluator evaluator = this.b((PsiElement)psiForStatement.getInitialization());
                Evaluator evaluator2 = this.b((PsiElement)psiForStatement.getCondition());
                if (evaluator2 != null) {
                    evaluator2 = new UnBoxingEvaluator(evaluator2);
                }
                Evaluator evaluator3 = this.b((PsiElement)psiForStatement.getUpdate());
                Evaluator evaluator4 = this.b((PsiElement)psiForStatement.getBody());
                if (evaluator4 != null) {
                    this.e = new ForStatementEvaluator(evaluator, evaluator2, evaluator3, evaluator4, Builder.a((PsiElement)psiForStatement));
                }
            }
            finally {
                this.d = codeFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForeachStatement(PsiForeachStatement psiForeachStatement) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.b();
            try {
                String string = psiForeachStatement.getIterationParameter().getName();
                this.d.setInitialValue(string, null);
                SyntheticVariableEvaluator syntheticVariableEvaluator = new SyntheticVariableEvaluator(this.d, string);
                Evaluator evaluator = this.b((PsiElement)psiForeachStatement.getIteratedValue());
                Evaluator evaluator2 = this.b((PsiElement)psiForeachStatement.getBody());
                if (evaluator2 != null) {
                    this.e = new ForeachStatementEvaluator(syntheticVariableEvaluator, evaluator, evaluator2, Builder.a((PsiElement)psiForeachStatement));
                }
            }
            finally {
                this.d = codeFragmentEvaluator;
            }
        }

        @Nullable
        private Evaluator b(@Nullable PsiElement psiElement) {
            if (psiElement == null || psiElement instanceof PsiEmptyStatement) {
                return null;
            }
            psiElement.accept((PsiElementVisitor)this);
            return this.e;
        }

        public void visitIfStatement(PsiIfStatement psiIfStatement) {
            PsiExpression psiExpression;
            PsiStatement psiStatement = psiIfStatement.getThenBranch();
            if (psiStatement == null) {
                return;
            }
            psiStatement.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiStatement psiStatement2 = psiIfStatement.getElseBranch();
            Evaluator evaluator2 = null;
            if (psiStatement2 != null) {
                psiStatement2.accept((PsiElementVisitor)this);
                evaluator2 = this.e;
            }
            if ((psiExpression = psiIfStatement.getCondition()) == null) {
                return;
            }
            psiExpression.accept((PsiElementVisitor)this);
            this.e = new IfStatementEvaluator(new UnBoxingEvaluator(this.e), evaluator, evaluator2);
        }

        public void visitBreakStatement(PsiBreakStatement psiBreakStatement) {
            PsiIdentifier psiIdentifier = psiBreakStatement.getLabelIdentifier();
            this.e = BreakContinueStatementEvaluator.createBreakEvaluator(psiIdentifier != null ? psiIdentifier.getText() : null);
        }

        public void visitContinueStatement(PsiContinueStatement psiContinueStatement) {
            PsiIdentifier psiIdentifier = psiContinueStatement.getLabelIdentifier();
            this.e = BreakContinueStatementEvaluator.createContinueEvaluator(psiIdentifier != null ? psiIdentifier.getText() : null);
        }

        public void visitExpressionStatement(PsiExpressionStatement psiExpressionStatement) {
            psiExpressionStatement.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression psiExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitExpression " + psiExpression);
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression psiPolyadicExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitPolyadicExpression " + psiPolyadicExpression);
            }
            PsiExpression[] psiExpressionArray = psiPolyadicExpression.getOperands();
            psiExpressionArray[0].accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiType psiType = psiExpressionArray[0].getType();
            for (int i2 = 1; i2 < psiExpressionArray.length; ++i2) {
                PsiType psiType2;
                PsiExpression psiExpression = psiExpressionArray[i2];
                if (psiExpression == null) {
                    Builder.c((PsiElement)psiPolyadicExpression);
                }
                psiExpression.accept((PsiElementVisitor)this);
                Evaluator evaluator2 = this.e;
                IElementType iElementType = psiPolyadicExpression.getOperationTokenType();
                PsiType psiType3 = psiExpression.getType();
                if (psiType3 == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression.getText()}));
                }
                if ((psiType2 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType, (PsiType)psiType3, (IElementType)iElementType, (boolean)true)) == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPolyadicExpression.getText()}));
                }
                this.e = Builder.a(evaluator, psiType, evaluator2, psiType3, iElementType, psiType2);
                psiType = psiType2;
                evaluator = this.e;
            }
        }

        private static Evaluator a(Evaluator evaluator, PsiType psiType, Evaluator evaluator2, @NotNull PsiType psiType2, @NotNull IElementType iElementType, @NotNull PsiType psiType3) {
            if (psiType2 == null) {
                Builder.a(0);
            }
            if (iElementType == null) {
                Builder.a(1);
            }
            if (psiType3 == null) {
                Builder.a(2);
            }
            if (Builder.a(psiType, psiType2, iElementType)) {
                if (psiType2 instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(psiType2.getCanonicalText())) {
                    evaluator2 = new UnBoxingEvaluator(evaluator2);
                }
                if (psiType instanceof PsiClassType && UnBoxingEvaluator.isTypeUnboxable(psiType.getCanonicalText())) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
            }
            if (Builder.b(psiType, psiType2, iElementType)) {
                PsiType psiType4 = psiType;
                PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
                if (psiPrimitiveType != null) {
                    psiType4 = psiPrimitiveType;
                }
                PsiType psiType5 = psiType2;
                PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
                if (psiPrimitiveType2 != null) {
                    psiType5 = psiPrimitiveType2;
                }
                if (PsiType.DOUBLE.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.DOUBLE)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.DOUBLE.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.DOUBLE)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.DOUBLE.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.FLOAT)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.FLOAT.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.FLOAT)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.FLOAT.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)psiType4)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.LONG)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.LONG.getCanonicalText(), true);
                    }
                } else if (PsiType.LONG.equals((Object)psiType5)) {
                    if (TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.LONG)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.LONG.getCanonicalText(), true);
                    }
                } else {
                    if (!PsiType.INT.equals((Object)psiType4) && TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.INT)) {
                        evaluator = new TypeCastEvaluator(evaluator, PsiType.INT.getCanonicalText(), true);
                    }
                    if (!PsiType.INT.equals((Object)psiType5) && TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.INT)) {
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.INT.getCanonicalText(), true);
                    }
                }
            } else if (iElementType == JavaTokenType.GTGT || iElementType == JavaTokenType.LTLT || iElementType == JavaTokenType.GTGTGT) {
                evaluator = Builder.a(psiType, evaluator);
                evaluator2 = Builder.a(psiType2, evaluator2);
            }
            return DisableGC.create(new BinaryExpressionEvaluator(evaluator, evaluator2, iElementType, psiType3.getCanonicalText()));
        }

        private static boolean b(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            if (psiType == null || psiType2 == null) {
                return false;
            }
            if (!TypeConversionUtil.isNumericType((PsiType)psiType) || !TypeConversionUtil.isNumericType((PsiType)psiType2)) {
                return false;
            }
            if (iElementType == JavaTokenType.EQEQ || iElementType == JavaTokenType.NE) {
                if (PsiType.NULL.equals((Object)psiType) || PsiType.NULL.equals((Object)psiType2)) {
                    return false;
                }
                if (psiType instanceof PsiClassType && psiType2 instanceof PsiClassType) {
                    return false;
                }
                if (psiType instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)psiType) != null;
                }
                if (psiType2 instanceof PsiClassType) {
                    return PsiPrimitiveType.getUnboxedType((PsiType)psiType2) != null;
                }
                return true;
            }
            return iElementType == JavaTokenType.ASTERISK || iElementType == JavaTokenType.DIV || iElementType == JavaTokenType.PERC || iElementType == JavaTokenType.PLUS || iElementType == JavaTokenType.MINUS || iElementType == JavaTokenType.LT || iElementType == JavaTokenType.LE || iElementType == JavaTokenType.GT || iElementType == JavaTokenType.GE || iElementType == JavaTokenType.AND || iElementType == JavaTokenType.XOR || iElementType == JavaTokenType.OR;
        }

        private static boolean a(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            if (PsiType.NULL.equals((Object)psiType) || PsiType.NULL.equals((Object)psiType2)) {
                return false;
            }
            if (iElementType == JavaTokenType.EQEQ || iElementType == JavaTokenType.NE) {
                return psiType instanceof PsiPrimitiveType && psiType2 instanceof PsiClassType || psiType instanceof PsiClassType && psiType2 instanceof PsiPrimitiveType;
            }
            if (iElementType == JavaTokenType.PLUS && (psiType instanceof PsiClassType && psiType.equalsToText("java.lang.String") || psiType2 instanceof PsiClassType && psiType2.equalsToText("java.lang.String"))) {
                return false;
            }
            return psiType instanceof PsiClassType || psiType2 instanceof PsiClassType;
        }

        @Nullable
        private static PsiType a(PsiPrimitiveType psiPrimitiveType) {
            if (PsiType.BYTE.equals((Object)psiPrimitiveType) || PsiType.SHORT.equals((Object)psiPrimitiveType) || PsiType.CHAR.equals((Object)psiPrimitiveType) || PsiType.INT.equals((Object)psiPrimitiveType)) {
                return PsiType.INT;
            }
            return null;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
            ArrayList<AssignmentEvaluator> arrayList = new ArrayList<AssignmentEvaluator>();
            PsiElement[] psiElementArray = psiDeclarationStatement.getDeclaredElements();
            for (PsiElement psiElement : psiElementArray) {
                if (psiElement instanceof PsiLocalVariable) {
                    if (this.d != null) {
                        Object object;
                        PsiExpression psiExpression;
                        PsiLocalVariable psiLocalVariable = (PsiLocalVariable)psiElement;
                        PsiType psiType = psiLocalVariable.getType();
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiLocalVariable.getProject()).getElementFactory();
                        try {
                            psiExpression = psiElementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)psiType), null);
                            object = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)psiExpression, (boolean)true);
                            this.d.setInitialValue(psiLocalVariable.getName(), object);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            b.error((Throwable)incorrectOperationException);
                        }
                        psiExpression = psiLocalVariable.getInitializer();
                        if (psiExpression == null) continue;
                        try {
                            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType, (PsiExpression)psiExpression)) {
                                Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{psiLocalVariable.getName()}));
                            }
                            object = psiExpression.getType();
                            psiExpression.accept((PsiElementVisitor)this);
                            Evaluator evaluator = this.e;
                            PsiExpression psiExpression2 = psiElementFactory.createExpressionFromText(psiLocalVariable.getName(), (PsiElement)psiExpression);
                            psiExpression2.accept((PsiElementVisitor)this);
                            Evaluator evaluator2 = this.e;
                            evaluator = Builder.a(psiExpression2.getType(), (PsiType)object, evaluator);
                            AssignmentEvaluator assignmentEvaluator = new AssignmentEvaluator(evaluator2, evaluator);
                            arrayList.add(assignmentEvaluator);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            b.error((Throwable)incorrectOperationException);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{psiElement.getText()}), null));
            }
            if (!arrayList.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.d);
                codeFragmentEvaluator.setStatements(arrayList.toArray(new Evaluator[0]));
                this.e = codeFragmentEvaluator;
            } else {
                this.e = null;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression psiConditionalExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitConditionalExpression " + psiConditionalExpression);
            }
            PsiExpression psiExpression = psiConditionalExpression.getThenExpression();
            PsiExpression psiExpression2 = psiConditionalExpression.getElseExpression();
            if (psiExpression == null || psiExpression2 == null) {
                Builder.c((PsiElement)psiConditionalExpression);
            }
            PsiExpression psiExpression3 = psiConditionalExpression.getCondition();
            psiExpression3.accept((PsiElementVisitor)this);
            if (this.e == null) {
                Builder.c((PsiElement)psiExpression3);
            }
            UnBoxingEvaluator unBoxingEvaluator = new UnBoxingEvaluator(this.e);
            psiExpression.accept((PsiElementVisitor)this);
            if (this.e == null) {
                Builder.c((PsiElement)psiExpression);
            }
            Evaluator evaluator = this.e;
            psiExpression2.accept((PsiElementVisitor)this);
            if (this.e == null) {
                Builder.c((PsiElement)psiExpression2);
            }
            Evaluator evaluator2 = this.e;
            this.e = new ConditionalExpressionEvaluator(unBoxingEvaluator, evaluator, evaluator2);
        }

        public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitReferenceExpression " + psiReferenceExpression);
            }
            PsiExpression psiExpression = psiReferenceExpression.getQualifierExpression();
            JavaResolveResult javaResolveResult = psiReferenceExpression.advancedResolve(true);
            PsiElement psiElement = javaResolveResult.getElement();
            if (psiElement instanceof PsiLocalVariable || psiElement instanceof PsiParameter) {
                Value value = (Value)psiElement.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                if (value != null) {
                    this.e = new IdentityEvaluator(value);
                    return;
                }
                PsiFile psiFile = psiElement.getContainingFile();
                if (psiFile instanceof PsiCodeFragment && this.d != null && this.g.contains(psiFile)) {
                    this.e = new SyntheticVariableEvaluator(this.d, ((PsiVariable)psiElement).getName());
                    return;
                }
                PsiVariable psiVariable = (PsiVariable)psiElement;
                String string = psiVariable.getName();
                PsiClass psiClass = this.a(psiVariable);
                PsiClass psiClass2 = this.a();
                if (Objects.equals(psiClass2, psiClass)) {
                    PsiElement psiElement2 = DebuggerUtilsEx.getContainingMethod((PsiElement)psiReferenceExpression);
                    boolean bl2 = psiElement2 instanceof PsiLambdaExpression || ContextUtil.isJspImplicit(psiElement);
                    this.e = new LocalVariableEvaluator(string, bl2);
                    return;
                }
                int n2 = this.a((PsiElement)psiClass, psiClass.getName(), false) - 1;
                if (n2 > -1) {
                    Object object;
                    PsiExpression psiExpression2 = psiVariable.getInitializer();
                    if (psiExpression2 != null && (object = JavaPsiFacade.getInstance((Project)psiVariable.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)psiExpression2)) != null) {
                        PsiType psiType = javaResolveResult.getSubstitutor().substitute(psiVariable.getType());
                        this.e = new LiteralEvaluator(object, psiType.getCanonicalText());
                        return;
                    }
                    object = new ThisEvaluator(n2);
                    this.e = Builder.a(new FieldEvaluator((Evaluator)object, FieldEvaluator.createClassFilter(psiClass2), "val$" + string), (Evaluator)new LocalVariableEvaluator(string, true));
                    return;
                }
                Builder.a(DebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{string}));
            } else if (psiElement instanceof PsiField) {
                Evaluator evaluator;
                PsiField psiField = (PsiField)psiElement;
                PsiClass psiClass = psiField.getContainingClass();
                if (psiClass == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                    return;
                }
                if (psiField.hasModifierProperty("static")) {
                    JVMName jVMName = JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField));
                    if (jVMName == null) {
                        jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                    }
                    evaluator = new TypeEvaluator(jVMName);
                } else if (psiExpression != null) {
                    psiExpression.accept((PsiElementVisitor)this);
                    evaluator = this.e;
                } else {
                    int n3 = this.a((PsiElement)psiClass, psiClass.getName(), true);
                    if (n3 < 0) {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                    }
                    evaluator = new ThisEvaluator(n3);
                }
                this.e = new FieldEvaluator(evaluator, FieldEvaluator.createClassFilter(psiClass), psiField.getName());
            } else {
                PsiElement psiElement3 = psiReferenceExpression.getReferenceNameElement();
                if (!(psiElement3 instanceof PsiIdentifier)) {
                    String string = psiElement3 != null ? psiElement3.getText() : "(null)";
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{string}));
                    return;
                }
                String string = psiElement3.getText();
                if (psiExpression != null) {
                    PsiElement psiElement4;
                    PsiElement psiElement5 = psiElement4 = psiExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)psiExpression).resolve() : null;
                    if (psiElement4 instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)psiElement4;
                        JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.e = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.createClassFilter(psiClass), string);
                    } else {
                        psiExpression.accept((PsiElementVisitor)this);
                        if (this.e == null) {
                            Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{psiExpression.getText()}));
                        }
                        this.e = new FieldEvaluator(this.e, FieldEvaluator.createClassFilter(psiExpression.getType()), string);
                    }
                } else {
                    this.e = Builder.a(new LocalVariableEvaluator(string, false), (Evaluator)new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, string));
                }
            }
        }

        private static Evaluator a(final Evaluator evaluator, final Evaluator evaluator2) {
            return new Evaluator(){
                private boolean a;

                @Override
                public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
                    try {
                        return evaluator.evaluate(evaluationContextImpl);
                    }
                    catch (EvaluateException evaluateException) {
                        try {
                            Object object = evaluator2.evaluate(evaluationContextImpl);
                            this.a = true;
                            return object;
                        }
                        catch (EvaluateException evaluateException2) {
                            throw evaluateException;
                        }
                    }
                }

                @Override
                public Modifier getModifier() {
                    return this.a ? evaluator2.getModifier() : evaluator.getModifier();
                }
            };
        }

        private static void c(PsiElement psiElement) {
            Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{psiElement.getText()}));
        }

        private static void a(String string) throws EvaluateRuntimeException {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)string));
        }

        public void visitSuperExpression(PsiSuperExpression psiSuperExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitSuperExpression " + psiSuperExpression);
            }
            this.e = new SuperEvaluator(this.a(psiSuperExpression.getQualifier()));
        }

        public void visitThisExpression(PsiThisExpression psiThisExpression) {
            if (b.isDebugEnabled()) {
                b.debug("visitThisExpression " + psiThisExpression);
            }
            this.e = new ThisEvaluator(this.a(psiThisExpression.getQualifier()));
        }

        private int a(PsiJavaCodeReferenceElement psiJavaCodeReferenceElement) {
            if (psiJavaCodeReferenceElement != null) {
                return this.a(psiJavaCodeReferenceElement.resolve(), psiJavaCodeReferenceElement.getText(), false);
            }
            return 0;
        }

        private int a(PsiElement psiElement, String string, boolean bl2) {
            PsiClass psiClass = this.a();
            if (psiElement == null || psiClass == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{string}));
            }
            try {
                int n2 = Builder.a(psiElement, psiClass, bl2);
                if (n2 < -1 && !psiClass.equals(this.f)) {
                    n2 = Builder.a(psiElement, this.f, bl2);
                }
                return Math.max(0, n2);
            }
            catch (Exception exception) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)exception));
            }
        }

        private static int a(PsiElement psiElement, PsiClass psiClass, boolean bl2) {
            int n2 = 0;
            while (!(psiClass == null || psiClass.equals(psiElement) || bl2 && psiClass.isInheritor((PsiClass)psiElement, true))) {
                ++n2;
                psiClass = Builder.a(psiClass);
            }
            return psiClass != null ? n2 : -1;
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression psiInstanceOfExpression) {
            PsiTypeElement psiTypeElement;
            if (b.isDebugEnabled()) {
                b.debug("visitInstanceOfExpression " + psiInstanceOfExpression);
            }
            if ((psiTypeElement = psiInstanceOfExpression.getCheckType()) == null) {
                Builder.c((PsiElement)psiInstanceOfExpression);
            }
            PsiType psiType = psiTypeElement.getType();
            psiInstanceOfExpression.getOperand().accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            this.e = new InstanceofEvaluator(evaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression psiParenthesizedExpression) {
            PsiExpression psiExpression;
            if (b.isDebugEnabled()) {
                b.debug("visitParenthesizedExpression " + psiParenthesizedExpression);
            }
            if ((psiExpression = psiParenthesizedExpression.getExpression()) != null) {
                psiExpression.accept((PsiElementVisitor)this);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression psiPostfixExpression) {
            if (psiPostfixExpression.getType() == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPostfixExpression.getText()}));
            }
            PsiExpression psiExpression = psiPostfixExpression.getOperand();
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            IElementType iElementType = psiPostfixExpression.getOperationTokenType();
            PsiType psiType = psiExpression.getType();
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            Evaluator evaluator2 = Builder.a(evaluator, psiType, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, iElementType == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(psiPrimitiveType != null ? psiPrimitiveType : psiType));
            if (psiPrimitiveType != null) {
                evaluator2 = new BoxingEvaluator(evaluator2);
            }
            this.e = new PostfixOperationEvaluator(evaluator, evaluator2);
        }

        public void visitPrefixExpression(PsiPrefixExpression psiPrefixExpression) {
            PsiExpression psiExpression;
            PsiType psiType = psiPrefixExpression.getType();
            if (psiType == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPrefixExpression.getText()}));
            }
            if ((psiExpression = psiPrefixExpression.getOperand()) == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{psiPrefixExpression.getText()}));
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiType psiType2 = psiExpression.getType();
            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
            IElementType iElementType = psiPrefixExpression.getOperationTokenType();
            if (iElementType == JavaTokenType.PLUSPLUS || iElementType == JavaTokenType.MINUSMINUS) {
                try {
                    Evaluator evaluator2 = Builder.a(evaluator, psiType2, new LiteralEvaluator(1, "int"), (PsiType)PsiType.INT, iElementType == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS, (PsiType)(psiPrimitiveType != null ? psiPrimitiveType : psiType2));
                    this.e = new AssignmentEvaluator(evaluator, psiPrimitiveType != null ? new BoxingEvaluator(evaluator2) : evaluator2);
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    b.error((Throwable)incorrectOperationException);
                }
            } else {
                if (JavaTokenType.PLUS.equals(iElementType) || JavaTokenType.MINUS.equals(iElementType) || JavaTokenType.TILDE.equals(iElementType)) {
                    evaluator = Builder.a(psiType2, evaluator);
                } else if (psiPrimitiveType != null) {
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
                this.e = new UnaryExpressionEvaluator(iElementType, psiType.getCanonicalText(), evaluator, psiPrefixExpression.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            boolean bl2;
            Evaluator evaluator;
            PsiClass psiClass;
            PsiExpression psiExpression;
            if (b.isDebugEnabled()) {
                b.debug("visitMethodCallExpression " + psiMethodCallExpression);
            }
            PsiExpressionList psiExpressionList = psiMethodCallExpression.getArgumentList();
            PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
            Evaluator[] evaluatorArray = new Evaluator[psiExpressionArray.length];
            for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                psiExpression = psiExpressionArray[i2];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.e == null) {
                    Builder.c((PsiElement)psiExpression);
                }
                evaluatorArray[i2] = DisableGC.create(this.e);
            }
            PsiReferenceExpression psiReferenceExpression = psiMethodCallExpression.getMethodExpression();
            psiExpression = psiReferenceExpression.advancedResolve(false);
            PsiMethod psiMethod = (PsiMethod)psiExpression.getElement();
            PsiExpression psiExpression2 = psiReferenceExpression.getQualifierExpression();
            JVMName jVMName = null;
            if (psiMethod != null) {
                psiClass = psiMethod.getContainingClass();
                jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                if (psiMethod.hasModifierProperty("static")) {
                    evaluator = new TypeEvaluator(jVMName);
                } else if (psiExpression2 != null) {
                    psiExpression2.accept((PsiElementVisitor)this);
                    evaluator = this.e;
                } else {
                    bl2 = false;
                    PsiElement psiElement = psiExpression.getCurrentFileResolveScope();
                    if (psiElement instanceof PsiClass) {
                        bl2 = this.a(psiElement, ((PsiClass)psiElement).getName(), false);
                    }
                    evaluator = new ThisEvaluator(bl2 ? 1 : 0);
                }
            } else if (psiExpression2 != null) {
                psiClass = psiExpression2.getType();
                if (psiClass != null) {
                    jVMName = JVMNameUtil.getJVMQualifiedName((PsiType)psiClass);
                }
                if (psiExpression2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)psiExpression2).resolve() instanceof PsiClass) {
                    if (jVMName == null) {
                        jVMName = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)psiExpression2).getQualifiedName());
                    }
                    evaluator = new TypeEvaluator(jVMName);
                } else {
                    psiExpression2.accept((PsiElementVisitor)this);
                    evaluator = this.e;
                }
            } else {
                evaluator = new ThisEvaluator();
                psiClass = this.a();
                if (psiClass != null) {
                    jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                }
            }
            if (evaluator == null) {
                Builder.c((PsiElement)psiMethodCallExpression);
            }
            if (psiMethod != null && !psiMethod.isConstructor() && psiMethod.getReturnType() == null) {
                Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
            }
            boolean bl3 = false;
            bl2 = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.a(psiMethod.getParameterList().getParameters(), psiExpressionArray, psiExpression.getSubstitutor(), evaluatorArray);
                bl3 = psiMethod.hasModifierProperty("default");
                bl2 = psiMethod.isVarArgs();
            }
            this.e = new MethodEvaluator(evaluator, jVMName, psiReferenceExpression.getReferenceName(), psiMethod != null ? JVMNameUtil.getJVMSignature(psiMethod) : null, evaluatorArray, bl3, bl2);
        }

        public void visitLiteralExpression(PsiLiteralExpression psiLiteralExpression) {
            HighlightInfo highlightInfo = HighlightUtil.checkLiteralExpressionParsingError((PsiLiteralExpression)psiLiteralExpression, null, null);
            if (highlightInfo != null) {
                Builder.a(highlightInfo.getDescription());
                return;
            }
            PsiType psiType = psiLiteralExpression.getType();
            if (psiType == null) {
                Builder.a(psiLiteralExpression + ": null type");
                return;
            }
            this.e = new LiteralEvaluator(psiLiteralExpression.getValue(), psiType.getCanonicalText());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression psiArrayAccessExpression) {
            PsiExpression psiExpression = psiArrayAccessExpression.getIndexExpression();
            if (psiExpression == null) {
                Builder.c((PsiElement)psiArrayAccessExpression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = Builder.a(psiExpression.getType(), this.e);
            psiArrayAccessExpression.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.e;
            this.e = new ArrayAccessEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, Evaluator evaluator) {
            PsiType psiType2;
            PsiPrimitiveType psiPrimitiveType;
            PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
            if (psiPrimitiveType2 != null && !PsiType.BOOLEAN.equals((Object)psiPrimitiveType2)) {
                evaluator = new UnBoxingEvaluator(evaluator);
            }
            Object object = psiPrimitiveType = psiPrimitiveType2 != null ? psiPrimitiveType2 : psiType;
            if (psiPrimitiveType instanceof PsiPrimitiveType && (psiType2 = Builder.a(psiPrimitiveType)) != null) {
                evaluator = new TypeCastEvaluator(evaluator, psiType2.getCanonicalText(), true);
            }
            return evaluator;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression psiTypeCastExpression) {
            boolean bl2;
            PsiExpression psiExpression = psiTypeCastExpression.getOperand();
            if (psiExpression == null) {
                Builder.c((PsiElement)psiTypeCastExpression);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiTypeElement psiTypeElement = psiTypeCastExpression.getCastType();
            if (psiTypeElement == null) {
                Builder.c((PsiElement)psiTypeCastExpression);
            }
            PsiType psiType = psiTypeElement.getType();
            PsiType psiType2 = psiExpression.getType();
            if (psiType2 != null && !TypeConversionUtil.areTypesConvertible((PsiType)psiType2, (PsiType)psiType) && PsiUtil.resolveClassInType((PsiType)psiType2) != null) {
                throw new EvaluateRuntimeException(new EvaluateException(JavaErrorMessages.message((String)"inconvertible.type.cast", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)psiType2), JavaHighlightUtil.formatType((PsiType)psiType)})));
            }
            boolean bl3 = psiType2 != null && TypeConversionUtil.boxingConversionApplicable((PsiType)psiType, (PsiType)psiType2);
            boolean bl4 = psiType instanceof PsiPrimitiveType;
            if (bl3 && bl4) {
                evaluator = new UnBoxingEvaluator(evaluator);
            }
            boolean bl5 = bl2 = bl3 && !bl4;
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType) instanceof PsiTypeParameter)) {
                PsiPrimitiveType psiPrimitiveType;
                String string = psiType.getCanonicalText();
                if (bl2 && (psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType)) != null) {
                    string = psiPrimitiveType.getCanonicalText();
                }
                this.e = new TypeCastEvaluator(evaluator, string, bl4);
            }
            if (bl2) {
                this.e = new BoxingEvaluator(this.e);
            }
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression psiClassObjectAccessExpression) {
            PsiType psiType = psiClassObjectAccessExpression.getOperand().getType();
            if (psiType instanceof PsiPrimitiveType) {
                JVMName jVMName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)psiType).getBoxedTypeName());
                this.e = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.e = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression psiLambdaExpression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression psiMethodReferenceExpression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitNewExpression(PsiNewExpression psiNewExpression) {
            PsiType psiType = psiNewExpression.getType();
            if (psiType instanceof PsiArrayType) {
                Object object;
                Evaluator evaluator = null;
                PsiExpression[] psiExpressionArray = psiNewExpression.getArrayDimensions();
                if (psiExpressionArray.length == 1) {
                    object = psiExpressionArray[0];
                    object.accept((PsiElementVisitor)this);
                    if (this.e != null) {
                        evaluator = Builder.a(object.getType(), this.e);
                    } else {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{object.getText()}));
                    }
                } else if (psiExpressionArray.length > 1) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                }
                object = null;
                PsiArrayInitializerExpression psiArrayInitializerExpression = psiNewExpression.getArrayInitializer();
                if (psiArrayInitializerExpression != null) {
                    if (evaluator != null) {
                        Builder.c((PsiElement)psiNewExpression);
                    }
                    psiArrayInitializerExpression.accept((PsiElementVisitor)this);
                    if (this.e != null) {
                        object = Builder.a(psiArrayInitializerExpression.getType(), this.e);
                    } else {
                        Builder.c((PsiElement)psiArrayInitializerExpression);
                    }
                }
                if (evaluator == null && object == null) {
                    Builder.c((PsiElement)psiNewExpression);
                }
                this.e = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), evaluator, (Evaluator)object);
            } else if (psiType instanceof PsiClassType) {
                PsiClass psiClass;
                PsiExpression psiExpression;
                PsiClass psiClass2 = ((PsiClassType)psiType).resolve();
                if (psiClass2 instanceof PsiAnonymousClass) {
                    throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0])));
                }
                PsiExpressionList psiExpressionList = psiNewExpression.getArgumentList();
                if (psiExpressionList == null) {
                    Builder.c((PsiElement)psiNewExpression);
                }
                PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
                JavaResolveResult javaResolveResult = psiNewExpression.resolveMethodGenerics();
                PsiMethod psiMethod = (PsiMethod)javaResolveResult.getElement();
                if (psiMethod == null && psiExpressionArray.length > 0) {
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{psiNewExpression.getText()}), null));
                }
                Object[] objectArray = new Evaluator[psiExpressionArray.length];
                for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                    psiExpression = psiExpressionArray[i2];
                    psiExpression.accept((PsiElementVisitor)this);
                    if (this.e != null) {
                        objectArray[i2] = DisableGC.create(this.e);
                        continue;
                    }
                    Builder.c((PsiElement)psiExpression);
                }
                if (psiMethod != null) {
                    EvaluatorBuilderImpl.a(psiMethod.getParameterList().getParameters(), psiExpressionArray, javaResolveResult.getSubstitutor(), (Evaluator[])objectArray);
                }
                if (psiClass2 != null && (psiClass = psiClass2.getContainingClass()) != null && !psiClass2.hasModifierProperty("static")) {
                    psiExpression = psiNewExpression.getQualifier();
                    if (psiExpression != null) {
                        psiExpression.accept((PsiElementVisitor)this);
                        if (this.e != null) {
                            objectArray = (Evaluator[])ArrayUtil.prepend((Object)this.e, (Object[])objectArray);
                        }
                    } else {
                        objectArray = (Evaluator[])ArrayUtil.prepend((Object)new ThisEvaluator(this.a((PsiElement)psiClass, "this", false)), (Object[])objectArray);
                    }
                }
                JVMName jVMName = JVMNameUtil.getJVMConstructorSignature(psiMethod, psiClass2);
                this.e = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), jVMName, (Evaluator[])objectArray);
            } else if (psiType != null) {
                Builder.a("Unsupported expression type: " + psiType.getPresentableText());
            } else {
                Builder.a("Unknown type for expression: " + psiNewExpression.getText());
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression psiArrayInitializerExpression) {
            PsiExpression[] psiExpressionArray = psiArrayInitializerExpression.getInitializers();
            Evaluator[] evaluatorArray = new Evaluator[psiExpressionArray.length];
            PsiType psiType = psiArrayInitializerExpression.getType();
            boolean bl2 = psiType instanceof PsiArrayType && ((PsiArrayType)psiType).getComponentType() instanceof PsiPrimitiveType;
            for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                PsiExpression psiExpression = psiExpressionArray[i2];
                psiExpression.accept((PsiElementVisitor)this);
                if (this.e != null) {
                    Evaluator evaluator = bl2 ? Builder.a(psiExpression.getType(), this.e) : new BoxingEvaluator(this.e);
                    evaluatorArray[i2] = DisableGC.create(evaluator);
                    continue;
                }
                Builder.c((PsiElement)psiExpression);
            }
            this.e = new ArrayInitializerEvaluator(evaluatorArray);
            if (psiType != null && !(psiArrayInitializerExpression.getParent() instanceof PsiNewExpression)) {
                this.e = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), null, this.e);
            }
        }

        @Nullable
        private static PsiClass a(PsiClass psiClass) {
            return psiClass == null ? null : (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
        }

        private PsiClass a(PsiVariable psiVariable) {
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiVariable.getParent(), PsiClass.class, (boolean)false);
            return psiElement == null ? this.f : (PsiClass)psiElement;
        }

        @Nullable
        private PsiClass a() {
            return this.a != null ? this.a : this.f;
        }

        protected ExpressionEvaluator buildElement(PsiElement psiElement) throws EvaluateException {
            b.assertTrue(psiElement.isValid());
            this.f = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
            try {
                psiElement.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw evaluateRuntimeException.getCause();
            }
            if (this.e == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{psiElement.toString()}));
            }
            return new ExpressionEvaluatorImpl(this.e);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "operation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expressionExpectedType";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl$Builder";
            objectArray[2] = "createBinaryEvaluator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

