/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;

public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator");
    private final Evaluator a;

    public ExpressionEvaluatorImpl(Evaluator evaluator) {
        this.a = evaluator;
    }

    public Modifier getModifier() {
        return this.a.getModifier();
    }

    public Value evaluate(EvaluationContext evaluationContext) throws EvaluateException {
        if (!evaluationContext.getDebugProcess().isAttached()) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]));
        }
        try {
            if (evaluationContext.getFrameProxy() == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
            Object object = this.a.evaluate((EvaluationContextImpl)evaluationContext);
            if (object != null && !(object instanceof Value)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{""}));
            }
            return (Value)object;
        }
        catch (ReturnEvaluator.ReturnException returnException) {
            return (Value)returnException.getReturnValue();
        }
        catch (Throwable throwable) {
            b.debug(throwable);
            if (throwable instanceof EvaluateException) {
                throw (EvaluateException)throwable;
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)throwable);
        }
    }
}

