/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldEvaluator
implements Evaluator {
    private final Evaluator e;
    private final TargetClassFilter c;
    private final String b;
    private Object a;
    private Field d;

    public FieldEvaluator(Evaluator evaluator, TargetClassFilter targetClassFilter, @NonNls String string) {
        this.e = evaluator;
        this.b = string;
        this.c = targetClassFilter;
    }

    @NotNull
    public static TargetClassFilter createClassFilter(@Nullable PsiType psiType) {
        if (psiType == null || psiType instanceof PsiArrayType) {
            TargetClassFilter targetClassFilter = TargetClassFilter.ALL;
            if (targetClassFilter == null) {
                FieldEvaluator.a(0);
            }
            return targetClassFilter;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiClass != null) {
            TargetClassFilter targetClassFilter = FieldEvaluator.createClassFilter(psiClass);
            if (targetClassFilter == null) {
                FieldEvaluator.a(1);
            }
            return targetClassFilter;
        }
        FQNameClassFilter fQNameClassFilter = new FQNameClassFilter(psiType.getCanonicalText());
        if (fQNameClassFilter == null) {
            FieldEvaluator.a(2);
        }
        return fQNameClassFilter;
    }

    public static TargetClassFilter createClassFilter(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            return TargetClassFilter.ALL;
        }
        if (PsiUtil.isLocalClass((PsiClass)psiClass)) {
            return new LocalClassFilter(psiClass.getName());
        }
        String string = JVMNameUtil.getNonAnonymousClassName(psiClass);
        return string != null ? new FQNameClassFilter(string) : TargetClassFilter.ALL;
    }

    @Nullable
    private Field a(@Nullable Type type) {
        if (type instanceof ClassType) {
            ClassType classType = (ClassType)type;
            if (this.c.acceptClass(classType)) {
                return classType.fieldByName(this.b);
            }
            for (InterfaceType interfaceType : classType.interfaces()) {
                Field field = this.a(interfaceType);
                if (field == null) continue;
                return field;
            }
            return this.a(classType.superclass());
        }
        if (type instanceof InterfaceType) {
            InterfaceType interfaceType = (InterfaceType)type;
            if (this.c.acceptClass(interfaceType)) {
                return interfaceType.fieldByName(this.b);
            }
            for (InterfaceType interfaceType2 : interfaceType.superinterfaces()) {
                Field field = this.a(interfaceType2);
                if (field == null) continue;
                return field;
            }
        }
        return null;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        this.d = null;
        this.a = null;
        Object object = this.e.evaluate(evaluationContextImpl);
        return this.a(object, evaluationContextImpl);
    }

    private Object a(Object object, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (object instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)object;
            Field field = this.a(referenceType);
            if (field == null || !field.isStatic()) {
                field = referenceType.fieldByName(this.b);
            }
            if (field == null || !field.isStatic()) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.static.field", (Object[])new Object[]{this.b}));
            }
            this.d = field;
            this.a = referenceType;
            return referenceType.getValue(field);
        }
        if (object instanceof ObjectReference) {
            ObjectReference objectReference = (ObjectReference)object;
            ReferenceType referenceType = objectReference.referenceType();
            if (!(referenceType instanceof ClassType) && !(referenceType instanceof ArrayType)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.class.or.array.expected", (Object[])new Object[]{this.b}));
            }
            if (objectReference instanceof ArrayReference && "length".equals(this.b)) {
                return DebuggerUtilsEx.createValue(evaluationContextImpl.getDebugProcess().getVirtualMachineProxy(), "int", ((ArrayReference)objectReference).length());
            }
            Field field = this.a(referenceType);
            if (field == null) {
                field = referenceType.fieldByName(this.b);
            }
            if (field == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.instance.field", (Object[])new Object[]{this.b}));
            }
            this.a = field.isStatic() ? referenceType : objectReference;
            this.d = field;
            return field.isStatic() ? referenceType.getValue(field) : objectReference.getValue(field);
        }
        if (object == null) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)new NullPointerException());
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.evaluating.field", (Object[])new Object[]{this.b}));
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = null;
        if (this.d != null && (this.a instanceof ClassType || this.a instanceof ObjectReference)) {
            modifier = new Modifier(){

                public boolean canInspect() {
                    return FieldEvaluator.this.a instanceof ObjectReference;
                }

                public boolean canSetValue() {
                    return true;
                }

                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    if (FieldEvaluator.this.a instanceof ReferenceType) {
                        ClassType classType = (ClassType)FieldEvaluator.this.a;
                        classType.setValue(FieldEvaluator.this.d, value);
                    } else {
                        ObjectReference objectReference = (ObjectReference)FieldEvaluator.this.a;
                        objectReference.setValue(FieldEvaluator.this.d, value);
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    return FieldEvaluator.this.d.type();
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    if (FieldEvaluator.this.a instanceof ObjectReference) {
                        return new FieldDescriptorImpl(project2, (ObjectReference)FieldEvaluator.this.a, FieldEvaluator.this.d);
                    }
                    return null;
                }
            };
        }
        return modifier;
    }

    public String toString() {
        return "field " + this.b;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/expression/FieldEvaluator", "createClassFilter"));
    }

    private static final class LocalClassFilter
    implements TargetClassFilter {
        private final String a;

        private LocalClassFilter(String string) {
            this.a = string;
        }

        @Override
        public boolean acceptClass(ReferenceType referenceType) {
            String string = referenceType.name();
            int n2 = string.lastIndexOf(this.a);
            if (n2 < 0) {
                return false;
            }
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                char c2 = string.charAt(i2);
                if (c2 == '$') {
                    return i2 < n2 - 1;
                }
                if (Character.isDigit(c2)) continue;
                return false;
            }
            return false;
        }
    }

    private static final class FQNameClassFilter
    implements TargetClassFilter {
        private final String a;

        private FQNameClassFilter(String string) {
            this.a = string;
        }

        @Override
        public boolean acceptClass(ReferenceType referenceType) {
            return referenceType.name().equals(this.a);
        }
    }

    public static interface TargetClassFilter {
        public static final TargetClassFilter ALL = referenceType -> true;

        public boolean acceptClass(ReferenceType var1);
    }
}

