/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.StringReference;
import java.util.Collections;

class LiteralEvaluator
implements Evaluator {
    private final Object a;
    private final String b;

    public LiteralEvaluator(Object object, String string) {
        this.a = object;
        this.b = string;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        if (this.a == null) {
            return null;
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (this.a instanceof Boolean) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, (Boolean)this.a);
        }
        if (this.a instanceof Character) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Character)this.a).charValue());
        }
        if (this.a instanceof Double) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).doubleValue());
        }
        if (this.a instanceof Float) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).floatValue());
        }
        if (this.a instanceof Number) {
            return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.b, ((Number)this.a).longValue());
        }
        if (this.a instanceof String) {
            return virtualMachineProxyImpl.mirrorOfStringLiteral((String)this.a, (ThrowableComputable<StringReference, EvaluateException>)((ThrowableComputable)() -> {
                Method method;
                StringReference stringReference = virtualMachineProxyImpl.mirrorOf((String)this.a);
                if (Registry.is((String)"debugger.intern.string.literals") && virtualMachineProxyImpl.versionHigher("1.7") && (method = ((ClassType)stringReference.referenceType()).concreteMethodByName("intern", "()Ljava/lang/String;")) != null) {
                    return (StringReference)evaluationContextImpl.getDebugProcess().invokeMethod((EvaluationContext)evaluationContextImpl, stringReference, method, Collections.emptyList());
                }
                return stringReference;
            }));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{this.b}));
    }

    public String toString() {
        return this.a != null ? this.a.toString() : "null";
    }
}

