/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ThisEvaluator
implements Evaluator {
    private final int a;

    public ThisEvaluator() {
        this.a = 0;
    }

    public ThisEvaluator(int n2) {
        this.a = n2;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Value value = evaluationContextImpl.computeThisObject();
        if (this.a > 0) {
            ObjectReference objectReference = (ObjectReference)value;
            for (int i2 = 0; i2 < this.a && objectReference != null; ++i2) {
                objectReference = ThisEvaluator.a(objectReference);
            }
            value = objectReference;
        }
        if (value == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.this.not.avalilable", (Object[])new Object[0]));
        }
        return value;
    }

    @Nullable
    private static ObjectReference a(ObjectReference objectReference) {
        if (objectReference == null) {
            return null;
        }
        List<Field> list2 = objectReference.referenceType().fields();
        for (Field field : list2) {
            ObjectReference objectReference2;
            String string = field.name();
            if (string == null || !string.startsWith("this$") || (objectReference2 = (ObjectReference)objectReference.getValue(field)) == null) continue;
            return objectReference2;
        }
        return null;
    }

    public String toString() {
        return "this";
    }
}

