/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class TypeCastEvaluator
implements Evaluator {
    private final Evaluator a;
    private final String c;
    private final boolean b;

    public TypeCastEvaluator(Evaluator evaluator, String string, boolean bl2) {
        this.a = evaluator;
        this.c = string;
        this.b = bl2;
    }

    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Type type;
        Value value = (Value)this.a.evaluate(evaluationContextImpl);
        if (value == null) {
            if (this.b) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.null", (Object[])new Object[]{this.c}));
            }
            return null;
        }
        VirtualMachineProxyImpl virtualMachineProxyImpl = evaluationContextImpl.getDebugProcess().getVirtualMachineProxy();
        if (DebuggerUtils.isInteger((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.c, ((PrimitiveValue)value).longValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.c}));
            }
        } else if (DebuggerUtils.isNumeric((Value)value)) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.c, ((PrimitiveValue)value).doubleValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.numeric", (Object[])new Object[]{this.c}));
            }
        } else if (value instanceof BooleanValue) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.c, ((BooleanValue)value).booleanValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.boolean", (Object[])new Object[]{this.c}));
            }
        } else if (value instanceof CharValue) {
            if ((value = DebuggerUtilsEx.createValue(virtualMachineProxyImpl, this.c, ((CharValue)value).charValue())) == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.char", (Object[])new Object[]{this.c}));
            }
        } else if (value instanceof ObjectReference && !DebuggerUtils.instanceOf((Type)(type = value.type()), (String)this.c)) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.cannot.cast.object", (Object[])new Object[]{type.name(), this.c}));
        }
        return value;
    }
}

