/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerContextImpl
implements DebuggerContext {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerContextImpl");
    public static final DebuggerContextImpl EMPTY_CONTEXT = DebuggerContextImpl.createDebuggerContext(null, null, null, null);
    private boolean c;
    @Nullable
    private final DebuggerSession d;
    private final SuspendContextImpl f;
    private final ThreadReferenceProxyImpl g;
    private StackFrameProxyImpl e;
    private SourcePosition b;
    private PsiElement h;

    private DebuggerContextImpl(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl, SourcePosition sourcePosition, PsiElement psiElement, boolean bl2) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        this.d = debuggerSession;
        this.g = threadReferenceProxyImpl;
        this.e = stackFrameProxyImpl;
        this.b = sourcePosition;
        this.f = suspendContextImpl;
        this.h = psiElement;
        this.c = bl2;
    }

    @Nullable
    public DebuggerSession getDebuggerSession() {
        return this.d;
    }

    @Nullable
    public DebugProcessImpl getDebugProcess() {
        return this.d != null ? this.d.getProcess() : null;
    }

    @Nullable
    public ThreadReferenceProxyImpl getThreadProxy() {
        return this.g;
    }

    public SuspendContextImpl getSuspendContext() {
        return this.f;
    }

    public Project getProject() {
        return this.d != null ? this.d.getProject() : null;
    }

    @Nullable
    public StackFrameProxyImpl getFrameProxy() {
        a.assertTrue(this.c);
        return this.e;
    }

    public SourcePosition getSourcePosition() {
        a.assertTrue(this.c);
        return this.b;
    }

    public PsiElement getContextElement() {
        a.assertTrue(this.c);
        PsiElement psiElement = this.h;
        if (psiElement != null && !psiElement.isValid()) {
            this.h = ContextUtil.getContextElement(this.b);
        }
        return this.h;
    }

    public EvaluationContextImpl createEvaluationContext(Value value) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return new EvaluationContextImpl(this.getSuspendContext(), this.getFrameProxy(), value);
    }

    @Nullable
    public EvaluationContextImpl createEvaluationContext() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        SuspendContextImpl suspendContextImpl = this.getSuspendContext();
        return suspendContextImpl != null ? new EvaluationContextImpl(suspendContextImpl, this.getFrameProxy()) : null;
    }

    @NotNull
    public static DebuggerContextImpl createDebuggerContext(@Nullable DebuggerSession debuggerSession, @Nullable SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        a.assertTrue(stackFrameProxyImpl == null || threadReferenceProxyImpl == null || threadReferenceProxyImpl == stackFrameProxyImpl.threadProxy());
        DebuggerContextImpl debuggerContextImpl = new DebuggerContextImpl(debuggerSession, suspendContextImpl, threadReferenceProxyImpl, stackFrameProxyImpl, null, null, suspendContextImpl == null);
        if (debuggerContextImpl == null) {
            DebuggerContextImpl.a(0);
        }
        return debuggerContextImpl;
    }

    public void initCaches() {
        if (this.c) {
            return;
        }
        this.c = true;
        if (this.e == null && this.g != null) {
            try {
                this.e = this.g.frameCount() > 0 ? this.g.frame(0) : null;
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        if (this.e != null) {
            if (this.b == null) {
                this.b = ContextUtil.getSourcePosition((StackFrameContext)this);
            }
            this.h = ContextUtil.getContextElement(this.b);
        }
    }

    public void setPositionCache(SourcePosition sourcePosition) {
        this.b = sourcePosition;
    }

    public boolean isInitialised() {
        return this.c;
    }

    public boolean isEvaluationPossible() {
        DebugProcessImpl debugProcessImpl = this.getDebugProcess();
        return debugProcessImpl != null && debugProcessImpl.getSuspendManager().getPausedContext() != null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/DebuggerContextImpl", "createDebuggerContext"));
    }
}

