/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class JavaEditorTextProviderImpl
implements EditorTextProvider {
    private static final Logger a = Logger.getInstance(JavaEditorTextProviderImpl.class);

    @Override
    public TextWithImports getEditorText(PsiElement psiElement) {
        String string = null;
        PsiElement psiElement2 = JavaEditorTextProviderImpl.a(psiElement);
        if (psiElement2 == null) {
            return null;
        }
        if (psiElement2 instanceof PsiVariable) {
            string = JavaEditorTextProviderImpl.a(psiElement2, ((PsiVariable)psiElement2).getName());
        } else if (psiElement2 instanceof PsiMethod) {
            string = ((PsiMethod)psiElement2).getName() + "()";
        } else if (psiElement2 instanceof PsiReferenceExpression) {
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement2;
            string = JavaEditorTextProviderImpl.a(psiReferenceExpression.resolve(), psiElement2.getText());
        } else {
            string = psiElement2.getText();
        }
        return string != null ? new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string) : null;
    }

    @Nullable
    private static PsiElement a(PsiElement psiElement) {
        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiVariable.class, PsiExpression.class, PsiMethod.class});
        if (!(psiElement2 instanceof PsiVariable)) {
            if (psiElement2 instanceof PsiMethod && psiElement.getParent() != psiElement2) {
                psiElement2 = null;
            } else if (psiElement2 instanceof PsiReferenceExpression) {
                PsiElement psiElement3;
                if (psiElement2.getParent() instanceof PsiCallExpression) {
                    psiElement2 = psiElement2.getParent();
                } else if (psiElement2.getParent() instanceof PsiReferenceExpression && (psiElement3 = ((PsiReferenceExpression)psiElement2).resolve()) instanceof PsiClass) {
                    psiElement2 = psiElement2.getParent();
                }
            }
        }
        if (psiElement2 instanceof PsiNewExpression && ((PsiNewExpression)psiElement2).getAnonymousClass() != null) {
            return null;
        }
        return psiElement2;
    }

    @Override
    @Nullable
    public Pair<PsiElement, TextRange> findExpression(PsiElement psiElement, boolean bl2) {
        TextRange textRange;
        PsiElement psiElement2;
        PsiElement psiElement3 = null;
        PsiElement psiElement4 = psiElement.getParent();
        if (psiElement4 instanceof PsiLiteralExpression || psiElement4 instanceof PsiLambdaExpression) {
            psiElement = psiElement4;
            psiElement4 = psiElement4.getParent();
        }
        if (psiElement4 instanceof PsiVariable) {
            psiElement3 = psiElement;
        } else if (psiElement4 instanceof PsiReferenceExpression) {
            psiElement2 = psiElement4.getParent();
            if (psiElement4 instanceof PsiMethodReferenceExpression || psiElement2 instanceof PsiCallExpression && ((PsiCallExpression)psiElement2).getArgumentList() != null) {
                psiElement4 = psiElement2;
            } else if (psiElement2 instanceof PsiReferenceExpression && ((PsiReferenceExpression)psiElement4).resolve() instanceof PsiClass) {
                return this.findExpression(psiElement2, bl2);
            }
            if (bl2 || !DebuggerUtils.hasSideEffects((PsiElement)psiElement4)) {
                psiElement3 = psiElement4;
            }
        } else if (psiElement4 instanceof PsiThisExpression) {
            psiElement3 = psiElement4;
        } else if (psiElement4 instanceof PsiExpressionList && psiElement4.getParent() instanceof PsiMethodCallExpression) {
            if (bl2) {
                psiElement3 = psiElement4.getParent();
            }
        } else if (psiElement4 instanceof PsiArrayInitializerExpression) {
            if (bl2 && (psiElement2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiNewExpression.class)) != null) {
                psiElement3 = psiElement2;
            }
        } else if (psiElement4 instanceof PsiExpression && !(psiElement4 instanceof PsiNewExpression) && !(psiElement4 instanceof PsiLambdaExpression)) {
            if (bl2 || !DebuggerUtils.hasSideEffects((PsiElement)psiElement4)) {
                psiElement3 = psiElement4;
            }
        } else {
            psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiTypeCastExpression.class);
            if (psiElement2 != null) {
                if (bl2 || !DebuggerUtils.hasSideEffects((PsiElement)psiElement2)) {
                    psiElement3 = psiElement2;
                }
            } else if (bl2 && (textRange = PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{PsiVariable.class, PsiExpression.class, PsiMethod.class})) instanceof PsiNewExpression && ((PsiNewExpression)textRange).getAnonymousClass() == null) {
                psiElement3 = textRange;
            }
        }
        if (psiElement3 != null) {
            try {
                if (psiElement4 instanceof PsiParameter) {
                    try {
                        psiElement2 = ((PsiMethod)((PsiParameter)psiElement4).getDeclarationScope()).getBody();
                    }
                    catch (Throwable throwable) {}
                } else {
                    for (psiElement2 = psiElement; psiElement2 != null && !(psiElement2 instanceof PsiStatement) && !(psiElement2 instanceof PsiClass); psiElement2 = psiElement2.getParent()) {
                    }
                }
                textRange = psiElement3.getTextRange();
                PsiExpression psiExpression = JavaPsiFacade.getInstance((Project)psiElement3.getProject()).getElementFactory().createExpressionFromText(psiElement3.getText(), psiElement2);
                return Pair.create((Object)psiExpression, (Object)textRange);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                a.debug((Throwable)incorrectOperationException);
            }
        }
        return null;
    }

    @Nullable
    private static String a(PsiElement psiElement, @Nullable String string) {
        PsiEnumConstant psiEnumConstant;
        PsiClass psiClass;
        if (psiElement instanceof PsiEnumConstant && (psiClass = (psiEnumConstant = (PsiEnumConstant)psiElement).getContainingClass()) != null) {
            return psiClass.getName() + "." + psiEnumConstant.getName();
        }
        return string;
    }
}

