/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class ReloadClassesWorker {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.impl.ReloadClassesWorker");
    private final DebuggerSession b;
    private final HotSwapProgress a;

    public ReloadClassesWorker(DebuggerSession debuggerSession, HotSwapProgress hotSwapProgress) {
        this.b = debuggerSession;
        this.a = hotSwapProgress;
    }

    private DebugProcessImpl a() {
        return this.b.getProcess();
    }

    private void a(Throwable throwable) {
        if (throwable.getMessage() != null) {
            this.a.addMessage(this.b, 4, throwable.getMessage());
        }
        if (throwable instanceof ProcessCanceledException) {
            this.a.addMessage(this.b, 3, DebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
            return;
        }
        if (throwable instanceof UnsupportedOperationException) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[0]));
        } else if (throwable instanceof NoClassDefFoundError) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof VerifyError) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof UnsupportedClassVersionError) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof ClassFormatError) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else if (throwable instanceof ClassCircularityError) {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
        } else {
            this.a.addMessage(this.b, 4, DebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{throwable.getClass().getName(), throwable.getLocalizedMessage()}));
        }
    }

    public void reloadClasses(Map<String, HotSwapFile> map) {
        JavaExecutionStack javaExecutionStack;
        Object object;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (map == null || map.size() == 0) {
            this.a.addMessage(this.b, 3, DebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
            return;
        }
        DebugProcessImpl debugProcessImpl = this.a();
        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
        Project project2 = debugProcessImpl.getProject();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(project2).getBreakpointManager();
        breakpointManager.disableBreakpoints(debugProcessImpl);
        StackCapturingLineBreakpoint.deleteAll(debugProcessImpl);
        if (c.isDebugEnabled()) {
            c.debug("Threads before hotswap:\n", new Object[]{StreamEx.of(ThreadDumpAction.buildThreadStates(virtualMachineProxyImpl)).map(ThreadState::getStackTrace).joining((CharSequence)"\n")});
        }
        if (Registry.is((String)"debugger.resume.yourkit.threads")) {
            virtualMachineProxyImpl.allThreads().stream().filter(ThreadReferenceProxyImpl::isResumeOnHotSwap).filter(ThreadReferenceProxyImpl::isSuspended).forEach(threadReferenceProxyImpl -> IntStream.range(0, threadReferenceProxyImpl.getSuspendCount()).forEach(n2 -> threadReferenceProxyImpl.resume()));
        }
        try {
            object = new RedefineProcessor(virtualMachineProxyImpl);
            int n2 = 0;
            for (Map.Entry<String, HotSwapFile> object2 : map.entrySet()) {
                if (debugProcessImpl.isDetached() || debugProcessImpl.isDetaching() || ((RedefineProcessor)object).getProcessedClassesCount() == 0 && this.a.isCancelled()) break;
                ++n2;
                String string = object2.getKey();
                if (string != null) {
                    this.a.setText(string);
                    this.a.setFraction((double)n2 / (double)map.size());
                }
                try {
                    ((RedefineProcessor)object).processClass(string, object2.getValue().file);
                }
                catch (IOException iOException) {
                    this.a(string, iOException);
                }
            }
            if (((RedefineProcessor)object).getProcessedClassesCount() == 0 && this.a.isCancelled()) {
                return;
            }
            ((RedefineProcessor)object).processPending();
            this.a.setFraction(1.0);
            int n3 = ((RedefineProcessor)object).getPartiallyRedefinedClassesCount();
            if (n3 == 0) {
                this.a.addMessage(this.b, 3, DebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{((RedefineProcessor)object).getProcessedClassesCount()}));
            } else {
                String exception = DebuggerBundle.message((String)"status.classes.not.all.versions.reloaded", (Object[])new Object[]{n3, ((RedefineProcessor)object).getProcessedClassesCount()});
                this.a.addMessage(this.b, 5, exception);
            }
            c.debug("classes reloaded");
        }
        catch (Throwable throwable) {
            this.a(throwable);
        }
        debugProcessImpl.onHotSwapFinished();
        object = this.b.getContextManager().getContext();
        SuspendContextImpl suspendContextImpl = ((DebuggerContextImpl)object).getSuspendContext();
        if (suspendContextImpl != null && (javaExecutionStack = suspendContextImpl.getActiveExecutionStack()) != null) {
            javaExecutionStack.initTopFrame();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        SwingUtilities.invokeLater(() -> {
            try {
                if (!project2.isDisposed()) {
                    breakpointManager.reloadBreakpoints();
                    debugProcessImpl.getRequestsManager().clearWarnings();
                    if (c.isDebugEnabled()) {
                        c.debug("requests updated");
                        c.debug("time stamp set");
                    }
                    this.b.refresh(false);
                    XDebugSession xDebugSession = this.b.getXDebugSession();
                    if (xDebugSession != null) {
                        xDebugSession.rebuildViews();
                    }
                }
            }
            catch (Throwable throwable) {
                c.error(throwable);
            }
            finally {
                semaphore.up();
            }
        });
        semaphore.waitFor();
        if (!project2.isDisposed()) {
            try {
                breakpointManager.enableBreakpoints(debugProcessImpl);
                StackCapturingLineBreakpoint.createAll(debugProcessImpl);
            }
            catch (Exception exception) {
                this.a(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, @Nullable Exception exception) {
        String string2 = null;
        if (exception != null) {
            string2 = exception.getLocalizedMessage();
        }
        if (string2 == null || string2.length() == 0) {
            string2 = DebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(string).append(" : ").append(string2);
            this.a.addMessage(this.b, 4, stringBuilder.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    private static class RedefineProcessor {
        private static final int c = 100;
        private final VirtualMachineProxyImpl d;
        private final Map<ReferenceType, byte[]> e = new HashMap<ReferenceType, byte[]>();
        private int a;
        private int b;

        public RedefineProcessor(VirtualMachineProxyImpl virtualMachineProxyImpl) {
            this.d = virtualMachineProxyImpl;
        }

        public void processClass(String string, File file) throws Throwable {
            List<ReferenceType> list2 = this.d.classesByName(string);
            if (list2.isEmpty()) {
                return;
            }
            byte[] byArray = FileUtil.loadFileBytes((File)file);
            if (list2.size() == 1) {
                this.e.put(list2.get(0), byArray);
                if (this.e.size() >= 100) {
                    this.a();
                }
                return;
            }
            int n2 = 0;
            Throwable throwable = null;
            for (ReferenceType referenceType : list2) {
                try {
                    this.d.redefineClasses(Collections.singletonMap(referenceType, byArray));
                    ++n2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            if (n2 == 0) {
                throw throwable;
            }
            if (n2 < list2.size()) {
                ++this.b;
            }
            ++this.a;
        }

        private void a() throws Throwable {
            try {
                this.d.redefineClasses(this.e);
                this.a += this.e.size();
            }
            finally {
                this.e.clear();
            }
        }

        public void processPending() throws Throwable {
            if (this.e.size() > 0) {
                this.a();
            }
        }

        public int getProcessedClassesCount() {
            return this.a;
        }

        public int getPartiallyRedefinedClassesCount() {
            return this.b;
        }
    }
}

