/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SourceCodeChecker {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.SourceCodeChecker");

    private SourceCodeChecker() {
    }

    public static void checkSource(final DebuggerContextImpl debuggerContextImpl) {
        if (!Registry.is((String)"debugger.check.source")) {
            return;
        }
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        if (suspendContextImpl == null) {
            return;
        }
        suspendContextImpl.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                if (suspendContextImpl == null) {
                    1.b(0);
                }
                try {
                    StackFrameProxyImpl stackFrameProxyImpl = debuggerContextImpl.getFrameProxy();
                    if (stackFrameProxyImpl == null) {
                        return;
                    }
                    Location location = stackFrameProxyImpl.location();
                    SourceCodeChecker.a(location, debuggerContextImpl.getSourcePosition(), suspendContextImpl.getDebugProcess().getProject());
                }
                catch (EvaluateException evaluateException) {
                    a.info((Throwable)evaluateException);
                }
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/SourceCodeChecker$1", "contextAction"));
            }
        });
    }

    private static ThreeState a(Location location, SourcePosition sourcePosition, Project project2) {
        Method method = DebuggerUtilsEx.getMethod(location);
        if (method == null || method.isConstructor() || method.isSynthetic() || method.isBridge() || method.isStaticInitializer() || method.declaringType() instanceof ClassType && ((ClassType)method.declaringType()).isEnum() || DebuggerUtilsEx.isLambda(method)) {
            return ThreeState.UNSURE;
        }
        List<Location> list2 = DebuggerUtilsEx.allLineLocations(method);
        if (ContainerUtil.isEmpty(list2)) {
            return ThreeState.UNSURE;
        }
        if (sourcePosition != null) {
            return (ThreeState)ReadAction.compute(() -> {
                TextRange textRange;
                PsiFile psiFile = sourcePosition.getFile();
                if (!psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                    return ThreeState.UNSURE;
                }
                Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
                if (document == null) {
                    return ThreeState.UNSURE;
                }
                boolean bl2 = false;
                PsiElement psiElement = DebuggerUtilsEx.getContainingMethod(sourcePosition);
                if (psiElement != null) {
                    PsiDocComment psiDocComment;
                    textRange = psiElement.getTextRange();
                    if (psiElement instanceof PsiDocCommentOwner && (psiDocComment = ((PsiDocCommentOwner)psiElement).getDocComment()) != null) {
                        textRange = new TextRange(psiDocComment.getTextRange().getEndOffset() + 1, textRange.getEndOffset());
                    }
                    int n2 = document.getLineNumber(textRange.getStartOffset()) + 1;
                    int n3 = document.getLineNumber(textRange.getEndOffset()) + 1;
                    bl2 = SourceCodeChecker.a(list2, psiFile).allMatch(n4 -> n2 <= n4 && n4 <= n3);
                    if (!bl2) {
                        a.debug("Source check failed: Method " + method.name() + ", source: " + ((NavigationItem)psiElement).getName() + "\nLines: " + SourceCodeChecker.a(list2, psiFile).joining((CharSequence)", ") + "\nExpected range: " + n2 + "-" + n3);
                    }
                } else {
                    a.debug("Source check failed: method " + method.name() + " not found in sources");
                }
                if (!bl2) {
                    textRange = FileEditorManager.getInstance((Project)project2).getSelectedEditor(sourcePosition.getFile().getVirtualFile());
                    if (textRange instanceof TextEditor) {
                        AppUIUtil.invokeOnEdt(() -> SourceCodeChecker.a((FileEditor)textRange));
                    } else {
                        XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]), NotificationType.WARNING).notify(project2);
                    }
                    return ThreeState.NO;
                }
                return ThreeState.YES;
            });
        }
        return ThreeState.YES;
    }

    private static IntStreamEx a(List<Location> list2, PsiFile psiFile) {
        IntStreamEx intStreamEx = StreamEx.of(list2).mapToInt(Location::lineNumber);
        if (psiFile instanceof PsiCompiledFile) {
            intStreamEx = intStreamEx.map(n2 -> DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n2) + 1);
        }
        return intStreamEx.filter(n2 -> n2 > 0);
    }

    private static void a(DebuggerContextImpl debuggerContextImpl) {
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        VirtualMachine virtualMachine = debugProcessImpl.getVirtualMachineProxy().getVirtualMachine();
        PositionManagerImpl positionManagerImpl = new PositionManagerImpl(debugProcessImpl);
        List<ReferenceType> list2 = virtualMachine.allClasses();
        System.out.println("Checking " + list2.size() + " classes");
        int n2 = 0;
        block2: for (ReferenceType referenceType : list2) {
            ++n2;
            try {
                for (Location location : referenceType.allLineLocations()) {
                    SourcePosition sourcePosition = (SourcePosition)ReadAction.compute(() -> {
                        try {
                            return positionManagerImpl.getSourcePosition(location);
                        }
                        catch (NoDataException noDataException) {
                            return null;
                        }
                    });
                    if (sourcePosition == null) continue;
                    if (sourcePosition.getFile() instanceof PsiCompiledFile) {
                        VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
                        if (virtualFile == null || virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY) == null) continue block2;
                        if (DebuggerUtilsEx.bytecodeToSourceLine(sourcePosition.getFile(), location.lineNumber()) == -1) continue;
                    }
                    if (SourceCodeChecker.a(location, sourcePosition, debugProcessImpl.getProject()) != ThreeState.NO) continue;
                    System.out.println("failed " + referenceType);
                }
            }
            catch (AbsentInformationException absentInformationException) {}
        }
        System.out.println("Done checking");
    }

    private static /* synthetic */ void a(FileEditor fileEditor) {
        HintManager.getInstance().showErrorHint(((TextEditor)fileEditor).getEditor(), DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]));
    }
}

