/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface ClassesByNameProvider {
    public List<ReferenceType> get(@NotNull String var1);

    public static ClassesByNameProvider createCache(List<ReferenceType> list2) {
        return new Cache(list2);
    }

    public static final class Cache
    implements ClassesByNameProvider {
        private final MultiMap<String, ReferenceType> a = new MultiMap();

        public Cache(List<ReferenceType> list2) {
            list2.forEach(referenceType -> this.a.putValue((Object)referenceType.signature(), referenceType));
        }

        @Override
        public List<ReferenceType> get(@NotNull String string) {
            String string2;
            if (string == null) {
                Cache.a(0);
            }
            if ((string2 = VirtualMachineProxyImpl.JNITypeParserReflect.typeNameToSignature(string)) != null) {
                return (List)this.a.get((Object)string2);
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/debugger/jdi/ClassesByNameProvider$Cache", "get"));
        }
    }
}

