/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger e = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    private final ThreadReferenceProxyImpl f;
    private final int i;
    private int d;
    private StackFrame h;
    private ObjectReference g;
    private ClassLoaderReference c;
    private ThreeState b;
    private Map<LocalVariable, Value> j;

    public StackFrameProxyImpl(@NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl, @NotNull StackFrame stackFrame, int n2) {
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.b(0);
        }
        if (stackFrame == null) {
            StackFrameProxyImpl.b(1);
        }
        super(threadReferenceProxyImpl.getVirtualMachine());
        this.d = -1;
        this.b = ThreeState.UNSURE;
        this.f = threadReferenceProxyImpl;
        this.i = n2;
        this.h = stackFrame;
    }

    public boolean isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.b != ThreeState.UNSURE) {
            return this.b.toBoolean();
        }
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                Method method = DebuggerUtilsEx.getMethod(this.location());
                boolean bl2 = this.getVirtualMachine().canRedefineClasses() && (method == null || method.isObsolete());
                this.b = ThreeState.fromBoolean((boolean)bl2);
                return bl2;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 23) {
                    this.b = ThreeState.YES;
                    return true;
                }
                throw internalException;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @Override
    public boolean isValid() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!super.isValid()) {
            return false;
        }
        try {
            if (this.h != null) {
                this.h.location();
            }
            return true;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (e.isDebugEnabled()) {
            e.debug("caches cleared " + super.toString());
        }
        this.d = -1;
        this.h = null;
        this.b = ThreeState.UNSURE;
        this.g = null;
        this.c = null;
        this.j = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.h == null) {
            try {
                ThreadReference threadReference = this.f.getThreadReference();
                this.h = threadReference.frame(this.getFrameIndex());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new EvaluateException(indexOutOfBoundsException.getMessage(), (Throwable)indexOutOfBoundsException);
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
            }
        }
        return this.h;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.d == -1) {
            int n2 = this.f.frameCount();
            if (this.i > n2) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.d = n2 - this.i;
        }
        return this.d;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            StackFrameProxyImpl.b(2);
        }
        return virtualMachineProxyImpl;
    }

    public Location location() throws EvaluateException {
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @NotNull
    public ThreadReferenceProxyImpl threadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.f;
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.b(3);
        }
        return threadReferenceProxyImpl;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException evaluateException) {
            return "StackFrameProxyImpl: " + evaluateException.getMessage() + "; frameFromBottom = " + this.i + " threadName = " + this.threadProxy().name();
        }
    }

    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        try {
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    if (this.g == null) {
                        this.g = this.getStackFrame().thisObject();
                    }
                    break;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() != 23 && internalException.errorCode() != 35) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)internalException);
            }
            e.info("Exception while getting this object", (Throwable)internalException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            e.info("Exception while getting this object", (Throwable)illegalArgumentException);
        }
        return this.g;
    }

    @NotNull
    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            ArrayList<LocalVariableProxyImpl> arrayList;
            try {
                List<LocalVariable> list2 = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> arrayList2 = new ArrayList<LocalVariableProxyImpl>(list2.size());
                for (LocalVariable localVariable : list2) {
                    e.assertTrue(localVariable != null);
                    arrayList2.add(new LocalVariableProxyImpl(this, localVariable));
                }
                arrayList = arrayList2;
            }
            catch (InvalidStackFrameException | IllegalArgumentException runtimeException) {
                throwable = runtimeException;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            if (arrayList == null) {
                StackFrameProxyImpl.b(4);
            }
            return arrayList;
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public LocalVariableProxyImpl visibleVariableByName(String string) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable localVariable = this.visibleVariableByNameInt(string);
        return localVariable != null ? new LocalVariableProxyImpl(this, localVariable) : null;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String string) throws EvaluateException {
        LocalVariable localVariable;
        if (string == null) {
            StackFrameProxyImpl.b(5);
        }
        return (localVariable = this.visibleVariableByNameInt(string)) != null ? this.getValue(new LocalVariableProxyImpl(this, localVariable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String string) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                return this.getStackFrame().visibleVariableByName(string);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                try {
                    throwable = invalidStackFrameException;
                    this.clearCaches();
                    continue;
                }
                catch (AbsentInformationException | InvalidStackFrameException exception) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public Value getValue(LocalVariableProxyImpl localVariableProxyImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                Map<LocalVariable, Value> map = this.a();
                LocalVariable localVariable = localVariableProxyImpl.getVariable();
                if (map.containsKey(localVariable)) {
                    return map.get(localVariable);
                }
                return this.getStackFrame().getValue(localVariable);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35 || internalException.errorCode() == 101) {
                    throw new EvaluateException(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}), (Throwable)internalException);
                }
                throw internalException;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    @NotNull
    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            List<Value> list2;
            try {
                StackFrame stackFrame = this.getStackFrame();
                list2 = stackFrame != null ? stackFrame.getArgumentValues() : Collections.emptyList();
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 32) {
                    List<Value> list3 = Collections.emptyList();
                    if (list3 == null) {
                        StackFrameProxyImpl.b(7);
                    }
                    return list3;
                }
                throw internalException;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            if (list2 == null) {
                StackFrameProxyImpl.b(6);
            }
            return list2;
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    private Map<LocalVariable, Value> a() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.j == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.j = new THashMap(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            catch (InternalException internalException) {
                if (internalException.errorCode() == 35 || internalException.errorCode() == 101) {
                    e.info((Throwable)internalException);
                    this.j = new THashMap();
                }
                throw internalException;
            }
        }
        return this.j;
    }

    public void setValue(LocalVariableProxyImpl localVariableProxyImpl, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                LocalVariable localVariable = localVariableProxyImpl.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(localVariable, value instanceof ObjectReference ? (ObjectReference)value : value);
                if (this.j != null) {
                    this.j.put(localVariable, stackFrame.getValue(localVariable));
                }
                return;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public int hashCode() {
        return 31 * this.f.hashCode() + this.i;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)object;
        if (stackFrameProxyImpl == this) {
            return true;
        }
        return this.i == stackFrameProxyImpl.i && this.f.equals(stackFrameProxyImpl.f);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl localVariableProxyImpl) throws EvaluateException {
        try {
            return localVariableProxyImpl.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.c == null) {
            this.c = this.location().declaringType().classLoader();
        }
        return this.c;
    }

    public boolean isBottom() {
        return this.i == 1;
    }

    public int getIndexFromBottom() {
        return this.i;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "threadProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleVariables";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visibleValueByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

