/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.engine.jdi.ThreadGroupReferenceProxy;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ThreadGroupReference;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;

public class ThreadGroupReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadGroupReferenceProxy {
    private static final Logger h = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl");
    private ThreadGroupReferenceProxyImpl f;
    private boolean g = false;
    private String i;

    public ThreadGroupReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxyImpl, ThreadGroupReference threadGroupReference) {
        super(virtualMachineProxyImpl, threadGroupReference);
    }

    public ThreadGroupReference getThreadGroupReference() {
        return (ThreadGroupReference)this.getObjectReference();
    }

    public String name() {
        this.checkValid();
        if (this.i == null) {
            this.i = this.getThreadGroupReference().name();
        }
        return this.i;
    }

    public ThreadGroupReferenceProxyImpl parent() {
        this.checkValid();
        if (!this.g) {
            this.f = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(this.getThreadGroupReference().parent());
            this.g = true;
        }
        return this.f;
    }

    @Override
    @NonNls
    public String toString() {
        return "ThreadGroupReferenceProxy: " + this.getThreadGroupReference().toString();
    }

    public void suspend() {
        this.getThreadGroupReference().suspend();
    }

    public void resume() {
        this.getThreadGroupReference().resume();
    }

    public List<ThreadReferenceProxyImpl> threads() {
        return StreamEx.of(this.getThreadGroupReference().threads()).map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public List<ThreadGroupReferenceProxyImpl> threadGroups() {
        return StreamEx.of(this.getThreadGroupReference().threadGroups()).map(this.getVirtualMachineProxy()::getThreadGroupReferenceProxy).toList();
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
    }
}

