/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.Patches;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.JdiTimer;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StringReferenceProxy;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThreeState;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.jdi.JNITypeParser;
import com.sun.tools.jdi.TargetVM;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualMachineProxyImpl
implements JdiTimer,
VirtualMachineProxy {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.jdi.VirtualMachineProxyImpl");
    private final DebugProcessImpl l;
    private final VirtualMachine G;
    private int u;
    private int c;
    private final Map<ObjectReference, ObjectReferenceProxyImpl> i;
    private final Map<String, StringReference> s;
    @NotNull
    private final Map<ThreadReference, ThreadReferenceProxyImpl> h;
    private final Map<ThreadGroupReference, ThreadGroupReferenceProxyImpl> x;
    private boolean g;
    private List<ReferenceType> D;
    private Map<ReferenceType, List<ReferenceType>> C;
    public final Throwable mySuspendLogger;
    private final boolean k;
    private final boolean f;
    private final Capability a;
    private final Capability j;
    private final Capability n;
    private final Capability B;
    private final Capability y;
    private final Capability q;
    private final Capability t;
    private final Capability z;
    private final Capability E;
    private final Capability d;
    private final Capability A;
    private final Capability p;
    private final Capability F;
    private final Capability o;
    private final Capability v;
    private final Capability e;
    private final Capability w;
    private final Capability r;
    private final Capability m;

    public VirtualMachineProxyImpl(DebugProcessImpl debugProcessImpl, @NotNull VirtualMachine virtualMachine) {
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(0);
        }
        this.u = 0;
        this.c = 0;
        this.i = new HashMap<ObjectReference, ObjectReferenceProxyImpl>();
        this.s = new HashMap<String, StringReference>();
        this.h = new ConcurrentHashMap<ThreadReference, ThreadReferenceProxyImpl>();
        this.x = new HashMap<ThreadGroupReference, ThreadGroupReferenceProxyImpl>();
        this.g = true;
        this.C = new HashMap<ReferenceType, List<ReferenceType>>();
        this.mySuspendLogger = new Throwable();
        this.a = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canWatchFieldModification();
            }
        };
        this.j = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canWatchFieldAccess();
            }
        };
        this.n = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.isJ2ME();
            }
        };
        this.B = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetBytecodes();
            }
        };
        this.y = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetSyntheticAttribute();
            }
        };
        this.q = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetOwnedMonitorInfo();
            }
        };
        this.t = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetMonitorFrameInfo();
            }
        };
        this.z = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetCurrentContendedMonitor();
            }
        };
        this.E = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canGetMonitorInfo();
            }
        };
        this.d = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canUseInstanceFilters();
            }
        };
        this.A = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canRedefineClasses();
            }
        };
        this.p = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canAddMethod();
            }
        };
        this.F = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canUnrestrictedlyRedefineClasses();
            }
        };
        this.o = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canPopFrames();
            }
        };
        this.v = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.G.canForceEarlyReturn();
            }
        };
        this.e = new Capability(){

            @Override
            protected boolean calcValue() {
                if (!VirtualMachineProxyImpl.this.k) {
                    return false;
                }
                try {
                    Method method = VirtualMachine.class.getMethod("canGetInstanceInfo", new Class[0]);
                    return (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.G, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    b.error((Throwable)reflectiveOperationException);
                }
                return false;
            }
        };
        this.w = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canGetSourceDebugExtension();
            }
        };
        this.r = new Capability(){

            @Override
            protected boolean calcValue() {
                return VirtualMachineProxyImpl.this.f && VirtualMachineProxyImpl.this.G.canRequestVMDeathEvent();
            }
        };
        this.m = new Capability(){

            @Override
            protected boolean calcValue() {
                if (VirtualMachineProxyImpl.this.k) {
                    try {
                        Method method = VirtualMachine.class.getDeclaredMethod("canGetMethodReturnValues", new Class[0]);
                        Boolean bl2 = (Boolean)method.invoke((Object)VirtualMachineProxyImpl.this.G, new Object[0]);
                        return bl2;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                        // empty catch block
                    }
                }
                return false;
            }
        };
        this.G = virtualMachine;
        this.l = debugProcessImpl;
        this.k = this.versionHigher("1.5");
        this.f = this.k || this.versionHigher("1.4");
        this.canRedefineClasses();
        this.canWatchFieldModification();
        this.canPopFrames();
        try {
            virtualMachine.allClasses();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw vMDisconnectedException;
        }
        catch (Throwable throwable) {
            b.info(throwable);
        }
        virtualMachine.topLevelThreadGroups().forEach(this::threadGroupCreated);
    }

    @NotNull
    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = this.G;
        if (virtualMachine == null) {
            VirtualMachineProxyImpl.a(1);
        }
        return virtualMachine;
    }

    public ClassesByNameProvider getClassesByNameProvider() {
        return this::classesByName;
    }

    public List<ReferenceType> classesByName(@NotNull String string) {
        if (string == null) {
            VirtualMachineProxyImpl.a(2);
        }
        return this.G.classesByName(string);
    }

    public List<ReferenceType> nestedTypes(ReferenceType referenceType) {
        List<Object> list2 = this.C.get(referenceType);
        if (list2 == null) {
            List<Object> list3 = Collections.emptyList();
            try {
                list3 = referenceType.nestedTypes();
            }
            catch (Throwable throwable) {
                b.info(throwable);
            }
            if (!list3.isEmpty()) {
                HashSet<Object> hashSet = new HashSet<Object>();
                ClassLoaderReference classLoaderReference = referenceType.classLoader();
                for (Object object : list3) {
                    try {
                        if (!(classLoaderReference == null ? object.classLoader() == null : classLoaderReference.equals(object.classLoader()))) continue;
                        hashSet.add(object);
                    }
                    catch (ObjectCollectedException objectCollectedException) {}
                }
                if (!hashSet.isEmpty()) {
                    HashSet hashSet2 = new HashSet();
                    for (ReferenceType referenceType2 : hashSet) {
                        hashSet2.addAll(this.nestedTypes(referenceType2));
                    }
                    hashSet.removeAll(hashSet2);
                }
                list2 = hashSet.isEmpty() ? Collections.emptyList() : new ArrayList(hashSet);
            } else {
                list2 = Collections.emptyList();
            }
            this.C.put(referenceType, list2);
        }
        return list2;
    }

    public List<ReferenceType> allClasses() {
        List<ReferenceType> list2 = this.D;
        if (list2 == null) {
            this.D = list2 = this.G.allClasses();
        }
        return list2;
    }

    public String toString() {
        return this.G.toString();
    }

    public void redefineClasses(Map<ReferenceType, byte[]> map) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.G.redefineClasses(map);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<ThreadReferenceProxyImpl> allThreads() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.g) {
            this.g = false;
            for (ThreadReference threadReference : this.G.allThreads()) {
                this.getThreadReferenceProxy(threadReference);
            }
        }
        return new ArrayList<ThreadReferenceProxyImpl>(this.h.values());
    }

    public void threadStarted(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.getThreadReferenceProxy(threadReference);
    }

    public void threadStopped(ThreadReference threadReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.h.remove(threadReference);
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ++this.c;
        this.G.suspend();
        this.clearCaches();
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.c > 0) {
            --this.c;
        }
        this.clearCaches();
        b.debug("before resume VM");
        try {
            this.G.resume();
        }
        catch (InternalException internalException) {
            b.info((Throwable)internalException);
        }
        b.debug("VM resumed");
    }

    public List<ThreadGroupReferenceProxyImpl> topLevelThreadGroups() {
        return StreamEx.of(this.getVirtualMachine().topLevelThreadGroups()).map(this::getThreadGroupReferenceProxy).toList();
    }

    public void threadGroupCreated(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!this.isJ2ME()) {
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.x.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
    }

    public boolean isJ2ME() {
        return VirtualMachineProxyImpl.a(this.getVirtualMachine());
    }

    private static boolean a(VirtualMachine virtualMachine) {
        return virtualMachine.version().startsWith("1.0");
    }

    public void threadGroupRemoved(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.x.remove(threadGroupReference);
    }

    public EventQueue eventQueue() {
        return this.G.eventQueue();
    }

    public EventRequestManager eventRequestManager() {
        return this.G.eventRequestManager();
    }

    @Deprecated
    public VoidValue mirrorOf() throws EvaluateException {
        return this.mirrorOfVoid();
    }

    public VoidValue mirrorOfVoid() {
        return this.G.mirrorOfVoid();
    }

    public BooleanValue mirrorOf(boolean bl2) {
        return this.G.mirrorOf(bl2);
    }

    public ByteValue mirrorOf(byte by2) {
        return this.G.mirrorOf(by2);
    }

    public CharValue mirrorOf(char c2) {
        return this.G.mirrorOf(c2);
    }

    public ShortValue mirrorOf(short s2) {
        return this.G.mirrorOf(s2);
    }

    public IntegerValue mirrorOf(int n2) {
        return this.G.mirrorOf(n2);
    }

    public LongValue mirrorOf(long l2) {
        return this.G.mirrorOf(l2);
    }

    public FloatValue mirrorOf(float f2) {
        return this.G.mirrorOf(f2);
    }

    public DoubleValue mirrorOf(double d2) {
        return this.G.mirrorOf(d2);
    }

    public StringReference mirrorOf(String string) {
        return this.G.mirrorOf(string);
    }

    public StringReference mirrorOfStringLiteral(String string, ThrowableComputable<StringReference, EvaluateException> throwableComputable) throws EvaluateException {
        StringReference stringReference = this.s.get(string);
        if (stringReference != null && !stringReference.isCollected()) {
            return stringReference;
        }
        stringReference = (StringReference)throwableComputable.compute();
        this.s.put(string, stringReference);
        return stringReference;
    }

    public Process process() {
        return this.G.process();
    }

    public void dispose() {
        try {
            this.G.dispose();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            b.info((Throwable)unsupportedOperationException);
        }
        finally {
            Thread thread;
            TargetVM targetVM;
            if (Patches.JDK_BUG_EVENT_CONTROLLER_LEAK && (targetVM = (TargetVM)ReflectionUtil.getField(this.G.getClass(), (Object)this.G, TargetVM.class, (String)"target")) != null && (thread = (Thread)ReflectionUtil.getField(targetVM.getClass(), (Object)targetVM, Thread.class, (String)"eventController")) != null) {
                thread.stop();
            }
        }
    }

    public void exit(int n2) {
        this.G.exit(n2);
    }

    public boolean canWatchFieldModification() {
        return this.a.isAvailable();
    }

    public boolean canWatchFieldAccess() {
        return this.j.isAvailable();
    }

    public boolean canInvokeMethods() {
        return !this.n.isAvailable();
    }

    public boolean canGetBytecodes() {
        return this.B.isAvailable();
    }

    public boolean canGetSyntheticAttribute() {
        return this.y.isAvailable();
    }

    public boolean canGetOwnedMonitorInfo() {
        return this.q.isAvailable();
    }

    public boolean canGetMonitorFrameInfo() {
        return this.t.isAvailable();
    }

    public boolean canGetCurrentContendedMonitor() {
        return this.z.isAvailable();
    }

    public boolean canGetMonitorInfo() {
        return this.E.isAvailable();
    }

    public boolean canUseInstanceFilters() {
        return this.d.isAvailable();
    }

    public boolean canRedefineClasses() {
        return this.A.isAvailable();
    }

    public boolean canAddMethod() {
        return this.p.isAvailable();
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return this.F.isAvailable();
    }

    public boolean canPopFrames() {
        return this.o.isAvailable();
    }

    public boolean canForceEarlyReturn() {
        return this.v.isAvailable();
    }

    public boolean canGetInstanceInfo() {
        return this.e.isAvailable();
    }

    public final boolean versionHigher(String string) {
        return this.G.version().compareTo(string) >= 0;
    }

    public boolean canGetSourceDebugExtension() {
        return this.w.isAvailable();
    }

    public boolean canRequestVMDeathEvent() {
        return this.r.isAvailable();
    }

    public boolean canGetMethodReturnValues() {
        return this.m.isAvailable();
    }

    public String getDefaultStratum() {
        return this.f ? this.G.getDefaultStratum() : null;
    }

    public String description() {
        return this.G.description();
    }

    public String version() {
        return this.G.version();
    }

    public String name() {
        return this.G.name();
    }

    public void setDebugTraceMode(int n2) {
        this.G.setDebugTraceMode(n2);
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public ThreadReferenceProxyImpl getThreadReferenceProxy(@Nullable ThreadReference threadReference2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadReference2 == null) {
            return null;
        }
        return this.h.computeIfAbsent(threadReference2, threadReference -> new ThreadReferenceProxyImpl(this, (ThreadReference)threadReference));
    }

    public ThreadGroupReferenceProxyImpl getThreadGroupReferenceProxy(ThreadGroupReference threadGroupReference) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (threadGroupReference == null) {
            return null;
        }
        ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl = this.x.get(threadGroupReference);
        if (threadGroupReferenceProxyImpl == null && !this.n.isAvailable()) {
            threadGroupReferenceProxyImpl = new ThreadGroupReferenceProxyImpl(this, threadGroupReference);
            this.x.put(threadGroupReference, threadGroupReferenceProxyImpl);
        }
        return threadGroupReferenceProxyImpl;
    }

    public ObjectReferenceProxyImpl getObjectReferenceProxy(ObjectReference objectReference) {
        if (objectReference != null) {
            if (objectReference instanceof ThreadReference) {
                return this.getThreadReferenceProxy((ThreadReference)objectReference);
            }
            if (objectReference instanceof ThreadGroupReference) {
                return this.getThreadGroupReferenceProxy((ThreadGroupReference)objectReference);
            }
            ObjectReferenceProxyImpl objectReferenceProxyImpl = this.i.get(objectReference);
            if (objectReferenceProxyImpl == null) {
                objectReferenceProxyImpl = objectReference instanceof StringReference ? new StringReferenceProxy(this, (StringReference)objectReference) : new ObjectReferenceProxyImpl(this, objectReference);
                this.i.put(objectReference, objectReferenceProxyImpl);
            }
            return objectReferenceProxyImpl;
        }
        return null;
    }

    public boolean equals(Object object) {
        b.assertTrue(object instanceof VirtualMachineProxyImpl);
        return this.G.equals(((VirtualMachineProxyImpl)object).getVirtualMachine());
    }

    public int hashCode() {
        return this.G.hashCode();
    }

    public void clearCaches() {
        b.debug("VM cleared");
        this.D = null;
        if (!this.C.isEmpty()) {
            this.C = new HashMap<ReferenceType, List<ReferenceType>>(this.C.size());
        }
        ++this.u;
    }

    @Override
    public int getCurrentTime() {
        return this.u;
    }

    public DebugProcess getDebugProcess() {
        return this.l;
    }

    public static boolean isCollected(ObjectReference objectReference) {
        try {
            return !VirtualMachineProxyImpl.a(objectReference.virtualMachine()) && objectReference.isCollected();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            b.info((Throwable)unsupportedOperationException);
            return false;
        }
    }

    public String getResumeStack() {
        return StringUtil.getThrowableText((Throwable)this.mySuspendLogger);
    }

    public boolean isPausePressed() {
        return this.c > 0;
    }

    public boolean isSuspended() {
        return this.allThreads().stream().anyMatch(threadReferenceProxyImpl -> threadReferenceProxyImpl.getSuspendCount() != 0);
    }

    public void logThreads() {
        if (b.isDebugEnabled()) {
            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : this.allThreads()) {
                if (threadReferenceProxyImpl.isCollected()) continue;
                b.debug("suspends " + threadReferenceProxyImpl + " " + threadReferenceProxyImpl.getSuspendCount() + " " + threadReferenceProxyImpl.isSuspended());
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/VirtualMachineProxyImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "classesByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class Capability {
        private ThreeState a = ThreeState.UNSURE;

        private Capability() {
        }

        public final boolean isAvailable() {
            if (this.a == ThreeState.UNSURE) {
                try {
                    this.a = ThreeState.fromBoolean((boolean)this.calcValue());
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    b.info((Throwable)vMDisconnectedException);
                    this.a = ThreeState.NO;
                }
            }
            return this.a.toBoolean();
        }

        protected abstract boolean calcValue();
    }

    static final class JNITypeParserReflect {
        static final Method typeNameToSignatureMethod = ReflectionUtil.getDeclaredMethod(JNITypeParser.class, (String)"typeNameToSignature", (Class[])new Class[]{String.class});

        JNITypeParserReflect() {
        }

        @Nullable
        static String typeNameToSignature(@NotNull String string) {
            if (string == null) {
                JNITypeParserReflect.a(0);
            }
            if (typeNameToSignatureMethod != null) {
                try {
                    return (String)typeNameToSignatureMethod.invoke(null, string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        static {
            if (typeNameToSignatureMethod == null) {
                b.warn("Unable to find JNITypeParser.typeNameToSignature method");
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/jdi/VirtualMachineProxyImpl$JNITypeParserReflect", "typeNameToSignature"));
        }
    }
}

