/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.component;

import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="InstancesTracker", storages={@Storage(value="$WORKSPACE_FILE$")})
public class InstancesTracker
extends AbstractProjectComponent
implements PersistentStateComponent<MyState> {
    private final EventDispatcher<InstancesTrackerListener> a = EventDispatcher.create(InstancesTrackerListener.class);
    private MyState b = new MyState();

    public InstancesTracker(Project project2) {
        super(project2);
    }

    public static InstancesTracker getInstance(@NotNull Project project2) {
        if (project2 == null) {
            InstancesTracker.a(0);
        }
        return (InstancesTracker)((Object)project2.getComponent(InstancesTracker.class));
    }

    public boolean isTracked(@NotNull String string) {
        if (string == null) {
            InstancesTracker.a(1);
        }
        return this.b.classes.containsKey(string);
    }

    public boolean isBackgroundTrackingEnabled() {
        return this.b.isBackgroundTrackingEnabled;
    }

    @Nullable
    public TrackingType getTrackingType(@NotNull String string) {
        if (string == null) {
            InstancesTracker.a(2);
        }
        return this.b.classes.getOrDefault(string, null);
    }

    @NotNull
    public Map<String, TrackingType> getTrackedClasses() {
        HashMap<String, TrackingType> hashMap = new HashMap<String, TrackingType>(this.b.classes);
        if (hashMap == null) {
            InstancesTracker.a(3);
        }
        return hashMap;
    }

    public void add(@NotNull String string, @NotNull TrackingType trackingType) {
        if (string == null) {
            InstancesTracker.a(4);
        }
        if (trackingType == null) {
            InstancesTracker.a(5);
        }
        if (trackingType.equals(this.b.classes.getOrDefault(string, null))) {
            return;
        }
        this.b.classes.put(string, trackingType);
        ((InstancesTrackerListener)this.a.getMulticaster()).classChanged(string, trackingType);
    }

    public void remove(@NotNull String string) {
        TrackingType trackingType;
        if (string == null) {
            InstancesTracker.a(6);
        }
        if ((trackingType = this.b.classes.remove(string)) != null) {
            ((InstancesTrackerListener)this.a.getMulticaster()).classRemoved(string);
        }
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener instancesTrackerListener) {
        if (instancesTrackerListener == null) {
            InstancesTracker.a(7);
        }
        this.a.addListener((EventListener)instancesTrackerListener);
    }

    public void addTrackerListener(@NotNull InstancesTrackerListener instancesTrackerListener, @NotNull Disposable disposable) {
        if (instancesTrackerListener == null) {
            InstancesTracker.a(8);
        }
        if (disposable == null) {
            InstancesTracker.a(9);
        }
        this.a.addListener((EventListener)instancesTrackerListener, disposable);
    }

    public void removeTrackerListener(@NotNull InstancesTrackerListener instancesTrackerListener) {
        if (instancesTrackerListener == null) {
            InstancesTracker.a(10);
        }
        this.a.removeListener((EventListener)instancesTrackerListener);
    }

    public void setBackgroundTackingEnabled(boolean bl2) {
        boolean bl3 = this.b.isBackgroundTrackingEnabled;
        if (bl2 != bl3) {
            this.b.isBackgroundTrackingEnabled = bl2;
            ((InstancesTrackerListener)this.a.getMulticaster()).backgroundTrackingValueChanged(bl2);
        }
    }

    @Nullable
    public MyState getState() {
        return new MyState(this.b);
    }

    public void loadState(@NotNull MyState myState) {
        if (myState == null) {
            InstancesTracker.a(11);
        }
        this.b = new MyState(myState);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/component/InstancesTracker";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/component/InstancesTracker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTrackedClasses";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTracked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTrackingType";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addTrackerListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeTrackerListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyState {
        boolean isBackgroundTrackingEnabled;
        @XCollection(elementTypes={Map.Entry.class})
        final Map<String, TrackingType> classes;

        MyState() {
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
        }

        MyState(@NotNull MyState myState) {
            if (myState == null) {
                MyState.a(0);
            }
            this.isBackgroundTrackingEnabled = false;
            this.classes = new ConcurrentHashMap<String, TrackingType>();
            this.isBackgroundTrackingEnabled = myState.isBackgroundTrackingEnabled;
            for (Map.Entry<String, TrackingType> entry : myState.classes.entrySet()) {
                this.classes.put(entry.getKey(), entry.getValue());
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/debugger/memory/component/InstancesTracker$MyState", "<init>"));
        }
    }
}

