/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.component.MemoryViewManager;
import com.intellij.debugger.memory.component.MemoryViewManagerState;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.event.MemoryViewManagerListener;
import com.intellij.debugger.memory.tracking.ConstructorInstancesTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.tracking.TrackingType;
import com.intellij.debugger.memory.ui.ClassesTable;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.KeyboardUtils;
import com.intellij.debugger.memory.utils.LowestPriorityCommand;
import com.intellij.debugger.memory.utils.SingleAlarmWithMutableDelay;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.ClassPrepareRequest;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesFilteredView
extends BorderLayoutPanel
implements Disposable {
    private static final Logger a = Logger.getInstance(ClassesFilteredView.class);
    private static final double r = 0.5;
    private static final double n = TimeUnit.SECONDS.toMillis(2L);
    private static final int f = Integer.MAX_VALUE;
    private static final String o = "The application is running";
    private static final String i = "Classes are not available";
    private static final String c = "Click to load the classes list";
    private final Project p;
    private final SingleAlarmWithMutableDelay d;
    private final SearchTextField k;
    private final ClassesTable h;
    private final InstancesTracker e;
    private final Map<ReferenceType, ConstructorInstancesTracker> j;
    private final MyDebuggerSessionListener l;
    private final AtomicInteger m;
    private final AtomicInteger g;
    private final AtomicBoolean q;
    private volatile boolean b;

    public ClassesFilteredView(final @NotNull XDebugSession xDebugSession, final @NotNull DebugProcessImpl debugProcessImpl, final @NotNull InstancesTracker instancesTracker) {
        if (xDebugSession == null) {
            ClassesFilteredView.a(0);
        }
        if (debugProcessImpl == null) {
            ClassesFilteredView.a(1);
        }
        if (instancesTracker == null) {
            ClassesFilteredView.a(2);
        }
        this.k = new FilterTextField();
        this.j = new ConcurrentHashMap<ReferenceType, ConstructorInstancesTracker>();
        this.m = new AtomicInteger(0);
        this.g = new AtomicInteger(Integer.MIN_VALUE);
        this.q = new AtomicBoolean(false);
        this.p = xDebugSession.getProject();
        final DebuggerManagerThreadImpl debuggerManagerThreadImpl = debugProcessImpl.getManagerThread();
        this.e = instancesTracker;
        final InstancesTrackerListener instancesTrackerListener = new InstancesTrackerListener(){

            @Override
            public void classChanged(@NotNull String string, final @NotNull TrackingType trackingType) {
                ReferenceType referenceType;
                if (string == null) {
                    1.b(0);
                }
                if (trackingType == null) {
                    1.b(1);
                }
                if ((referenceType = ClassesFilteredView.this.h.getClassByName(string)) != null) {
                    final boolean bl2 = ClassesFilteredView.this.q.get();
                    debuggerManagerThreadImpl.schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() {
                            ClassesFilteredView.this.a(xDebugSession, referenceType, trackingType, bl2);
                        }
                    });
                }
                ClassesFilteredView.this.h.repaint();
            }

            @Override
            public void classRemoved(@NotNull String string) {
                ReferenceType referenceType;
                if (string == null) {
                    1.b(2);
                }
                if ((referenceType = ClassesFilteredView.this.h.getClassByName(string)) != null && ClassesFilteredView.this.j.containsKey(referenceType)) {
                    ConstructorInstancesTracker constructorInstancesTracker = (ConstructorInstancesTracker)ClassesFilteredView.this.j.remove(referenceType);
                    Disposer.dispose((Disposable)constructorInstancesTracker);
                    ClassesFilteredView.this.h.getRowSorter().allRowsChanged();
                }
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "classRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        xDebugSession.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                xDebugSession.removeSessionListener((XDebugSessionListener)this);
                ClassesFilteredView.this.e.removeTrackerListener(instancesTrackerListener);
            }
        });
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){

            public void processAttached(DebugProcess debugProcess) {
                debugProcessImpl.removeDebugProcessListener(this);
                debuggerManagerThreadImpl.invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() {
                        boolean bl2 = ClassesFilteredView.this.q.get();
                        VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                        instancesTracker.getTrackedClasses().forEach((string, trackingType) -> {
                            List<ReferenceType> list2;
                            if (xDebugSession == null) {
                                1.a(0);
                            }
                            if (debugProcessImpl == null) {
                                1.a(1);
                            }
                            if ((list2 = virtualMachineProxyImpl.classesByName((String)string)).isEmpty()) {
                                this.a(string, xDebugSession, debugProcessImpl, trackingType);
                            } else {
                                for (ReferenceType referenceType : list2) {
                                    ClassesFilteredView.this.a(xDebugSession, referenceType, trackingType, bl2);
                                }
                            }
                        });
                        instancesTracker.addTrackerListener(instancesTrackerListener);
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugSession";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3$1";
                        objectArray[2] = "lambda$action$0";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            private void a(@NotNull String string, final @NotNull XDebugSession xDebugSession2, final @NotNull DebugProcessImpl debugProcessImpl2, final @NotNull TrackingType trackingType) {
                if (string == null) {
                    3.a(0);
                }
                if (xDebugSession2 == null) {
                    3.a(1);
                }
                if (debugProcessImpl2 == null) {
                    3.a(2);
                }
                if (trackingType == null) {
                    3.a(3);
                }
                ClassPrepareRequestor classPrepareRequestor = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
                        debugProcessImpl2.getRequestsManager().deleteRequest((Requestor)this);
                        ClassesFilteredView.this.a(xDebugSession2, referenceType, trackingType, ClassesFilteredView.this.q.get());
                    }
                };
                ClassPrepareRequest classPrepareRequest = debugProcessImpl2.getRequestsManager().createClassPrepareRequest(classPrepareRequestor, string);
                if (classPrepareRequest != null) {
                    classPrepareRequest.enable();
                } else {
                    a.warn("Cannot create a 'class prepare' request. Class " + string + " not tracked.");
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "className";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "session";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "process";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$3";
                objectArray[2] = "trackWhenPrepared";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        MemoryViewManagerState memoryViewManagerState2 = MemoryViewManager.getInstance().getState();
        this.h = new ClassesTable(instancesTracker, this, memoryViewManagerState2.isShowWithDiffOnly, memoryViewManagerState2.isShowWithInstancesOnly, memoryViewManagerState2.isShowTrackedOnly);
        this.h.getEmptyText().setText(o);
        Disposer.register((Disposable)this, (Disposable)this.h);
        this.h.addMouseMotionListener(new MyMouseMotionListener());
        this.h.addMouseListener(new MyOpenNewInstancesListener());
        new MyDoubleClickListener().installOn((Component)((Object)this.h));
        this.h.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                int n2 = keyEvent.getKeyCode();
                if (KeyboardUtils.isEnterKey(n2)) {
                    ClassesFilteredView.this.a(ClassesFilteredView.this.h.getSelectedClass());
                } else if (KeyboardUtils.isCharacter(n2) || KeyboardUtils.isBackSpace(n2)) {
                    String string = ClassesFilteredView.this.k.getText();
                    String string2 = KeyboardUtils.isBackSpace(n2) ? string.substring(0, string.length() - 1) : string + keyEvent.getKeyChar();
                    ClassesFilteredView.this.k.setText(string2);
                    IdeFocusManager.getInstance((Project)ClassesFilteredView.this.p).requestFocus((Component)ClassesFilteredView.this.k, false);
                }
            }
        });
        this.k.addKeyboardListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                this.a(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                this.a(keyEvent);
            }

            private void a(KeyEvent keyEvent) {
                int n2 = keyEvent.getKeyCode();
                if (ClassesFilteredView.this.h.isInClickableMode() && (KeyboardUtils.isCharacter(n2) || KeyboardUtils.isEnterKey(n2))) {
                    ClassesFilteredView.this.h.exitClickableMode();
                    ClassesFilteredView.this.a(true);
                } else if (KeyboardUtils.isUpDownKey(n2) || KeyboardUtils.isEnterKey(n2)) {
                    ClassesFilteredView.this.h.dispatchEvent(keyEvent);
                }
            }
        });
        this.k.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                ClassesFilteredView.this.h.setFilterPattern(ClassesFilteredView.this.k.getText());
            }
        });
        MemoryViewManagerListener memoryViewManagerListener = memoryViewManagerState -> {
            this.h.setFilteringByDiffNonZero(memoryViewManagerState.isShowWithDiffOnly);
            this.h.setFilteringByInstanceExists(memoryViewManagerState.isShowWithInstancesOnly);
            this.h.setFilteringByTrackingState(memoryViewManagerState.isShowTrackedOnly);
            if (memoryViewManagerState.isAutoUpdateModeOn && this.h.isInClickableMode()) {
                this.a(true);
            }
        };
        MemoryViewManager.getInstance().addMemoryViewManagerListener(memoryViewManagerListener, this);
        this.l = new MyDebuggerSessionListener();
        xDebugSession.addSessionListener((XDebugSessionListener)this.l, (Disposable)this);
        this.d = new SingleAlarmWithMutableDelay(suspendContextImpl -> {
            ApplicationManager.getApplication().invokeLater(() -> this.h.setBusy(true));
            suspendContextImpl.getDebugProcess().getManagerThread().schedule(new MyUpdateClassesCommand(suspendContextImpl));
        }, this);
        this.d.setDelay((int)TimeUnit.MILLISECONDS.toMillis(500L));
        this.h.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component component, int n2, int n3) {
                ActionPopupMenu actionPopupMenu = ClassesFilteredView.b();
                actionPopupMenu.getComponent().show(component, n2, n3);
            }
        });
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.h), (int)2);
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("MemoryView.SettingsPopupActionGroup");
        defaultActionGroup.setPopup(true);
        Presentation presentation = new Presentation("Memory View Settings");
        presentation.setIcon(AllIcons.General.SecondaryGroup);
        ActionButton actionButton = new ActionButton((AnAction)defaultActionGroup, presentation, "unknown", (Dimension)new JBDimension(25, 25));
        BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
        borderLayoutPanel.addToCenter((Component)this.k);
        borderLayoutPanel.addToRight((Component)actionButton);
        this.addToTop((Component)borderLayoutPanel);
        this.addToCenter(jScrollPane);
    }

    @Nullable
    TrackerForNewInstances getStrategy(@NotNull ReferenceType referenceType) {
        if (referenceType == null) {
            ClassesFilteredView.a(3);
        }
        return this.j.getOrDefault(referenceType, null);
    }

    private void a(@NotNull XDebugSession xDebugSession, @NotNull ReferenceType referenceType, @NotNull TrackingType trackingType, boolean bl2) {
        if (xDebugSession == null) {
            ClassesFilteredView.a(4);
        }
        if (referenceType == null) {
            ClassesFilteredView.a(5);
        }
        if (trackingType == null) {
            ClassesFilteredView.a(6);
        }
        a.assertTrue(DebuggerManager.getInstance((Project)this.p).isDebuggerManagerThread());
        if (trackingType == TrackingType.CREATION) {
            ConstructorInstancesTracker constructorInstancesTracker = this.j.getOrDefault(referenceType, null);
            if (constructorInstancesTracker != null) {
                Disposer.dispose((Disposable)constructorInstancesTracker);
            }
            ConstructorInstancesTracker constructorInstancesTracker2 = new ConstructorInstancesTracker(referenceType, xDebugSession, this.e);
            constructorInstancesTracker2.setBackgroundMode(!this.b);
            if (bl2) {
                constructorInstancesTracker2.enable();
            } else {
                constructorInstancesTracker2.disable();
            }
            this.j.put(referenceType, constructorInstancesTracker2);
        }
    }

    private void a(@Nullable ReferenceType referenceType) {
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.p).getCurrentSession();
        if (referenceType != null && xDebugSession != null && xDebugSession.isSuspended()) {
            if (!referenceType.virtualMachine().canGetInstanceInfo()) {
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification("The virtual machine implementation does not provide an ability to get instances", NotificationType.INFORMATION).notify(xDebugSession.getProject());
                return;
            }
            new InstancesWindow(xDebugSession, n2 -> {
                List<ObjectReference> list2 = referenceType.instances(n2);
                return list2 == null ? Collections.emptyList() : list2;
            }, referenceType.name()).show();
        }
    }

    private void h() {
        this.j.values().forEach(ConstructorInstancesTracker::commitTracked);
    }

    private void a(boolean bl2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            DebugProcessImpl debugProcessImpl;
            SuspendContextImpl suspendContextImpl;
            DebugProcess debugProcess;
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.p).getCurrentSession();
            if (xDebugSession != null && (debugProcess = DebuggerManager.getInstance((Project)this.p).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler())) != null && debugProcess.isAttached() && debugProcess instanceof DebugProcessImpl && (suspendContextImpl = (debugProcessImpl = (DebugProcessImpl)debugProcess).getDebuggerContext().getSuspendContext()) != null) {
                if (bl2) {
                    this.d.cancelAndRequestImmediate(suspendContextImpl);
                } else {
                    this.d.cancelAndRequest(suspendContextImpl);
                }
            }
        }, this.p.getDisposed());
    }

    private static ActionPopupMenu b() {
        ActionGroup actionGroup = (ActionGroup)ActionManager.getInstance().getAction("MemoryView.ClassesPopupActionGroup");
        return ActionManager.getInstance().createActionPopupMenu("MemoryView.ClassesPopupActionGroup", actionGroup);
    }

    public void dispose() {
        this.j.clear();
    }

    public void setActive(final boolean bl2, @NotNull DebuggerManagerThreadImpl debuggerManagerThreadImpl) {
        if (debuggerManagerThreadImpl == null) {
            ClassesFilteredView.a(7);
        }
        if (this.b == bl2) {
            return;
        }
        this.b = bl2;
        debuggerManagerThreadImpl.schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                if (bl2) {
                    ClassesFilteredView.this.g();
                } else {
                    ClassesFilteredView.this.d();
                }
            }
        });
    }

    private void g() {
        this.l.setActive(true);
        this.j.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(false));
        if (this.a()) {
            if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                this.a(true);
            } else {
                this.j();
            }
        }
    }

    private void j() {
        ApplicationManager.getApplication().invokeLater(() -> this.h.makeClickable(c, () -> this.a(true)));
    }

    private void d() {
        this.l.setActive(false);
        this.d.cancelAllRequests();
        this.j.values().forEach(constructorInstancesTracker -> constructorInstancesTracker.setBackgroundMode(true));
    }

    private boolean a() {
        return this.g.get() != this.m.get();
    }

    private void e() {
        this.g.set(this.m.get());
    }

    private boolean a(@NotNull MouseEvent mouseEvent) {
        if (mouseEvent == null) {
            ClassesFilteredView.a(8);
        }
        int n2 = this.h.columnAtPoint(mouseEvent.getPoint());
        int n3 = this.h.rowAtPoint(mouseEvent.getPoint());
        if (n2 == -1 || n3 == -1 || this.h.convertColumnIndexToModel(n2) != 2) {
            return false;
        }
        int n4 = this.h.convertRowIndexToModel(n3);
        ReferenceType referenceType = (ReferenceType)this.h.getModel().getValueAt(n4, 0);
        ConstructorInstancesTracker constructorInstancesTracker = this.j.getOrDefault(referenceType, null);
        return constructorInstancesTracker != null && constructorInstancesTracker.isReady() && constructorInstancesTracker.getCount() > 0;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "managerThread";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getStrategy";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trackClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setActive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowNewInstancesEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDebuggerSessionListener
    implements XDebugSessionListener {
        private volatile boolean a = false;

        private MyDebuggerSessionListener() {
        }

        void setActive(boolean bl2) {
            this.a = bl2;
        }

        public void sessionResumed() {
            if (this.a) {
                ClassesFilteredView.this.j.values().forEach(ConstructorInstancesTracker::obsolete);
                ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.h.hideContent(ClassesFilteredView.o));
                ClassesFilteredView.this.d.cancelAllRequests();
            }
        }

        public void sessionStopped() {
            ClassesFilteredView.this.j.values().forEach(Disposer::dispose);
            ClassesFilteredView.this.j.clear();
            ClassesFilteredView.this.d.cancelAllRequests();
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.h.clean(ClassesFilteredView.i));
        }

        public void sessionPaused() {
            ClassesFilteredView.this.m.incrementAndGet();
            if (this.a) {
                if (MemoryViewManager.getInstance().isAutoUpdateModeEnabled()) {
                    ClassesFilteredView.this.a(false);
                } else {
                    ClassesFilteredView.this.j();
                }
            }
        }
    }

    private class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (ClassesFilteredView.this.h.isInClickableMode()) {
                return;
            }
            if (ClassesFilteredView.this.a(mouseEvent)) {
                ClassesFilteredView.this.h.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                ClassesFilteredView.this.h.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class MyDoubleClickListener
    extends DoubleClickListener {
        private MyDoubleClickListener() {
        }

        protected boolean onDoubleClick(MouseEvent mouseEvent) {
            if (!ClassesFilteredView.this.a(mouseEvent)) {
                ClassesFilteredView.this.a(ClassesFilteredView.this.h.getSelectedClass());
                return true;
            }
            return false;
        }
    }

    private class MyOpenNewInstancesListener
    extends MouseAdapter {
        private MyOpenNewInstancesListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() != 1 || mouseEvent.getButton() != 1 || !ClassesFilteredView.this.a(mouseEvent)) {
                return;
            }
            ReferenceType referenceType = ClassesFilteredView.this.h.getSelectedClass();
            TrackerForNewInstances trackerForNewInstances = referenceType == null ? null : ClassesFilteredView.this.getStrategy(referenceType);
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)ClassesFilteredView.this.p).getCurrentSession();
            if (trackerForNewInstances != null && xDebugSession != null) {
                DebugProcess debugProcess = DebuggerManager.getInstance((Project)ClassesFilteredView.this.p).getDebugProcess(xDebugSession.getDebugProcess().getProcessHandler());
                MemoryViewDebugProcessData memoryViewDebugProcessData = (MemoryViewDebugProcessData)debugProcess.getUserData(MemoryViewDebugProcessData.KEY);
                if (memoryViewDebugProcessData != null) {
                    List<ObjectReference> list2 = trackerForNewInstances.getNewInstances();
                    memoryViewDebugProcessData.getTrackedStacks().pinStacks(referenceType);
                    InstancesWindow instancesWindow = new InstancesWindow(xDebugSession, n2 -> list2, referenceType.name());
                    Disposer.register((Disposable)instancesWindow.getDisposable(), () -> memoryViewDebugProcessData.getTrackedStacks().unpinStacks(referenceType));
                    instancesWindow.show();
                } else {
                    a.warn("MemoryViewDebugProcessData not found in debug session user data");
                }
            }
        }
    }

    private static class FilterTextField
    extends SearchTextField {
        FilterTextField() {
            super(false);
        }

        protected void showPopup() {
        }

        protected boolean hasIconsOutsideOfTextField() {
            return false;
        }
    }

    private final class MyUpdateClassesCommand
    extends LowestPriorityCommand {
        MyUpdateClassesCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
            if (suspendContextImpl == null) {
                MyUpdateClassesCommand.b(0);
            }
            this.b();
            VirtualMachineProxyImpl virtualMachineProxyImpl = suspendContextImpl.getDebugProcess().getVirtualMachineProxy();
            List<ReferenceType> list2 = virtualMachineProxyImpl.allClasses();
            if (!list2.isEmpty()) {
                VirtualMachine virtualMachine = list2.get(0).virtualMachine();
                if (virtualMachineProxyImpl.canGetInstanceInfo()) {
                    Map<ReferenceType, Long> map = this.a(list2, virtualMachine);
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.h.updateContent(map));
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.h.updateClassesOnly(list2));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> ClassesFilteredView.this.h.setBusy(false));
            ClassesFilteredView.this.e();
        }

        private void b() {
            if (!ClassesFilteredView.this.q.get()) {
                ClassesFilteredView.this.j.values().forEach(ConstructorInstancesTracker::enable);
                ClassesFilteredView.this.q.set(true);
            } else {
                ClassesFilteredView.this.h();
            }
        }

        private Map<ReferenceType, Long> a(@NotNull List<ReferenceType> list2, @NotNull VirtualMachine virtualMachine) {
            if (list2 == null) {
                MyUpdateClassesCommand.b(1);
            }
            if (virtualMachine == null) {
                MyUpdateClassesCommand.b(2);
            }
            int n2 = AndroidUtil.isAndroidVM(virtualMachine) ? 500 : Integer.MAX_VALUE;
            int n3 = list2.size();
            LinkedHashMap<ReferenceType, Long> linkedHashMap = new LinkedHashMap<ReferenceType, Long>();
            int n4 = 0;
            int n5 = Math.min(n2, n3);
            while (n4 != n3) {
                int n6;
                List<ReferenceType> list3 = list2.subList(n4, n5);
                long l2 = System.nanoTime();
                long[] lArray = virtualMachine.instanceCounts(list3);
                long l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
                for (n6 = 0; n6 < list3.size(); ++n6) {
                    linkedHashMap.put(list3.get(n6), lArray[n6]);
                }
                n6 = (int)Math.min(0.5 * (double)l3, n);
                ClassesFilteredView.this.d.setDelay(n6);
                a.debug(String.format("Instances query time = %d ms. Count of classes = %d", l3, list3.size()));
                n4 = n5;
                n5 = Math.min(n5 + n2, n3);
            }
            return linkedHashMap;
        }

        private static /* synthetic */ void b(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suspendContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vm";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/ui/ClassesFilteredView$MyUpdateClassesCommand";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contextAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstancesCounts";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

