/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.DefaultSyntheticProvider;
import com.intellij.debugger.engine.JVMStackFrameInfoProvider;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebuggerFramesList;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameItem {
    private static final Logger a = Logger.getInstance(StackFrameItem.class);
    private static final List<XNamedValue> c = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null));
    private static final List<XNamedValue> b = Collections.singletonList(JavaStackFrame.createMessageNode(DebuggerBundle.message((String)"message.node.local.variables.not.captured", (Object[])new Object[0]), XDebuggerUIConstants.INFORMATION_MESSAGE_ICON));
    public static final XDebuggerTreeNodeHyperlink CAPTURE_SETTINGS_OPENER = new XDebuggerTreeNodeHyperlink(" settings"){

        public void onClick(MouseEvent mouseEvent) {
            ShowSettingsUtil.getInstance().showSettingsDialog(null, CaptureConfigurable.class);
            mouseEvent.consume();
        }
    };
    private final Location d;
    private final List<XNamedValue> e;

    public StackFrameItem(@NotNull Location location, List<XNamedValue> list2) {
        if (location == null) {
            StackFrameItem.a(0);
        }
        this.d = location;
        this.e = list2;
    }

    @NotNull
    public String path() {
        String string = this.d.declaringType().name();
        if (string == null) {
            StackFrameItem.a(1);
        }
        return string;
    }

    @NotNull
    public String method() {
        String string = this.d.method().name();
        if (string == null) {
            StackFrameItem.a(2);
        }
        return string;
    }

    public int line() {
        return DebuggerUtilsEx.getLineNumber(this.d, false);
    }

    @NotNull
    public static List<StackFrameItem> createFrames(@NotNull SuspendContextImpl suspendContextImpl, boolean bl2) throws EvaluateException {
        ThreadReferenceProxyImpl threadReferenceProxyImpl;
        if (suspendContextImpl == null) {
            StackFrameItem.a(3);
        }
        if ((threadReferenceProxyImpl = suspendContextImpl.getThread()) != null) {
            List<StackFrameProxyImpl> list2 = threadReferenceProxyImpl.forceFrames();
            ArrayList<StackFrameItem> arrayList = new ArrayList<StackFrameItem>(list2.size());
            for (StackFrameProxyImpl stackFrameProxyImpl : list2) {
                try {
                    Iterator<LocalVariableProxyImpl> iterator;
                    Location location;
                    List<XNamedValue> list3;
                    block24: {
                        list3 = null;
                        location = stackFrameProxyImpl.location();
                        Method method = location.method();
                        if (bl2) {
                            if (!DebuggerSettings.getInstance().CAPTURE_VARIABLES) {
                                list3 = c;
                            } else if (method.isNative() || method.isBridge() || DefaultSyntheticProvider.checkIsSynthetic(method)) {
                                list3 = b;
                            } else {
                                list3 = new ArrayList<XNamedValue>();
                                try {
                                    iterator = stackFrameProxyImpl.thisObject();
                                    if (iterator != null) {
                                        list3.add(StackFrameItem.a((Value)((Object)iterator), "this", VariableItem.VarType.OBJECT));
                                    }
                                }
                                catch (EvaluateException evaluateException) {
                                    a.debug((Throwable)evaluateException);
                                }
                                try {
                                    for (LocalVariableProxyImpl localVariableProxyImpl : stackFrameProxyImpl.visibleVariables()) {
                                        try {
                                            VariableItem.VarType varType = localVariableProxyImpl.getVariable().isArgument() ? VariableItem.VarType.PARAM : VariableItem.VarType.OBJECT;
                                            list3.add(StackFrameItem.a(stackFrameProxyImpl.getValue(localVariableProxyImpl), localVariableProxyImpl.name(), varType));
                                        }
                                        catch (EvaluateException evaluateException) {
                                            a.debug((Throwable)evaluateException);
                                        }
                                    }
                                }
                                catch (EvaluateException evaluateException) {
                                    if (evaluateException.getCause() instanceof AbsentInformationException) {
                                        list3.add(JavaStackFrame.LOCAL_VARIABLES_INFO_UNAVAILABLE_MESSAGE_NODE);
                                        try {
                                            for (Map.Entry<DecompiledLocalVariable, Value> entry : LocalVariablesUtil.fetchValues(stackFrameProxyImpl, suspendContextImpl.getDebugProcess(), false).entrySet()) {
                                                list3.add(StackFrameItem.a(entry.getValue(), entry.getKey().getDisplayName(), VariableItem.VarType.PARAM));
                                            }
                                        }
                                        catch (Exception exception) {
                                            a.info((Throwable)exception);
                                            break block24;
                                        }
                                    }
                                    a.debug((Throwable)evaluateException);
                                }
                            }
                        }
                    }
                    iterator = new StackFrameItem(location, list3);
                    arrayList.add((StackFrameItem)((Object)iterator));
                    List<StackFrameItem> object2 = StackCapturingLineBreakpoint.getRelatedStack(stackFrameProxyImpl, suspendContextImpl, false);
                    if (ContainerUtil.isEmpty(object2)) continue;
                    arrayList.add(null);
                    arrayList.addAll(object2);
                    break;
                }
                catch (EvaluateException evaluateException) {
                    a.debug((Throwable)evaluateException);
                }
            }
            ArrayList<StackFrameItem> arrayList2 = arrayList;
            if (arrayList2 == null) {
                StackFrameItem.a(4);
            }
            return arrayList2;
        }
        List<StackFrameItem> list2 = Collections.emptyList();
        if (list2 == null) {
            StackFrameItem.a(5);
        }
        return list2;
    }

    private static VariableItem a(Value value, String string, VariableItem.VarType varType) {
        String string2 = null;
        String string3 = "null";
        if (value instanceof ObjectReference) {
            string3 = value instanceof StringReference ? ((StringReference)value).value() : "";
            string2 = value.type().name() + "@" + ((ObjectReference)value).uniqueID();
        } else if (value != null) {
            string3 = value.toString();
        }
        return new VariableItem(string, string2, string3, varType);
    }

    public String toString() {
        return this.d.toString();
    }

    public CapturedStackFrame createFrame(DebugProcessImpl debugProcessImpl) {
        return new CapturedStackFrame(debugProcessImpl, this);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "path";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "method";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFrames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CapturedStackFrame
    extends XStackFrame
    implements JVMStackFrameInfoProvider,
    XDebuggerFramesList.ItemWithSeparatorAbove {
        private static final String i = DebuggerBundle.message((String)"frame.panel.async.stacktrace", (Object[])new Object[0]);
        private final XSourcePosition f;
        private final boolean g;
        private final boolean e;
        private final String d;
        private final String h;
        private final int a;
        private final List<XNamedValue> c;
        private volatile boolean b;

        public CapturedStackFrame(DebugProcessImpl debugProcessImpl, StackFrameItem stackFrameItem) {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.d = stackFrameItem.path();
            this.h = stackFrameItem.method();
            this.a = stackFrameItem.line();
            this.c = stackFrameItem.e;
            Location location = stackFrameItem.d;
            this.f = DebuggerUtilsEx.toXSourcePosition(debugProcessImpl.getPositionManager().getSourcePosition(location));
            this.g = DebuggerUtils.isSynthetic((TypeComponent)location.method());
            this.e = DebuggerUtilsEx.isInLibraryContent(this.f != null ? this.f.getFile() : null, debugProcessImpl.getProject());
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return this.f;
        }

        @Override
        public boolean isSynthetic() {
            return this.g;
        }

        @Override
        public boolean isInLibraryContent() {
            return this.e;
        }

        public void customizePresentation(@NotNull ColoredTextContainer coloredTextContainer) {
            if (coloredTextContainer == null) {
                CapturedStackFrame.a(0);
            }
            coloredTextContainer.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6)));
            coloredTextContainer.append(String.format("%s:%d", this.h, this.a), this.a());
            ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
            if (threadsViewSettings.SHOW_CLASS_NAME) {
                coloredTextContainer.append(String.format(", %s", StringUtil.getShortName((String)this.d)), this.a());
                String string = StringUtil.getPackageName((String)this.d);
                if (threadsViewSettings.SHOW_PACKAGE_NAME && !string.trim().isEmpty()) {
                    coloredTextContainer.append(String.format(" (%s)", string), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                }
            }
        }

        public void computeChildren(@NotNull XCompositeNode xCompositeNode) {
            if (xCompositeNode == null) {
                CapturedStackFrame.a(1);
            }
            XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
            if (this.c == c) {
                xCompositeNode.setMessage(DebuggerBundle.message((String)"message.node.local.variables.capture.disabled", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, CAPTURE_SETTINGS_OPENER);
            } else if (this.c != null) {
                xValueChildrenList = new XValueChildrenList(this.c.size());
                this.c.forEach(arg_0 -> ((XValueChildrenList)xValueChildrenList).add(arg_0));
            }
            xCompositeNode.addChildren(xValueChildrenList, true);
        }

        private SimpleTextAttributes a() {
            if (this.isSynthetic() || this.isInLibraryContent()) {
                return SimpleTextAttributes.GRAYED_ATTRIBUTES;
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        public String getCaptionAboveOf() {
            return i;
        }

        public boolean hasSeparatorAbove() {
            return this.b;
        }

        public void setWithSeparator(boolean bl2) {
            this.b = bl2;
        }

        public String toString() {
            if (this.f != null) {
                return this.f.getFile().getName() + ":" + (this.f.getLine() + 1);
            }
            return "<position unknown>";
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/utils/StackFrameItem$CapturedStackFrame";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizePresentation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "computeChildren";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class VariableItem
    extends XNamedValue {
        private final String a;
        private final String b;
        private final VarType c;

        public VariableItem(String string, String string2, String string3, VarType varType) {
            super(string);
            this.a = string2;
            this.b = string3;
            this.c = varType;
        }

        public void computePresentation(@NotNull XValueNode xValueNode, @NotNull XValuePlace xValuePlace) {
            Icon icon;
            if (xValueNode == null) {
                VariableItem.a(0);
            }
            if (xValuePlace == null) {
                VariableItem.a(1);
            }
            final ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            final String string = Registry.is((String)"debugger.showTypes") ? classRenderer.renderTypeName(this.a) : null;
            Icon icon2 = icon = this.c == VarType.PARAM ? PlatformIcons.PARAMETER_ICON : AllIcons.Debugger.Value;
            if (this.a != null && this.a.startsWith("java.lang.String@")) {
                xValueNode.setPresentation(icon, (XValuePresentation)new XStringValuePresentation(this.b){

                    @Nullable
                    public String getType() {
                        return classRenderer.SHOW_STRINGS_TYPE ? string : null;
                    }
                }, false);
                return;
            }
            xValueNode.setPresentation(icon, string, this.b, false);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "place";
                    break;
                }
            }
            objectArray[1] = "com/intellij/debugger/memory/utils/StackFrameItem$VariableItem";
            objectArray[2] = "computePresentation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static enum VarType {
            PARAM,
            OBJECT;

        }
    }
}

