/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerDataViewsConfigurable
implements SearchableConfigurable {
    private JCheckBox o;
    private JCheckBox h;
    private StateRestoringCheckBox i;
    private JCheckBox f;
    private JCheckBox q;
    private JCheckBox k;
    private JCheckBox e;
    private JCheckBox a;
    private JCheckBox l;
    private JCheckBox c;
    private JCheckBox d;
    private StateRestoringCheckBox j;
    private JCheckBox m;
    private JCheckBox g;
    private JRadioButton p;
    private JRadioButton b;
    private ClassFilterEditor n;
    private Project r;

    public DebuggerDataViewsConfigurable(@Nullable Project project2) {
        this.r = project2;
    }

    public void disposeUIResources() {
        this.n = null;
        this.r = null;
    }

    public String getDisplayName() {
        return OptionsBundle.message((String)"options.java.display.name", (Object[])new Object[0]);
    }

    public JComponent createComponent() {
        if (this.r == null) {
            this.r = JavaDebuggerSupport.getContextProjectForEditorFieldsInDebuggerConfigurables();
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.o = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.autoscroll", (Object[])new Object[0]));
        this.h = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.synthetic.fields", (Object[])new Object[0]));
        this.i = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.val.fields.as.locals", (Object[])new Object[0]));
        this.f = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.hide.null.array.elements", (Object[])new Object[0]));
        this.q = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.fields", (Object[])new Object[0]));
        this.j = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.static.final.fields", (Object[])new Object[0]));
        this.m = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.alternate.view", (Object[])new Object[0]));
        this.q.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DebuggerDataViewsConfigurable.this.q.isSelected()) {
                    DebuggerDataViewsConfigurable.this.j.makeSelectable();
                } else {
                    DebuggerDataViewsConfigurable.this.j.makeUnselectable(false);
                }
            }
        });
        this.h.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DebuggerDataViewsConfigurable.this.h.isSelected()) {
                    DebuggerDataViewsConfigurable.this.i.makeSelectable();
                } else {
                    DebuggerDataViewsConfigurable.this.i.makeUnselectable(false);
                }
            }
        });
        this.k = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.declared.type", (Object[])new Object[0]));
        this.e = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.fq.names", (Object[])new Object[0]));
        this.a = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.object.id", (Object[])new Object[0]));
        this.c = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.hex.value", (Object[])new Object[0]));
        this.l = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.show.strings.type", (Object[])new Object[0]));
        this.d = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.populate.throwable.stack", (Object[])new Object[0]));
        this.g = new JCheckBox(DebuggerBundle.message((String)"label.base.renderer.configurable.enable.toString", (Object[])new Object[0]));
        this.p = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.all.overriding", (Object[])new Object[0]));
        this.b = new JRadioButton(DebuggerBundle.message((String)"label.base.renderer.configurable.classes.from.list", (Object[])new Object[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.p);
        buttonGroup.add(this.b);
        this.n = new ClassFilterEditor(this.r, null, "reference.viewBreakpoints.classFilters.newPattern");
        this.g.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl2 = DebuggerDataViewsConfigurable.this.g.isSelected();
                DebuggerDataViewsConfigurable.this.p.setEnabled(bl2);
                DebuggerDataViewsConfigurable.this.b.setEnabled(bl2);
                DebuggerDataViewsConfigurable.this.n.setEnabled(bl2 && DebuggerDataViewsConfigurable.this.b.isSelected());
            }
        });
        this.b.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DebuggerDataViewsConfigurable.this.n.setEnabled(DebuggerDataViewsConfigurable.this.g.isSelected() && DebuggerDataViewsConfigurable.this.b.isSelected());
            }
        });
        jPanel.add((Component)this.o, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Show", (boolean)true));
        jPanel2.add((Component)this.k, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        jPanel2.add((Component)this.a, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel2.add((Component)this.h, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        jPanel2.add((Component)this.q, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)4, (int)10, (int)0, (int)0), 0, 0));
        jPanel2.add((Component)this.i, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)4, (int)10, (int)0, (int)0), 0, 0));
        jPanel2.add((Component)this.j, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)4, (int)10, (int)0, (int)0), 0, 0));
        jPanel2.add((Component)this.e, new GridBagConstraints(3, -1, 1, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)10), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel.add((Component)this.l, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        jPanel.add((Component)this.c, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel.add((Component)this.f, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel.add((Component)this.d, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 11, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel.add((Component)this.m, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)4, (int)0, (int)0, (int)10), 0, 0));
        jPanel.add((Component)this.g, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        jPanel.add((Component)this.p, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)12), 0, 0));
        jPanel.add((Component)this.b, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsLeft((int)12), 0, 0));
        this.n.setMinimumSize((Dimension)JBUI.size((int)50, (int)100));
        jPanel.add((Component)this.n, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsLeft((int)12), 0, 0));
        return jPanel;
    }

    public void apply() {
        ViewsGeneralSettings viewsGeneralSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        viewsGeneralSettings.AUTOSCROLL_TO_NEW_LOCALS = this.o.isSelected();
        nodeRendererSettings.setAlternateCollectionViewsEnabled(this.m.isSelected());
        viewsGeneralSettings.HIDE_NULL_ARRAY_ELEMENTS = this.f.isSelected();
        viewsGeneralSettings.POPULATE_THROWABLE_STACKTRACE = this.d.isSelected();
        ClassRenderer classRenderer = nodeRendererSettings.getClassRenderer();
        classRenderer.SHOW_STATIC = this.q.isSelected();
        classRenderer.SHOW_STATIC_FINAL = this.j.isSelectedWhenSelectable();
        classRenderer.SHOW_SYNTHETICS = this.h.isSelected();
        classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES = this.i.isSelectedWhenSelectable();
        classRenderer.SHOW_DECLARED_TYPE = this.k.isSelected();
        classRenderer.SHOW_FQ_TYPE_NAMES = this.e.isSelected();
        classRenderer.SHOW_OBJECT_ID = this.a.isSelected();
        classRenderer.SHOW_STRINGS_TYPE = this.l.isSelected();
        ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
        toStringRenderer.setOnDemand(!this.g.isSelected());
        toStringRenderer.setUseClassFilters(this.b.isSelected());
        toStringRenderer.setClassFilters(this.n.getFilters());
        PrimitiveRenderer primitiveRenderer = nodeRendererSettings.getPrimitiveRenderer();
        primitiveRenderer.setShowHexValue(this.c.isSelected());
        nodeRendererSettings.fireRenderersChanged();
    }

    public void reset() {
        ViewsGeneralSettings viewsGeneralSettings = ViewsGeneralSettings.getInstance();
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        this.o.setSelected(viewsGeneralSettings.AUTOSCROLL_TO_NEW_LOCALS);
        this.f.setSelected(viewsGeneralSettings.HIDE_NULL_ARRAY_ELEMENTS);
        this.m.setSelected(nodeRendererSettings.areAlternateCollectionViewsEnabled());
        this.d.setSelected(viewsGeneralSettings.POPULATE_THROWABLE_STACKTRACE);
        ClassRenderer classRenderer = nodeRendererSettings.getClassRenderer();
        this.h.setSelected(classRenderer.SHOW_SYNTHETICS);
        this.i.setSelected(classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES);
        if (!classRenderer.SHOW_SYNTHETICS) {
            this.i.makeUnselectable(false);
        }
        this.q.setSelected(classRenderer.SHOW_STATIC);
        this.j.setSelected(classRenderer.SHOW_STATIC_FINAL);
        if (!classRenderer.SHOW_STATIC) {
            this.j.makeUnselectable(false);
        }
        this.k.setSelected(classRenderer.SHOW_DECLARED_TYPE);
        this.e.setSelected(classRenderer.SHOW_FQ_TYPE_NAMES);
        this.a.setSelected(classRenderer.SHOW_OBJECT_ID);
        this.l.setSelected(classRenderer.SHOW_STRINGS_TYPE);
        ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
        boolean bl2 = !toStringRenderer.isOnDemand();
        boolean bl3 = toStringRenderer.isUseClassFilters();
        this.g.setSelected(bl2);
        this.p.setSelected(!bl3);
        this.b.setSelected(bl3);
        this.n.setFilters(toStringRenderer.getClassFilters());
        this.n.setEnabled(bl2 && bl3);
        this.b.setEnabled(bl2);
        this.p.setEnabled(bl2);
        PrimitiveRenderer primitiveRenderer = nodeRendererSettings.getPrimitiveRenderer();
        this.c.setSelected(primitiveRenderer.isShowHexValue());
    }

    public boolean isModified() {
        return this.b() || this.a();
    }

    private boolean b() {
        ViewsGeneralSettings viewsGeneralSettings = ViewsGeneralSettings.getInstance();
        return viewsGeneralSettings.AUTOSCROLL_TO_NEW_LOCALS != this.o.isSelected() || viewsGeneralSettings.HIDE_NULL_ARRAY_ELEMENTS != this.f.isSelected() || viewsGeneralSettings.POPULATE_THROWABLE_STACKTRACE != this.d.isSelected();
    }

    private boolean a() {
        boolean bl2;
        boolean bl3;
        NodeRendererSettings nodeRendererSettings = NodeRendererSettings.getInstance();
        ClassRenderer classRenderer = nodeRendererSettings.getClassRenderer();
        boolean bl4 = bl3 = classRenderer.SHOW_STATIC != this.q.isSelected() || classRenderer.SHOW_STATIC_FINAL != this.j.isSelectedWhenSelectable() || classRenderer.SHOW_SYNTHETICS != this.h.isSelected() || classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES != this.i.isSelectedWhenSelectable() || classRenderer.SHOW_DECLARED_TYPE != this.k.isSelected() || classRenderer.SHOW_FQ_TYPE_NAMES != this.e.isSelected() || classRenderer.SHOW_OBJECT_ID != this.a.isSelected() || classRenderer.SHOW_STRINGS_TYPE != this.l.isSelected();
        if (bl3) {
            return true;
        }
        ToStringRenderer toStringRenderer = nodeRendererSettings.getToStringRenderer();
        boolean bl5 = bl2 = toStringRenderer.isOnDemand() == this.g.isSelected() || toStringRenderer.isUseClassFilters() != this.b.isSelected() || !DebuggerUtilsEx.filterEquals(toStringRenderer.getClassFilters(), this.n.getFilters());
        if (bl2) {
            return true;
        }
        if (nodeRendererSettings.areAlternateCollectionViewsEnabled() != this.m.isSelected()) {
            return true;
        }
        PrimitiveRenderer primitiveRenderer = nodeRendererSettings.getPrimitiveRenderer();
        return primitiveRenderer.isShowHexValue() != this.c.isSelected();
    }

    @NotNull
    public String getHelpTopic() {
        if ("Debugger_Data_Views_Java" == null) {
            DebuggerDataViewsConfigurable.a(0);
        }
        return "Debugger_Data_Views_Java";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            DebuggerDataViewsConfigurable.a(1);
        }
        return string;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/debugger/settings/DebuggerDataViewsConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

