/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.CompoundRendererConfigurable;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.InternalIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public final class UserRenderersConfigurable
extends JPanel
implements ConfigurableUi<NodeRendererSettings>,
Disposable {
    private final JPanel a;
    private final JTextField c;
    private final ElementsChooser<NodeRenderer> d;
    private NodeRenderer e = null;
    private final CompoundRendererConfigurable b = new CompoundRendererConfigurable(this);

    public UserRenderersConfigurable() {
        super(new BorderLayout(4, 0));
        this.d = new ElementsChooser(true);
        this.a();
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)((JTable)this.d.getComponent()));
        toolbarDecorator.setToolbarPosition(ActionToolbarPosition.TOP);
        toolbarDecorator.setAddAction((AnActionButtonRunnable)new AddAction());
        toolbarDecorator.setRemoveAction((AnActionButtonRunnable)new RemoveAction());
        toolbarDecorator.setMoveUpAction((AnActionButtonRunnable)new MoveAction(true));
        toolbarDecorator.setMoveDownAction((AnActionButtonRunnable)new MoveAction(false));
        toolbarDecorator.addExtraAction((AnActionButton)new CopyAction());
        this.c = new JTextField();
        this.a = new JPanel(new BorderLayout());
        this.a.add((Component)new JLabel(DebuggerBundle.message((String)"label.user.renderers.configurable.renderer.name", (Object[])new Object[0])), "West");
        this.a.add((Component)this.c, "Center");
        this.a.setVisible(false);
        JPanel jPanel = new JPanel(new BorderLayout(0, 4));
        jPanel.add((Component)this.a, "North");
        jPanel.add((Component)this.b, "Center");
        this.c.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (UserRenderersConfigurable.this.e != null) {
                    UserRenderersConfigurable.this.e.setName(UserRenderersConfigurable.this.c.getText());
                    UserRenderersConfigurable.this.d.refresh((Object)UserRenderersConfigurable.this.e);
                }
            }
        });
        Splitter splitter = new Splitter(false);
        splitter.setProportion(0.3f);
        splitter.setFirstComponent((JComponent)toolbarDecorator.createPanel());
        splitter.setSecondComponent((JComponent)jPanel);
        this.add((Component)splitter, "Center");
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        UserRenderersConfigurable userRenderersConfigurable = this;
        if (userRenderersConfigurable == null) {
            UserRenderersConfigurable.a(0);
        }
        return userRenderersConfigurable;
    }

    private void a() {
        this.d.getEmptyText().setText(DebuggerBundle.message((String)"text.user.renderers.configurable.no.renderers", (Object[])new Object[0]));
        this.d.addElementsMarkListener(NodeRenderer::setEnabled);
        this.d.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.a(this.d.getSelectedElements());
            }
        });
    }

    private void a(List<NodeRenderer> list2) {
        if (list2.size() != 1) {
            this.a((NodeRenderer)null);
        } else {
            this.a(list2.get(0));
        }
    }

    private void a(NodeRenderer nodeRenderer) {
        if (this.e == nodeRenderer) {
            return;
        }
        if (this.b.isModified()) {
            this.b.apply();
        }
        this.e = nodeRenderer;
        if (nodeRenderer != null) {
            this.a.setVisible(true);
            this.c.setText(nodeRenderer.getName());
        } else {
            this.a.setVisible(false);
            this.c.setText("");
        }
        this.b.setRenderer(nodeRenderer);
    }

    public void apply(@NotNull NodeRendererSettings nodeRendererSettings) {
        if (nodeRendererSettings == null) {
            UserRenderersConfigurable.a(1);
        }
        this.b.apply();
        this.a(nodeRendererSettings.getCustomRenderers());
        nodeRendererSettings.fireRenderersChanged();
    }

    private void a(RendererConfiguration rendererConfiguration) {
        int n2 = this.d.getElementCount();
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add((NodeRenderer)this.d.getElementAt(i2));
        }
        rendererConfiguration.setRenderers(arrayList);
    }

    public boolean isModified(@NotNull NodeRendererSettings nodeRendererSettings) {
        if (nodeRendererSettings == null) {
            UserRenderersConfigurable.a(2);
        }
        if (this.b.isModified()) {
            return true;
        }
        RendererConfiguration rendererConfiguration = nodeRendererSettings.getCustomRenderers();
        if (this.d.getElementCount() != rendererConfiguration.getRendererCount()) {
            return true;
        }
        RendererConfiguration rendererConfiguration2 = new RendererConfiguration(nodeRendererSettings);
        this.a(rendererConfiguration2);
        return !rendererConfiguration2.equals(rendererConfiguration);
    }

    public void reset(@NotNull NodeRendererSettings nodeRendererSettings) {
        if (nodeRendererSettings == null) {
            UserRenderersConfigurable.a(3);
        }
        this.d.removeAllElements();
        RendererConfiguration rendererConfiguration = nodeRendererSettings.getCustomRenderers();
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>(1);
        rendererConfiguration.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)nodeRenderer -> {
            NodeRenderer nodeRenderer2 = (NodeRenderer)nodeRenderer.clone();
            this.d.addElement((Object)nodeRenderer2, nodeRenderer2.isEnabled());
            if (arrayList.size() == 0) {
                arrayList.add(nodeRenderer2);
            }
            return true;
        }));
        this.d.selectElements(arrayList);
        this.a(arrayList);
        this.b.reset();
    }

    public void addRenderer(NodeRenderer nodeRenderer) {
        this.d.addElement((Object)nodeRenderer, nodeRenderer.isEnabled());
        this.d.moveElement((Object)nodeRenderer, 0);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/settings/UserRenderersConfigurable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/settings/UserRenderersConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MoveAction
    implements AnActionButtonRunnable {
        private final boolean a;

        public MoveAction(boolean bl2) {
            this.a = bl2;
        }

        public void run(AnActionButton anActionButton) {
            int n2 = UserRenderersConfigurable.this.d.getSelectedElementRow();
            if (n2 < 0) {
                return;
            }
            int n3 = n2 + (this.a ? -1 : 1);
            if (n3 < 0) {
                n3 = UserRenderersConfigurable.this.d.getElementCount() - 1;
            } else if (n3 >= UserRenderersConfigurable.this.d.getElementCount()) {
                n3 = 0;
            }
            UserRenderersConfigurable.this.d.moveElement(UserRenderersConfigurable.this.d.getElementAt(n2), n3);
        }
    }

    private class CopyAction
    extends AnActionButton {
        public CopyAction() {
            super(DebuggerBundle.message((String)"button.copy", (Object[])new Object[0]), DebuggerBundle.message((String)"user.renderers.configurable.button.description.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            NodeRenderer nodeRenderer = (NodeRenderer)UserRenderersConfigurable.this.d.getSelectedElement();
            if (nodeRenderer != null) {
                UserRenderersConfigurable.this.d.addElement((Object)((NodeRenderer)nodeRenderer.clone()), true);
            }
        }

        public void updateButton(AnActionEvent anActionEvent) {
            super.updateButton(anActionEvent);
            anActionEvent.getPresentation().setEnabled(UserRenderersConfigurable.this.d.getSelectedElement() != null);
        }
    }

    private class RemoveAction
    implements AnActionButtonRunnable {
        private RemoveAction() {
        }

        public void run(AnActionButton anActionButton) {
            UserRenderersConfigurable.this.d.getSelectedElements().forEach(arg_0 -> ((ElementsChooser)UserRenderersConfigurable.this.d).removeElement(arg_0));
        }
    }

    private class AddAction
    implements AnActionButtonRunnable {
        private AddAction() {
        }

        public void run(AnActionButton anActionButton) {
            NodeRenderer nodeRenderer = (NodeRenderer)NodeRendererSettings.getInstance().createRenderer("CompoundTypeRenderer");
            nodeRenderer.setEnabled(true);
            UserRenderersConfigurable.this.addRenderer(nodeRenderer);
        }
    }
}

