/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.ClassFilterEditor;
import com.intellij.util.IconUtil;
import java.awt.Component;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class InstanceFilterEditor
extends ClassFilterEditor {
    public InstanceFilterEditor(Project project2) {
        super(project2);
    }

    protected void addClassFilter() {
        String string = Messages.showInputDialog((Project)this.myProject, (String)DebuggerBundle.message((String)"add.instance.filter.dialog.prompt", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"add.instance.filter.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), null, (InputValidator)new InputValidatorEx(){

            @Nullable
            public String getErrorText(String string) {
                try {
                    Long.parseLong(string);
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    return DebuggerBundle.message((String)"add.instance.filter.dialog.error.numeric.value.expected", (Object[])new Object[0]);
                }
            }

            public boolean checkInput(String string) {
                return this.getErrorText(string) == null;
            }

            public boolean canClose(String string) {
                return this.getErrorText(string) == null;
            }
        });
        if (string != null) {
            ClassFilter classFilter = this.createFilter(string);
            this.myTableModel.addRow(classFilter);
            int n2 = this.myTableModel.getRowCount() - 1;
            this.myTable.getSelectionModel().setSelectionInterval(n2, n2);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(n2, 0, true));
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTable, true));
        }
    }

    protected String getAddButtonText() {
        return DebuggerBundle.message((String)"button.add", (Object[])new Object[0]);
    }

    protected Icon getAddButtonIcon() {
        return IconUtil.getAddIcon();
    }

    protected boolean addPatternButtonVisible() {
        return false;
    }
}

