/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger j = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    @Nullable
    private JVMName k;
    private boolean l;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            MethodBreakpoint.c(0);
        }
        super(project2, xBreakpoint);
    }

    public boolean isStatic() {
        return this.l;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key = CATEGORY;
        if (key == null) {
            MethodBreakpoint.c(1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.a() != null;
    }

    @Override
    protected void reload(@NotNull PsiFile psiFile) {
        PsiClass psiClass;
        if (psiFile == null) {
            MethodBreakpoint.c(2);
        }
        this.a(null);
        this.k = null;
        MethodDescriptor methodDescriptor = MethodBreakpoint.a(this.myProject, psiFile, this.getSourcePosition());
        if (methodDescriptor != null) {
            this.a(methodDescriptor.methodName);
            this.k = methodDescriptor.methodSignature;
            this.l = methodDescriptor.isStatic;
        }
        if ((psiClass = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = psiClass.getQualifiedName();
        }
        if (this.l) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    private static void a(final @NotNull MethodBreakpointBase methodBreakpointBase, @NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType) {
        if (methodBreakpointBase == null) {
            MethodBreakpoint.c(3);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(4);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(5);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
        ClassPrepareRequest classPrepareRequest = requestManagerImpl.createClassPrepareRequest((debugProcess, referenceType2) -> {
            if (referenceType == null) {
                MethodBreakpoint.c(42);
            }
            if (methodBreakpointBase == null) {
                MethodBreakpoint.c(43);
            }
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(44);
            }
            if (MethodBreakpoint.b(referenceType2, referenceType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(methodBreakpointBase, debugProcessImpl, referenceType2, false);
            }
        }, null);
        if (classPrepareRequest != null) {
            requestManagerImpl.registerRequest(methodBreakpointBase, classPrepareRequest);
            classPrepareRequest.enable();
        }
        AtomicReference atomicReference = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(41);
            }
            ProgressWindow progressWindow = new ProgressWindow(true, false, debugProcessImpl.getProject(), "Cancel emulation");
            progressWindow.setDelayInMillis(2000);
            atomicReference.set(progressWindow);
        });
        final ProgressWindow progressWindow = (ProgressWindow)atomicReference.get();
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        XBreakpointListener xBreakpointListener = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint xBreakpoint) {
                if (xBreakpoint == null) {
                    1.a(0);
                }
                if (xBreakpoint == methodBreakpointBase.getXBreakpoint()) {
                    atomicBoolean.set(true);
                    progressWindow.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint xBreakpoint) {
                if (xBreakpoint == null) {
                    1.a(1);
                }
                this.changed(xBreakpoint);
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                if (xBreakpoint == null) {
                    1.a(2);
                }
                this.changed(xBreakpoint);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        XDebuggerManager.getInstance((Project)debugProcessImpl.getProject()).getBreakpointManager().addBreakpointListener(xBreakpointListener, (Disposable)progressWindow);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (referenceType == null) {
                MethodBreakpoint.c(36);
            }
            if (methodBreakpointBase == null) {
                MethodBreakpoint.c(37);
            }
            if (debugProcessImpl == null) {
                MethodBreakpoint.c(38);
            }
            MethodBreakpoint.a(referenceType, (ReferenceType referenceType, ClassesByNameProvider classesByNameProvider) -> {
                if (methodBreakpointBase == null) {
                    MethodBreakpoint.c(39);
                }
                if (debugProcessImpl == null) {
                    MethodBreakpoint.c(40);
                }
                MethodBreakpoint.createRequestForPreparedClassEmulated(methodBreakpointBase, debugProcessImpl, referenceType, classesByNameProvider, false);
            }, (ProgressIndicator)progressWindow);
        }, (ProgressIndicator)progressWindow);
        if (progressWindow.isCanceled() && !atomicBoolean.get()) {
            methodBreakpointBase.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase methodBreakpointBase, @NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType, boolean bl2) {
        if (methodBreakpointBase == null) {
            MethodBreakpoint.c(6);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(7);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(8);
        }
        MethodBreakpoint.createRequestForPreparedClassEmulated(methodBreakpointBase, debugProcessImpl, referenceType, debugProcessImpl.getVirtualMachineProxy().getClassesByNameProvider(), bl2);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase methodBreakpointBase, final @NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType, @NotNull ClassesByNameProvider classesByNameProvider, boolean bl2) {
        if (methodBreakpointBase == null) {
            MethodBreakpoint.c(9);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(10);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(11);
        }
        if (classesByNameProvider == null) {
            MethodBreakpoint.c(12);
        }
        if (!bl2 && !MethodBreakpoint.shouldCreateRequest(methodBreakpointBase, methodBreakpointBase.getXBreakpoint(), debugProcessImpl, true)) {
            return;
        }
        try {
            Method method2 = MethodBytecodeUtil.getLambdaMethod(referenceType, classesByNameProvider);
            if (method2 != null && !methodBreakpointBase.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)referenceType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcessImpl).findFirst().isPresent()) {
                return;
            }
            StreamEx streamEx = method2 != null ? StreamEx.of((Object)method2) : methodBreakpointBase.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(referenceType.methods()).filter(method -> bl2 || !method.isAbstract())), debugProcessImpl);
            boolean bl3 = false;
            for (Method method3 : streamEx) {
                List<Location> list2;
                bl3 = true;
                if (method3.isNative()) {
                    methodBreakpointBase.disableEmulation();
                    return;
                }
                Method method4 = MethodBytecodeUtil.getBridgeTargetMethod(method3, classesByNameProvider);
                if (method4 != null && !ContainerUtil.isEmpty(DebuggerUtilsEx.allLineLocations(method4))) {
                    method3 = method4;
                }
                if ((list2 = DebuggerUtilsEx.allLineLocations(method3)) == null && !method3.isBridge()) {
                    methodBreakpointBase.disableEmulation();
                    return;
                }
                if (ContainerUtil.isEmpty(list2)) continue;
                if (methodBreakpointBase.isWatchEntry()) {
                    MethodBreakpoint.a((FilteredRequestor)methodBreakpointBase, (Location)ContainerUtil.getFirstItem(list2), debugProcessImpl, true);
                }
                if (!methodBreakpointBase.isWatchExit()) continue;
                MethodBytecodeUtil.visit(method3, new MethodVisitor(393216){
                    int myLastLine;
                    {
                        super(n2);
                        this.myLastLine = 0;
                    }

                    public void visitLineNumber(int n2, Label label) {
                        this.myLastLine = n2;
                    }

                    public void visitInsn(int n2) {
                        switch (n2) {
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: 
                            case 176: 
                            case 177: {
                                list2.stream().filter(location -> location.lineNumber() == this.myLastLine).findFirst().ifPresent(location -> {
                                    if (methodBreakpointBase == null) {
                                        2.a(0);
                                    }
                                    if (debugProcessImpl == null) {
                                        2.a(1);
                                    }
                                    MethodBreakpoint.a(methodBreakpointBase, location, debugProcessImpl, false);
                                });
                            }
                        }
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "breakpoint";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "debugProcess";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$2";
                        objectArray[2] = "lambda$visitInsn$1";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, true);
            }
            if (bl2 && bl3) {
                MethodBreakpoint.a(methodBreakpointBase, debugProcessImpl, referenceType);
            }
        }
        catch (Exception exception) {
            j.debug((Throwable)exception);
        }
    }

    private static void a(@NotNull FilteredRequestor filteredRequestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcessImpl, boolean bl2) {
        BreakpointRequest breakpointRequest;
        if (filteredRequestor == null) {
            MethodBreakpoint.c(13);
        }
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(14);
        }
        if ((breakpointRequest = MethodBreakpoint.createLocationBreakpointRequest(filteredRequestor, location, debugProcessImpl)) != null) {
            breakpointRequest.putProperty("METHOD_ENTRY_KEY", bl2);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType) {
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(15);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(16);
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcessImpl, referenceType, true);
        } else {
            this.b(debugProcessImpl, referenceType);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void b(@NotNull DebugProcessImpl debugProcessImpl, @NotNull ReferenceType referenceType) {
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(17);
        }
        if (referenceType == null) {
            MethodBreakpoint.c(18);
        }
        try {
            boolean bl2 = false;
            for (Method mirror2 : referenceType.allMethods()) {
                String string = mirror2.signature();
                String string2 = mirror2.name();
                if (!this.a().equals(string2) || !this.k.getName(debugProcessImpl).equals(string)) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                debugProcessImpl.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{referenceType.name()}));
                return;
            }
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            if (this.isWatchEntry()) {
                void var5_9;
                MethodEntryRequest methodEntryRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodEntryRequest.class, this);
                if (methodEntryRequest == null) {
                    MethodEntryRequest methodEntryRequest2 = requestManagerImpl.createMethodEntryRequest(this);
                } else {
                    methodEntryRequest.disable();
                }
                var5_9.addClassFilter(referenceType);
                debugProcessImpl.getRequestsManager().enableRequest((EventRequest)var5_9);
            }
            if (this.isWatchExit()) {
                void var5_13;
                MethodExitRequest methodExitRequest = MethodBreakpoint.findRequest(debugProcessImpl, MethodExitRequest.class, this);
                if (methodExitRequest == null) {
                    MethodExitRequest methodExitRequest2 = requestManagerImpl.createMethodExitRequest(this);
                } else {
                    methodExitRequest.disable();
                }
                var5_13.addClassFilter(referenceType);
                debugProcessImpl.getRequestsManager().enableRequest((EventRequest)var5_13);
            }
        }
        catch (Exception exception) {
            j.debug((Throwable)exception);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent locatableEvent) {
        if (locatableEvent == null) {
            MethodBreakpoint.c(19);
        }
        return MethodBreakpoint.getEventMessage(locatableEvent, this.getFileName());
    }

    static String getEventMessage(@NotNull LocatableEvent locatableEvent, @NotNull String string) {
        if (locatableEvent == null) {
            MethodBreakpoint.c(20);
        }
        if (string == null) {
            MethodBreakpoint.c(21);
        }
        Location location = locatableEvent.location();
        if (locatableEvent instanceof MethodEntryEvent) {
            return MethodBreakpoint.a(true, ((MethodEntryEvent)locatableEvent).method(), location, string);
        }
        if (locatableEvent instanceof MethodExitEvent) {
            return MethodBreakpoint.a(false, ((MethodExitEvent)locatableEvent).method(), location, string);
        }
        Object object = locatableEvent.request().getProperty("METHOD_ENTRY_KEY");
        if (object instanceof Boolean) {
            return MethodBreakpoint.a((Boolean)object, location.method(), location, string);
        }
        return "";
    }

    private static String a(boolean bl2, Method method, Location location, String string) {
        String string2 = DebuggerUtilsEx.getLocationMethodQName(location);
        String string3 = DebuggerUtilsEx.getSourceName(location, throwable -> string);
        int n2 = location.lineNumber();
        return DebuggerBundle.message((String)(bl2 ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", string2, string3, n2});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean bl2) {
        Breakpoint breakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (breakpoint != null) {
            return bl2 ? AllIcons.Debugger.Db_muted_dep_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    @NotNull
    protected Icon getInvalidIcon(boolean bl2) {
        Icon icon = bl2 ? AllIcons.Debugger.Db_muted_invalid_method_breakpoint : AllIcons.Debugger.Db_invalid_method_breakpoint;
        if (icon == null) {
            MethodBreakpoint.c(22);
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedIcon(boolean bl2) {
        Icon icon = bl2 ? AllIcons.Debugger.Db_muted_verified_method_breakpoint : AllIcons.Debugger.Db_verified_method_breakpoint;
        if (icon == null) {
            MethodBreakpoint.c(23);
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean bl2) {
        Icon icon = bl2 ? AllIcons.Debugger.Db_muted_method_warning_breakpoint : AllIcons.Debugger.Db_method_warning_breakpoint;
        if (icon == null) {
            MethodBreakpoint.c(24);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            String string;
            if (this.isValid()) {
                boolean bl2;
                string = this.getClassName();
                boolean bl3 = bl2 = string != null && string.length() > 0;
                if (bl2) {
                    stringBuilder.append(string);
                }
                if (this.a() != null) {
                    if (bl2) {
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(this.a());
                }
            } else {
                stringBuilder.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
            }
            string = stringBuilder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl evaluationContextImpl, @NotNull LocatableEvent locatableEvent) throws EvaluateException {
        if (evaluationContextImpl == null) {
            MethodBreakpoint.c(25);
        }
        if (locatableEvent == null) {
            MethodBreakpoint.c(26);
        }
        if (!this.matchesEvent(locatableEvent, evaluationContextImpl.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(evaluationContextImpl, locatableEvent);
    }

    public boolean matchesEvent(@NotNull LocatableEvent locatableEvent, DebugProcessImpl debugProcessImpl) throws EvaluateException {
        if (locatableEvent == null) {
            MethodBreakpoint.c(27);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.a() == null || this.k == null) {
            return false;
        }
        Method method = locatableEvent.location().method();
        return method != null && method.name().equals(this.a()) && method.signature().equals(this.k.getName(debugProcessImpl));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            MethodBreakpoint.c(28);
        }
        MethodBreakpoint methodBreakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)methodBreakpoint.init();
    }

    @Nullable
    private static MethodDescriptor a(@NotNull Project project2, @NotNull PsiFile psiFile, @Nullable SourcePosition sourcePosition) {
        if (project2 == null) {
            MethodBreakpoint.c(29);
        }
        if (psiFile == null) {
            MethodBreakpoint.c(30);
        }
        if (sourcePosition == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)ReadAction.compute(() -> {
            PsiMethod psiMethod;
            if (project2 == null) {
                MethodBreakpoint.c(35);
            }
            if ((psiMethod = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition)) == null) {
                return null;
            }
            int n2 = psiMethod.getTextOffset();
            if (n2 < 0) {
                return null;
            }
            if (document.getLineNumber(n2) < sourcePosition.getLine()) {
                return null;
            }
            PsiIdentifier psiIdentifier = psiMethod.getNameIdentifier();
            int n3 = psiIdentifier != null ? psiIdentifier.getTextOffset() : n2;
            MethodDescriptor methodDescriptor = new MethodDescriptor();
            methodDescriptor.methodName = JVMNameUtil.getJVMMethodName(psiMethod);
            try {
                methodDescriptor.methodSignature = JVMNameUtil.getJVMSignature(psiMethod);
                methodDescriptor.isStatic = psiMethod.hasModifierProperty("static");
            }
            catch (IndexNotReadyException indexNotReadyException) {
                return null;
            }
            methodDescriptor.methodLine = document.getLineNumber(n3);
            return methodDescriptor;
        });
        if (methodDescriptor == null || methodDescriptor.methodName == null || methodDescriptor.methodSignature == null) {
            return null;
        }
        return methodDescriptor;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcessImpl, Class<T> clazz, Requestor requestor) {
        if (debugProcessImpl == null) {
            MethodBreakpoint.c(31);
        }
        return (T)((EventRequest)StreamEx.of(debugProcessImpl.getRequestsManager().findRequests(requestor)).select(clazz).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            MethodBreakpoint.c(32);
        }
        super.readExternal(element);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> streamEx, DebugProcessImpl debugProcessImpl) {
        try {
            String string = this.a();
            String string2 = this.k != null ? this.k.getName(debugProcessImpl) : null;
            return (StreamEx)((StreamEx)streamEx.filter(method -> Comparing.equal((String)string, (String)method.name()) && Comparing.equal((String)string2, (String)method.signature()))).limit(1L);
        }
        catch (EvaluateException evaluateException) {
            j.warn((Throwable)evaluateException);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String a() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void a(@Nullable String string) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = string;
    }

    private static boolean b(@Nullable ReferenceType referenceType, @NotNull ReferenceType referenceType3) {
        if (referenceType3 == null) {
            MethodBreakpoint.c(33);
        }
        if (referenceType == null) {
            return false;
        }
        if (referenceType3.equals(referenceType)) {
            return true;
        }
        return MethodBreakpoint.a(referenceType).anyMatch(referenceType2 -> {
            if (referenceType3 == null) {
                MethodBreakpoint.c(34);
            }
            return MethodBreakpoint.b(referenceType2, referenceType3);
        });
    }

    private static Stream<? extends ReferenceType> a(ReferenceType referenceType) {
        if (referenceType instanceof InterfaceType) {
            return ((InterfaceType)referenceType).superinterfaces().stream();
        }
        if (referenceType instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)referenceType).superclass()).prepend(((ClassType)referenceType).interfaces());
        }
        return StreamEx.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(ReferenceType referenceType2, BiConsumer<ReferenceType, ClassesByNameProvider> biConsumer, ProgressIndicator progressIndicator) {
        long l2 = 0L;
        if (j.isDebugEnabled()) {
            l2 = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            Object object;
            MultiMap multiMap = new MultiMap();
            List<ReferenceType> list2 = referenceType2.virtualMachine().allClasses();
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                object = list2.get(i2);
                if (object.isPrepared()) {
                    MethodBreakpoint.a((ReferenceType)object).forEach(arg_0 -> MethodBreakpoint.a(multiMap, (ReferenceType)object, arg_0));
                }
                progressIndicator.setText2(i2 + "/" + list2.size());
                progressIndicator.setFraction((double)i2 / (double)list2.size());
            }
            List list3 = ((StreamEx)StreamEx.ofTree((Object)referenceType2, referenceType -> StreamEx.of((Collection)multiMap.get(referenceType))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            object = ClassesByNameProvider.createCache(list2);
            for (int i3 = 0; i3 < list3.size(); ++i3) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                biConsumer.accept((ReferenceType)list3.get(i3), (ClassesByNameProvider)object);
                progressIndicator.setText2(i3 + "/" + list3.size());
                progressIndicator.setFraction((double)i3 / (double)list3.size());
            }
            if (j.isDebugEnabled()) {
                j.debug("Processed " + list3.size() + " classes in " + String.valueOf(System.currentTimeMillis() - l2) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static /* synthetic */ void a(MultiMap multiMap, ReferenceType referenceType, ReferenceType referenceType2) {
        multiMap.putValue((Object)referenceType2, (Object)referenceType);
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 31: 
            case 38: 
            case 40: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 5: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 8: 
            case 11: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiJavaFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIcon";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedIcon";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedWarningsIcon";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "instanceOf";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$instanceOf$8";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getMethodDescriptor$6";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$3";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$1";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createRequestForSubClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

