/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.TipManager;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.GeometryUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeBase
extends DnDAwareTree
implements Disposable {
    private final Project a;
    private DebuggerTreeNodeImpl b;
    private JComponent c;
    protected final TipManager myTipManager;

    public DebuggerTreeBase(TreeModel treeModel, Project project2) {
        super(treeModel);
        this.a = project2;
        this.myTipManager = new TipManager((JComponent)((Object)this), new TipManager.TipFactory(){

            @Override
            public JComponent createToolTip(MouseEvent mouseEvent) {
                return DebuggerTreeBase.this.createToolTip(mouseEvent);
            }

            @Override
            public MouseEvent createTooltipEvent(MouseEvent mouseEvent) {
                return DebuggerTreeBase.this.createTooltipEvent(mouseEvent);
            }

            @Override
            public boolean isFocusOwner() {
                return DebuggerTreeBase.this.isFocusOwner();
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myTipManager);
        UIUtil.setLineStyleAngled((JTree)((Object)this));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setCellRenderer((TreeCellRenderer)((Object)new DebuggerTreeRenderer()));
        this.updateUI();
        TreeUtil.installActions((JTree)((Object)this));
    }

    private JComponent a(String string, DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        JToolTip jToolTip = new JToolTip();
        if (string == null) {
            jToolTip.setTipText(string);
        } else {
            Dimension dimension = this.getVisibleRect().getSize();
            Insets insets = jToolTip.getBorder().getBorderInsets(jToolTip);
            dimension.width -= (insets.left + insets.right) * 2;
            dimension.height -= (insets.top + insets.bottom) * 2;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = debuggerTreeNodeImpl.getMarkupTooltipText();
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (!string.isEmpty()) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n ", true);
                while (stringTokenizer.hasMoreElements()) {
                    String string3 = stringTokenizer.nextElement();
                    if ("\n".equals(string3)) {
                        stringBuilder.append("<br>");
                        continue;
                    }
                    if (" ".equals(string3)) {
                        stringBuilder.append("&nbsp ");
                        continue;
                    }
                    stringBuilder.append(JDOMUtil.legalizeText((String)string3));
                }
            }
            jToolTip.setTipText(UIUtil.toHtml((String)stringBuilder.toString(), (int)0));
        }
        jToolTip.setBorder(null);
        return jToolTip;
    }

    public MouseEvent createTooltipEvent(MouseEvent mouseEvent) {
        TreePath treePath = null;
        if (mouseEvent != null) {
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), (Component)((Object)this));
            if (GeometryUtil.isWithin((Rectangle)new Rectangle(0, 0, this.getWidth(), this.getHeight()), (Point2D)point)) {
                treePath = this.getPathForLocation(point.x, point.y);
            }
        }
        if (treePath == null && this.isFocusOwner()) {
            treePath = this.getSelectionPath();
        }
        if (treePath == null) {
            return null;
        }
        int n2 = this.getRowForPath(treePath);
        if (n2 == -1) {
            return null;
        }
        Rectangle rectangle = this.getRowBounds(n2);
        return new MouseEvent((Component)((Object)this), 503, System.currentTimeMillis(), 0, rectangle.x, rectangle.y + rectangle.height - rectangle.height / 4, 0, false);
    }

    @Nullable
    public JComponent createToolTip(MouseEvent mouseEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = this.a(mouseEvent);
        if (debuggerTreeNodeImpl == null) {
            return null;
        }
        if (this.c != null && this.c.isShowing() && this.b == debuggerTreeNodeImpl) {
            return this.c;
        }
        String string = this.a(debuggerTreeNodeImpl);
        if (string == null) {
            return null;
        }
        JComponent jComponent = this.a(string, debuggerTreeNodeImpl);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)jComponent);
        jScrollPane.setBorder(null);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        Point point = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
        Rectangle rectangle = new Rectangle(point, jComponent.getPreferredSize());
        Rectangle rectangle2 = ScreenUtil.getScreenRectangle((int)point.x, (int)point.y);
        JToolTip jToolTip = new JToolTip();
        jComponent.addMouseListener(new HideTooltip(jToolTip));
        Border border = jToolTip.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets((Component)((Object)this));
            rectangle.setSize(rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        }
        jToolTip.setLayout(new BorderLayout());
        jToolTip.add((Component)jScrollPane, "Center");
        rectangle.height += jScrollPane.getHorizontalScrollBar().getPreferredSize().height;
        rectangle.width += jScrollPane.getVerticalScrollBar().getPreferredSize().width;
        int n2 = (int)((double)rectangle2.width - (double)rectangle2.width * 0.25);
        if (rectangle.width > n2) {
            rectangle.width = n2;
        }
        Dimension dimension = rectangle.getSize();
        ScreenUtil.cropRectangleToFitTheScreen((Rectangle)rectangle);
        if (dimension.width > rectangle.width) {
            int n3 = dimension.width - rectangle.width;
            rectangle.x -= n3;
            if (rectangle.x < rectangle2.x) {
                rectangle.x = rectangle2.x + n2 / 2;
                rectangle.width = rectangle2.width - n2 / 2;
            } else {
                rectangle.width += n3;
            }
        }
        jToolTip.setPreferredSize(rectangle.getSize());
        this.c = jToolTip;
        this.b = debuggerTreeNodeImpl;
        return this.c;
    }

    @Nullable
    private String a(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        String string;
        String string2;
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (!(!(nodeDescriptorImpl instanceof ValueDescriptorImpl) || (string2 = DebuggerUtilsEx.prepareValueText(string = ((ValueDescriptorImpl)nodeDescriptorImpl).getValueText(), this.a)).isEmpty() || string2.indexOf(10) < 0 && this.getVisibleRect().contains(this.getRowBounds(this.getRowForPath(new TreePath(debuggerTreeNodeImpl.getPath())))))) {
            return string2;
        }
        return debuggerTreeNodeImpl.getMarkupTooltipText() != null ? "" : null;
    }

    @Nullable
    private DebuggerTreeNodeImpl a(MouseEvent mouseEvent) {
        Object object;
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DebuggerTreeNodeImpl) {
            return (DebuggerTreeNodeImpl)object;
        }
        return null;
    }

    public void dispose() {
        JComponent jComponent = this.c;
        if (jComponent != null) {
            jComponent.setVisible(false);
        }
        this.c = null;
        this.b = null;
    }

    public Project getProject() {
        return this.a;
    }

    private static class HideTooltip
    extends MouseAdapter {
        private final JToolTip a;

        public HideTooltip(JToolTip jToolTip) {
            this.a = jToolTip;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Window window;
            if (UIUtil.isActionClick((MouseEvent)mouseEvent) && (window = SwingUtilities.getWindowAncestor(this.a)) instanceof JWindow) {
                window.setVisible(false);
            }
        }
    }
}

