/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThrownExceptionValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes c = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes b = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    private static final SimpleTextAttributes a = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));

    public void customizeCellRenderer(@NotNull JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl;
        if (jTree == null) {
            DebuggerTreeRenderer.a(0);
        }
        if ((debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)object) != null) {
            SimpleColoredText simpleColoredText = debuggerTreeNodeImpl.getText();
            if (simpleColoredText != null) {
                simpleColoredText.appendToComponent((ColoredTextContainer)this);
            }
            this.setIcon(debuggerTreeNodeImpl.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptor nodeDescriptor) {
        Icon icon = null;
        if (nodeDescriptor instanceof ThreadGroupDescriptorImpl) {
            icon = ((ThreadGroupDescriptorImpl)nodeDescriptor).isCurrent() ? AllIcons.Debugger.ThreadGroupCurrent : AllIcons.Debugger.ThreadGroup;
        } else if (nodeDescriptor instanceof ThreadDescriptorImpl) {
            ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)nodeDescriptor;
            icon = threadDescriptorImpl.getIcon();
        } else if (nodeDescriptor instanceof StackFrameDescriptorImpl) {
            StackFrameDescriptorImpl stackFrameDescriptorImpl = (StackFrameDescriptorImpl)nodeDescriptor;
            icon = stackFrameDescriptorImpl.getIcon();
        } else if (nodeDescriptor instanceof ValueDescriptorImpl) {
            icon = DebuggerTreeRenderer.getValueIcon((ValueDescriptorImpl)nodeDescriptor, null);
        } else if (nodeDescriptor instanceof MessageDescriptor) {
            MessageDescriptor messageDescriptor = (MessageDescriptor)nodeDescriptor;
            if (messageDescriptor.getKind() == 0) {
                icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 2) {
                icon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
            } else if (messageDescriptor.getKind() == 3) {
                icon = null;
            }
        } else if (nodeDescriptor instanceof StaticDescriptorImpl) {
            icon = AllIcons.Nodes.Static;
        }
        return icon;
    }

    public static Icon getValueIcon(ValueDescriptorImpl valueDescriptorImpl, @Nullable ValueDescriptorImpl valueDescriptorImpl2) {
        Value value;
        Icon icon;
        Object object;
        if (valueDescriptorImpl instanceof FieldDescriptorImpl) {
            object = (FieldDescriptorImpl)valueDescriptorImpl;
            icon = PlatformIcons.FIELD_ICON;
            if (valueDescriptorImpl2 != null && (value = valueDescriptorImpl.getValue()) instanceof ObjectReference && value.equals(valueDescriptorImpl2.getValue())) {
                icon = AllIcons.Debugger.Selfreference;
            }
            if (((FieldDescriptorImpl)object).getField().isFinal()) {
                icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.FinalMark});
            }
            if (((FieldDescriptorImpl)object).isStatic()) {
                icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.StaticMark});
            }
        } else {
            icon = valueDescriptorImpl instanceof ThrownExceptionValueDescriptorImpl ? AllIcons.Nodes.ExceptionClass : (valueDescriptorImpl instanceof MethodReturnValueDescriptorImpl ? AllIcons.Debugger.WatchLastReturnValue : (DebuggerTreeRenderer.a(valueDescriptorImpl) ? PlatformIcons.PARAMETER_ICON : (valueDescriptorImpl.isEnumConstant() ? PlatformIcons.ENUM_ICON : (valueDescriptorImpl.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptorImpl.isPrimitive() ? AllIcons.Debugger.Db_primitive : (valueDescriptorImpl instanceof WatchItemDescriptor ? AllIcons.Debugger.Watch : AllIcons.Debugger.Value))))));
        }
        if (valueDescriptorImpl instanceof UserExpressionDescriptorImpl && (object = EnumerationChildrenRenderer.getCurrent(((UserExpressionDescriptorImpl)valueDescriptorImpl).getParentDescriptor())) != null && ((EnumerationChildrenRenderer)object).isAppendDefaultChildren()) {
            icon = AllIcons.Debugger.Watch;
        }
        if (valueDescriptorImpl instanceof WatchItemDescriptor && icon != AllIcons.Debugger.Watch && (object = XDebuggerManager.getInstance((Project)valueDescriptorImpl.getProject()).getCurrentSession()) != null && (value = ((XDebugSessionImpl)object).getSessionTab()) != null && value.isWatchesInVariables()) {
            icon = AllIcons.Debugger.Watch;
        }
        object = valueDescriptorImpl.getValueIcon();
        if (icon != null && object != null) {
            icon = new RowIcon(new Icon[]{icon, object});
        }
        return icon;
    }

    private static boolean a(ValueDescriptorImpl valueDescriptorImpl) {
        if (valueDescriptorImpl instanceof LocalVariableDescriptorImpl) {
            try {
                return ((LocalVariableDescriptorImpl)valueDescriptorImpl).getLocalVariable().getVariable().isArgument();
            }
            catch (EvaluateException evaluateException) {
            }
        } else if (valueDescriptorImpl instanceof ArgumentValueDescriptorImpl) {
            return ((ArgumentValueDescriptorImpl)valueDescriptorImpl).isParameter();
        }
        return false;
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, EditorColorsScheme editorColorsScheme, boolean bl2) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, editorColorsScheme, bl2, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, boolean bl2) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, DebuggerUIUtil.getColorScheme(null), bl2, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, DebuggerUIUtil.getColorScheme(null), false, false);
    }

    private static SimpleColoredText a(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, EditorColorsScheme editorColorsScheme, boolean bl2, boolean bl3) {
        String[] stringArray;
        String string;
        String string2;
        SimpleColoredText simpleColoredText = new SimpleColoredText();
        if (nodeDescriptorImpl == null) {
            string2 = "";
            string = null;
        } else {
            string2 = nodeDescriptorImpl.getLabel();
            string = nodeDescriptorImpl.getName();
        }
        if (string2.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
            simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
            return simpleColoredText;
        }
        if (nodeDescriptorImpl instanceof ValueDescriptor && (stringArray = ((ValueDescriptor)((Object)nodeDescriptorImpl)).getMarkup(debuggerContextImpl.getDebugProcess())) != null) {
            simpleColoredText.append("[" + stringArray.getText() + "] ", new SimpleTextAttributes(1, stringArray.getColor()));
        }
        if ((stringArray = DebuggerTreeRenderer.a(string2, string))[0] != null) {
            if (nodeDescriptorImpl instanceof MessageDescriptor && ((MessageDescriptor)nodeDescriptorImpl).getKind() == 3) {
                simpleColoredText.append((String)stringArray[0], b);
            } else {
                simpleColoredText.append((String)stringArray[0], c);
            }
        }
        if (stringArray[1] != null) {
            simpleColoredText.append((String)stringArray[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
        }
        if (stringArray[2] != null) {
            if (nodeDescriptorImpl instanceof ValueDescriptorImpl) {
                ValueDescriptorImpl valueDescriptorImpl;
                String string3;
                if (bl2 && stringArray[2].indexOf(10) >= 0 && (stringArray = DebuggerTreeRenderer.a((String)stringArray[2], "="))[2] != null) {
                    stringArray[2] = stringArray[0] + stringArray[1] + "\n" + stringArray[2];
                }
                if ((stringArray = DebuggerTreeRenderer.a((String)stringArray[2], string3 = (valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptorImpl).getValueLabel()))[0] != null) {
                    simpleColoredText.append(stringArray[0], c);
                }
                if (bl3 && stringArray[1] != null) {
                    SimpleTextAttributes simpleTextAttributes;
                    Object object;
                    if (string3 != null && StringUtil.startsWithChar((CharSequence)string3, (char)'{') && string3.indexOf(125) > 0 && !StringUtil.endsWithChar((CharSequence)string3, (char)'}')) {
                        int n2 = string3.indexOf(125);
                        object = string3.substring(0, n2 + 1);
                        string3 = string3.substring(n2 + 1);
                        simpleColoredText.append((String)object, a);
                    }
                    string3 = DebuggerUtilsEx.truncateString(string3);
                    if (valueDescriptorImpl.isDirty()) {
                        simpleTextAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                    } else {
                        object = null;
                        if (valueDescriptorImpl.isNull()) {
                            object = editorColorsScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                        } else if (valueDescriptorImpl.isString()) {
                            object = editorColorsScheme.getAttributes(JavaHighlightingColors.STRING);
                        }
                        simpleTextAttributes = object != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)object) : c;
                    }
                    object = nodeDescriptorImpl.getEvaluateException();
                    if (object != null) {
                        String string4 = object.getMessage();
                        if (string3.endsWith(string4)) {
                            DebuggerTreeRenderer.a(simpleColoredText, string3.substring(0, string3.length() - string4.length()), simpleTextAttributes, editorColorsScheme);
                            simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        } else {
                            DebuggerTreeRenderer.a(simpleColoredText, string3, simpleTextAttributes, editorColorsScheme);
                            simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                        }
                    } else if (string3.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                        simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    } else {
                        DebuggerTreeRenderer.a(simpleColoredText, string3, simpleTextAttributes, editorColorsScheme);
                    }
                }
            } else {
                simpleColoredText.append((String)stringArray[2], c);
            }
        }
        return simpleColoredText;
    }

    private static void a(SimpleColoredText simpleColoredText, String string, SimpleTextAttributes simpleTextAttributes, EditorColorsScheme editorColorsScheme) {
        SimpleTextAttributes simpleTextAttributes2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                bl2 = false;
                if (c2 == '\\' || c2 == '\"' || c2 == 'b' || c2 == 't' || c2 == 'n' || c2 == 'f' || c2 == 'r') {
                    if (stringBuilder.length() > 0) {
                        simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
                        stringBuilder.setLength(0);
                    }
                    if (simpleTextAttributes2 == null) {
                        TextAttributes textAttributes = editorColorsScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                        simpleTextAttributes2 = textAttributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes) : c.derive(1, (Color)JBColor.GRAY, null, null);
                    }
                    if (c2 != '\\' && c2 != '\"') {
                        simpleColoredText.append("\\", simpleTextAttributes2);
                    }
                    simpleColoredText.append(String.valueOf(c2), simpleTextAttributes2);
                    continue;
                }
                stringBuilder.append('\\').append(c2);
                continue;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        if (stringBuilder.length() > 0) {
            simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
        }
    }

    private static String[] a(String string, String string2) {
        if (string2 != null && string2.length() > 0) {
            int n2 = Math.max(string.indexOf(string2), 0);
            String string3 = n2 > 0 ? string.substring(0, n2) : null;
            String string4 = (n2 += string2.length()) < string.length() - 1 ? string.substring(n2) : null;
            return new String[]{string3, string2, string4};
        }
        return new String[]{string, null, null};
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "customizeCellRenderer"));
    }
}

