/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.server.BuildManager;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluator;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractLightMethodObjectHandler;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilingEvaluatorImpl
extends CompilingEvaluator {
    private Collection<ClassObject> b;

    public CompilingEvaluatorImpl(@NotNull Project project2, @NotNull PsiElement psiElement, @NotNull ExtractLightMethodObjectHandler.ExtractedData extractedData) {
        if (project2 == null) {
            CompilingEvaluatorImpl.b(0);
        }
        if (psiElement == null) {
            CompilingEvaluatorImpl.b(1);
        }
        if (extractedData == null) {
            CompilingEvaluatorImpl.b(2);
        }
        super(project2, psiElement, extractedData);
    }

    @Override
    @NotNull
    protected Collection<ClassObject> compile(@Nullable JavaSdkVersion javaSdkVersion) throws EvaluateException {
        if (this.b == null) {
            Object object;
            Object object22;
            ModuleRootManager moduleRootManager;
            Module module2 = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPsiContext));
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add("-encoding");
            arrayList.add("UTF-8");
            ArrayList<File> arrayList2 = new ArrayList<File>();
            ArrayList<File> arrayList3 = new ArrayList<File>();
            AnnotationProcessingConfiguration annotationProcessingConfiguration = null;
            if (module2 != null) {
                assert (this.myProject.equals(module2.getProject())) : module2 + " is from another project";
                annotationProcessingConfiguration = CompilerConfiguration.getInstance((Project)this.myProject).getAnnotationProcessingConfiguration(module2);
                moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                for (Object object22 : moduleRootManager.orderEntries().compileOnly().recursively().exportedOnly().withoutSdk().getPathsList().getPathList()) {
                    arrayList3.add(new File((String)object22));
                }
                for (Object object22 : moduleRootManager.orderEntries().compileOnly().sdkOnly().getPathsList().getPathList()) {
                    arrayList2.add(new File((String)object22));
                }
            }
            JavaBuilder.addAnnotationProcessingOptions(arrayList, annotationProcessingConfiguration);
            moduleRootManager = BuildManager.getJavacRuntimeSdk(this.myProject);
            JavaSdkVersion javaSdkVersion2 = (JavaSdkVersion)moduleRootManager.getSecond();
            if (javaSdkVersion2 != null && javaSdkVersion != null) {
                object22 = javaSdkVersion.compareTo((Enum)javaSdkVersion2) < 0 ? javaSdkVersion : javaSdkVersion2;
                object = JpsJavaSdkType.complianceOption((JavaVersion)object22.getMaxLanguageLevel().toJavaVersion());
                arrayList.add("-source");
                arrayList.add(object);
                arrayList.add("-target");
                arrayList.add(object);
            }
            object22 = CompilerManager.getInstance((Project)this.myProject);
            object = null;
            try {
                object = this.a(object22.getJavacCompilerWorkingDir());
                File file = ((File)object).getParentFile();
                List list2 = Collections.emptyList();
                Set<Object> set = Collections.singleton(object);
                this.b = object22.compileJavaCode(arrayList, arrayList2, arrayList3, Collections.emptyList(), list2, set, file);
            }
            catch (CompilationException compilationException) {
                StringBuilder stringBuilder = new StringBuilder("Compilation failed:\n");
                for (CompilationException.Message message : compilationException.getMessages()) {
                    if (message.getCategory() != CompilerMessageCategory.ERROR) continue;
                    stringBuilder.append(message.getText()).append("\n");
                }
                throw new EvaluateException(stringBuilder.toString());
            }
            catch (Exception exception) {
                throw new EvaluateException(exception.getMessage());
            }
            finally {
                if (object != null) {
                    FileUtil.delete((File)object);
                }
            }
        }
        Collection<ClassObject> collection = this.b;
        if (collection == null) {
            CompilingEvaluatorImpl.b(3);
        }
        return collection;
    }

    private File a(File file) throws IOException {
        Pair pair2 = (Pair)ReadAction.compute(() -> {
            PsiFile psiFile = this.myData.getGeneratedInnerClass().getContainingFile();
            return Pair.create((Object)psiFile.getName(), (Object)psiFile.getText());
        });
        if (pair2.first == null) {
            throw new IOException("Class file name not specified");
        }
        if (pair2.second == null) {
            throw new IOException("Class source code not specified");
        }
        File file2 = new File(file, "debugger/src/" + (String)pair2.first);
        FileUtil.writeToFile((File)file2, (String)((String)pair2.second));
        return file2;
    }

    @Nullable
    public static ExpressionEvaluator create(@NotNull Project project2, @Nullable PsiElement psiElement, @NotNull Function<PsiElement, PsiCodeFragment> function) throws EvaluateException {
        if (project2 == null) {
            CompilingEvaluatorImpl.b(4);
        }
        if (function == null) {
            CompilingEvaluatorImpl.b(5);
        }
        if (Registry.is((String)"debugger.compiling.evaluator") && psiElement != null) {
            return (ExpressionEvaluator)ApplicationManager.getApplication().runReadAction(() -> {
                if (project2 == null) {
                    CompilingEvaluatorImpl.b(8);
                }
                if (function == null) {
                    CompilingEvaluatorImpl.b(9);
                }
                try {
                    ExtractLightMethodObjectHandler.ExtractedData extractedData = ExtractLightMethodObjectHandler.extractLightMethodObject((Project)project2, (PsiElement)CompilingEvaluatorImpl.a(psiElement), (PsiCodeFragment)((PsiCodeFragment)function.apply(psiElement)), (String)CompilingEvaluatorImpl.getGeneratedClassName());
                    if (extractedData != null) {
                        return new CompilingEvaluatorImpl(project2, psiElement, extractedData);
                    }
                }
                catch (PrepareFailedException prepareFailedException) {
                    NodeDescriptorImpl.LOG.info((Throwable)prepareFailedException);
                }
                return null;
            });
        }
        return null;
    }

    @NotNull
    private static PsiElement a(@NotNull PsiElement psiElement) {
        PsiElement psiElement2;
        if (psiElement == null) {
            CompilingEvaluatorImpl.b(6);
        }
        while (!psiElement.isPhysical() && (psiElement2 = psiElement.getContext()) != null) {
            psiElement = psiElement2;
        }
        PsiElement psiElement3 = psiElement;
        if (psiElement3 == null) {
            CompilingEvaluatorImpl.b(7);
        }
        return psiElement3;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentFactory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/CompilingEvaluatorImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findPhysicalContext";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPhysicalContext";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$create$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

