/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.StackFrameDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameDescriptorImpl
extends NodeDescriptorImpl
implements StackFrameDescriptor {
    private final StackFrameProxyImpl j;
    private int m;
    private String l;
    private Location h;
    private MethodsTracker.MethodOccurrence g;
    private boolean f;
    private boolean e;
    private ObjectReference i;
    private SourcePosition k;
    private Icon n;

    public StackFrameDescriptorImpl(@NotNull StackFrameProxyImpl stackFrameProxyImpl, @NotNull MethodsTracker methodsTracker) {
        if (stackFrameProxyImpl == null) {
            StackFrameDescriptorImpl.a(0);
        }
        if (methodsTracker == null) {
            StackFrameDescriptorImpl.a(1);
        }
        this.l = null;
        this.n = AllIcons.Debugger.StackFrame;
        this.j = stackFrameProxyImpl;
        try {
            this.m = stackFrameProxyImpl.getFrameIndex();
            this.h = stackFrameProxyImpl.location();
            try {
                this.i = stackFrameProxyImpl.thisObject();
            }
            catch (EvaluateException evaluateException) {
                if (!(evaluateException.getCause() instanceof InternalException)) {
                    throw evaluateException;
                }
                LOG.info((Throwable)evaluateException);
            }
            this.g = methodsTracker.getMethodOccurrence(this.m, DebuggerUtilsEx.getMethod(this.h));
            this.f = DebuggerUtils.isSynthetic((TypeComponent)this.g.getMethod());
            this.k = ContextUtil.getSourcePosition(this);
            PsiFile psiFile = this.k != null ? this.k.getFile() : null;
            this.e = DebuggerUtilsEx.isInLibraryContent(psiFile != null ? psiFile.getVirtualFile() : null, this.getDebugProcess().getProject());
        }
        catch (EvaluateException | InternalException throwable) {
            LOG.info(throwable);
            this.h = null;
            this.g = methodsTracker.getMethodOccurrence(0, null);
            this.f = false;
            this.e = false;
        }
    }

    public int getUiIndex() {
        return this.m;
    }

    @NotNull
    public StackFrameProxyImpl getFrameProxy() {
        StackFrameProxyImpl stackFrameProxyImpl = this.j;
        if (stackFrameProxyImpl == null) {
            StackFrameDescriptorImpl.a(2);
        }
        return stackFrameProxyImpl;
    }

    @NotNull
    public DebugProcess getDebugProcess() {
        DebugProcess debugProcess = this.j.getVirtualMachine().getDebugProcess();
        if (debugProcess == null) {
            StackFrameDescriptorImpl.a(3);
        }
        return debugProcess;
    }

    @Nullable
    public Method getMethod() {
        return this.g.getMethod();
    }

    public int getOccurrenceIndex() {
        return this.g.getIndex();
    }

    public boolean isRecursiveCall() {
        return this.g.isRecursive();
    }

    @Nullable
    public ValueMarkup getValueMarkup() {
        XValueMarkers xValueMarkers;
        XDebugSession xDebugSession;
        DebugProcess debugProcess;
        if (this.i != null && (debugProcess = this.j.getVirtualMachine().getDebugProcess()) instanceof DebugProcessImpl && (xDebugSession = ((DebugProcessImpl)debugProcess).getSession().getXDebugSession()) instanceof XDebugSessionImpl && (xValueMarkers = ((XDebugSessionImpl)xDebugSession).getValueMarkers()) != null) {
            return (ValueMarkup)xValueMarkers.getAllMarkers().get(this.i);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.l;
    }

    @Override
    protected String calcRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (this.h == null) {
            return "";
        }
        ThreadsViewSettings threadsViewSettings = ThreadsViewSettings.getInstance();
        StringBuilder stringBuilder = new StringBuilder();
        Method method = this.g.getMethod();
        if (method != null) {
            this.l = method.name();
            stringBuilder.append(threadsViewSettings.SHOW_ARGUMENTS_TYPES ? DebuggerUtilsEx.methodNameWithArguments(method) : this.l);
        }
        if (threadsViewSettings.SHOW_LINE_NUMBER) {
            stringBuilder.append(':').append(Integer.toString(DebuggerUtilsEx.getLineNumber(this.h, false)));
        }
        if (threadsViewSettings.SHOW_CLASS_NAME) {
            String string;
            try {
                ReferenceType referenceType = this.h.declaringType();
                string = referenceType != null ? referenceType.name() : null;
            }
            catch (InternalError internalError) {
                string = internalError.toString();
            }
            if (string != null) {
                stringBuilder.append(", ");
                int n2 = string.lastIndexOf(46);
                if (n2 < 0) {
                    stringBuilder.append(string);
                } else {
                    stringBuilder.append(string.substring(n2 + 1));
                    if (threadsViewSettings.SHOW_PACKAGE_NAME) {
                        stringBuilder.append(" {");
                        stringBuilder.append(string.substring(0, n2));
                        stringBuilder.append("}");
                    }
                }
            }
        }
        if (threadsViewSettings.SHOW_SOURCE_NAME) {
            stringBuilder.append(", ").append(DebuggerUtilsEx.getSourceName(this.h, throwable -> "Unknown Source"));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public final void setContext(EvaluationContextImpl evaluationContextImpl) {
        this.n = this.a();
    }

    public boolean isSynthetic() {
        return this.f;
    }

    public boolean isInLibraryContent() {
        return this.e;
    }

    @Nullable
    public Location getLocation() {
        return this.h;
    }

    public SourcePosition getSourcePosition() {
        return this.k;
    }

    private Icon a() {
        try {
            if (this.j.isObsolete()) {
                return AllIcons.Debugger.Db_obsolete;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)6));
    }

    public Icon getIcon() {
        return this.n;
    }

    public ObjectReference getThisObject() {
        return this.i;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/impl/watch/StackFrameDescriptorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameProxy";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcess";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

