/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.managerThread.DebuggerCommand;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.rt.debugger.BatchEvaluatorServer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import one.util.streamex.StreamEx;

public class BatchEvaluator {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.BatchEvaluator");
    private final DebugProcess g;
    private boolean b;
    private ObjectReference d;
    private Method e;
    private static final Key<BatchEvaluator> f = new Key("BatchEvaluator");
    public static final Key<Boolean> REMOTE_SESSION_KEY = new Key("is_remote_session_key");
    private final HashMap<SuspendContext, List<ToStringCommand>> c = new HashMap();

    private BatchEvaluator(DebugProcess debugProcess) {
        this.g = debugProcess;
        this.g.addDebugProcessListener(new DebugProcessListener(){

            public void processDetached(DebugProcess debugProcess, boolean bl2) {
                BatchEvaluator.this.b = false;
                BatchEvaluator.this.d = null;
                BatchEvaluator.this.e = null;
            }
        });
    }

    public boolean hasBatchEvaluator(EvaluationContext evaluationContext) {
        if (!this.b) {
            Method method;
            this.b = true;
            if (DebuggerUtilsImpl.isRemote(this.g)) {
                return false;
            }
            ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
            if (threadReferenceProxy == null) {
                return false;
            }
            ThreadReference threadReference = threadReferenceProxy.getThreadReference();
            if (threadReference == null) {
                return false;
            }
            ClassType classType = null;
            try {
                classType = (ClassType)this.g.findClass(evaluationContext, BatchEvaluatorServer.class.getName(), evaluationContext.getClassLoader());
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (classType != null && (method = classType.concreteMethodByName("<init>", "()V")) != null) {
                ObjectReference objectReference = null;
                try {
                    objectReference = this.g.newInstance(evaluationContext, classType, method, Collections.emptyList());
                }
                catch (Exception exception) {
                    a.debug((Throwable)exception);
                }
                this.d = objectReference;
                if (this.d != null) {
                    this.e = classType.concreteMethodByName("evaluate", "([Ljava/lang/Object;)[Ljava/lang/Object;");
                }
            }
        }
        return this.e != null;
    }

    public void invoke(ToStringCommand toStringCommand) {
        a.assertTrue(DebuggerManager.getInstance((Project)this.g.getProject()).isDebuggerManagerThread());
        final EvaluationContext evaluationContext = toStringCommand.getEvaluationContext();
        final SuspendContext suspendContext = evaluationContext.getSuspendContext();
        if (!Registry.is((String)"debugger.batch.evaluation") || !this.hasBatchEvaluator(evaluationContext)) {
            this.g.getManagerThread().invokeCommand((DebuggerCommand)toStringCommand);
        } else {
            List<ToStringCommand> list2 = this.c.get(suspendContext);
            if (list2 == null) {
                final ArrayList<ToStringCommand> arrayList = new ArrayList<ToStringCommand>();
                list2 = arrayList;
                this.c.put(suspendContext, arrayList);
                this.g.getManagerThread().invokeCommand((DebuggerCommand)new SuspendContextCommand(){

                    public SuspendContext getSuspendContext() {
                        return suspendContext;
                    }

                    public void action() {
                        BatchEvaluator.this.c.remove(suspendContext);
                        if (!BatchEvaluator.this.a(arrayList, evaluationContext)) {
                            arrayList.forEach(ToStringCommand::action);
                        }
                    }

                    public void commandCancelled() {
                        BatchEvaluator.this.c.remove(suspendContext);
                    }
                });
            }
            list2.add(toStringCommand);
        }
    }

    public static BatchEvaluator getBatchEvaluator(DebugProcess debugProcess) {
        BatchEvaluator batchEvaluator = (BatchEvaluator)debugProcess.getUserData(f);
        if (batchEvaluator == null) {
            batchEvaluator = new BatchEvaluator(debugProcess);
            debugProcess.putUserData(f, (Object)batchEvaluator);
        }
        return batchEvaluator;
    }

    private boolean a(List<ToStringCommand> list2, EvaluationContext evaluationContext) {
        try {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            List list3 = StreamEx.of(list2).map(ToStringCommand::getValue).toList();
            ArrayType arrayType = (ArrayType)debugProcess.findClass(evaluationContext, "java.lang.Object[]", evaluationContext.getClassLoader());
            if (arrayType == null) {
                return false;
            }
            ArrayReference arrayReference = debugProcess.newInstance(arrayType, list3.size());
            ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep(arrayReference);
            arrayReference.setValues(list3);
            ArrayList<ArrayReference> arrayList = new ArrayList<ArrayReference>(1);
            arrayList.add(arrayReference);
            Value value = debugProcess.invokeMethod(evaluationContext, this.d, this.e, arrayList);
            if (value instanceof ArrayReference) {
                ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep((ArrayReference)value);
                ArrayReference arrayReference2 = (ArrayReference)value;
                List<Value> list4 = arrayReference2.getValues();
                Value[] valueArray = list4.toArray(new Value[0]);
                int n2 = 0;
                for (ToStringCommand toStringCommand : list2) {
                    Value value2 = valueArray[n2];
                    if (value2 == null || value2 instanceof StringReference) {
                        try {
                            String string = value2 == null ? null : ((StringReference)value2).value();
                            toStringCommand.evaluationResult(string);
                        }
                        catch (ObjectCollectedException objectCollectedException) {}
                    } else if (value2 instanceof ObjectReference) {
                        toStringCommand.evaluationError(EvaluateExceptionUtil.createEvaluateException((Throwable)new InvocationException((ObjectReference)value2)).getMessage());
                    } else {
                        a.assertTrue(false);
                    }
                    toStringCommand.setEvaluated();
                    ++n2;
                }
            }
            return true;
        }
        catch (EvaluateException | ClassNotLoadedException | InvalidTypeException | ObjectCollectedException throwable) {
            return false;
        }
    }
}

