/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public class BinaryRenderer
extends NodeRendererImpl {
    private static final Logger b = Logger.getInstance(BinaryRenderer.class);

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        int n2;
        Value value = valueDescriptor.getValue();
        if (value == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("0b");
        int n3 = stringBuilder.length();
        String string = "";
        if (value instanceof ByteValue) {
            string = Integer.toBinaryString(0xFF & ((ByteValue)value).byteValue());
        } else if (value instanceof ShortValue) {
            string = Integer.toBinaryString(0xFFFF & ((ShortValue)value).shortValue());
        } else if (value instanceof IntegerValue) {
            string = Integer.toBinaryString(((PrimitiveValue)value).intValue());
        } else if (value instanceof LongValue) {
            string = Long.toBinaryString(((LongValue)value).longValue());
        } else {
            b.error("Unsupported value " + value);
        }
        int n4 = string.length() % 8;
        if (n4 != 0) {
            for (n2 = 0; n2 < 8 - n4; ++n2) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(string);
        for (n2 = stringBuilder.length() - 8; n2 > n3; n2 -= 8) {
            stringBuilder.insert(n2, '_');
        }
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "Binary";
    }

    @Override
    public String getUniqueId() {
        return "BinaryRenderer";
    }

    @Override
    public boolean isApplicable(Type type) {
        if (type == null) {
            return false;
        }
        return type instanceof ByteType || type instanceof ShortType || type instanceof IntegerType || type instanceof LongType;
    }
}

